/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecRowBuilder;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.w3c.dom.Element;

abstract class ScanResultSet
extends NoPutResultSetImpl {
    private final boolean tableLocked;
    private final boolean unspecifiedIsolationLevel;
    private final int suppliedLockMode;
    private boolean isolationLevelNeedsUpdate;
    int lockMode;
    int isolationLevel;
    final ExecRowBuilder resultRowBuilder;
    final ExecRow candidate;
    protected FormatableBitSet accessedCols;
    protected boolean fetchRowLocations = false;
    public String tableName;
    public String indexName;

    ScanResultSet(Activation activation, int n2, int n3, int n4, boolean bl2, int n5, int n6, double d2, double d3) throws StandardException {
        super(activation, n2, d2, d3);
        this.tableLocked = bl2;
        this.suppliedLockMode = n4;
        if (n5 == 0) {
            this.unspecifiedIsolationLevel = true;
            n5 = this.getLanguageConnectionContext().getCurrentIsolationLevel();
        } else {
            this.unspecifiedIsolationLevel = false;
        }
        this.lockMode = this.getLockMode(n5);
        this.isolationLevel = this.translateLanguageIsolationLevel(n5);
        ExecPreparedStatement execPreparedStatement = activation.getPreparedStatement();
        this.resultRowBuilder = (ExecRowBuilder)execPreparedStatement.getSavedObject(n3);
        this.candidate = this.resultRowBuilder.build(activation.getExecutionFactory());
        this.accessedCols = n6 != -1 ? (FormatableBitSet)execPreparedStatement.getSavedObject(n6) : null;
    }

    void initIsolationLevel() {
        if (this.isolationLevelNeedsUpdate) {
            int n2 = this.getLanguageConnectionContext().getCurrentIsolationLevel();
            this.lockMode = this.getLockMode(n2);
            this.isolationLevel = this.translateLanguageIsolationLevel(n2);
            this.isolationLevelNeedsUpdate = false;
        }
    }

    private int getLockMode(int n2) {
        if (this.tableLocked || n2 == 4) {
            return this.suppliedLockMode;
        }
        return 6;
    }

    protected void setRowLocationsState() throws StandardException {
        this.fetchRowLocations = this.indexName == null && this.candidate.nColumns() > 0 && this.candidate.getColumn(this.candidate.nColumns()) instanceof RowLocation;
    }

    private int translateLanguageIsolationLevel(int n2) {
        switch (n2) {
            case 1: {
                return 1;
            }
            case 2: {
                if (!this.canGetInstantaneousLocks()) {
                    return 2;
                }
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
        }
        return 0;
    }

    abstract boolean canGetInstantaneousLocks();

    @Override
    public int getScanIsolationLevel() {
        return this.isolationLevel;
    }

    @Override
    public void close() throws StandardException {
        this.isolationLevelNeedsUpdate = this.unspecifiedIsolationLevel;
        this.candidate.resetRowArray();
        super.close();
    }

    @Override
    public Element toXML(Element element, String string) throws Exception {
        Element element2 = super.toXML(element, string);
        if (this.tableName != null) {
            element2.setAttribute("tableName", this.tableName);
        }
        if (this.indexName != null) {
            element2.setAttribute("indexName", this.indexName);
        }
        return element2;
    }
}

