/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.types.DataValueDescriptor;

public class RowUtil {
    private static long rowCountBase = 0L;

    public static void setRowCountBase(long l2) {
    }

    public static long getRowCountBase() {
        return rowCountBase;
    }

    public static ExecRow getEmptyValueRow(int n2, LanguageConnectionContext languageConnectionContext) {
        return languageConnectionContext.getLanguageConnectionFactory().getExecutionFactory().getValueRow(n2);
    }

    public static ExecIndexRow getEmptyIndexRow(int n2, LanguageConnectionContext languageConnectionContext) {
        return languageConnectionContext.getLanguageConnectionFactory().getExecutionFactory().getIndexableRow(n2);
    }

    public static void copyCloneColumns(ExecRow execRow, ExecRow execRow2, int n2) {
        for (int i2 = 1; i2 <= n2; ++i2) {
            execRow.setColumn(i2, execRow2.cloneColumn(i2));
        }
    }

    public static void copyRefColumns(ExecRow execRow, ExecRow execRow2) {
        DataValueDescriptor[] dataValueDescriptorArray = execRow2.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray2 = execRow.getRowArray();
        System.arraycopy(dataValueDescriptorArray, 0, dataValueDescriptorArray2, 0, dataValueDescriptorArray.length);
    }

    public static void copyRefColumns(ExecRow execRow, ExecRow execRow2, int n2) throws StandardException {
        RowUtil.copyRefColumns(execRow, 0, execRow2, 0, n2);
    }

    public static void copyRefColumns(ExecRow execRow, ExecRow execRow2, int n2, int n3) throws StandardException {
        RowUtil.copyRefColumns(execRow, 0, execRow2, n2, n3);
    }

    public static void copyRefColumns(ExecRow execRow, int n2, ExecRow execRow2, int n3, int n4) throws StandardException {
        for (int i2 = 1; i2 <= n4; ++i2) {
            execRow.setColumn(i2 + n2, execRow2.getColumn(i2 + n3));
        }
    }

    public static void copyRefColumns(ExecRow execRow, ExecRow execRow2, int[] nArray) throws StandardException {
        if (nArray == null) {
            return;
        }
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            execRow.setColumn(i2 + 1, execRow2.getColumn(nArray[i2]));
        }
    }

    public static void copyRefColumns(ExecRow execRow, ExecRow execRow2, FormatableBitSet formatableBitSet) throws StandardException {
        if (formatableBitSet == null) {
            return;
        }
        int n2 = execRow.getRowArray().length;
        int n3 = 1;
        for (int i2 = 1; i2 <= n2; ++i2) {
            if (!formatableBitSet.get(i2)) continue;
            execRow.setColumn(i2, execRow2.getColumn(n3));
            ++n3;
        }
    }

    public static void copyRefColumns(ExecRow execRow) throws StandardException {
        for (int i2 = 1; i2 <= execRow.nColumns(); ++i2) {
            execRow.setColumn(i2, null);
        }
    }

    public static String toString(ExecRow execRow) {
        return "";
    }

    public static String toString(Object[] objectArray) {
        return "";
    }

    public static String toString(ExecRow execRow, int n2, int n3) {
        return RowUtil.toString(execRow.getRowArray(), n2, n3);
    }

    public static String toString(Object[] objectArray, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(objectArray[i2]);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String toString(ExecRow execRow, int[] nArray) {
        return RowUtil.toString(execRow.getRowArray(), nArray);
    }

    public static String toString(Object[] objectArray, int[] nArray) {
        if (nArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(objectArray[nArray[i2] - 1]);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String intArrayToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(nArray[i2]);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static boolean inAscendingOrder(int[] nArray) {
        if (nArray != null) {
            int n2 = -1;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (n2 > nArray[i2]) {
                    return false;
                }
                n2 = nArray[i2];
            }
        }
        return true;
    }

    public static FormatableBitSet shift(FormatableBitSet formatableBitSet, int n2) {
        FormatableBitSet formatableBitSet2 = null;
        if (formatableBitSet != null) {
            int n3 = formatableBitSet.size();
            formatableBitSet2 = new FormatableBitSet(n3);
            for (int i2 = n2; i2 < n3; ++i2) {
                if (!formatableBitSet.get(i2)) continue;
                formatableBitSet2.set(i2 - n2);
            }
        }
        return formatableBitSet2;
    }
}

