/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

class RowResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public int rowsReturned;
    private boolean canCacheRow;
    private boolean next;
    private GeneratedMethod row;
    private ExecRow cachedRow;

    RowResultSet(Activation activation, GeneratedMethod generatedMethod, boolean bl2, int n2, double d2, double d3) {
        super(activation, n2, d2, d3);
        this.row = generatedMethod;
        this.canCacheRow = bl2;
        this.recordConstructorTime();
    }

    RowResultSet(Activation activation, ExecRow execRow, boolean bl2, int n2, double d2, double d3) {
        super(activation, n2, d2, d3);
        this.beginTime = this.getCurrentTimeMillis();
        this.cachedRow = execRow;
        this.canCacheRow = bl2;
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        this.next = false;
        this.beginTime = this.getCurrentTimeMillis();
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        this.currentRow = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            if (!this.next) {
                this.next = true;
                if (this.cachedRow != null) {
                    this.currentRow = this.cachedRow;
                } else if (this.row != null) {
                    this.currentRow = (ExecRow)this.row.invoke(this.activation);
                    if (this.canCacheRow) {
                        this.cachedRow = this.currentRow;
                    }
                }
                ++this.rowsReturned;
            }
            this.setCurrentRow(this.currentRow);
            this.nextTime += this.getElapsedMillis(this.beginTime);
        }
        return this.currentRow;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.next = false;
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public long getTimeSpent(int n2) {
        long l2 = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        return l2;
    }

    @Override
    public RowLocation getRowLocation() {
        return null;
    }

    @Override
    public ExecRow getCurrentRow() {
        return null;
    }
}

