/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.SQLWarning;
import java.sql.Timestamp;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.ResultSetStatisticsFactory;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.BasicNoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.NormalizeResultSet;
import org.apache.derby.impl.sql.execute.ValueRow;
import org.w3c.dom.Element;

abstract class NoRowsResultSetImpl
implements ResultSet {
    final Activation activation;
    private NoPutResultSet[] subqueryTrackingArray;
    private final boolean statisticsTimingOn;
    private boolean isOpen;
    final LanguageConnectionContext lcc;
    protected long beginTime;
    protected long endTime;
    protected long beginExecutionTime;
    protected long endExecutionTime;
    private int firstColumn = -1;
    private int[] generatedColumnPositions;
    private DataValueDescriptor[] normalizedGeneratedValues;

    NoRowsResultSetImpl(Activation activation) {
        this.activation = activation;
        this.lcc = activation.getLanguageConnectionContext();
        this.statisticsTimingOn = this.lcc.getStatisticsTiming();
        this.beginExecutionTime = this.beginTime = this.getCurrentTimeMillis();
    }

    void setup() throws StandardException {
        this.isOpen = true;
        StatementContext statementContext = this.lcc.getStatementContext();
        statementContext.setTopResultSet(this, this.subqueryTrackingArray);
        if (this.subqueryTrackingArray == null) {
            this.subqueryTrackingArray = statementContext.getSubqueryTrackingArray();
        }
    }

    @Override
    public final boolean returnsRows() {
        return false;
    }

    @Override
    public long modifiedRowCount() {
        return 0L;
    }

    @Override
    public ResultDescription getResultDescription() {
        return null;
    }

    @Override
    public final Activation getActivation() {
        return this.activation;
    }

    @Override
    public final ExecRow getAbsoluteRow(int n2) throws StandardException {
        throw StandardException.newException("XCL01.S", "absolute");
    }

    @Override
    public final ExecRow getRelativeRow(int n2) throws StandardException {
        throw StandardException.newException("XCL01.S", "relative");
    }

    @Override
    public final ExecRow setBeforeFirstRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "beforeFirst");
    }

    @Override
    public final ExecRow getFirstRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "first");
    }

    @Override
    public final ExecRow getNextRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "next");
    }

    @Override
    public final ExecRow getPreviousRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "previous");
    }

    @Override
    public final ExecRow getLastRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "last");
    }

    @Override
    public final ExecRow setAfterLastRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "afterLast");
    }

    @Override
    public final void clearCurrentRow() {
    }

    @Override
    public final boolean checkRowPosition(int n2) {
        return false;
    }

    @Override
    public final int getRowNumber() {
        return 0;
    }

    public void close(boolean bl2) throws StandardException {
        if (!this.isOpen) {
            return;
        }
        if (this.lcc.getRunTimeStatisticsMode() && !this.doesCommit() && !this.activation.isClosed() && !this.lcc.getStatementContext().getStatementWasInvalidated()) {
            this.endExecutionTime = this.getCurrentTimeMillis();
            ResultSetStatisticsFactory resultSetStatisticsFactory = this.lcc.getLanguageConnectionFactory().getExecutionFactory().getResultSetStatisticsFactory();
            RunTimeStatistics runTimeStatistics = resultSetStatisticsFactory.getRunTimeStatistics(this.activation, this, this.subqueryTrackingArray);
            this.lcc.setRunTimeStatisticsObject(runTimeStatistics);
            XPLAINVisitor xPLAINVisitor = this.lcc.getLanguageConnectionFactory().getExecutionFactory().getXPLAINFactory().getXPLAINVisitor();
            xPLAINVisitor.doXPLAIN(runTimeStatistics, this.activation);
        }
        int n2 = this.subqueryTrackingArray == null ? 0 : this.subqueryTrackingArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.subqueryTrackingArray[i2] == null || this.subqueryTrackingArray[i2].isClosed()) continue;
            this.subqueryTrackingArray[i2].close();
        }
        this.isOpen = false;
        if (this.activation.isSingleExecution() && !bl2) {
            this.activation.close();
        }
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen;
    }

    @Override
    public void finish() throws StandardException {
    }

    @Override
    public long getExecuteTime() {
        return this.endTime - this.beginTime;
    }

    @Override
    public Timestamp getBeginExecutionTimestamp() {
        if (this.beginExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.beginExecutionTime);
    }

    @Override
    public Timestamp getEndExecutionTimestamp() {
        if (this.endExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.endExecutionTime);
    }

    public String getQueryPlanText(int n2) {
        return MessageService.getTextMessage("42Z47.U", this.getClass().getName());
    }

    @Override
    public long getTimeSpent(int n2) {
        return 0L;
    }

    @Override
    public final NoPutResultSet[] getSubqueryTrackingArray(int n2) {
        if (this.subqueryTrackingArray == null) {
            this.subqueryTrackingArray = new NoPutResultSet[n2];
        }
        return this.subqueryTrackingArray;
    }

    @Override
    public ResultSet getAutoGeneratedKeysResultset() {
        return null;
    }

    @Override
    public String getCursorName() {
        return null;
    }

    protected final long getCurrentTimeMillis() {
        if (this.statisticsTimingOn) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateGenerationClauses(GeneratedMethod generatedMethod, Activation activation, NoPutResultSet noPutResultSet, ExecRow execRow, boolean bl2) throws StandardException {
        if (generatedMethod != null) {
            ExecRow execRow2 = (ExecRow)activation.getCurrentRow(noPutResultSet.resultSetNumber());
            try {
                noPutResultSet.setCurrentRow(execRow);
                activation.setCurrentRow(execRow, noPutResultSet.resultSetNumber());
                generatedMethod.invoke(activation);
                if (this.firstColumn < 0) {
                    this.firstColumn = NormalizeResultSet.computeStartColumn(bl2, activation.getResultDescription());
                }
                if (this.generatedColumnPositions == null) {
                    this.setupGeneratedColumns(activation, (ValueRow)execRow);
                }
                ResultDescription resultDescription = activation.getResultDescription();
                int n2 = this.generatedColumnPositions.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n3 = this.generatedColumnPositions[i2];
                    DataValueDescriptor dataValueDescriptor = NormalizeResultSet.normalizeColumn(resultDescription.getColumnDescriptor(n3).getType(), execRow, n3, this.normalizedGeneratedValues[i2], resultDescription);
                    execRow.setColumn(n3, dataValueDescriptor);
                }
            }
            finally {
                if (execRow2 == null) {
                    noPutResultSet.clearCurrentRow();
                } else {
                    noPutResultSet.setCurrentRow(execRow2);
                }
            }
        }
    }

    private void setupGeneratedColumns(Activation activation, ValueRow valueRow) throws StandardException {
        int n2;
        ResultDescription resultDescription = activation.getResultDescription();
        int n3 = resultDescription.getColumnCount();
        ExecRow execRow = valueRow.getNewNullRow();
        int n4 = 0;
        for (n2 = 1; n2 <= n3; ++n2) {
            ResultColumnDescriptor resultColumnDescriptor;
            if (n2 < this.firstColumn || !(resultColumnDescriptor = resultDescription.getColumnDescriptor(n2)).hasGenerationClause()) continue;
            ++n4;
        }
        this.generatedColumnPositions = new int[n4];
        this.normalizedGeneratedValues = new DataValueDescriptor[n4];
        n2 = 0;
        for (int i2 = 1; i2 <= n3; ++i2) {
            ResultColumnDescriptor resultColumnDescriptor;
            if (i2 < this.firstColumn || !(resultColumnDescriptor = resultDescription.getColumnDescriptor(i2)).hasGenerationClause()) continue;
            this.generatedColumnPositions[n2] = i2;
            this.normalizedGeneratedValues[n2] = execRow.getColumn(i2);
            ++n2;
        }
    }

    public boolean doesCommit() {
        return false;
    }

    @Override
    public void addWarning(SQLWarning sQLWarning) {
        this.getActivation().addWarning(sQLWarning);
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public Element toXML(Element element, String string) throws Exception {
        return BasicNoPutResultSetImpl.childrenToXML(BasicNoPutResultSetImpl.toXML(element, string, this), this);
    }
}

