/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.ResultSetStatisticsFactory;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.iapi.sql.execute.TargetResultSet;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.LocatedRow;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.BasicNoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.GenericQualifier;

abstract class NoPutResultSetImpl
extends BasicNoPutResultSetImpl {
    public final int resultSetNumber;
    private boolean needsRowLocation;
    private boolean needsRowLocationForDeferredCheckConstraints;
    protected ExecRow clonedExecRow;
    protected TargetResultSet targetResultSet;
    protected int[] checkNullCols;
    protected int cncLen;

    NoPutResultSetImpl(Activation activation, int n2, double d2, double d3) {
        super(null, activation, d2, d3);
        this.resultSetNumber = n2;
    }

    @Override
    public ResultDescription getResultDescription() {
        return this.activation.getResultDescription();
    }

    @Override
    public String getCursorName() {
        String string = this.activation.getCursorName();
        if (string == null && this.isForUpdate()) {
            this.activation.setCursorName(this.activation.getLanguageConnectionContext().getUniqueCursorName());
            string = this.activation.getCursorName();
        }
        return string;
    }

    @Override
    public int resultSetNumber() {
        return this.resultSetNumber;
    }

    @Override
    public void close() throws StandardException {
        if (!this.isOpen) {
            return;
        }
        if (this.isTopResultSet) {
            LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
            if (languageConnectionContext.getRunTimeStatisticsMode() && !languageConnectionContext.getStatementContext().getStatementWasInvalidated()) {
                this.endExecutionTime = this.getCurrentTimeMillis();
                ExecutionFactory executionFactory = languageConnectionContext.getLanguageConnectionFactory().getExecutionFactory();
                ResultSetStatisticsFactory resultSetStatisticsFactory = executionFactory.getResultSetStatisticsFactory();
                RunTimeStatistics runTimeStatistics = resultSetStatisticsFactory.getRunTimeStatistics(this.activation, this, this.subqueryTrackingArray);
                languageConnectionContext.setRunTimeStatisticsObject(runTimeStatistics);
                XPLAINVisitor xPLAINVisitor = executionFactory.getXPLAINFactory().getXPLAINVisitor();
                xPLAINVisitor.doXPLAIN(runTimeStatistics, this.activation);
            }
            int n2 = this.subqueryTrackingArray == null ? 0 : this.subqueryTrackingArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.subqueryTrackingArray[i2] == null || this.subqueryTrackingArray[i2].isClosed()) continue;
                this.subqueryTrackingArray[i2].close();
            }
        }
        this.isOpen = false;
    }

    @Override
    public void setTargetResultSet(TargetResultSet targetResultSet) {
        this.targetResultSet = targetResultSet;
    }

    @Override
    public void setNeedsRowLocation(boolean bl2) {
        this.needsRowLocation = bl2;
    }

    @Override
    public void setHasDeferrableChecks() {
        this.needsRowLocationForDeferredCheckConstraints = true;
    }

    @Override
    public FormatableBitSet getValidColumns() {
        return null;
    }

    @Override
    public DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        ExecRow execRow = this.getNextRowCore();
        if (execRow != null) {
            this.clonedExecRow = this.targetResultSet.preprocessSourceRow(execRow);
            return execRow.getRowArray();
        }
        return null;
    }

    @Override
    public boolean needsToClone() {
        return true;
    }

    @Override
    public void closeRowSource() {
    }

    @Override
    public boolean needsRowLocation() {
        return this.needsRowLocation;
    }

    @Override
    public boolean needsRowLocationForDeferredCheckConstraints() {
        return this.needsRowLocationForDeferredCheckConstraints;
    }

    @Override
    public void rowLocation(RowLocation rowLocation) throws StandardException {
        this.targetResultSet.changedRow(this.clonedExecRow, rowLocation);
    }

    @Override
    public void offendingRowLocation(RowLocation rowLocation, long l2) throws StandardException {
        this.targetResultSet.offendingRowLocation(rowLocation, l2);
    }

    protected void clearOrderableCache(Qualifier[][] qualifierArray) throws StandardException {
        if (qualifierArray != null) {
            for (int i2 = 0; i2 < qualifierArray.length; ++i2) {
                for (int i3 = 0; i3 < qualifierArray[i2].length; ++i3) {
                    Qualifier qualifier = qualifierArray[i2][i3];
                    qualifier.clearOrderableCache();
                    if (((GenericQualifier)qualifier).variantType == 0) continue;
                    qualifier.getOrderable();
                }
            }
        }
    }

    @Override
    public final void setCurrentRow(ExecRow execRow) {
        this.activation.setCurrentRow(execRow, this.resultSetNumber);
        this.currentRow = execRow;
    }

    @Override
    public void clearCurrentRow() {
        this.currentRow = null;
        this.activation.clearCurrentRow(this.resultSetNumber);
    }

    @Override
    public boolean isForUpdate() {
        return false;
    }

    protected boolean skipScan(ExecIndexRow execIndexRow, ExecIndexRow execIndexRow2) throws StandardException {
        int n2;
        int n3 = execIndexRow == null ? 0 : execIndexRow.nColumns();
        int n4 = execIndexRow2 == null ? 0 : execIndexRow2.nColumns();
        boolean bl2 = false;
        int n5 = n4;
        if (n3 > n4) {
            bl2 = true;
            n5 = n3;
        }
        if (n5 == 0) {
            return false;
        }
        if (this.checkNullCols == null || this.checkNullCols.length < n5) {
            this.checkNullCols = new int[n5];
        }
        this.cncLen = 0;
        boolean bl3 = false;
        for (n2 = 0; n2 < n3; ++n2) {
            if (execIndexRow.areNullsOrdered(n2)) continue;
            if (bl2) {
                this.checkNullCols[this.cncLen++] = n2 + 1;
            }
            if (!execIndexRow.getColumn(n2 + 1).isNull()) continue;
            bl3 = true;
            if (!bl2) break;
        }
        if (bl2 && bl3) {
            return true;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (execIndexRow2.areNullsOrdered(n2)) continue;
            if (!bl2) {
                this.checkNullCols[this.cncLen++] = n2 + 1;
            }
            if (bl3 || !execIndexRow2.getColumn(n2 + 1).isNull()) continue;
            bl3 = true;
            if (bl2) break;
        }
        return bl3;
    }

    protected boolean skipRow(ExecRow execRow) throws StandardException {
        for (int i2 = 0; i2 < this.cncLen; ++i2) {
            if (!execRow.getColumn(this.checkNullCols[i2]).isNull()) continue;
            return true;
        }
        return false;
    }

    public static String printQualifiers(Qualifier[][] qualifierArray) {
        String string = "";
        String string2 = "";
        if (qualifierArray == null) {
            return string + MessageService.getTextMessage("42Z37.U", new Object[0]);
        }
        for (int i2 = 0; i2 < qualifierArray.length; ++i2) {
            for (int i3 = 0; i3 < qualifierArray[i2].length; ++i3) {
                Qualifier qualifier = qualifierArray[i2][i3];
                string2 = string + string2 + MessageService.getTextMessage("42Z48.U", String.valueOf(i2), String.valueOf(i3)) + ": " + qualifier.getColumnId() + "\n";
                int n2 = qualifier.getOperator();
                String string3 = null;
                switch (n2) {
                    case 2: {
                        string3 = "=";
                        break;
                    }
                    case 3: {
                        string3 = "<=";
                        break;
                    }
                    case 1: {
                        string3 = "<";
                        break;
                    }
                    default: {
                        string3 = "unknown value (" + n2 + ")";
                    }
                }
                string2 = string2 + string + MessageService.getTextMessage("42Z43.U", new Object[0]) + ": " + string3 + "\n" + string + MessageService.getTextMessage("42Z44.U", new Object[0]) + ": " + qualifier.getOrderedNulls() + "\n" + string + MessageService.getTextMessage("42Z45.U", new Object[0]) + ": " + qualifier.getUnknownRV() + "\n" + string + MessageService.getTextMessage("42Z46.U", new Object[0]) + ": " + qualifier.negateCompareResult() + "\n";
            }
        }
        return string2;
    }

    @Override
    public void updateRow(ExecRow execRow, RowChanger rowChanger) throws StandardException {
    }

    @Override
    public void markRowAsDeleted() throws StandardException {
    }

    @Override
    public void positionScanAtRowLocation(RowLocation rowLocation) throws StandardException {
    }

    protected DataValueDescriptor[] unpackHashValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof DataValueDescriptor[]) {
            return (DataValueDescriptor[])object;
        }
        return ((LocatedRow)object).flatten();
    }
}

