/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.JoinResultSet;

class NestedLoopJoinResultSet
extends JoinResultSet {
    private boolean returnedRowMatchingRightSide = false;
    private ExecRow rightTemplate;

    @Override
    void clearScanState() {
        this.returnedRowMatchingRightSide = false;
        super.clearScanState();
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecRow execRow = null;
        boolean bl2 = false;
        boolean bl3 = false;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "next");
        }
        if (!this.isRightOpen && this.leftRow != null) {
            this.leftRow = this.leftResultSet.getNextRowCore();
            if (this.leftRow == null) {
                this.closeRight();
            } else {
                ++this.rowsSeenLeft;
                this.openRight();
            }
        }
        while (this.leftRow != null && !bl2) {
            DataValueDescriptor dataValueDescriptor;
            if (this.oneRowRightSide && this.returnedRowMatchingRightSide) {
                this.rightRow = null;
                this.returnedRowMatchingRightSide = false;
            } else {
                this.rightRow = this.rightResultSet.getNextRowCore();
                if (this.notExistsRightSide) {
                    this.rightRow = this.rightRow == null ? this.rightTemplate : null;
                }
                boolean bl4 = this.returnedRowMatchingRightSide = this.rightRow != null;
            }
            if (this.rightRow == null) {
                this.leftRow = this.leftResultSet.getNextRowCore();
                if (this.leftRow == null) {
                    this.closeRight();
                    continue;
                }
                ++this.rowsSeenLeft;
                this.openRight();
                continue;
            }
            ++this.rowsSeenRight;
            if (this.restriction != null) {
                DataValueDescriptor dataValueDescriptor2 = (DataValueDescriptor)this.restriction.invoke(this.activation);
                boolean bl5 = bl3 = !dataValueDescriptor2.isNull() && dataValueDescriptor2.getBoolean();
                if (!bl3) {
                    ++this.rowsFiltered;
                    continue;
                }
            }
            if (this.mergedRow == null) {
                this.mergedRow = this.getExecutionFactory().getValueRow(this.leftNumCols + this.rightNumCols);
            }
            int n2 = 1;
            int n3 = 1;
            while (n2 <= this.leftNumCols) {
                dataValueDescriptor = this.leftRow.getColumn(n2);
                if (dataValueDescriptor != null && dataValueDescriptor.hasStream()) {
                    dataValueDescriptor = dataValueDescriptor.cloneValue(false);
                }
                this.mergedRow.setColumn(n3, dataValueDescriptor);
                ++n2;
                ++n3;
            }
            if (!this.notExistsRightSide) {
                n2 = 1;
                while (n2 <= this.rightNumCols) {
                    dataValueDescriptor = this.rightRow.getColumn(n2);
                    if (dataValueDescriptor != null && dataValueDescriptor.hasStream()) {
                        dataValueDescriptor = dataValueDescriptor.cloneValue(false);
                    }
                    this.mergedRow.setColumn(n3, dataValueDescriptor);
                    ++n2;
                    ++n3;
                }
            }
            this.setCurrentRow(this.mergedRow);
            bl2 = true;
        }
        if (bl2) {
            execRow = this.mergedRow;
            ++this.rowsReturned;
        } else {
            this.clearCurrentRow();
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow;
    }

    @Override
    public void close() throws StandardException {
        if (this.isOpen) {
            this.beginTime = this.getCurrentTimeMillis();
            this.clearCurrentRow();
            super.close();
            this.returnedRowMatchingRightSide = false;
            this.closeTime += this.getElapsedMillis(this.beginTime);
        }
    }

    @Override
    public long getTimeSpent(int n2) {
        long l2 = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n2 == 0) {
            return l2 - this.leftResultSet.getTimeSpent(1) - this.rightResultSet.getTimeSpent(1);
        }
        return l2;
    }

    NestedLoopJoinResultSet(NoPutResultSet noPutResultSet, int n2, NoPutResultSet noPutResultSet2, int n3, Activation activation, GeneratedMethod generatedMethod, int n4, boolean bl2, boolean bl3, double d2, double d3, String string) {
        super(noPutResultSet, n2, noPutResultSet2, n3, activation, generatedMethod, n4, bl2, bl3, d2, d3, string);
        if (bl3) {
            this.rightTemplate = this.getExecutionFactory().getValueRow(n3);
        }
    }
}

