/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Arrays;
import java.util.Collections;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.TableScanResultSet;

class MultiProbeTableScanResultSet
extends TableScanResultSet
implements CursorResultSet {
    protected DataValueDescriptor[] probeValues;
    protected DataValueDescriptor[] origProbeValues;
    protected int probeValIndex;
    private int sortRequired;
    private boolean skipNextScan;

    MultiProbeTableScanResultSet(long l2, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, Activation activation, int n2, int n3, GeneratedMethod generatedMethod, int n4, GeneratedMethod generatedMethod2, int n5, boolean bl2, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray, int n6, String string, String string2, String string3, boolean bl3, boolean bl4, int n7, int n8, int n9, boolean bl5, int n10, boolean bl6, double d2, double d3) throws StandardException {
        super(l2, staticCompiledOpenConglomInfo, activation, n2, n3, generatedMethod, n4, generatedMethod2, n5, bl2, qualifierArray, string, string2, string3, bl3, bl4, n7, n8, n9, bl5, n10, 1, bl6, d2, d3);
        this.origProbeValues = dataValueDescriptorArray;
        this.sortRequired = n6;
    }

    @Override
    public void openCore() throws StandardException {
        if (this.sortRequired == 3) {
            this.probeValues = this.origProbeValues;
        } else {
            Object[] objectArray = new DataValueDescriptor[this.origProbeValues.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                objectArray[i2] = this.origProbeValues[i2].cloneValue(false);
            }
            if (this.sortRequired == 1) {
                Arrays.sort(objectArray);
            } else {
                Arrays.sort(objectArray, Collections.reverseOrder());
            }
            this.probeValues = objectArray;
        }
        this.probeValIndex = 0;
        super.openCore();
    }

    @Override
    public void reopenCore() throws StandardException {
        this.reopenCore(false);
    }

    private void reopenCore(boolean bl2) throws StandardException {
        if (!bl2) {
            this.probeValIndex = 0;
        }
        super.reopenCore();
    }

    @Override
    protected void reopenScanController() throws StandardException {
        long l2 = this.rowsThisScan;
        super.reopenScanController();
        this.rowsThisScan = l2;
    }

    @Override
    void initStartAndStopKey() throws StandardException {
        super.initStartAndStopKey();
        if (this.probeValIndex == 0) {
            this.rowsThisScan = 0L;
        }
        DataValueDescriptor[] dataValueDescriptorArray = this.startPosition.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray2 = this.stopPosition.getRowArray();
        DataValueDescriptor dataValueDescriptor = this.getNextProbeValue();
        if (dataValueDescriptor != null) {
            dataValueDescriptorArray[0] = dataValueDescriptor;
            if (!this.sameStartStopPosition) {
                dataValueDescriptorArray2[0] = dataValueDescriptorArray[0];
            }
        }
        this.skipNextScan = dataValueDescriptor == null;
    }

    @Override
    protected boolean skipScan(ExecIndexRow execIndexRow, ExecIndexRow execIndexRow2) throws StandardException {
        return this.skipNextScan || super.skipScan(execIndexRow, execIndexRow2);
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        this.checkCancellationFlag();
        ExecRow execRow = super.getNextRowCore();
        while (execRow == null && this.moreInListVals()) {
            this.reopenCore(true);
            execRow = super.getNextRowCore();
        }
        return execRow;
    }

    @Override
    public void close() throws StandardException {
        super.close();
    }

    private boolean moreInListVals() {
        return this.probeValIndex < this.probeValues.length;
    }

    private DataValueDescriptor getNextProbeValue() {
        int n2;
        for (n2 = this.probeValIndex; n2 > 0 && n2 < this.probeValues.length && this.probeValues[this.probeValIndex - 1].equals(this.probeValues[n2]); ++n2) {
        }
        this.probeValIndex = n2;
        if (this.probeValIndex < this.probeValues.length) {
            return this.probeValues[this.probeValIndex++];
        }
        return null;
    }
}

