/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.TriggerInfo;
import org.apache.derby.impl.sql.execute.WriteCursorConstantAction;

public class InsertConstantAction
extends WriteCursorConstantAction {
    boolean[] indexedCols;
    private String schemaName;
    private String tableName;
    private String[] columnNames;
    RowLocation[] autoincRowLocation;
    private long[] autoincIncrement;
    private transient int firstAutoGenColumn = -1;
    public final boolean hasDeferrableChecks;
    String identitySequenceUUIDString;

    public InsertConstantAction() {
        this.hasDeferrableChecks = false;
    }

    InsertConstantAction(TableDescriptor tableDescriptor, long l2, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, IndexRowGenerator[] indexRowGeneratorArray, long[] lArray, StaticCompiledOpenConglomInfo[] staticCompiledOpenConglomInfoArray, String[] stringArray, boolean bl2, boolean bl3, Properties properties, UUID uUID, int n2, FKInfo[] fKInfoArray, TriggerInfo triggerInfo, int[] nArray, boolean[] blArray, boolean bl4, RowLocation[] rowLocationArray, boolean bl5, String string) {
        super(l2, staticCompiledOpenConglomInfo, indexRowGeneratorArray, lArray, staticCompiledOpenConglomInfoArray, stringArray, bl2, properties, uUID, n2, fKInfoArray, triggerInfo, null, null, nArray, bl4, bl5);
        this.indexedCols = blArray;
        this.autoincRowLocation = rowLocationArray;
        this.schemaName = tableDescriptor.getSchemaName();
        this.tableName = tableDescriptor.getName();
        this.columnNames = tableDescriptor.getColumnNamesArray();
        this.autoincIncrement = tableDescriptor.getAutoincIncrementArray();
        this.indexNames = stringArray;
        this.hasDeferrableChecks = bl3;
        this.identitySequenceUUIDString = string;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n2;
        Object[] objectArray = null;
        super.readExternal(objectInput);
        this.indexedCols = ArrayUtil.readBooleanArray(objectInput);
        objectArray = ArrayUtil.readObjectArray(objectInput);
        if (objectArray != null) {
            this.autoincRowLocation = new RowLocation[objectArray.length];
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                this.autoincRowLocation[n2] = (RowLocation)objectArray[n2];
            }
        }
        this.schemaName = (String)objectInput.readObject();
        this.tableName = (String)objectInput.readObject();
        objectArray = ArrayUtil.readObjectArray(objectInput);
        if (objectArray != null) {
            this.columnNames = new String[objectArray.length];
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                this.columnNames[n2] = (String)objectArray[n2];
            }
        }
        this.autoincIncrement = ArrayUtil.readLongArray(objectInput);
        this.identitySequenceUUIDString = (String)objectInput.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        ArrayUtil.writeBooleanArray(objectOutput, this.indexedCols);
        ArrayUtil.writeArray(objectOutput, this.autoincRowLocation);
        objectOutput.writeObject(this.schemaName);
        objectOutput.writeObject(this.tableName);
        ArrayUtil.writeArray(objectOutput, this.columnNames);
        ArrayUtil.writeLongArray(objectOutput, this.autoincIncrement);
        objectOutput.writeObject(this.identitySequenceUUIDString);
    }

    public int getAutoGenColumn() {
        if (!this.hasAutoincrement()) {
            return -1;
        }
        if (this.firstAutoGenColumn < 0) {
            for (int i2 = 0; i2 < this.autoincIncrement.length; ++i2) {
                if (this.autoincIncrement[i2] <= 0L) continue;
                this.firstAutoGenColumn = i2;
                break;
            }
        }
        return this.firstAutoGenColumn;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName(int n2) {
        return this.columnNames[n2];
    }

    String[] getColumnNames() {
        return this.columnNames;
    }

    public long getAutoincIncrement(int n2) {
        return this.autoincIncrement[n2];
    }

    public boolean hasAutoincrement() {
        return this.autoincRowLocation != null;
    }

    RowLocation[] getAutoincRowLocation() {
        return this.autoincRowLocation;
    }

    @Override
    public int getTypeFormatId() {
        return 38;
    }
}

