/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Iterator;
import java.util.List;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermDescriptor;
import org.apache.derby.iapi.sql.dictionary.PrivilegedSQLObject;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.PrivilegeInfo;

public class GenericPrivilegeInfo
extends PrivilegeInfo {
    private PrivilegedSQLObject _tupleDescriptor;
    private String _privilege;
    private boolean _restrict;

    public GenericPrivilegeInfo(PrivilegedSQLObject privilegedSQLObject, String string, boolean bl2) {
        this._tupleDescriptor = privilegedSQLObject;
        this._privilege = string;
        this._restrict = bl2;
    }

    @Override
    public void executeGrantRevoke(Activation activation, boolean bl2, List list) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        String string = languageConnectionContext.getCurrentUserId(activation);
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        SchemaDescriptor schemaDescriptor = this._tupleDescriptor.getSchemaDescriptor();
        UUID uUID = this._tupleDescriptor.getUUID();
        String string2 = this._tupleDescriptor.getObjectTypeName();
        this.checkOwnership(string, this._tupleDescriptor, schemaDescriptor, dataDictionary);
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        PermDescriptor permDescriptor = dataDescriptorGenerator.newPermDescriptor(null, string2, uUID, this._privilege, string, null, false);
        dataDictionary.startWriting(languageConnectionContext);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            boolean bl3 = false;
            String string3 = (String)iterator.next();
            if (dataDictionary.addRemovePermissionsDescriptor(bl2, permDescriptor, string3, transactionController)) {
                bl3 = true;
                int n2 = this._restrict ? 45 : 44;
                dataDictionary.getDependencyManager().invalidateFor(permDescriptor, n2, languageConnectionContext);
                dataDictionary.getDependencyManager().invalidateFor(this._tupleDescriptor, n2, languageConnectionContext);
            }
            this.addWarningIfPrivilegeNotRevoked(activation, bl2, bl3, string3);
        }
    }
}

