/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.StatementUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DeferredConstraintsMemory;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.GenericRIChecker;
import org.apache.derby.impl.sql.execute.RowUtil;

public class ForeignKeyRIChecker
extends GenericRIChecker {
    ForeignKeyRIChecker(LanguageConnectionContext languageConnectionContext, TransactionController transactionController, FKInfo fKInfo) throws StandardException {
        super(languageConnectionContext, transactionController, fKInfo);
    }

    @Override
    void doCheck(Activation activation, ExecRow execRow, boolean bl2, int n2) throws StandardException {
        if (bl2) {
            return;
        }
        if (this.isAnyFieldNull(execRow)) {
            return;
        }
        ScanController scanController = this.getScanController(this.fkInfo.refConglomNumber, this.refScoci, this.refDcoci, execRow);
        if (!scanController.next()) {
            UUID uUID = this.fkInfo.fkIds[0];
            this.close();
            if (this.fkInfo.deferrable[0] && this.lcc.isEffectivelyDeferred(this.lcc.getCurrentSQLSessionContext(activation), uUID)) {
                this.deferredRowsHashTable = DeferredConstraintsMemory.rememberFKViolation(this.lcc, this.deferredRowsHashTable, this.fkInfo.fkIds[0], this.indexQualifierRow.getRowArray(), this.fkInfo.schemaName, this.fkInfo.tableName);
            } else {
                StandardException standardException = StandardException.newException("23503", this.fkInfo.fkConstraintNames[0], this.fkInfo.tableName, StatementUtil.typeName(this.fkInfo.stmtType), RowUtil.toString(execRow, this.fkInfo.colArray));
                throw standardException;
            }
        }
    }

    @Override
    int getRICheckIsolationLevel() {
        return 2;
    }
}

