/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.types.RowLocation;

public class FKInfo
implements Formatable {
    public static final int FOREIGN_KEY = 1;
    public static final int REFERENCED_KEY = 2;
    String schemaName;
    String tableName;
    int type;
    UUID refUUID;
    long refConglomNumber;
    UUID refConstraintID;
    boolean refConstraintIsDeferrable;
    int stmtType;
    RowLocation rowLocation;
    String[] fkConstraintNames;
    private UUID[] fkUUIDs;
    long[] fkConglomNumbers;
    UUID[] fkIds;
    boolean[] fkIsSelfReferencing;
    int[] colArray;
    int[] raRules;
    boolean[] deferrable;

    public FKInfo() {
    }

    public FKInfo(String[] stringArray, String string, String string2, int n2, int n3, UUID uUID, long l2, UUID uUID2, boolean bl2, UUID[] uUIDArray, long[] lArray, boolean[] blArray, int[] nArray, RowLocation rowLocation, int[] nArray2, boolean[] blArray2, UUID[] uUIDArray2) {
        this.fkConstraintNames = ArrayUtil.copy(stringArray);
        this.tableName = string2;
        this.schemaName = string;
        this.stmtType = n2;
        this.type = n3;
        this.refUUID = uUID;
        this.refConglomNumber = l2;
        this.refConstraintID = uUID2;
        this.refConstraintIsDeferrable = bl2;
        this.fkUUIDs = ArrayUtil.copy(uUIDArray);
        this.fkConglomNumbers = ArrayUtil.copy(lArray);
        this.fkIsSelfReferencing = ArrayUtil.copy(blArray);
        this.colArray = ArrayUtil.copy(nArray);
        this.rowLocation = rowLocation;
        this.raRules = ArrayUtil.copy(nArray2);
        this.deferrable = ArrayUtil.copy(blArray2);
        this.fkIds = ArrayUtil.copy(uUIDArray2);
    }

    public static FKInfo[] chooseRelevantFKInfos(FKInfo[] fKInfoArray, int[] nArray, boolean bl2) {
        int n2;
        int n3;
        if (fKInfoArray == null) {
            return null;
        }
        Vector<FKInfo> vector = new Vector<FKInfo>();
        FKInfo[] fKInfoArray2 = null;
        for (n3 = 0; n3 < fKInfoArray.length; ++n3) {
            if (bl2 && fKInfoArray[n3].type == 1) {
                vector.addElement(fKInfoArray[n3]);
                continue;
            }
            n2 = fKInfoArray[n3].colArray.length;
            block1: for (int i2 = 0; i2 < n2; ++i2) {
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    if (fKInfoArray[n3].colArray[i2] != nArray[i3]) continue;
                    vector.addElement(fKInfoArray[n3]);
                    i2 = n2;
                    continue block1;
                }
            }
        }
        n3 = vector.size();
        if (n3 > 0) {
            fKInfoArray2 = new FKInfo[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                fKInfoArray2[n2] = (FKInfo)vector.elementAt(n2);
            }
        }
        return fKInfoArray2;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        FormatIdUtil.writeFormatIdInteger(objectOutput, this.rowLocation.getTypeFormatId());
        objectOutput.writeObject(this.schemaName);
        objectOutput.writeObject(this.tableName);
        objectOutput.writeInt(this.type);
        objectOutput.writeInt(this.stmtType);
        objectOutput.writeObject(this.refUUID);
        objectOutput.writeLong(this.refConglomNumber);
        objectOutput.writeObject(this.refConstraintID);
        objectOutput.writeBoolean(this.refConstraintIsDeferrable);
        ArrayUtil.writeArray(objectOutput, this.fkConstraintNames);
        ArrayUtil.writeArray(objectOutput, this.fkUUIDs);
        ArrayUtil.writeLongArray(objectOutput, this.fkConglomNumbers);
        ArrayUtil.writeBooleanArray(objectOutput, this.fkIsSelfReferencing);
        ArrayUtil.writeIntArray(objectOutput, this.colArray);
        ArrayUtil.writeIntArray(objectOutput, this.raRules);
        ArrayUtil.writeBooleanArray(objectOutput, this.deferrable);
        ArrayUtil.writeArray(objectOutput, this.fkIds);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        try {
            int n2 = FormatIdUtil.readFormatIdInteger(objectInput);
            this.rowLocation = (RowLocation)Monitor.newInstanceFromIdentifier(n2);
            this.schemaName = (String)objectInput.readObject();
            this.tableName = (String)objectInput.readObject();
            this.type = objectInput.readInt();
            this.stmtType = objectInput.readInt();
            this.refUUID = (UUID)objectInput.readObject();
            this.refConglomNumber = objectInput.readLong();
            this.refConstraintID = (UUID)objectInput.readObject();
            this.refConstraintIsDeferrable = objectInput.readBoolean();
            this.fkConstraintNames = new String[ArrayUtil.readArrayLength(objectInput)];
            ArrayUtil.readArrayItems(objectInput, this.fkConstraintNames);
            this.fkUUIDs = new UUID[ArrayUtil.readArrayLength(objectInput)];
            ArrayUtil.readArrayItems(objectInput, this.fkUUIDs);
            this.fkConglomNumbers = ArrayUtil.readLongArray(objectInput);
            this.fkIsSelfReferencing = ArrayUtil.readBooleanArray(objectInput);
            this.colArray = ArrayUtil.readIntArray(objectInput);
            this.raRules = ArrayUtil.readIntArray(objectInput);
            this.deferrable = ArrayUtil.readBooleanArray(objectInput);
            this.fkIds = new UUID[ArrayUtil.readArrayLength(objectInput)];
            ArrayUtil.readArrayItems(objectInput, this.fkIds);
        }
        catch (StandardException standardException) {
            throw new StreamCorruptedException(standardException.toString());
        }
    }

    @Override
    public int getTypeFormatId() {
        return 282;
    }

    public String toString() {
        return "";
    }
}

