/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class DropStatisticsConstantAction
extends DDLConstantAction {
    private final String objectName;
    private final boolean forTable;
    private final SchemaDescriptor sd;
    private final String fullTableName;

    DropStatisticsConstantAction(SchemaDescriptor schemaDescriptor, String string, String string2, boolean bl2) {
        this.objectName = string2;
        this.sd = schemaDescriptor;
        this.forTable = bl2;
        this.fullTableName = string;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        TableDescriptor tableDescriptor;
        ConglomerateDescriptor conglomerateDescriptor = null;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dataDictionary.startWriting(languageConnectionContext);
        if (this.forTable) {
            tableDescriptor = dataDictionary.getTableDescriptor(this.objectName, this.sd, transactionController);
        } else {
            conglomerateDescriptor = dataDictionary.getConglomerateDescriptor(this.objectName, this.sd, false);
            tableDescriptor = dataDictionary.getTableDescriptor(conglomerateDescriptor.getTableID());
        }
        dependencyManager.invalidateFor(tableDescriptor, 39, languageConnectionContext);
        dataDictionary.dropStatisticsDescriptors(tableDescriptor.getUUID(), conglomerateDescriptor != null ? conglomerateDescriptor.getUUID() : null, transactionController);
    }

    public String toString() {
        return "DROP STATISTICS FOR " + (this.forTable ? "table " : "index ") + this.fullTableName;
    }
}

