/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.TemporaryRowHolder;
import org.apache.derby.impl.sql.execute.DeleteResultSet;
import org.apache.derby.impl.sql.execute.UpdateResultSet;

class DeleteCascadeResultSet
extends DeleteResultSet {
    ResultSet[] dependentResultSets;
    private int noDependents = 0;
    private final String resultSetId;
    private boolean mainNodeForTable = true;
    private boolean affectedRows = false;
    private int tempRowHolderId;

    public DeleteCascadeResultSet(NoPutResultSet noPutResultSet, Activation activation, int n2, ResultSet[] resultSetArray, String string) throws StandardException {
        super(noPutResultSet, n2 == -1 ? activation.getConstantAction() : (ConstantAction)activation.getPreparedStatement().getSavedObject(n2), activation);
        if (n2 == -1) {
            ConstantAction constantAction = activation.getConstantAction();
        } else {
            ConstantAction constantAction = (ConstantAction)activation.getPreparedStatement().getSavedObject(n2);
            this.resultDescription = this.constants.resultDescription;
        }
        this.cascadeDelete = true;
        this.resultSetId = string;
        if (resultSetArray != null) {
            this.noDependents = resultSetArray.length;
            this.dependentResultSets = resultSetArray;
        }
    }

    @Override
    public void open() throws StandardException {
        try {
            this.setup();
            if (this.isMultipleDeletePathsExist()) {
                this.setRowHoldersTypeToUniqueStream();
                while (this.collectAffectedRows(false)) {
                }
            } else {
                this.collectAffectedRows(false);
            }
            if (!this.affectedRows) {
                this.activation.addWarning(StandardException.newWarning("02000", new Object[0]));
            }
            this.runFkChecker(true);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            this.mergeRowHolders(hashMap);
            this.fireBeforeTriggers(hashMap);
            this.deleteDeferredRows();
            this.runFkChecker(false);
            this.rowChangerFinish();
            this.fireAfterTriggers();
        }
        finally {
            this.cleanUp();
            this.activation.clearParentResultSets();
        }
        this.endTime = this.getCurrentTimeMillis();
    }

    @Override
    void setup() throws StandardException {
        if (this.lcc.getRunTimeStatisticsMode()) {
            this.savedSource = this.source;
        }
        super.setup();
        this.activation.setParentResultSet(this.rowHolder, this.resultSetId);
        Vector<TemporaryRowHolder> vector = this.activation.getParentResultSet(this.resultSetId);
        this.tempRowHolderId = vector.size() - 1;
        for (int i2 = 0; i2 < this.noDependents; ++i2) {
            if (this.dependentResultSets[i2] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i2]).setup();
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i2]).setup();
        }
    }

    boolean collectAffectedRows(boolean bl2) throws StandardException {
        if (super.collectAffectedRows()) {
            this.affectedRows = true;
            bl2 = true;
        }
        for (int i2 = 0; i2 < this.noDependents; ++i2) {
            if (this.dependentResultSets[i2] instanceof UpdateResultSet) {
                if (!((UpdateResultSet)this.dependentResultSets[i2]).collectAffectedRows()) continue;
                bl2 = true;
                continue;
            }
            if (!((DeleteCascadeResultSet)this.dependentResultSets[i2]).collectAffectedRows(bl2)) continue;
            bl2 = true;
        }
        return bl2;
    }

    void fireBeforeTriggers(HashMap<String, String> hashMap) throws StandardException {
        if (!this.mainNodeForTable && !hashMap.containsKey(this.resultSetId)) {
            this.mainNodeForTable = true;
            hashMap.put(this.resultSetId, this.resultSetId);
        }
        for (int i2 = 0; i2 < this.noDependents; ++i2) {
            if (this.dependentResultSets[i2] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i2]).fireBeforeTriggers();
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i2]).fireBeforeTriggers(hashMap);
        }
        if (this.mainNodeForTable && this.constants.deferred) {
            super.fireBeforeTriggers();
        }
    }

    @Override
    void fireAfterTriggers() throws StandardException {
        for (int i2 = 0; i2 < this.noDependents && this.affectedRows; ++i2) {
            if (this.dependentResultSets[i2] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i2]).fireAfterTriggers();
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i2]).fireAfterTriggers();
        }
        if (this.mainNodeForTable && this.constants.deferred) {
            super.fireAfterTriggers();
        }
    }

    @Override
    void deleteDeferredRows() throws StandardException {
        for (int i2 = 0; i2 < this.noDependents; ++i2) {
            if (this.dependentResultSets[i2] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i2]).updateDeferredRows();
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i2]).deleteDeferredRows();
        }
        if (this.mainNodeForTable) {
            super.deleteDeferredRows();
        }
    }

    @Override
    void runFkChecker(boolean bl2) throws StandardException {
        for (int i2 = 0; i2 < this.noDependents; ++i2) {
            if (this.dependentResultSets[i2] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i2]).runChecker(bl2);
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i2]).runFkChecker(bl2);
        }
        if (this.mainNodeForTable) {
            super.runFkChecker(bl2);
        }
    }

    @Override
    public void cleanUp() throws StandardException {
        super.cleanUp();
        for (int i2 = 0; i2 < this.noDependents; ++i2) {
            if (this.dependentResultSets[i2] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i2]).cleanUp();
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i2]).cleanUp();
        }
        this.endTime = this.getCurrentTimeMillis();
    }

    private void rowChangerFinish() throws StandardException {
        this.rc.finish();
        for (int i2 = 0; i2 < this.noDependents; ++i2) {
            if (this.dependentResultSets[i2] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i2]).rowChangerFinish();
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i2]).rowChangerFinish();
        }
    }

    private void mergeRowHolders(HashMap<String, String> hashMap) throws StandardException {
        if (hashMap.containsKey(this.resultSetId) || this.rowCount == 0L) {
            this.mainNodeForTable = false;
        } else {
            this.mergeResultSets();
            this.mainNodeForTable = true;
            hashMap.put(this.resultSetId, this.resultSetId);
        }
        for (int i2 = 0; i2 < this.noDependents; ++i2) {
            if (this.dependentResultSets[i2] instanceof UpdateResultSet) {
                return;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i2]).mergeRowHolders(hashMap);
        }
    }

    private void mergeResultSets() throws StandardException {
        Vector<TemporaryRowHolder> vector = this.activation.getParentResultSet(this.resultSetId);
        int n2 = vector.size();
        if (n2 > 1) {
            int n3 = 0;
            while (n3 < n2) {
                ExecRow execRow;
                if (n3 == this.tempRowHolderId) {
                    ++n3;
                    continue;
                }
                TemporaryRowHolder temporaryRowHolder = vector.elementAt(n3);
                CursorResultSet cursorResultSet = temporaryRowHolder.getResultSet();
                cursorResultSet.open();
                while ((execRow = cursorResultSet.getNextRow()) != null) {
                    this.rowHolder.insert(execRow);
                }
                cursorResultSet.close();
                ++n3;
            }
        }
    }

    @Override
    public void finish() throws StandardException {
        super.finish();
        this.activation.clearParentResultSets();
    }

    private boolean isMultipleDeletePathsExist() {
        Enumeration<String> enumeration = this.activation.getParentResultSetKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Vector<TemporaryRowHolder> vector = this.activation.getParentResultSet(string);
            if (vector.size() <= 1) continue;
            return true;
        }
        return false;
    }

    private void setRowHoldersTypeToUniqueStream() {
        Enumeration<String> enumeration = this.activation.getParentResultSetKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Vector<TemporaryRowHolder> vector = this.activation.getParentResultSet(string);
            int n2 = vector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                TemporaryRowHolder temporaryRowHolder = vector.elementAt(i2);
                temporaryRowHolder.setRowHolderTypeToUniqueStream();
            }
        }
    }
}

