/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.InputStream;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.NoRowsResultSetImpl;
import org.apache.derby.impl.sql.execute.NormalizeResultSet;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.UpdatableVTIConstantAction;
import org.apache.derby.impl.sql.execute.WriteCursorConstantAction;

public abstract class DMLWriteResultSet
extends NoRowsResultSetImpl {
    protected WriteCursorConstantAction constantAction;
    protected int[] baseRowReadMap;
    protected int[] streamStorableHeapColIds;
    protected DynamicCompiledOpenConglomInfo heapDCOCI;
    protected DynamicCompiledOpenConglomInfo[] indexDCOCIs;
    private boolean needToObjectifyStream;
    public long rowCount;
    protected ResultDescription resultDescription;
    protected DataValueDescriptor[] cachedDestinations;

    DMLWriteResultSet(Activation activation) throws StandardException {
        this(activation, activation.getConstantAction());
    }

    DMLWriteResultSet(Activation activation, ConstantAction constantAction) throws StandardException {
        super(activation);
        this.constantAction = (WriteCursorConstantAction)constantAction;
        this.baseRowReadMap = this.constantAction.getBaseRowReadMap();
        this.streamStorableHeapColIds = this.constantAction.getStreamStorableHeapColIds();
        TransactionController transactionController = activation.getTransactionController();
        if (!(constantAction instanceof UpdatableVTIConstantAction)) {
            this.heapDCOCI = transactionController.getDynamicCompiledConglomInfo(this.constantAction.conglomId);
            if (this.constantAction.indexCIDS.length != 0) {
                this.indexDCOCIs = new DynamicCompiledOpenConglomInfo[this.constantAction.indexCIDS.length];
                for (int i2 = 0; i2 < this.constantAction.indexCIDS.length; ++i2) {
                    this.indexDCOCIs[i2] = transactionController.getDynamicCompiledConglomInfo(this.constantAction.indexCIDS[i2]);
                }
            }
        }
        this.needToObjectifyStream = this.constantAction.getTriggerInfo() != null;
    }

    @Override
    public final long modifiedRowCount() {
        return this.rowCount + RowUtil.getRowCountBase();
    }

    @Override
    public ResultDescription getResultDescription() {
        return this.resultDescription;
    }

    protected ExecRow getNextRowCore(NoPutResultSet noPutResultSet) throws StandardException {
        ExecRow execRow = noPutResultSet.getNextRowCore();
        if (this.needToObjectifyStream) {
            this.objectifyStreams(execRow);
        }
        return execRow;
    }

    private void objectifyStreams(ExecRow execRow) throws StandardException {
        if (execRow != null && this.streamStorableHeapColIds != null) {
            for (int i2 = 0; i2 < this.streamStorableHeapColIds.length; ++i2) {
                int n2 = this.streamStorableHeapColIds[i2];
                int n3 = this.baseRowReadMap == null ? n2 : this.baseRowReadMap[n2];
                DataValueDescriptor dataValueDescriptor = execRow.getColumn(n3 + 1);
                if (dataValueDescriptor == null) continue;
                InputStream inputStream = ((StreamStorable)((Object)dataValueDescriptor)).returnStream();
                ((StreamStorable)((Object)dataValueDescriptor)).loadStream();
                if (inputStream == null) continue;
                for (int i3 = 1; i3 <= execRow.nColumns(); ++i3) {
                    DataValueDescriptor dataValueDescriptor2 = execRow.getColumn(i3);
                    if (!(dataValueDescriptor2 instanceof StreamStorable) || ((StreamStorable)((Object)dataValueDescriptor2)).returnStream() != inputStream) continue;
                    execRow.setColumn(i3, dataValueDescriptor.cloneValue(false));
                }
            }
        }
    }

    protected ExecRow makeDeferredSparseRow(ExecRow execRow, FormatableBitSet formatableBitSet, LanguageConnectionContext languageConnectionContext) throws StandardException {
        ExecRow execRow2;
        if (formatableBitSet == null) {
            execRow2 = execRow;
        } else {
            execRow2 = RowUtil.getEmptyValueRow(formatableBitSet.getLength() - 1, languageConnectionContext);
            int n2 = 1;
            for (int i2 = 1; i2 <= execRow2.nColumns(); ++i2) {
                if (!formatableBitSet.isSet(i2)) continue;
                execRow2.setColumn(i2, execRow.getColumn(n2++));
            }
        }
        return execRow2;
    }

    int decodeLockMode(int n2) {
        if (n2 >>> 16 == 0) {
            return n2;
        }
        int n3 = this.lcc.getCurrentIsolationLevel();
        if (n3 == 4) {
            return n2 >>> 16;
        }
        return n2 & 0xFF;
    }

    String getIndexNameFromCID(long l2) {
        return this.constantAction.getIndexNameFromCID(l2);
    }

    protected ExecRow normalizeRow(NoPutResultSet noPutResultSet, ExecRow execRow) throws StandardException {
        Object object;
        int n2;
        int n3;
        int n4 = this.resultDescription.getColumnCount();
        if (this.cachedDestinations == null) {
            this.cachedDestinations = new DataValueDescriptor[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = n3 + 1;
                object = this.resultDescription.getColumnDescriptor(n2);
                this.cachedDestinations[n3] = object.getType().getNull();
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = n3 + 1;
            object = this.resultDescription.getColumnDescriptor(n2).getType();
            if (execRow.getColumn(n2) == null) {
                execRow.setColumn(n2, ((DataTypeDescriptor)object).getNull());
            }
            execRow.setColumn(n2, NormalizeResultSet.normalizeColumn((DataTypeDescriptor)object, execRow, n2, this.cachedDestinations[n3], this.resultDescription));
        }
        this.activation.setCurrentRow(execRow, noPutResultSet.resultSetNumber());
        return execRow;
    }

    public void rememberConstraint(UUID uUID) throws StandardException {
    }
}

