/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.KeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.impl.sql.execute.CreateIndexConstantAction;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

abstract class DDLSingleTableConstantAction
extends DDLConstantAction {
    protected UUID tableId;

    DDLSingleTableConstantAction(UUID uUID) {
        this.tableId = uUID;
    }

    void dropConstraint(ConstraintDescriptor constraintDescriptor, Activation activation, LanguageConnectionContext languageConnectionContext, boolean bl2) throws StandardException {
        this.dropConstraint(constraintDescriptor, null, null, activation, languageConnectionContext, bl2);
    }

    void dropConstraint(ConstraintDescriptor constraintDescriptor, TableDescriptor tableDescriptor, Activation activation, LanguageConnectionContext languageConnectionContext, boolean bl2) throws StandardException {
        this.dropConstraint(constraintDescriptor, tableDescriptor, null, activation, languageConnectionContext, bl2);
    }

    void dropConstraint(ConstraintDescriptor constraintDescriptor, TableDescriptor tableDescriptor, List<ConstantAction> list, Activation activation, LanguageConnectionContext languageConnectionContext, boolean bl2) throws StandardException {
        ConglomerateDescriptor conglomerateDescriptor;
        Properties properties = null;
        if (constraintDescriptor instanceof KeyConstraintDescriptor) {
            properties = new Properties();
            this.loadIndexProperties(languageConnectionContext, ((KeyConstraintDescriptor)constraintDescriptor).getIndexConglomerateDescriptor(languageConnectionContext.getDataDictionary()), properties);
        }
        if ((conglomerateDescriptor = constraintDescriptor.drop(languageConnectionContext, bl2)) == null) {
            return;
        }
        if (tableDescriptor != null && tableDescriptor.getUUID().equals(constraintDescriptor.getTableDescriptor().getUUID())) {
            if (list != null) {
                list.add(this.getConglomReplacementAction(conglomerateDescriptor, constraintDescriptor.getTableDescriptor(), properties));
            }
        } else {
            this.executeConglomReplacement(this.getConglomReplacementAction(conglomerateDescriptor, constraintDescriptor.getTableDescriptor(), properties), activation);
        }
    }

    void dropConglomerate(ConglomerateDescriptor conglomerateDescriptor, TableDescriptor tableDescriptor, Activation activation, LanguageConnectionContext languageConnectionContext) throws StandardException {
        this.dropConglomerate(conglomerateDescriptor, tableDescriptor, false, null, activation, languageConnectionContext);
    }

    void dropConglomerate(ConglomerateDescriptor conglomerateDescriptor, TableDescriptor tableDescriptor, boolean bl2, List<ConstantAction> list, Activation activation, LanguageConnectionContext languageConnectionContext) throws StandardException {
        Properties properties = new Properties();
        this.loadIndexProperties(languageConnectionContext, conglomerateDescriptor, properties);
        ConglomerateDescriptor conglomerateDescriptor2 = conglomerateDescriptor.drop(languageConnectionContext, tableDescriptor);
        if (conglomerateDescriptor2 == null) {
            return;
        }
        if (bl2) {
            if (list != null) {
                list.add(this.getConglomReplacementAction(conglomerateDescriptor2, tableDescriptor, properties));
            }
        } else {
            this.executeConglomReplacement(this.getConglomReplacementAction(conglomerateDescriptor2, tableDescriptor, properties), activation);
        }
    }

    void recreateUniqueConstraintBackingIndexAsUniqueWhenNotNull(ConglomerateDescriptor conglomerateDescriptor, TableDescriptor tableDescriptor, Activation activation, LanguageConnectionContext languageConnectionContext) throws StandardException {
        Object object;
        Properties properties = new Properties();
        this.loadIndexProperties(languageConnectionContext, conglomerateDescriptor, properties);
        ArrayList<ConstantAction> arrayList = new ArrayList<ConstantAction>();
        this.dropConglomerate(conglomerateDescriptor, tableDescriptor, false, arrayList, activation, languageConnectionContext);
        String[] stringArray = conglomerateDescriptor.getColumnNames();
        if (stringArray == null) {
            object = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
            stringArray = new String[((int[])object).length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray[i2] = tableDescriptor.getColumnDescriptor(object[i2]).getColumnName();
            }
        }
        object = new CreateIndexConstantAction(false, false, true, conglomerateDescriptor.getIndexDescriptor().hasDeferrableChecking(), false, 3, conglomerateDescriptor.getIndexDescriptor().indexType(), tableDescriptor.getSchemaName(), conglomerateDescriptor.getConglomerateName(), tableDescriptor.getName(), tableDescriptor.getUUID(), stringArray, conglomerateDescriptor.getIndexDescriptor().isAscending(), true, conglomerateDescriptor.getUUID(), properties);
        ((CreateIndexConstantAction)object).executeConstantAction(activation);
    }

    private void loadIndexProperties(LanguageConnectionContext languageConnectionContext, ConglomerateDescriptor conglomerateDescriptor, Properties properties) throws StandardException {
        ConglomerateController conglomerateController = languageConnectionContext.getTransactionExecute().openConglomerate(conglomerateDescriptor.getConglomerateNumber(), false, 4, 7, 5);
        conglomerateController.getInternalTablePropertySet(properties);
        conglomerateController.close();
    }

    ConstantAction getConglomReplacementAction(ConglomerateDescriptor conglomerateDescriptor, TableDescriptor tableDescriptor, Properties properties) throws StandardException {
        return new CreateIndexConstantAction(conglomerateDescriptor, tableDescriptor, properties);
    }

    void executeConglomReplacement(ConstantAction constantAction, Activation activation) throws StandardException {
        CreateIndexConstantAction createIndexConstantAction = (CreateIndexConstantAction)constantAction;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        createIndexConstantAction.executeConstantAction(activation);
        ConglomerateDescriptor[] conglomerateDescriptorArray = dataDictionary.getConglomerateDescriptors(createIndexConstantAction.getReplacedConglomNumber());
        dataDictionary.updateConglomerateDescriptor(conglomerateDescriptorArray, createIndexConstantAction.getCreatedConglomNumber(), languageConnectionContext.getTransactionExecute());
    }
}

