/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.StatisticsImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.services.daemon.IndexStatisticsDaemonImpl;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.CardinalityCounter;
import org.apache.derby.impl.sql.execute.IndexColumnOrder;
import org.apache.derby.impl.sql.execute.IndexConstantAction;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.UniqueIndexSortObserver;
import org.apache.derby.impl.sql.execute.UniqueWithDuplicateNullsIndexSortObserver;

class CreateIndexConstantAction
extends IndexConstantAction {
    private final boolean forCreateTable;
    private boolean unique;
    private boolean uniqueWithDuplicateNulls;
    private boolean uniqueDeferrable;
    private final boolean hasDeferrableChecking;
    private final boolean initiallyDeferred;
    private final int constraintType;
    private String indexType;
    private String[] columnNames;
    private boolean[] isAscending;
    private boolean isConstraint;
    private UUID conglomerateUUID;
    private Properties properties;
    private ExecRow indexTemplateRow;
    private long conglomId;
    private long droppedConglomNum;

    CreateIndexConstantAction(boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n2, String string, String string2, String string3, String string4, UUID uUID, String[] stringArray, boolean[] blArray, boolean bl7, UUID uUID2, Properties properties) {
        super(uUID, string3, string4, string2);
        this.forCreateTable = bl2;
        this.unique = bl3 && !bl5;
        this.uniqueWithDuplicateNulls = bl4;
        this.hasDeferrableChecking = bl5;
        this.initiallyDeferred = bl6;
        this.constraintType = n2;
        this.uniqueDeferrable = bl3 && bl5;
        this.indexType = string;
        this.columnNames = stringArray;
        this.isAscending = blArray;
        this.isConstraint = bl7;
        this.conglomerateUUID = uUID2;
        this.properties = properties;
        this.conglomId = -1L;
        this.droppedConglomNum = -1L;
    }

    CreateIndexConstantAction(ConglomerateDescriptor conglomerateDescriptor, TableDescriptor tableDescriptor, Properties properties) {
        super(tableDescriptor.getUUID(), conglomerateDescriptor.getConglomerateName(), tableDescriptor.getName(), tableDescriptor.getSchemaName());
        this.forCreateTable = false;
        this.droppedConglomNum = conglomerateDescriptor.getConglomerateNumber();
        IndexRowGenerator indexRowGenerator = conglomerateDescriptor.getIndexDescriptor();
        this.unique = indexRowGenerator.isUnique();
        this.uniqueWithDuplicateNulls = indexRowGenerator.isUniqueWithDuplicateNulls();
        this.hasDeferrableChecking = false;
        this.uniqueDeferrable = false;
        this.initiallyDeferred = false;
        this.constraintType = -1;
        this.indexType = indexRowGenerator.indexType();
        this.columnNames = conglomerateDescriptor.getColumnNames();
        this.isAscending = indexRowGenerator.isAscending();
        this.isConstraint = conglomerateDescriptor.isConstraint();
        this.conglomerateUUID = conglomerateDescriptor.getUUID();
        this.properties = properties;
        this.conglomId = -1L;
        if (this.columnNames == null) {
            int[] nArray = indexRowGenerator.baseColumnPositions();
            this.columnNames = new String[nArray.length];
            ColumnDescriptorList columnDescriptorList = tableDescriptor.getColumnDescriptorList();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                this.columnNames[i2] = columnDescriptorList.elementAt(nArray[i2] - 1).getColumnName();
            }
        }
    }

    public String toString() {
        return "CREATE INDEX " + this.indexName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        CardinalityCounter cardinalityCounter;
        long l2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n2;
        int n3;
        Object object5;
        int n4;
        Object object6;
        IndexRowGenerator indexRowGenerator = null;
        int n5 = -1;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dataDictionary.startWriting(languageConnectionContext);
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(this.schemaName, transactionController, true);
        TableDescriptor tableDescriptor = activation.getDDLTableDescriptor();
        if (tableDescriptor == null) {
            tableDescriptor = this.tableId != null ? dataDictionary.getTableDescriptor(this.tableId) : dataDictionary.getTableDescriptor(this.tableName, schemaDescriptor, transactionController);
        }
        if (tableDescriptor == null) {
            throw StandardException.newException("X0Y38.S", this.indexName, this.tableName);
        }
        if (tableDescriptor.getTableType() == 1) {
            throw StandardException.newException("X0Y28.S", this.indexName, this.tableName);
        }
        this.lockTableForDDL(transactionController, tableDescriptor.getHeapConglomerateId(), false);
        if (!this.forCreateTable) {
            dependencyManager.invalidateFor(tableDescriptor, 3, languageConnectionContext);
        }
        int[] nArray = new int[this.columnNames.length];
        for (int i2 = 0; i2 < this.columnNames.length; ++i2) {
            ClassFactory classFactory;
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(this.columnNames[i2]);
            if (columnDescriptor == null) {
                throw StandardException.newException("42X14", this.columnNames[i2], this.tableName);
            }
            TypeId typeId = columnDescriptor.getType().getTypeId();
            boolean bl2 = typeId.orderable(classFactory = languageConnectionContext.getLanguageConnectionFactory().getClassFactory());
            if (bl2 && typeId.userType()) {
                object6 = typeId.getCorrespondingJavaTypeName();
                try {
                    if (classFactory.isApplicationClass(classFactory.loadApplicationClass((String)object6))) {
                        bl2 = false;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bl2 = false;
                }
            }
            if (!bl2) {
                throw StandardException.newException("X0X67.S", typeId.getSQLTypeName());
            }
            nArray[i2] = columnDescriptor.getPosition();
            if (n5 >= nArray[i2]) continue;
            n5 = nArray[i2];
        }
        ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
        boolean bl3 = false;
        for (n4 = 0; n4 < conglomerateDescriptorArray.length; ++n4) {
            ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[n4];
            if (!conglomerateDescriptor.isIndex() || this.droppedConglomNum == conglomerateDescriptor.getConglomerateNumber()) continue;
            object6 = conglomerateDescriptor.getIndexDescriptor();
            object5 = ((IndexRowGenerator)object6).baseColumnPositions();
            boolean[] blArray = ((IndexRowGenerator)object6).isAscending();
            n3 = 0;
            int n6 = n2 = (((IndexRowGenerator)object6).isUnique() || !this.unique) && ((int[])object5).length == nArray.length && !this.hasDeferrableChecking ? 1 : 0;
            if (n2 != 0 && !((IndexRowGenerator)object6).isUnique()) {
                int n7 = n2 = ((IndexRowGenerator)object6).isUniqueWithDuplicateNulls() || !this.uniqueWithDuplicateNulls ? 1 : 0;
            }
            if (n2 != 0 && this.indexType.equals(((IndexRowGenerator)object6).indexType())) {
                while (n3 < ((Object)object5).length && object5[n3] == nArray[n3] && blArray[n3] == this.isAscending[n3]) {
                    ++n3;
                }
            }
            if (n3 != nArray.length) continue;
            if (!this.isConstraint) {
                activation.addWarning(StandardException.newWarning("01504", this.indexName, conglomerateDescriptor.getConglomerateName()));
                return;
            }
            this.conglomId = conglomerateDescriptor.getConglomerateNumber();
            indexRowGenerator = new IndexRowGenerator(this.indexType, this.unique, this.uniqueWithDuplicateNulls, false, false, nArray, this.isAscending, nArray.length);
            this.conglomerateUUID = dataDictionary.getUUIDFactory().createUUID();
            bl3 = true;
            break;
        }
        n4 = this.droppedConglomNum > -1L ? 1 : 0;
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        if (bl3 && n4 == 0) {
            object6 = dataDescriptorGenerator.newConglomerateDescriptor(this.conglomId, this.indexName, true, indexRowGenerator, this.isConstraint, this.conglomerateUUID, tableDescriptor.getUUID(), schemaDescriptor.getUUID());
            dataDictionary.addDescriptor((TupleDescriptor)object6, schemaDescriptor, 0, false, transactionController);
            object5 = tableDescriptor.getConglomerateDescriptorList();
            ((ArrayList)object5).add(object6);
        }
        object6 = this.properties != null ? this.properties : new Properties();
        ((Properties)object6).put("baseConglomerateId", Long.toString(tableDescriptor.getHeapConglomerateId()));
        if (this.uniqueWithDuplicateNulls && !this.hasDeferrableChecking) {
            if (dataDictionary.checkVersion(160, null)) {
                ((Properties)object6).put("uniqueWithDuplicateNulls", Boolean.toString(true));
            } else if (this.uniqueWithDuplicateNulls) {
                this.unique = true;
            }
        }
        ((Properties)object6).put("nUniqueColumns", Integer.toString(this.unique ? nArray.length : nArray.length + 1));
        ((Properties)object6).put("rowLocationColumn", Integer.toString(nArray.length));
        ((Properties)object6).put("nKeyFields", Integer.toString(nArray.length + 1));
        if (!bl3) {
            indexRowGenerator = dataDictionary.checkVersion(160, null) ? new IndexRowGenerator(this.indexType, this.unique, this.uniqueWithDuplicateNulls, this.uniqueDeferrable, this.hasDeferrableChecking && this.constraintType != 6, nArray, this.isAscending, nArray.length) : new IndexRowGenerator(this.indexType, this.unique, false, false, false, nArray, this.isAscending, nArray.length);
        }
        RowSource rowSource = null;
        long l3 = 0L;
        boolean bl4 = false;
        int n8 = this.forCreateTable ? 1 : 16;
        n3 = tableDescriptor.getNumberOfColumns();
        n2 = 0;
        FormatableBitSet formatableBitSet = new FormatableBitSet(n3 + 1);
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            formatableBitSet.set(nArray[i3]);
        }
        FormatableBitSet formatableBitSet2 = RowUtil.shift(formatableBitSet, 1);
        GroupFetchScanController groupFetchScanController = transactionController.openGroupFetchScan(tableDescriptor.getHeapConglomerateId(), false, 0, 7, 5, formatableBitSet2, null, 0, null, null, 0);
        ExecRow[] execRowArray = new ExecRow[n8];
        ExecIndexRow[] execIndexRowArray = new ExecIndexRow[n8];
        ExecRow[] execRowArray2 = new ExecRow[n8];
        try {
            Serializable serializable;
            for (int i4 = 0; i4 < n8; ++i4) {
                execRowArray[i4] = activation.getExecutionFactory().getValueRow(n5);
                execIndexRowArray[i4] = indexRowGenerator.getIndexRowTemplate();
                execRowArray2[i4] = activation.getExecutionFactory().getValueRow(nArray.length);
            }
            this.indexTemplateRow = execIndexRowArray[0];
            object4 = tableDescriptor.getColumnDescriptorList();
            int n9 = ((ArrayList)object4).size();
            int n10 = 0;
            for (int i5 = 0; i5 < n9; ++i5) {
                if (!formatableBitSet2.get(i5)) continue;
                ++n10;
                object3 = ((ColumnDescriptorList)object4).elementAt(i5);
                serializable = ((ColumnDescriptor)object3).getType();
                for (int i6 = 0; i6 < n8; ++i6) {
                    execRowArray[i6].setColumn(i5 + 1, ((DataTypeDescriptor)serializable).getNull());
                    execRowArray2[i6].setColumn(n10, execRowArray[i6].getColumn(i5 + 1));
                }
                n2 += ((DataTypeDescriptor)serializable).getTypeId().getApproximateLengthInBytes((DataTypeDescriptor)serializable);
            }
            object2 = new RowLocation[n8];
            for (n10 = 0; n10 < n8; ++n10) {
                object2[n10] = groupFetchScanController.newRowLocationTemplate();
                indexRowGenerator.getIndexRow(execRowArray2[n10], object2[n10], execIndexRowArray[n10], formatableBitSet);
            }
            if (bl3) {
                return;
            }
            serializable = null;
            if (this.unique || this.uniqueWithDuplicateNulls || this.uniqueDeferrable) {
                String string = this.indexName;
                if (this.conglomerateUUID != null) {
                    ConglomerateDescriptor conglomerateDescriptor = dataDictionary.getConglomerateDescriptor(this.conglomerateUUID);
                    if (this.isConstraint && conglomerateDescriptor != null && conglomerateDescriptor.getUUID() != null && tableDescriptor != null) {
                        ConstraintDescriptor constraintDescriptor = dataDictionary.getConstraintDescriptor(tableDescriptor, conglomerateDescriptor.getUUID());
                        string = constraintDescriptor.getConstraintName();
                    }
                }
                if (this.unique || this.uniqueDeferrable) {
                    n10 = this.unique ? nArray.length : nArray.length + 1;
                    object3 = new UniqueIndexSortObserver(languageConnectionContext, this.constraintID, true, this.uniqueDeferrable, this.initiallyDeferred, string, this.indexTemplateRow, true, tableDescriptor.getName());
                } else {
                    n10 = nArray.length + 1;
                    serializable = new Properties();
                    ((Properties)serializable).put("implType", "sort almost unique external");
                    object3 = new UniqueWithDuplicateNullsIndexSortObserver(languageConnectionContext, this.constraintID, true, this.hasDeferrableChecking && this.constraintType != 6, this.initiallyDeferred, string, this.indexTemplateRow, true, tableDescriptor.getName());
                }
            } else {
                n10 = nArray.length + 1;
                object3 = new BasicSortObserver(true, false, this.indexTemplateRow, true);
            }
            object = new ColumnOrdering[n10];
            for (int i7 = 0; i7 < n10; ++i7) {
                object[i7] = new IndexColumnOrder(i7, this.unique || i7 < n10 - 1 ? this.isAscending[i7] : true);
            }
            l3 = transactionController.createSort((Properties)serializable, this.indexTemplateRow.getRowArrayClone(), (ColumnOrdering[])object, (SortObserver)object3, false, groupFetchScanController.getEstimatedRowCount(), n2);
            bl4 = true;
            rowSource = this.loadSorter(execRowArray, execIndexRowArray, transactionController, groupFetchScanController, l3, (RowLocation[])object2);
            this.conglomId = transactionController.createAndLoadConglomerate(this.indexType, this.indexTemplateRow.getRowArray(), (ColumnOrdering[])object, indexRowGenerator.getColumnCollationIds(tableDescriptor.getColumnDescriptorList()), (Properties)object6, 0, (RowLocationRetRowSource)rowSource, null);
        }
        finally {
            if (groupFetchScanController != null) {
                groupFetchScanController.close();
            }
            if (rowSource != null) {
                rowSource.closeRowSource();
            }
            if (bl4) {
                transactionController.dropSort(l3);
            }
        }
        object4 = transactionController.openConglomerate(this.conglomId, false, 0, 7, 5);
        if (!object4.isKeyed()) {
            object4.close();
            throw StandardException.newException("X0X85.S", this.indexName, this.indexType);
        }
        object4.close();
        if (n4 == 0) {
            ConglomerateDescriptor conglomerateDescriptor = dataDescriptorGenerator.newConglomerateDescriptor(this.conglomId, this.indexName, true, indexRowGenerator, this.isConstraint, this.conglomerateUUID, tableDescriptor.getUUID(), schemaDescriptor.getUUID());
            dataDictionary.addDescriptor(conglomerateDescriptor, schemaDescriptor, 0, false, transactionController);
            object2 = tableDescriptor.getConglomerateDescriptorList();
            ((ArrayList)object2).add(conglomerateDescriptor);
            this.conglomerateUUID = conglomerateDescriptor.getUUID();
        }
        if (this.addStatistics(dataDictionary, indexRowGenerator, l2 = (cardinalityCounter = (CardinalityCounter)rowSource).getRowCount())) {
            object3 = cardinalityCounter.getCardinality();
            for (int i8 = 0; i8 < ((Object)object3).length; ++i8) {
                object = new StatisticsDescriptor(dataDictionary, dataDictionary.getUUIDFactory().createUUID(), this.conglomerateUUID, tableDescriptor.getUUID(), "I", new StatisticsImpl(l2, (long)object3[i8]), i8 + 1);
                dataDictionary.addDescriptor((TupleDescriptor)object, null, 14, true, transactionController);
            }
        }
    }

    private boolean addStatistics(DataDictionary dataDictionary, IndexRowGenerator indexRowGenerator, long l2) throws StandardException {
        boolean bl2;
        boolean bl3 = bl2 = l2 > 0L;
        if (dataDictionary.checkVersion(210, null) && ((IndexStatisticsDaemonImpl)dataDictionary.getIndexStatsRefresher((boolean)false)).skipDisposableStats && bl2 && indexRowGenerator.isUnique() && indexRowGenerator.numberOfOrderedColumns() == 1) {
            bl2 = false;
        }
        return bl2;
    }

    ExecRow getIndexTemplateRow() {
        return this.indexTemplateRow;
    }

    long getCreatedConglomNumber() {
        return this.conglomId;
    }

    long getReplacedConglomNumber() {
        return this.droppedConglomNum;
    }

    UUID getCreatedUUID() {
        return this.conglomerateUUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RowLocationRetRowSource loadSorter(ExecRow[] execRowArray, ExecIndexRow[] execIndexRowArray, TransactionController transactionController, GroupFetchScanController groupFetchScanController, long l2, RowLocation[] rowLocationArray) throws StandardException {
        long l3 = 0L;
        SortController sortController = transactionController.openSort(l2);
        try {
            int n2;
            int n3 = execRowArray.length;
            DataValueDescriptor[][] dataValueDescriptorArray = new DataValueDescriptor[n3][];
            for (n2 = 0; n2 < n3; ++n2) {
                dataValueDescriptorArray[n2] = execRowArray[n2].getRowArray();
            }
            while ((n2 = groupFetchScanController.fetchNextGroup(dataValueDescriptorArray, rowLocationArray)) > 0) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    sortController.insert(execIndexRowArray[i2].getRowArray());
                    ++l3;
                }
            }
            groupFetchScanController.setEstimatedRowCount(l3);
        }
        finally {
            sortController.completedInserts();
        }
        return new CardinalityCounter(transactionController.openSortRowSource(l2));
    }
}

