/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.ArrayList;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.GenericScanController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.impl.sql.execute.DDLSingleTableConstantAction;
import org.apache.derby.impl.sql.execute.DeferredConstraintsMemory;
import org.apache.derby.impl.sql.execute.IndexConstantAction;
import org.apache.derby.impl.sql.execute.RIBulkChecker;
import org.apache.derby.impl.store.access.heap.HeapRowLocation;

public abstract class ConstraintConstantAction
extends DDLSingleTableConstantAction {
    protected String constraintName;
    protected int constraintType;
    protected String tableName;
    protected String schemaName;
    protected UUID schemaId;
    protected IndexConstantAction indexAction;
    protected UUID constraintId;

    ConstraintConstantAction(String string, int n2, String string2, UUID uUID, String string3, IndexConstantAction indexConstantAction) {
        super(uUID);
        this.constraintName = string;
        this.constraintType = n2;
        this.tableName = string2;
        this.indexAction = indexConstantAction;
        this.schemaName = string3;
    }

    public int getConstraintType() {
        return this.constraintType;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public UUID getConstraintId() {
        return this.constraintId;
    }

    public IndexConstantAction getIndexAction() {
        return this.indexAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void validateFKConstraint(Activation activation, TransactionController transactionController, DataDictionary dataDictionary, ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor, ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor, ExecRow execRow) throws StandardException {
        GenericScanController genericScanController = null;
        GroupFetchScanController groupFetchScanController = transactionController.openGroupFetchScan(foreignKeyConstraintDescriptor.getIndexConglomerateDescriptor(dataDictionary).getConglomerateNumber(), false, 0, 7, 2, null, null, 1, null, null, -1);
        try {
            if (!groupFetchScanController.next()) {
                groupFetchScanController.close();
                return;
            }
            groupFetchScanController.reopenScan(null, 1, null, null, -1);
            genericScanController = transactionController.openGroupFetchScan(referencedKeyConstraintDescriptor.getIndexConglomerateDescriptor(dataDictionary).getConglomerateNumber(), false, 0, 6, 2, null, null, 1, null, null, -1);
            RIBulkChecker rIBulkChecker = new RIBulkChecker(activation, (GroupFetchScanController)genericScanController, groupFetchScanController, execRow, true, null, null, foreignKeyConstraintDescriptor.getTableDescriptor().getSchemaName(), foreignKeyConstraintDescriptor.getTableDescriptor().getName(), foreignKeyConstraintDescriptor.getUUID(), foreignKeyConstraintDescriptor.deferrable(), foreignKeyConstraintDescriptor.getIndexConglomerateDescriptor(dataDictionary).getConglomerateNumber(), referencedKeyConstraintDescriptor.getIndexConglomerateDescriptor(dataDictionary).getConglomerateNumber());
            int n2 = rIBulkChecker.doCheck();
            if (n2 > 0) {
                StandardException standardException = StandardException.newException("X0Y45.S", foreignKeyConstraintDescriptor.getConstraintName(), foreignKeyConstraintDescriptor.getTableDescriptor().getName());
                throw standardException;
            }
        }
        finally {
            if (groupFetchScanController != null) {
                groupFetchScanController.close();
                groupFetchScanController = null;
            }
            if (genericScanController != null) {
                genericScanController.close();
                genericScanController = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean validateConstraint(String string, String string2, UUID uUID, TableDescriptor tableDescriptor, LanguageConnectionContext languageConnectionContext, boolean bl2, boolean bl3) throws StandardException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT COUNT(*) FROM ");
        stringBuilder.append(tableDescriptor.getQualifiedName());
        stringBuilder.append(" WHERE NOT(");
        stringBuilder.append(string2);
        stringBuilder.append(")");
        try (ResultSet resultSet = null;){
            PreparedStatement preparedStatement = languageConnectionContext.prepareInternalStatement(stringBuilder.toString());
            resultSet = preparedStatement.executeSubStatement(languageConnectionContext, false, 0L);
            ExecRow execRow = resultSet.getNextRow();
            Number number = (Number)((NumberDataValue)execRow.getRowArray()[0]).getObject();
            if (number != null && number.longValue() != 0L) {
                if (bl2) {
                    if (bl3) {
                        ArrayList<UUID> arrayList = new ArrayList<UUID>();
                        arrayList.add(uUID);
                        DeferredConstraintsMemory.CheckInfo[] checkInfoArray = new DeferredConstraintsMemory.CheckInfo[1];
                        DeferredConstraintsMemory.rememberCheckViolations(languageConnectionContext, tableDescriptor.getObjectID(), tableDescriptor.getSchemaName(), tableDescriptor.getName(), null, arrayList, new HeapRowLocation(), checkInfoArray);
                        checkInfoArray[0].setInvalidatedRowLocations();
                    } else {
                        throw StandardException.newException("X0Y59.S", string, tableDescriptor.getQualifiedName(), number.toString());
                    }
                }
                boolean bl4 = false;
                return bl4;
            }
        }
        return true;
    }
}

