/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.TableScanResultSet;
import org.apache.derby.impl.sql.execute.ValueRow;

class BulkTableScanResultSet
extends TableScanResultSet
implements CursorResultSet {
    private DataValueDescriptor[][] rowArray;
    private RowLocation[] rowLocations;
    private int curRowPosition;
    private int numRowsInArray;
    private int baseColumnCount;
    private int resultColumnCount;
    private static int OUT_OF_ROWS = 0;

    BulkTableScanResultSet(long l2, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, Activation activation, int n2, int n3, GeneratedMethod generatedMethod, int n4, GeneratedMethod generatedMethod2, int n5, boolean bl2, Qualifier[][] qualifierArray, String string, String string2, String string3, boolean bl3, boolean bl4, int n6, int n7, int n8, boolean bl5, int n9, int n10, boolean bl6, boolean bl7, double d2, double d3) throws StandardException {
        super(l2, staticCompiledOpenConglomInfo, activation, n2, n3, generatedMethod, n4, generatedMethod2, n5, bl2, qualifierArray, string, string2, string3, bl3, bl4, n6, n7, n8, bl5, n9, BulkTableScanResultSet.adjustBulkFetchSize(activation, n10, bl6), bl7, d2, d3);
        this.setRowLocationsState();
        if (this.fetchRowLocations) {
            this.resultColumnCount = this.accessedCols == null ? this.candidate.nColumns() : this.accessedCols.getNumBitsSet();
            this.baseColumnCount = this.candidate.nColumns() - 1;
            this.candidate.setRowArray(this.lopOffRowLocation());
            if (this.accessedCols == null) {
                this.accessedCols = new FormatableBitSet(this.baseColumnCount);
                for (int i2 = 0; i2 < this.baseColumnCount; ++i2) {
                    this.accessedCols.set(i2);
                }
            } else {
                FormatableBitSet formatableBitSet = new FormatableBitSet(this.baseColumnCount);
                for (int i3 = 0; i3 < this.baseColumnCount; ++i3) {
                    if (!this.accessedCols.isSet(i3)) continue;
                    formatableBitSet.set(i3);
                }
                this.accessedCols = formatableBitSet;
            }
        }
    }

    private static int adjustBulkFetchSize(Activation activation, int n2, boolean bl2) {
        if (bl2 && activation.getResultSetHoldability()) {
            return 1;
        }
        return n2;
    }

    @Override
    protected void openScanController(TransactionController transactionController) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray;
        DataValueDescriptor[] dataValueDescriptorArray2 = this.startPosition == null ? null : this.startPosition.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray3 = dataValueDescriptorArray = this.stopPosition == null ? null : this.stopPosition.getRowArray();
        if (this.qualifiers != null) {
            this.clearOrderableCache(this.qualifiers);
        }
        if (transactionController == null) {
            transactionController = this.activation.getTransactionController();
        }
        this.scanController = transactionController.openCompiledScan(this.activation.getResultSetHoldability(), this.forUpdate ? 4 : 0, this.lockMode, this.isolationLevel, this.accessedCols, dataValueDescriptorArray2, this.startSearchOperator, this.qualifiers, dataValueDescriptorArray, this.stopSearchOperator, this.scoci, this.dcoci);
        this.scanControllerOpened = true;
        this.rowsThisScan = 0L;
        this.activation.informOfRowCount(this, this.scanController.getEstimatedRowCount());
    }

    @Override
    public void openCore() throws StandardException {
        super.openCore();
        this.beginTime = this.getCurrentTimeMillis();
        this.rowArray = new DataValueDescriptor[this.rowsPerRead][];
        if (this.fetchRowLocations) {
            this.rowLocations = new RowLocation[this.rowsPerRead];
        }
        this.rowArray[0] = this.candidate.getRowArrayClone();
        this.numRowsInArray = 0;
        this.curRowPosition = -1;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    private DataValueDescriptor[] lopOffRowLocation() throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray = this.candidate.getRowArrayClone();
        int n2 = dataValueDescriptorArray.length - 1;
        DataValueDescriptor[] dataValueDescriptorArray2 = new DataValueDescriptor[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dataValueDescriptorArray2[i2] = dataValueDescriptorArray[i2];
        }
        return dataValueDescriptorArray2;
    }

    @Override
    public void reopenCore() throws StandardException {
        super.reopenCore();
        this.numRowsInArray = 0;
        this.curRowPosition = -1;
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecRow execRow = null;
        this.checkCancellationFlag();
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen && this.scanControllerOpened) {
            if (this.currentRow == null) {
                this.currentRow = this.getCompactRow(this.candidate, this.accessedCols, this.isKeyed);
            }
            block0: while (true) {
                if (this.curRowPosition >= this.numRowsInArray - 1 && this.reloadArray() == OUT_OF_ROWS) {
                    this.clearCurrentRow();
                    this.setRowCountIfPossible(this.rowsThisScan);
                    return null;
                }
                while (true) {
                    if (++this.curRowPosition >= this.numRowsInArray) continue block0;
                    this.candidate.setRowArray(this.rowArray[this.curRowPosition]);
                    this.currentRow = this.setCompactRow(this.candidate, this.currentRow);
                    ++this.rowsSeen;
                    ++this.rowsThisScan;
                    if (!this.skipRow(this.candidate)) break block0;
                    ++this.rowsFiltered;
                }
                break;
            }
            execRow = this.currentRow;
            if (this.fetchRowLocations) {
                int n2;
                execRow = new ValueRow(this.resultColumnCount);
                for (n2 = 1; n2 < this.resultColumnCount; ++n2) {
                    execRow.setColumn(n2, this.currentRow.getColumn(n2));
                }
                execRow.setColumn(n2, this.rowLocations[this.curRowPosition]);
            }
        }
        this.setCurrentRow(execRow);
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow;
    }

    private int reloadArray() throws StandardException {
        this.curRowPosition = -1;
        this.numRowsInArray = ((GroupFetchScanController)((Object)this.scanController)).fetchNextGroup(this.rowArray, this.rowLocations);
        return this.numRowsInArray;
    }

    @Override
    public void close() throws StandardException {
        super.close();
        this.numRowsInArray = -1;
        this.curRowPosition = -1;
        this.rowArray = null;
        this.rowLocations = null;
    }

    @Override
    protected boolean canGetInstantaneousLocks() {
        return !this.forUpdate;
    }

    @Override
    public boolean requiresRelocking() {
        return this.isolationLevel == 2 || this.isolationLevel == 3 || this.isolationLevel == 1;
    }
}

