/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.IndexDescriptor;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.catalog.types.StatisticsImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.CheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.DependencyDescriptor;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.IndexLister;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SequenceDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.CardinalityCounter;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.CreateConstraintConstantAction;
import org.apache.derby.impl.sql.execute.CreateIndexConstantAction;
import org.apache.derby.impl.sql.execute.CreateSequenceConstantAction;
import org.apache.derby.impl.sql.execute.CreateTableConstantAction;
import org.apache.derby.impl.sql.execute.DDLSingleTableConstantAction;
import org.apache.derby.impl.sql.execute.DeferredConstraintsMemory;
import org.apache.derby.impl.sql.execute.DropTableConstantAction;
import org.apache.derby.impl.sql.execute.IndexColumnOrder;

class AlterTableConstantAction
extends DDLSingleTableConstantAction
implements RowLocationRetRowSource {
    private SchemaDescriptor sd;
    private String tableName;
    private UUID schemaId;
    private int tableType;
    private ColumnInfo[] columnInfo;
    private ConstraintConstantAction[] constraintActions;
    private char lockGranularity;
    private long tableConglomerateId;
    private boolean compressTable;
    private int behavior;
    private boolean sequential;
    private boolean truncateTable;
    private boolean purge;
    private boolean defragment;
    private boolean truncateEndOfTable;
    private boolean updateStatistics;
    private boolean updateStatisticsAll;
    private boolean dropStatistics;
    private boolean dropStatisticsAll;
    private String indexNameForStatistics;
    private boolean doneScan;
    private boolean[] needToDropSort;
    private boolean[] validRow;
    private int bulkFetchSize = 16;
    private int currentCompressRow;
    private int numIndexes;
    private int rowCount;
    private long estimatedRowCount;
    private long[] indexConglomerateNumbers;
    private long[] sortIds;
    private FormatableBitSet indexedCols;
    private ConglomerateController compressHeapCC;
    private ExecIndexRow[] indexRows;
    private ExecRow[] baseRow;
    private ExecRow currentRow;
    private GroupFetchScanController compressHeapGSC;
    private IndexRowGenerator[] compressIRGs;
    private DataValueDescriptor[][] baseRowArray;
    private RowLocation[] compressRL;
    private SortController[] sorters;
    private int droppedColumnPosition;
    private ColumnOrdering[][] ordering;
    private int[][] collation;
    private TableDescriptor td;
    private LanguageConnectionContext lcc;
    private DataDictionary dd;
    private DependencyManager dm;
    private TransactionController tc;
    private Activation activation;

    AlterTableConstantAction(SchemaDescriptor schemaDescriptor, String string, UUID uUID, long l2, int n2, ColumnInfo[] columnInfoArray, ConstraintConstantAction[] constraintConstantActionArray, char c2, boolean bl2, int n3, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, String string2) {
        super(uUID);
        this.sd = schemaDescriptor;
        this.tableName = string;
        this.tableConglomerateId = l2;
        this.tableType = n2;
        this.columnInfo = columnInfoArray;
        this.constraintActions = constraintConstantActionArray;
        this.lockGranularity = c2;
        this.compressTable = bl2;
        this.behavior = n3;
        this.sequential = bl3;
        this.truncateTable = bl4;
        this.purge = bl5;
        this.defragment = bl6;
        this.truncateEndOfTable = bl7;
        this.updateStatistics = bl8;
        this.updateStatisticsAll = bl9;
        this.dropStatistics = bl10;
        this.dropStatisticsAll = bl11;
        this.indexNameForStatistics = string2;
    }

    public String toString() {
        if (this.truncateTable) {
            return "TRUNCATE TABLE " + this.tableName;
        }
        return "ALTER TABLE " + this.tableName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        try {
            this.executeConstantActionBody(activation);
        }
        finally {
            this.clearState();
        }
    }

    private void executeConstantActionBody(Activation activation) throws StandardException {
        Object object;
        int n2;
        this.activation = activation;
        this.lcc = activation.getLanguageConnectionContext();
        this.dd = this.lcc.getDataDictionary();
        this.dm = this.dd.getDependencyManager();
        this.tc = this.lcc.getTransactionExecute();
        int n3 = 0;
        boolean bl2 = false;
        if (this.compressTable || this.truncateTable) {
            DeferredConstraintsMemory.compressOrTruncate(this.lcc, this.tableId, this.tableName);
        }
        if (this.compressTable && (this.purge || this.defragment || this.truncateEndOfTable)) {
            this.td = this.dd.getTableDescriptor(this.tableId);
            if (this.td == null) {
                throw StandardException.newException("X0X05.S", this.tableName);
            }
            if (this.purge) {
                this.purgeRows(this.tc);
            }
            if (this.defragment) {
                this.defragmentRows(this.tc);
            }
            if (this.truncateEndOfTable) {
                this.truncateEnd(this.tc);
            }
            return;
        }
        if (this.updateStatistics) {
            this.updateStatistics();
            return;
        }
        if (this.dropStatistics) {
            this.dropStatistics();
            return;
        }
        this.dd.startWriting(this.lcc);
        if (this.tableConglomerateId == 0L) {
            this.td = this.dd.getTableDescriptor(this.tableId);
            if (this.td == null) {
                throw StandardException.newException("X0X05.S", this.tableName);
            }
            this.tableConglomerateId = this.td.getHeapConglomerateId();
        }
        this.lockTableForDDL(this.tc, this.tableConglomerateId, true);
        this.td = this.dd.getTableDescriptor(this.tableId);
        if (this.td == null) {
            throw StandardException.newException("X0X05.S", this.tableName);
        }
        if (this.truncateTable) {
            this.dm.invalidateFor(this.td, 42, this.lcc);
        } else {
            this.dm.invalidateFor(this.td, 12, this.lcc);
        }
        activation.setDDLTableDescriptor(this.td);
        if (this.sd == null) {
            this.sd = AlterTableConstantAction.getAndCheckSchemaDescriptor(this.dd, this.schemaId, "ALTER TABLE");
        }
        if (this.truncateTable) {
            this.dm.invalidateFor(this.td, 42, this.lcc);
        } else {
            this.dm.invalidateFor(this.td, 12, this.lcc);
        }
        if (this.columnInfo != null) {
            int n4;
            n2 = 0;
            for (n4 = 0; n4 < this.columnInfo.length; ++n4) {
                if (this.columnInfo[n4].action != 0 || this.columnInfo[n4].dataType.isNullable() || this.columnInfo[n4].defaultInfo != null || this.columnInfo[n4].autoincInc != 0L) continue;
                n2 = 1;
            }
            if (n2 != 0) {
                n3 = this.getSemiRowCount(this.tc);
                if (n3 > 0) {
                    throw StandardException.newException("X0Y57.S", this.td.getQualifiedName());
                }
                bl2 = true;
            }
            for (n4 = 0; n4 < this.columnInfo.length; ++n4) {
                if (this.columnInfo[n4].action == 0) {
                    this.addNewColumnToTable(n4);
                    continue;
                }
                if (this.columnInfo[n4].action == 5 || this.columnInfo[n4].action == 6 || this.columnInfo[n4].action == 7) {
                    this.modifyColumnDefault(n4);
                    continue;
                }
                if (this.columnInfo[n4].action == 2) {
                    this.modifyColumnType(n4);
                    continue;
                }
                if (this.columnInfo[n4].action == 3) {
                    this.modifyColumnConstraint(this.columnInfo[n4].name, true);
                    continue;
                }
                if (this.columnInfo[n4].action == 4) {
                    String[] stringArray;
                    if (!bl2) {
                        bl2 = true;
                        n3 = this.getSemiRowCount(this.tc);
                    }
                    if (!this.validateNotNullConstraint(stringArray = new String[]{this.columnInfo[n4].name}, (boolean[])(object = (Object)new boolean[1]), n3, this.lcc, "X0Y80.S")) continue;
                    this.modifyColumnConstraint(this.columnInfo[n4].name, false);
                    continue;
                }
                if (this.columnInfo[n4].action == 1) {
                    this.dropColumnFromTable(this.columnInfo[n4].name);
                    continue;
                }
                if (this.columnInfo[n4].action != 8 && this.columnInfo[n4].action != 9) continue;
                this.modifyIdentityState(n4);
            }
        }
        this.adjustUDTDependencies(this.lcc, this.dd, this.td, this.columnInfo, false);
        if (this.constraintActions != null) {
            for (n2 = 0; n2 < this.constraintActions.length; ++n2) {
                ConstraintConstantAction constraintConstantAction = this.constraintActions[n2];
                boolean bl3 = false;
                if (constraintConstantAction instanceof CreateConstraintConstantAction) {
                    object = (CreateConstraintConstantAction)constraintConstantAction;
                    int n5 = ((ConstraintConstantAction)object).getConstraintType();
                    bl3 = n5 == 4 && ((CreateConstraintConstantAction)object).isInitiallyDeferred();
                    switch (n5) {
                        case 2: {
                            ConstraintDescriptorList constraintDescriptorList = this.dd.getConstraintDescriptors(this.td);
                            if (constraintDescriptorList.getPrimaryKey() != null) {
                                throw StandardException.newException("X0Y58.S", this.td.getQualifiedName());
                            }
                            if (bl2) break;
                            bl2 = true;
                            n3 = this.getSemiRowCount(this.tc);
                            break;
                        }
                        case 4: {
                            if (!bl2) {
                                bl2 = true;
                                n3 = this.getSemiRowCount(this.tc);
                            }
                            if (bl3) {
                                this.constraintActions[n2].executeConstantAction(activation);
                            }
                            if (n3 <= 0) break;
                            ConstraintConstantAction.validateConstraint(constraintConstantAction.getConstraintName(), ((CreateConstraintConstantAction)constraintConstantAction).getConstraintText(), constraintConstantAction.getConstraintId(), this.td, this.lcc, true, bl3);
                        }
                    }
                }
                if (bl3) continue;
                this.constraintActions[n2].executeConstantAction(activation);
            }
        }
        if (this.lockGranularity != '\u0000') {
            this.td.setLockGranularity(this.lockGranularity);
            this.dd.updateLockGranularity(this.td, this.sd, this.lockGranularity, this.tc);
        }
        if (this.compressTable) {
            this.compressTable();
        }
        if (this.truncateTable) {
            this.truncateTable();
        }
    }

    private void clearState() {
        this.td = null;
        this.lcc = null;
        this.dd = null;
        this.dm = null;
        this.tc = null;
        this.activation = null;
    }

    private void dropStatistics() throws StandardException {
        this.td = this.dd.getTableDescriptor(this.tableId);
        this.dd.startWriting(this.lcc);
        this.dm.invalidateFor(this.td, 40, this.lcc);
        if (this.dropStatisticsAll) {
            this.dd.dropStatisticsDescriptors(this.td.getUUID(), null, this.tc);
        } else {
            ConglomerateDescriptor conglomerateDescriptor = this.dd.getConglomerateDescriptor(this.indexNameForStatistics, this.sd, false);
            this.dd.dropStatisticsDescriptors(this.td.getUUID(), conglomerateDescriptor.getUUID(), this.tc);
        }
    }

    private void updateStatistics() throws StandardException {
        this.td = this.dd.getTableDescriptor(this.tableId);
        ConglomerateDescriptor[] conglomerateDescriptorArray = this.updateStatisticsAll ? null : new ConglomerateDescriptor[]{this.dd.getConglomerateDescriptor(this.indexNameForStatistics, this.sd, false)};
        this.dd.getIndexStatsRefresher(false).runExplicitly(this.lcc, this.td, conglomerateDescriptorArray, "ALTER TABLE");
    }

    private void truncateEnd(TransactionController transactionController) throws StandardException {
        switch (this.td.getTableType()) {
            case 2: 
            case 5: {
                break;
            }
            default: {
                ConglomerateDescriptor[] conglomerateDescriptorArray = this.td.getConglomerateDescriptors();
                for (int i2 = 0; i2 < conglomerateDescriptorArray.length; ++i2) {
                    ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[i2];
                    transactionController.compressConglomerate(conglomerateDescriptor.getConglomerateNumber());
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void defragmentRows(TransactionController var1_1) throws StandardException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void setup_indexes(TransactionController transactionController, TableDescriptor tableDescriptor, int[][] nArray, ScanController[] scanControllerArray, ConglomerateController[] conglomerateControllerArray, DataValueDescriptor[][] dataValueDescriptorArray) throws StandardException {
        ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
        int n2 = 0;
        for (int i2 = 0; i2 < conglomerateDescriptorArray.length; ++i2) {
            ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[i2];
            if (!conglomerateDescriptor.isIndex()) continue;
            scanControllerArray[n2] = transactionController.openScan(conglomerateDescriptor.getConglomerateNumber(), true, 4, 7, 5, null, null, 0, null, null, 0);
            conglomerateControllerArray[n2] = transactionController.openConglomerate(conglomerateDescriptor.getConglomerateNumber(), true, 4, 7, 5);
            int[] nArray2 = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
            int[] nArray3 = new int[nArray2.length];
            for (int i3 = 0; i3 < nArray2.length; ++i3) {
                nArray3[i3] = nArray2[i3] - 1;
            }
            nArray[n2] = nArray3;
            dataValueDescriptorArray[n2] = new DataValueDescriptor[nArray2.length + 1];
            ++n2;
        }
    }

    private static void fixIndex(DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2, RowLocation rowLocation, RowLocation rowLocation2, ConglomerateController conglomerateController, ScanController scanController, int[] nArray) throws StandardException {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            dataValueDescriptorArray2[i2] = dataValueDescriptorArray[nArray[i2]];
        }
        dataValueDescriptorArray2[dataValueDescriptorArray2.length - 1] = rowLocation;
        scanController.reopenScan(dataValueDescriptorArray2, 1, null, dataValueDescriptorArray2, -1);
        if (scanController.next()) {
            scanController.delete();
        }
        dataValueDescriptorArray2[dataValueDescriptorArray2.length - 1] = rowLocation2;
        conglomerateController.insert(dataValueDescriptorArray2);
    }

    private void purgeRows(TransactionController transactionController) throws StandardException {
        switch (this.td.getTableType()) {
            case 2: 
            case 5: {
                break;
            }
            default: {
                ConglomerateDescriptor[] conglomerateDescriptorArray = this.td.getConglomerateDescriptors();
                for (int i2 = 0; i2 < conglomerateDescriptorArray.length; ++i2) {
                    ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[i2];
                    transactionController.purgeConglomerate(conglomerateDescriptor.getConglomerateNumber());
                }
            }
        }
    }

    private void addNewColumnToTable(int n2) throws StandardException {
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[n2].name);
        int n3 = this.td.getMaxColumnID() + n2;
        if (columnDescriptor != null) {
            throw StandardException.newException("X0Y32.S", columnDescriptor.getDescriptorType(), this.columnInfo[n2].name, this.td.getDescriptorType(), this.td.getQualifiedName());
        }
        DataValueDescriptor dataValueDescriptor = this.columnInfo[n2].defaultValue != null ? this.columnInfo[n2].defaultValue : this.columnInfo[n2].dataType.getNull();
        this.tc.addColumnToConglomerate(this.td.getHeapConglomerateId(), n3, dataValueDescriptor, this.columnInfo[n2].dataType.getCollationType());
        UUID uUID = this.columnInfo[n2].newDefaultUUID;
        if (this.columnInfo[n2].defaultInfo != null && uUID == null) {
            uUID = this.dd.getUUIDFactory().createUUID();
        }
        columnDescriptor = new ColumnDescriptor(this.columnInfo[n2].name, n3 + 1, this.columnInfo[n2].dataType, this.columnInfo[n2].defaultValue, this.columnInfo[n2].defaultInfo, this.td, uUID, this.columnInfo[n2].autoincStart, this.columnInfo[n2].autoincInc, this.columnInfo[n2].autoinc_create_or_modify_Start_Increment);
        this.dd.addDescriptor(columnDescriptor, this.td, 2, false, this.tc);
        this.td.getColumnDescriptorList().add(columnDescriptor);
        if (columnDescriptor.isAutoincrement()) {
            CreateSequenceConstantAction createSequenceConstantAction = CreateTableConstantAction.makeCSCA(this.columnInfo[n2], TableDescriptor.makeSequenceName(this.td.getUUID()));
            createSequenceConstantAction.executeConstantAction(this.activation);
        }
        if (columnDescriptor.isAutoincrement() || columnDescriptor.hasNonNullDefault()) {
            this.updateNewColumnToDefault(columnDescriptor);
        }
        this.addColumnDependencies(this.lcc, this.dd, this.td, this.columnInfo[n2]);
        this.dd.updateSYSCOLPERMSforAddColumnToUserTable(this.td.getUUID(), this.tc);
    }

    private void dropColumnFromTable(String string) throws StandardException {
        int n2;
        Object object;
        int n3;
        boolean bl2 = this.behavior == 0;
        ColumnDescriptorList columnDescriptorList = this.td.getGeneratedColumns();
        int n4 = columnDescriptorList.size();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < n4; ++i2) {
            ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(i2);
            String[] stringArray = columnDescriptor.getDefaultInfo().getReferencedColumnNames();
            n3 = stringArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!string.equals(stringArray[i3])) continue;
                object = columnDescriptor.getColumnName();
                if (!bl2) {
                    throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), string, "GENERATED COLUMN", object);
                }
                arrayList.add((String)object);
            }
        }
        DataDescriptorGenerator dataDescriptorGenerator = this.dd.getDataDescriptorGenerator();
        int n5 = arrayList.size();
        int n6 = this.td.getColumnDescriptorList().size() - n5;
        if (n6 == 1) {
            throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), "THE *LAST* COLUMN " + string, "TABLE", this.td.getQualifiedName());
        }
        for (n3 = 0; n3 < n5; ++n3) {
            String string2 = (String)arrayList.get(n3);
            this.activation.addWarning(StandardException.newWarning("01009", string2, this.td.getName()));
            this.dropColumnFromTable(string2);
        }
        this.td = this.dd.getTableDescriptor(this.tableId);
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(string);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X14", string, this.td.getQualifiedName());
        }
        int n7 = this.td.getColumnDescriptorList().size();
        this.droppedColumnPosition = columnDescriptor.getPosition();
        object = new FormatableBitSet(n7 + 1);
        ((FormatableBitSet)object).set(this.droppedColumnPosition);
        this.td.setReferencedColumnMap((FormatableBitSet)object);
        this.dm.invalidateFor(this.td, bl2 ? 37 : 46, this.lcc);
        if (columnDescriptor.getDefaultInfo() != null) {
            this.dm.clearDependencies(this.lcc, columnDescriptor.getDefaultDescriptor(this.dd));
        }
        if (columnDescriptor.isAutoincrement() && this.dd.checkVersion(230, null)) {
            DropTableConstantAction.dropIdentitySequence(this.dd, this.td, this.activation);
        }
        for (TriggerDescriptor triggerDescriptor : this.dd.getTriggerDescriptors(this.td)) {
            int[] nArray;
            int n8;
            boolean bl3 = false;
            int[] nArray2 = triggerDescriptor.getReferencedCols();
            if (nArray2 != null) {
                int n9 = nArray2.length;
                n8 = 0;
                for (n2 = 0; n2 < n9; ++n2) {
                    if (nArray2[n2] > this.droppedColumnPosition) {
                        n8 = 1;
                        continue;
                    }
                    if (nArray2[n2] != this.droppedColumnPosition) continue;
                    if (bl2) {
                        triggerDescriptor.drop(this.lcc);
                        bl3 = true;
                        this.activation.addWarning(StandardException.newWarning("01502", triggerDescriptor.getName(), this.td.getName()));
                        break;
                    }
                    throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), string, "TRIGGER", triggerDescriptor.getName());
                }
                if (n2 == n9 && n8 != 0) {
                    this.dd.dropTriggerDescriptor(triggerDescriptor, this.tc);
                    for (n2 = 0; n2 < n9; ++n2) {
                        if (nArray2[n2] <= this.droppedColumnPosition) continue;
                        int n10 = n2;
                        nArray2[n10] = nArray2[n10] - 1;
                    }
                    triggerDescriptor.setReferencedCols(nArray2);
                    this.dd.addDescriptor(triggerDescriptor, this.sd, 13, false, this.tc);
                }
            }
            if (bl3 || (nArray = triggerDescriptor.getReferencedColsInTriggerAction()) == null) continue;
            n2 = nArray.length;
            boolean bl4 = false;
            for (n8 = 0; n8 < n2; ++n8) {
                if (nArray[n8] > this.droppedColumnPosition) {
                    bl4 = true;
                    continue;
                }
                if (nArray[n8] != this.droppedColumnPosition) continue;
                if (bl2) {
                    triggerDescriptor.drop(this.lcc);
                    bl3 = true;
                    this.activation.addWarning(StandardException.newWarning("01502", triggerDescriptor.getName(), this.td.getName()));
                    break;
                }
                throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), string, "TRIGGER", triggerDescriptor.getName());
            }
            if (n8 != n2 || !bl4) continue;
            this.dd.dropTriggerDescriptor(triggerDescriptor, this.tc);
            for (n8 = 0; n8 < n2; ++n8) {
                if (nArray[n8] <= this.droppedColumnPosition) continue;
                int n11 = n8;
                nArray[n11] = nArray[n11] - 1;
            }
            triggerDescriptor.setReferencedColsInTriggerAction(nArray);
            this.dd.addDescriptor(triggerDescriptor, this.sd, 13, false, this.tc);
        }
        ConstraintDescriptorList constraintDescriptorList = this.dd.getConstraintDescriptors(this.td);
        int n12 = constraintDescriptorList.size();
        ArrayList<ConstantAction> arrayList2 = new ArrayList<ConstantAction>();
        int n13 = 0;
        ConstraintDescriptor[] constraintDescriptorArray = new ConstraintDescriptor[n12];
        for (n2 = n12 - 1; n2 >= 0; --n2) {
            int n14;
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(n2);
            int[] nArray = constraintDescriptor.getReferencedColumns();
            int n15 = nArray.length;
            boolean bl5 = false;
            for (n14 = 0; n14 < n15; ++n14) {
                if (nArray[n14] > this.droppedColumnPosition) {
                    bl5 = true;
                }
                if (nArray[n14] == this.droppedColumnPosition) break;
            }
            if (n14 == n15) {
                if (!(constraintDescriptor instanceof CheckConstraintDescriptor) || !bl5) continue;
                this.dd.dropConstraintDescriptor(constraintDescriptor, this.tc);
                for (n14 = 0; n14 < n15; ++n14) {
                    if (nArray[n14] <= this.droppedColumnPosition) continue;
                    int n16 = n14;
                    nArray[n16] = nArray[n16] - 1;
                }
                ((CheckConstraintDescriptor)constraintDescriptor).setReferencedColumnsDescriptor(new ReferencedColumnsDescriptorImpl(nArray));
                this.dd.addConstraintDescriptor(constraintDescriptor, this.tc);
                continue;
            }
            if (!bl2) {
                throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), string, "CONSTRAINT", constraintDescriptor.getConstraintName());
            }
            if (constraintDescriptor instanceof ReferencedKeyConstraintDescriptor) {
                constraintDescriptorArray[n13++] = constraintDescriptor;
                continue;
            }
            this.dm.invalidateFor(constraintDescriptor, 19, this.lcc);
            this.dropConstraint(constraintDescriptor, this.td, arrayList2, this.activation, this.lcc, true);
            this.activation.addWarning(StandardException.newWarning("01500", constraintDescriptor.getConstraintName(), this.td.getName()));
        }
        for (n2 = n13 - 1; n2 >= 0; --n2) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorArray[n2];
            this.dropConstraint(constraintDescriptor, this.td, arrayList2, this.activation, this.lcc, false);
            this.activation.addWarning(StandardException.newWarning("01500", constraintDescriptor.getConstraintName(), this.td.getName()));
            if (bl2) {
                ConstraintDescriptorList constraintDescriptorList2 = this.dd.getForeignKeys(constraintDescriptor.getUUID());
                for (ConstraintDescriptor constraintDescriptor2 : constraintDescriptorList2) {
                    this.dm.invalidateFor(constraintDescriptor2, 19, this.lcc);
                    this.dropConstraint(constraintDescriptor2, this.td, arrayList2, this.activation, this.lcc, true);
                    this.activation.addWarning(StandardException.newWarning("01500", constraintDescriptor2.getConstraintName(), constraintDescriptor2.getTableDescriptor().getName()));
                }
            }
            this.dm.invalidateFor(constraintDescriptor, 19, this.lcc);
            this.dm.clearDependencies(this.lcc, constraintDescriptor);
        }
        this.createNewBackingCongloms(arrayList2, null);
        this.td = this.dd.getTableDescriptor(this.tableId);
        this.compressTable();
        ColumnDescriptorList columnDescriptorList2 = this.td.getColumnDescriptorList();
        this.dd.dropColumnDescriptor(this.td.getUUID(), string, this.tc);
        TupleDescriptor[] tupleDescriptorArray = new ColumnDescriptor[n7 - columnDescriptor.getPosition()];
        int n17 = columnDescriptor.getPosition();
        int n18 = 0;
        while (n17 < n7) {
            ColumnDescriptor columnDescriptor2 = columnDescriptorList2.elementAt(n17);
            this.dd.dropColumnDescriptor(this.td.getUUID(), columnDescriptor2.getColumnName(), this.tc);
            columnDescriptor2.setPosition(n17);
            if (columnDescriptor2.isAutoincrement()) {
                columnDescriptor2.setAutoinc_create_or_modify_Start_Increment(0);
            }
            tupleDescriptorArray[n18] = columnDescriptor2;
            ++n17;
            ++n18;
        }
        this.dd.addDescriptorArray(tupleDescriptorArray, this.td, 2, false, this.tc);
        List<DependencyDescriptor> list = this.dd.getProvidersDescriptorList(this.td.getObjectID().toString());
        for (DependencyDescriptor dependencyDescriptor : list) {
            DependableFinder dependableFinder = dependencyDescriptor.getDependentFinder();
            if (!dependableFinder.getSQLObjectType().equals("StoredPreparedStatement")) continue;
            List<DependencyDescriptor> list2 = this.dd.getProvidersDescriptorList(dependencyDescriptor.getUUID().toString());
            for (DependencyDescriptor dependencyDescriptor2 : list2) {
                DependableFinder dependableFinder2 = dependencyDescriptor2.getDependentFinder();
                if (!dependableFinder2.getSQLObjectType().equals("Trigger")) continue;
                TriggerDescriptor triggerDescriptor = this.dd.getTriggerDescriptor(dependencyDescriptor2.getUUID());
                UUID uUID = triggerDescriptor.getWhenClauseId();
                boolean bl6 = false;
                if (uUID != null) {
                    bl6 = this.columnDroppedAndTriggerDependencies(triggerDescriptor, uUID, true, bl2, string);
                }
                if (bl6) continue;
                this.columnDroppedAndTriggerDependencies(triggerDescriptor, triggerDescriptor.getActionId(), false, bl2, string);
            }
        }
        this.dd.updateSYSCOLPERMSforDropColumn(this.td.getUUID(), this.tc, columnDescriptor);
        columnDescriptorList2.remove(this.td.getColumnDescriptor(string));
    }

    private boolean columnDroppedAndTriggerDependencies(TriggerDescriptor triggerDescriptor, UUID uUID, boolean bl2, boolean bl3, String string) throws StandardException {
        this.dd.dropTriggerDescriptor(triggerDescriptor, this.tc);
        SchemaDescriptor schemaDescriptor = this.dd.getSchemaDescriptor(this.dd.getSPSDescriptor(uUID).getCompSchemaId(), null);
        CompilerContext compilerContext = this.lcc.pushCompilerContext(schemaDescriptor);
        Parser parser = compilerContext.getParser();
        String string2 = bl2 ? triggerDescriptor.getWhenClauseText() : triggerDescriptor.getTriggerDefinition();
        Visitable visitable = bl2 ? parser.parseSearchCondition(string2) : parser.parseStatement(string2);
        this.lcc.popCompilerContext(compilerContext);
        compilerContext = null;
        try {
            SPSDescriptor sPSDescriptor = bl2 ? triggerDescriptor.getWhenClauseSPS(this.lcc) : triggerDescriptor.getActionSPS(this.lcc);
            int[] nArray = new int[this.td.getNumberOfColumns()];
            Arrays.fill(nArray, -1);
            String string3 = this.dd.getTriggerActionString(visitable, triggerDescriptor.getOldReferencingName(), triggerDescriptor.getNewReferencingName(), string2, triggerDescriptor.getReferencedCols(), nArray, 0, triggerDescriptor.getTableDescriptor(), triggerDescriptor.getTriggerEventMask(), true, null, null);
            if (bl2) {
                string3 = "VALUES " + string3;
            }
            sPSDescriptor.setText(string3);
            compilerContext = this.lcc.pushCompilerContext(schemaDescriptor);
            compilerContext.setReliability(0);
            parser = compilerContext.getParser();
            StatementNode statementNode = (StatementNode)parser.parseStatement(string3);
            compilerContext.setCurrentDependent(sPSDescriptor.getPreparedStatement());
            statementNode.bindStatement();
        }
        catch (StandardException standardException) {
            if (standardException.getMessageId().equals("42X04") || standardException.getMessageId().equals("42X14") || standardException.getMessageId().equals("42802") || standardException.getMessageId().equals("42X05")) {
                if (bl3) {
                    triggerDescriptor.drop(this.lcc);
                    this.activation.addWarning(StandardException.newWarning("01502", triggerDescriptor.getName(), this.td.getName()));
                    boolean bl4 = true;
                    return bl4;
                }
                throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), string, "TRIGGER", triggerDescriptor.getName());
            }
            throw standardException;
        }
        finally {
            if (compilerContext != null) {
                this.lcc.popCompilerContext(compilerContext);
            }
        }
        this.dd.addDescriptor(triggerDescriptor, this.sd, 13, false, this.tc);
        return false;
    }

    private void modifyColumnType(int n2) throws StandardException {
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[n2].name);
        ColumnDescriptor columnDescriptor2 = new ColumnDescriptor(this.columnInfo[n2].name, columnDescriptor.getPosition(), this.columnInfo[n2].dataType, columnDescriptor.getDefaultValue(), columnDescriptor.getDefaultInfo(), this.td, columnDescriptor.getDefaultUUID(), this.columnInfo[n2].autoincStart, this.columnInfo[n2].autoincInc);
        this.dd.dropColumnDescriptor(this.td.getUUID(), this.columnInfo[n2].name, this.tc);
        this.dd.addDescriptor(columnDescriptor2, this.td, 2, false, this.tc);
    }

    private void modifyColumnConstraint(String string, boolean bl2) throws StandardException {
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(string);
        DataTypeDescriptor dataTypeDescriptor = columnDescriptor.getType().getNullabilityType(bl2);
        ConstraintDescriptorList constraintDescriptorList = this.dd.getConstraintDescriptors(this.td);
        int n2 = columnDescriptor.getPosition();
        for (int i2 = 0; i2 < constraintDescriptorList.size(); ++i2) {
            ConglomerateDescriptor conglomerateDescriptor;
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(i2);
            if (constraintDescriptor.getConstraintType() != 3) continue;
            ColumnDescriptorList columnDescriptorList = constraintDescriptor.getColumnDescriptors();
            for (int i3 = 0; i3 < columnDescriptorList.size() && columnDescriptorList.elementAt(i3).getPosition() == n2 && ((conglomerateDescriptor = this.td.getConglomerateDescriptor(constraintDescriptor.getConglomerateId())).getIndexDescriptor().isUnique() || conglomerateDescriptor.getIndexDescriptor().hasDeferrableChecking()); ++i3) {
                this.recreateUniqueConstraintBackingIndexAsUniqueWhenNotNull(conglomerateDescriptor, this.td, this.activation, this.lcc);
            }
        }
        ColumnDescriptor columnDescriptor2 = new ColumnDescriptor(string, columnDescriptor.getPosition(), dataTypeDescriptor, columnDescriptor.getDefaultValue(), columnDescriptor.getDefaultInfo(), this.td, columnDescriptor.getDefaultUUID(), columnDescriptor.getAutoincStart(), columnDescriptor.getAutoincInc());
        this.dd.dropColumnDescriptor(this.td.getUUID(), string, this.tc);
        this.dd.addDescriptor(columnDescriptor2, this.td, 2, false, this.tc);
    }

    private void modifyColumnDefault(int n2) throws StandardException {
        Object object;
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[n2].name);
        int n3 = columnDescriptor.getPosition();
        if (columnDescriptor.hasNonNullDefault()) {
            object = new DefaultDescriptor(this.dd, this.columnInfo[n2].oldDefaultUUID, this.td.getUUID(), n3);
            this.dm.invalidateFor((Provider)object, 31, this.lcc);
            this.dm.clearDependencies(this.lcc, (Dependent)object);
        }
        object = this.columnInfo[n2].newDefaultUUID;
        if (this.columnInfo[n2].defaultInfo != null && object == null) {
            object = this.dd.getUUIDFactory().createUUID();
        }
        columnDescriptor = new ColumnDescriptor(this.columnInfo[n2].name, n3, this.columnInfo[n2].dataType, this.columnInfo[n2].defaultValue, this.columnInfo[n2].defaultInfo, this.td, (UUID)object, this.columnInfo[n2].autoincStart, this.columnInfo[n2].autoincInc, this.columnInfo[n2].autoinc_create_or_modify_Start_Increment);
        this.dd.dropColumnDescriptor(this.td.getUUID(), this.columnInfo[n2].name, this.tc);
        this.dd.addDescriptor(columnDescriptor, this.td, 2, false, this.tc);
        if (this.columnInfo[n2].action == 6) {
            long l2 = this.getColumnMax(this.td, this.columnInfo[n2].name, this.columnInfo[n2].autoincInc);
            this.dd.setAutoincrementValue(this.tc, this.td.getUUID(), this.columnInfo[n2].name, l2, true);
        } else if (this.columnInfo[n2].action == 5) {
            this.dd.setAutoincrementValue(this.tc, this.td.getUUID(), this.columnInfo[n2].name, this.columnInfo[n2].autoincStart, false);
        }
        if ((this.columnInfo[n2].action == 6 || this.columnInfo[n2].action == 5) && this.dd.checkVersion(230, null)) {
            Long l3 = null;
            if (this.columnInfo[n2].action == 6) {
                l3 = this.dd.peekAtIdentity(this.td.getSchemaName(), this.td.getName());
            }
            DropTableConstantAction.dropIdentitySequence(this.dd, this.td, this.activation);
            String string = TableDescriptor.makeSequenceName(this.td.getUUID());
            CreateSequenceConstantAction createSequenceConstantAction = CreateTableConstantAction.makeCSCA(this.columnInfo[n2], string);
            createSequenceConstantAction.executeConstantAction(this.activation);
            if (this.columnInfo[n2].action == 6) {
                SequenceDescriptor sequenceDescriptor = this.dd.getSequenceDescriptor(this.dd.getSystemSchemaDescriptor(), string);
                RowLocation[] rowLocationArray = new RowLocation[1];
                SequenceDescriptor[] sequenceDescriptorArray = new SequenceDescriptor[1];
                this.dd.computeSequenceRowLocation(this.tc, sequenceDescriptor.getUUID().toString(), rowLocationArray, sequenceDescriptorArray);
                this.dd.updateCurrentSequenceValue(this.tc, rowLocationArray[0], true, null, l3);
            }
        }
    }

    private void modifyIdentityState(int n2) throws StandardException {
        boolean bl2;
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[n2].name);
        int n3 = columnDescriptor.getPosition();
        boolean bl3 = columnDescriptor.isAutoincAlways();
        boolean bl4 = bl2 = this.columnInfo[n2].action == 8;
        if (bl3 == bl2) {
            return;
        }
        UUID uUID = bl2 ? null : this.dd.getUUIDFactory().createUUID();
        ColumnDescriptor columnDescriptor2 = new ColumnDescriptor(this.columnInfo[n2].name, n3, columnDescriptor.getType(), this.columnInfo[n2].defaultValue, this.columnInfo[n2].defaultInfo, this.td, uUID, columnDescriptor.getAutoincStart(), columnDescriptor.getAutoincInc(), 3L);
        this.dd.dropColumnDescriptor(this.td.getUUID(), this.columnInfo[n2].name, this.tc);
        this.dd.addDescriptor(columnDescriptor2, this.td, 2, false, this.tc);
    }

    private void compressTable() throws StandardException {
        Properties properties = new Properties();
        ExecRow execRow = this.td.getEmptyExecRow();
        int[] nArray = this.td.getColumnCollationIds();
        this.compressHeapCC = this.tc.openConglomerate(this.td.getHeapConglomerateId(), false, 4, 7, 5);
        RowLocation rowLocation = this.compressHeapCC.newRowLocationTemplate();
        this.compressHeapCC.getInternalTablePropertySet(properties);
        this.compressHeapCC.close();
        this.compressHeapCC = null;
        this.baseRow = new ExecRow[this.bulkFetchSize];
        this.baseRowArray = new DataValueDescriptor[this.bulkFetchSize][];
        this.validRow = new boolean[this.bulkFetchSize];
        this.getAffectedIndexes();
        this.compressRL = new RowLocation[this.bulkFetchSize];
        this.indexRows = new ExecIndexRow[this.numIndexes];
        if (!this.compressTable) {
            ExecRow execRow2 = this.activation.getExecutionFactory().getValueRow(execRow.nColumns() - 1);
            int[] nArray2 = new int[nArray.length - 1];
            for (int i2 = 0; i2 < execRow2.nColumns(); ++i2) {
                execRow2.setColumn(i2 + 1, i2 < this.droppedColumnPosition - 1 ? execRow.getColumn(i2 + 1) : execRow.getColumn(i2 + 1 + 1));
                nArray2[i2] = nArray[i2 < this.droppedColumnPosition - 1 ? i2 : i2 + 1];
            }
            execRow = execRow2;
            nArray = nArray2;
        }
        this.setUpAllSorts(execRow, rowLocation);
        this.openBulkFetchScan(this.td.getHeapConglomerateId());
        this.estimatedRowCount = this.compressHeapGSC.getEstimatedRowCount();
        for (int i3 = 0; i3 < this.bulkFetchSize; ++i3) {
            this.baseRow[i3] = this.td.getEmptyExecRow();
            this.baseRowArray[i3] = this.baseRow[i3].getRowArray();
            this.compressRL[i3] = this.compressHeapGSC.newRowLocationTemplate();
        }
        long l2 = this.tc.createAndLoadConglomerate("heap", execRow.getRowArray(), null, nArray, properties, 0, this, null);
        this.closeBulkFetchScan();
        ScanController scanController = this.tc.openScan(l2, false, 4, 7, 5, null, null, 0, null, null, 0);
        scanController.setEstimatedRowCount(this.rowCount);
        scanController.close();
        scanController = null;
        this.dd.startWriting(this.lcc);
        if (this.compressIRGs.length > 0) {
            this.updateAllIndexes(l2, this.dd);
        }
        long l3 = this.td.getHeapConglomerateId();
        ConglomerateDescriptor conglomerateDescriptor = this.td.getConglomerateDescriptor(l3);
        this.dd.updateConglomerateDescriptor(conglomerateDescriptor, l2, this.tc);
        this.dm.invalidateFor(this.td, 33, this.lcc);
        this.tc.dropConglomerate(l3);
        this.cleanUp();
    }

    private void truncateTable() throws StandardException {
        Object object;
        Object object2;
        Properties properties = new Properties();
        for (Object object3 : this.dd.getConstraintDescriptors(this.td)) {
            if (!(object3 instanceof ReferencedKeyConstraintDescriptor) || !(object2 = ((ReferencedKeyConstraintDescriptor)(object = (ReferencedKeyConstraintDescriptor)object3)).getNonSelfReferencingFK(1).iterator()).hasNext()) continue;
            ConstraintDescriptor constraintDescriptor = (ConstraintDescriptor)object2.next();
            ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor = (ForeignKeyConstraintDescriptor)constraintDescriptor;
            throw StandardException.newException("XCL48.S", this.td.getName());
        }
        for (Object object3 : this.dd.getTriggerDescriptors(this.td)) {
            if (!((TriggerDescriptor)object3).listensForEvent(2) || !((TriggerDescriptor)object3).isEnabled()) continue;
            throw StandardException.newException("XCL49.S", this.td.getName(), ((TriggerDescriptor)object3).getName());
        }
        ExecRow execRow = this.td.getEmptyExecRow();
        this.compressHeapCC = this.tc.openConglomerate(this.td.getHeapConglomerateId(), false, 4, 7, 5);
        RowLocation rowLocation = this.compressHeapCC.newRowLocationTemplate();
        this.compressHeapCC.getInternalTablePropertySet(properties);
        this.compressHeapCC.close();
        this.compressHeapCC = null;
        long l2 = this.tc.createConglomerate("heap", execRow.getRowArray(), null, this.td.getColumnCollationIds(), properties, 0);
        this.getAffectedIndexes();
        if (this.numIndexes > 0) {
            this.indexRows = new ExecIndexRow[this.numIndexes];
            this.ordering = new ColumnOrdering[this.numIndexes][];
            this.collation = new int[this.numIndexes][];
            for (int i2 = 0; i2 < this.numIndexes; ++i2) {
                Object object3;
                object3 = this.compressIRGs[i2];
                this.indexRows[i2] = ((IndexRowGenerator)object3).getIndexRowTemplate();
                ((IndexRowGenerator)object3).getIndexRow(execRow, rowLocation, this.indexRows[i2], null);
                object = ((IndexRowGenerator)object3).baseColumnPositions();
                object2 = ((IndexRowGenerator)object3).isAscending();
                int n2 = ((Object)object).length + 1;
                this.ordering[i2] = new ColumnOrdering[n2];
                this.collation[i2] = ((IndexRowGenerator)object3).getColumnCollationIds(this.td.getColumnDescriptorList());
                for (int i3 = 0; i3 < n2 - 1; ++i3) {
                    this.ordering[i2][i3] = new IndexColumnOrder(i3, (boolean)object2[i3]);
                }
                this.ordering[i2][n2 - 1] = new IndexColumnOrder(n2 - 1);
            }
        }
        this.dd.startWriting(this.lcc);
        if (this.numIndexes > 0) {
            long[] lArray = new long[this.numIndexes];
            for (int i4 = 0; i4 < this.numIndexes; ++i4) {
                this.updateIndex(l2, this.dd, i4, lArray);
            }
        }
        long l3 = this.td.getHeapConglomerateId();
        object = this.td.getConglomerateDescriptor(l3);
        this.dd.updateConglomerateDescriptor((ConglomerateDescriptor)object, l2, this.tc);
        this.dm.invalidateFor(this.td, 42, this.lcc);
        this.tc.dropConglomerate(l3);
        this.cleanUp();
    }

    private void updateAllIndexes(long l2, DataDictionary dataDictionary) throws StandardException {
        long[] lArray = new long[this.numIndexes];
        if (this.sequential) {
            if (this.numIndexes >= 1) {
                this.updateIndex(l2, dataDictionary, 0, lArray);
            }
            for (int i2 = 1; i2 < this.numIndexes; ++i2) {
                this.openBulkFetchScan(l2);
                while (this.getNextRowFromRowSource() != null) {
                    this.objectifyStreamingColumns();
                    this.insertIntoSorter(i2, this.compressRL[this.currentCompressRow - 1]);
                }
                this.updateIndex(l2, dataDictionary, i2, lArray);
                this.closeBulkFetchScan();
            }
        } else {
            for (int i3 = 0; i3 < this.numIndexes; ++i3) {
                this.updateIndex(l2, dataDictionary, i3, lArray);
            }
        }
    }

    private void updateIndex(long l2, DataDictionary dataDictionary, int n2, long[] lArray) throws StandardException {
        Properties properties = new Properties();
        ConglomerateDescriptor conglomerateDescriptor = this.td.getConglomerateDescriptor(this.indexConglomerateNumbers[n2]);
        ConglomerateController conglomerateController = this.tc.openConglomerate(this.indexConglomerateNumbers[n2], false, 4, 7, 5);
        conglomerateController.getInternalTablePropertySet(properties);
        int n3 = this.indexRows[n2].nColumns();
        properties.put("baseConglomerateId", Long.toString(l2));
        if (conglomerateDescriptor.getIndexDescriptor().isUnique()) {
            properties.put("nUniqueColumns", Integer.toString(n3 - 1));
        } else {
            properties.put("nUniqueColumns", Integer.toString(n3));
        }
        if (conglomerateDescriptor.getIndexDescriptor().isUniqueWithDuplicateNulls() && !conglomerateDescriptor.getIndexDescriptor().hasDeferrableChecking()) {
            properties.put("uniqueWithDuplicateNulls", Boolean.toString(true));
        }
        properties.put("rowLocationColumn", Integer.toString(n3 - 1));
        properties.put("nKeyFields", Integer.toString(n3));
        conglomerateController.close();
        boolean bl2 = false;
        if (!this.truncateTable) {
            long l3;
            CardinalityCounter cardinalityCounter;
            this.sorters[n2].completedInserts();
            this.sorters[n2] = null;
            if (this.td.statisticsExist(conglomerateDescriptor)) {
                cardinalityCounter = new CardinalityCounter(this.tc.openSortRowSource(this.sortIds[n2]));
                bl2 = true;
            } else {
                cardinalityCounter = new CardinalityCounter(this.tc.openSortRowSource(this.sortIds[n2]));
            }
            lArray[n2] = this.tc.createAndLoadConglomerate("BTREE", this.indexRows[n2].getRowArray(), this.ordering[n2], this.collation[n2], properties, 0, cardinalityCounter, null);
            if (bl2) {
                dataDictionary.dropStatisticsDescriptors(this.td.getUUID(), conglomerateDescriptor.getUUID(), this.tc);
            }
            if ((l3 = cardinalityCounter.getRowCount()) > 0L) {
                long[] lArray2 = cardinalityCounter.getCardinality();
                for (int i2 = 0; i2 < lArray2.length; ++i2) {
                    StatisticsDescriptor statisticsDescriptor = new StatisticsDescriptor(dataDictionary, dataDictionary.getUUIDFactory().createUUID(), conglomerateDescriptor.getUUID(), this.td.getUUID(), "I", new StatisticsImpl(l3, lArray2[i2]), i2 + 1);
                    dataDictionary.addDescriptor(statisticsDescriptor, null, 14, true, this.tc);
                }
            }
        } else {
            lArray[n2] = this.tc.createConglomerate("BTREE", this.indexRows[n2].getRowArray(), this.ordering[n2], this.collation[n2], properties, 0);
            if (this.td.statisticsExist(conglomerateDescriptor)) {
                dataDictionary.dropStatisticsDescriptors(this.td.getUUID(), conglomerateDescriptor.getUUID(), this.tc);
            }
        }
        dataDictionary.updateConglomerateDescriptor(this.td.getConglomerateDescriptors(this.indexConglomerateNumbers[n2]), lArray[n2], this.tc);
        this.tc.dropConglomerate(this.indexConglomerateNumbers[n2]);
    }

    private void getAffectedIndexes() throws StandardException {
        int n2;
        Object[] objectArray;
        Object[] objectArray2;
        IndexLister indexLister = this.td.getIndexLister();
        this.compressIRGs = indexLister.getIndexRowGenerators();
        this.numIndexes = this.compressIRGs.length;
        this.indexConglomerateNumbers = indexLister.getIndexConglomerateNumbers();
        if (!this.compressTable && !this.truncateTable) {
            objectArray2 = new ArrayList();
            for (int i2 = 0; i2 < this.compressIRGs.length; ++i2) {
                ConglomerateDescriptor conglomerateDescriptor;
                objectArray = this.compressIRGs[i2].baseColumnPositions();
                for (n2 = 0; n2 < objectArray.length && objectArray[n2] != this.droppedColumnPosition; ++n2) {
                }
                if (n2 == objectArray.length) continue;
                if (objectArray.length == 1 || this.behavior == 0 && this.compressIRGs[i2].isUnique()) {
                    --this.numIndexes;
                    conglomerateDescriptor = this.td.getConglomerateDescriptor(this.indexConglomerateNumbers[i2]);
                    this.dropConglomerate(conglomerateDescriptor, this.td, true, (List<ConstantAction>)objectArray2, this.activation, this.activation.getLanguageConnectionContext());
                    this.compressIRGs[i2] = null;
                    continue;
                }
                if (!this.compressIRGs[i2].isUnique()) continue;
                conglomerateDescriptor = this.td.getConglomerateDescriptor(this.indexConglomerateNumbers[i2]);
                throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), this.columnInfo[0].name, "UNIQUE INDEX", conglomerateDescriptor.getConglomerateName());
            }
            this.createNewBackingCongloms((ArrayList<ConstantAction>)objectArray2, this.indexConglomerateNumbers);
            IndexRowGenerator[] indexRowGeneratorArray = new IndexRowGenerator[this.numIndexes];
            objectArray = new long[this.numIndexes];
            this.collation = new int[this.numIndexes][];
            n2 = 0;
            int n3 = 0;
            while (n2 < this.numIndexes) {
                while (this.compressIRGs[n3] == null) {
                    ++n3;
                }
                this.collation[n2] = this.compressIRGs[n3].getColumnCollationIds(this.td.getColumnDescriptorList());
                int[] nArray = this.compressIRGs[n3].baseColumnPositions();
                indexRowGeneratorArray[n2] = this.compressIRGs[n3];
                objectArray[n2] = (int)this.indexConglomerateNumbers[n3];
                boolean[] blArray = this.compressIRGs[n3].isAscending();
                boolean bl2 = false;
                boolean bl3 = false;
                int n4 = nArray.length;
                for (int i3 = 0; i3 < n4; ++i3) {
                    if (nArray[i3] > this.droppedColumnPosition) {
                        int n5 = i3;
                        nArray[n5] = nArray[n5] - 1;
                        bl3 = true;
                        continue;
                    }
                    if (nArray[i3] != this.droppedColumnPosition) continue;
                    nArray[i3] = 0;
                    bl2 = true;
                }
                if (bl3) {
                    this.compressIRGs[n3].setBaseColumnPositions(nArray);
                }
                if (bl2) {
                    int[] nArray2 = new int[--n4];
                    boolean[] blArray2 = new boolean[n4];
                    int[] nArray3 = new int[this.collation[n2].length - 1];
                    int n6 = 0;
                    for (int i4 = 0; i4 < n4; ++i4) {
                        if (n6 == 0 && nArray[i4 + n6] == 0) {
                            ++n6;
                        }
                        nArray2[i4] = nArray[i4 + n6];
                        blArray2[i4] = blArray[i4 + n6];
                        nArray3[i4] = this.collation[n2][i4 + n6];
                    }
                    IndexDescriptor indexDescriptor = this.compressIRGs[n3].getIndexDescriptor();
                    indexDescriptor.setBaseColumnPositions(nArray2);
                    indexDescriptor.setIsAscending(blArray2);
                    indexDescriptor.setNumberOfOrderedColumns(indexDescriptor.numberOfOrderedColumns() - 1);
                    this.collation[n2] = nArray3;
                }
                ++n2;
                ++n3;
            }
            this.compressIRGs = indexRowGeneratorArray;
            this.indexConglomerateNumbers = objectArray;
        } else {
            this.collation = new int[this.numIndexes][];
            for (int i5 = 0; i5 < this.numIndexes; ++i5) {
                this.collation[i5] = this.compressIRGs[i5].getColumnCollationIds(this.td.getColumnDescriptorList());
            }
        }
        objectArray2 = this.compressIndexArrays(this.indexConglomerateNumbers, this.compressIRGs);
        if (objectArray2 != null) {
            this.indexConglomerateNumbers = (long[])objectArray2[1];
            this.compressIRGs = (IndexRowGenerator[])objectArray2[2];
            this.numIndexes = this.indexConglomerateNumbers.length;
        }
        this.indexedCols = new FormatableBitSet(this.compressTable || this.truncateTable ? this.td.getNumberOfColumns() + 1 : this.td.getNumberOfColumns());
        for (int i6 = 0; i6 < this.numIndexes; ++i6) {
            objectArray = this.compressIRGs[i6].getIndexDescriptor().baseColumnPositions();
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                this.indexedCols.set(objectArray[n2]);
            }
        }
    }

    private void createNewBackingCongloms(ArrayList<ConstantAction> arrayList, long[] lArray) throws StandardException {
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            CreateIndexConstantAction createIndexConstantAction = (CreateIndexConstantAction)arrayList.get(i2);
            if (this.dd.getConglomerateDescriptor(createIndexConstantAction.getCreatedUUID()) == null) continue;
            this.executeConglomReplacement(createIndexConstantAction, this.activation);
            long l2 = createIndexConstantAction.getReplacedConglomNumber();
            long l3 = createIndexConstantAction.getCreatedConglomNumber();
            ConglomerateDescriptor[] conglomerateDescriptorArray = this.td.getConglomerateDescriptors(l2);
            for (n3 = 0; n3 < conglomerateDescriptorArray.length; ++n3) {
                conglomerateDescriptorArray[n3].setConglomerateNumber(l3);
            }
            if (lArray == null) continue;
            for (n3 = 0; n3 < lArray.length; ++n3) {
                if (lArray[n3] != l2) continue;
                lArray[n3] = l3;
            }
        }
    }

    private void setUpAllSorts(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        int n2;
        this.ordering = new ColumnOrdering[this.numIndexes][];
        this.needToDropSort = new boolean[this.numIndexes];
        this.sortIds = new long[this.numIndexes];
        for (n2 = 0; n2 < this.numIndexes; ++n2) {
            this.indexRows[n2] = this.compressIRGs[n2].getIndexRowTemplate();
            this.compressIRGs[n2].getIndexRow(execRow, rowLocation, this.indexRows[n2], null);
            int[] nArray = this.compressIRGs[n2].baseColumnPositions();
            boolean[] blArray = this.compressIRGs[n2].isAscending();
            int n3 = nArray.length + 1;
            boolean bl2 = this.numIndexes == 1;
            BasicSortObserver basicSortObserver = new BasicSortObserver(false, false, this.indexRows[n2], bl2);
            this.ordering[n2] = new ColumnOrdering[n3];
            for (int i2 = 0; i2 < n3 - 1; ++i2) {
                this.ordering[n2][i2] = new IndexColumnOrder(i2, blArray[i2]);
            }
            this.ordering[n2][n3 - 1] = new IndexColumnOrder(n3 - 1);
            this.sortIds[n2] = this.tc.createSort(null, this.indexRows[n2].getRowArrayClone(), this.ordering[n2], basicSortObserver, false, this.estimatedRowCount, -1);
        }
        this.sorters = new SortController[this.numIndexes];
        for (n2 = 0; n2 < this.numIndexes; ++n2) {
            this.sorters[n2] = this.tc.openSort(this.sortIds[n2]);
            this.needToDropSort[n2] = true;
        }
    }

    @Override
    public FormatableBitSet getValidColumns() {
        return null;
    }

    @Override
    public DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        int n2;
        this.currentRow = null;
        if (!(this.doneScan || this.currentCompressRow != this.bulkFetchSize && this.validRow[this.currentCompressRow])) {
            int n3;
            n2 = this.compressHeapGSC.fetchNextGroup(this.baseRowArray, this.compressRL);
            this.doneScan = n2 != this.bulkFetchSize;
            this.currentCompressRow = 0;
            this.rowCount += n2;
            for (n3 = 0; n3 < n2; ++n3) {
                this.validRow[n3] = true;
            }
            for (n3 = n2; n3 < this.bulkFetchSize; ++n3) {
                this.validRow[n3] = false;
            }
        }
        if (this.validRow[this.currentCompressRow]) {
            if (this.compressTable) {
                this.currentRow = this.baseRow[this.currentCompressRow];
            } else {
                if (this.currentRow == null) {
                    this.currentRow = this.activation.getExecutionFactory().getValueRow(this.baseRowArray[this.currentCompressRow].length - 1);
                }
                for (n2 = 0; n2 < this.currentRow.nColumns(); ++n2) {
                    this.currentRow.setColumn(n2 + 1, n2 < this.droppedColumnPosition - 1 ? this.baseRow[this.currentCompressRow].getColumn(n2 + 1) : this.baseRow[this.currentCompressRow].getColumn(n2 + 1 + 1));
                }
            }
            ++this.currentCompressRow;
        }
        if (this.currentRow != null) {
            if (this.compressIRGs.length > 0) {
                this.currentRow = this.currentRow.getClone(this.indexedCols);
            }
            return this.currentRow.getRowArray();
        }
        return null;
    }

    @Override
    public boolean needsToClone() {
        return true;
    }

    @Override
    public void closeRowSource() {
    }

    @Override
    public boolean needsRowLocation() {
        return this.numIndexes > 0;
    }

    @Override
    public boolean needsRowLocationForDeferredCheckConstraints() {
        return false;
    }

    @Override
    public void rowLocation(RowLocation rowLocation) throws StandardException {
        if (this.compressIRGs.length > 0) {
            this.objectifyStreamingColumns();
            int n2 = this.compressIRGs.length;
            if (n2 > 1 && this.sequential) {
                n2 = 1;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                this.insertIntoSorter(i2, rowLocation);
            }
        }
    }

    private void objectifyStreamingColumns() throws StandardException {
        for (int i2 = 0; i2 < this.currentRow.getRowArray().length; ++i2) {
            if (!this.indexedCols.get(i2 + 1) || !(this.currentRow.getRowArray()[i2] instanceof StreamStorable)) continue;
            this.currentRow.getRowArray()[i2].getObject();
        }
    }

    private void insertIntoSorter(int n2, RowLocation rowLocation) throws StandardException {
        this.indexRows[n2].getNewObjectArray();
        this.compressIRGs[n2].getIndexRow(this.currentRow, (RowLocation)rowLocation.cloneValue(false), this.indexRows[n2], null);
        this.sorters[n2].insert(this.indexRows[n2].getRowArray());
    }

    private void cleanUp() throws StandardException {
        int n2;
        if (this.compressHeapCC != null) {
            this.compressHeapCC.close();
            this.compressHeapCC = null;
        }
        if (this.compressHeapGSC != null) {
            this.closeBulkFetchScan();
        }
        if (this.sorters != null) {
            for (n2 = 0; n2 < this.compressIRGs.length; ++n2) {
                if (this.sorters[n2] != null) {
                    this.sorters[n2].completedInserts();
                }
                this.sorters[n2] = null;
            }
        }
        if (this.needToDropSort != null) {
            for (n2 = 0; n2 < this.needToDropSort.length; ++n2) {
                if (!this.needToDropSort[n2]) continue;
                this.tc.dropSort(this.sortIds[n2]);
                this.needToDropSort[n2] = false;
            }
        }
    }

    private int getSemiRowCount(TransactionController transactionController) throws StandardException {
        int n2 = 0;
        ScanController scanController = transactionController.openScan(this.td.getHeapConglomerateId(), false, 0, 7, 5, RowUtil.EMPTY_ROW_BITSET, null, 1, null, null, -1);
        while (scanController.next() && ++n2 != 2) {
        }
        scanController.close();
        return n2;
    }

    private void updateNewColumnToDefault(ColumnDescriptor columnDescriptor) throws StandardException {
        String string = columnDescriptor.getColumnName();
        String string2 = "UPDATE " + IdUtil.mkQualifiedName(this.td.getSchemaName(), this.td.getName()) + " SET " + IdUtil.normalToDelimited(string) + "=DEFAULT";
        AlterTableConstantAction.executeUpdate(this.lcc, string2);
    }

    private static void executeUpdate(LanguageConnectionContext languageConnectionContext, String string) throws StandardException {
        PreparedStatement preparedStatement = languageConnectionContext.prepareInternalStatement(string);
        ResultSet resultSet = preparedStatement.executeSubStatement(languageConnectionContext, true, 0L);
        resultSet.close();
    }

    private long getColumnMax(TableDescriptor tableDescriptor, String string, long l2) throws StandardException {
        String string2 = l2 > 0L ? "MAX" : "MIN";
        String string3 = "SELECT  " + string2 + "(" + IdUtil.normalToDelimited(string) + ") FROM " + IdUtil.mkQualifiedName(tableDescriptor.getSchemaName(), tableDescriptor.getName());
        PreparedStatement preparedStatement = this.lcc.prepareInternalStatement(string3);
        ResultSet resultSet = preparedStatement.executeSubStatement(this.lcc, false, 0L);
        DataValueDescriptor[] dataValueDescriptorArray = resultSet.getNextRow().getRowArray();
        resultSet.close();
        resultSet.finish();
        return dataValueDescriptorArray[0].getLong();
    }

    private void openBulkFetchScan(long l2) throws StandardException {
        this.doneScan = false;
        this.compressHeapGSC = this.tc.openGroupFetchScan(l2, false, 0, 7, 5, null, null, 0, null, null, 0);
    }

    private void closeBulkFetchScan() throws StandardException {
        this.compressHeapGSC.close();
        this.compressHeapGSC = null;
    }

    private boolean validateNotNullConstraint(String[] stringArray, boolean[] blArray, int n2, LanguageConnectionContext languageConnectionContext, String string) throws StandardException {
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(stringArray[i2]);
            if (columnDescriptor == null) {
                throw StandardException.newException("42X14", stringArray[i2], this.td.getName());
            }
            if (!columnDescriptor.getType().isNullable()) continue;
            if (n2 > 0) {
                if (bl2) {
                    stringBuilder.append(" AND ");
                }
                stringBuilder.append(IdUtil.normalToDelimited(stringArray[i2]));
                stringBuilder.append(" IS NOT NULL ");
            }
            bl2 = true;
            blArray[i2] = true;
        }
        if (bl2 && n2 > 0 && !ConstraintConstantAction.validateConstraint(null, stringBuilder.toString(), null, this.td, languageConnectionContext, false, false)) {
            if (string.equals("X0Y63.S")) {
                throw StandardException.newException("X0Y63.S", this.td.getQualifiedName());
            }
            if (string.equals("X0Y63.S.1")) {
                throw StandardException.newException("X0Y63.S.1", this.td.getQualifiedName());
            }
            throw StandardException.newException("X0Y80.S", this.td.getQualifiedName(), stringArray[0]);
        }
        return bl2;
    }

    private Object[] compressIndexArrays(long[] lArray, IndexRowGenerator[] indexRowGeneratorArray) {
        long[] lArray2 = new long[lArray.length];
        int n2 = 0;
        int n3 = lArray.length - 1;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            int n4;
            for (n4 = 0; n4 < n2; ++n4) {
                if (lArray[i2] != lArray2[n4]) continue;
                lArray2[n3--] = i2;
                break;
            }
            if (n4 != n2) continue;
            lArray2[n2++] = lArray[i2];
        }
        if (n2 < lArray.length) {
            long[] lArray3 = new long[n2];
            IndexRowGenerator[] indexRowGeneratorArray2 = new IndexRowGenerator[n2];
            int[] nArray = new int[lArray.length - n2];
            n3 = 0;
            int n5 = lArray.length - 1;
            for (int i3 = 0; i3 < lArray.length; ++i3) {
                if (i3 < n2) {
                    lArray3[i3] = lArray2[i3];
                } else {
                    nArray[lArray.length - i3 - 1] = (int)lArray2[i3];
                }
                if (n5 >= n2 && i3 == (int)lArray2[n5]) {
                    --n5;
                    continue;
                }
                indexRowGeneratorArray2[n3] = indexRowGeneratorArray[i3];
                ++n3;
            }
            Object[] objectArray = new Object[]{nArray, lArray3, indexRowGeneratorArray2};
            return objectArray;
        }
        return null;
    }

    @Override
    public void offendingRowLocation(RowLocation rowLocation, long l2) throws StandardException {
    }
}

