/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.UserDataValue;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.GenericAggregator;

class AggregateSortObserver
extends BasicSortObserver {
    private final GenericAggregator[] aggsToProcess;
    private final GenericAggregator[] aggsToInitialize;
    private int firstAggregatorColumn;

    public AggregateSortObserver(boolean bl2, GenericAggregator[] genericAggregatorArray, GenericAggregator[] genericAggregatorArray2, ExecRow execRow) {
        super(bl2, false, execRow, true);
        this.aggsToProcess = genericAggregatorArray;
        this.aggsToInitialize = genericAggregatorArray2;
        if (genericAggregatorArray2.length > 0) {
            this.firstAggregatorColumn = genericAggregatorArray2[0].aggregatorColumnId;
        }
    }

    @Override
    public DataValueDescriptor[] insertNonDuplicateKey(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        Object[] objectArray = super.insertNonDuplicateKey(dataValueDescriptorArray);
        if (this.aggsToInitialize.length > 0 && objectArray[this.firstAggregatorColumn].isNull()) {
            for (int i2 = 0; i2 < this.aggsToInitialize.length; ++i2) {
                GenericAggregator genericAggregator = this.aggsToInitialize[i2];
                UserDataValue userDataValue = (UserDataValue)objectArray[genericAggregator.aggregatorColumnId];
                userDataValue.setValue(genericAggregator.getAggregatorInstance());
                genericAggregator.accumulate(objectArray, objectArray);
            }
        }
        return objectArray;
    }

    @Override
    public DataValueDescriptor[] insertDuplicateKey(DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2) throws StandardException {
        if (this.aggsToProcess.length == 0) {
            return null;
        }
        for (int i2 = 0; i2 < this.aggsToProcess.length; ++i2) {
            GenericAggregator genericAggregator = this.aggsToProcess[i2];
            if (dataValueDescriptorArray[genericAggregator.getColumnId()].isNull()) {
                genericAggregator.accumulate(dataValueDescriptorArray, dataValueDescriptorArray2);
                continue;
            }
            genericAggregator.merge(dataValueDescriptorArray, dataValueDescriptorArray2);
        }
        return null;
    }
}

