/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.io.PrintWriter;
import java.util.Date;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.OptTrace;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizableList;
import org.apache.derby.iapi.sql.compile.OptimizerPlan;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.OptimizerImpl;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.StaticMethodCallNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class XMLOptTrace
implements OptTrace {
    private static final String STMT = "statement";
    private static final String STMT_ID = "stmtID";
    private static final String STMT_TEXT = "stmtText";
    private static final String QBLOCK = "queryBlock";
    private static final String QBLOCK_OPTIMIZER_ID = "qbOptimizerID";
    private static final String QBLOCK_START_TIME = "qbStartTime";
    private static final String QBLOCK_ID = "qbID";
    private static final String QBLOCK_OPTIMIZABLE = "qbOptimizable";
    private static final String QBLOCK_OPT_TABLE_NUMBER = "qboTableNumber";
    private static final String QBLOCK_TIMEOUT = "qbTimeout";
    private static final String QBLOCK_VACUOUS = "qbVacuous";
    private static final String QBLOCK_SORT_COST = "qbSortCost";
    private static final String QBLOCK_TOTAL_COST = "qbTotalCost";
    private static final String QBLOCK_NO_BEST_PLAN = "qbNoBestPlan";
    private static final String QBLOCK_SKIP = "qbSkip";
    private static final String JO = "joinOrder";
    private static final String JO_COMPLETE = "joComplete";
    private static final String JO_SLOT = "joSlot";
    private static final String DECORATION = "decoration";
    private static final String DECORATION_CONGLOM_NAME = "decConglomerateName";
    private static final String DECORATION_KEY = "decKey";
    private static final String DECORATION_TABLE_NAME = "decTableName";
    private static final String DECORATION_JOIN_STRATEGY = "decJoinStrategy";
    private static final String DECORATION_SKIP = "decSkip";
    private static final String DECORATION_CONGLOM_COST = "decConglomerateCost";
    private static final String DECORATION_FIRST_COLUMN_SELECTIVITY = "decExtraFirstColumnPreds";
    private static final String DECORATION_EXTRA_START_STOP_SELECTIVITY = "decExtraFirstStartStopPreds";
    private static final String DECORATION_START_STOP_SELECTIVITY = "decStartStopPred";
    private static final String DECORATION_EXTRA_QUALIFIERS = "decExtraQualifiers";
    private static final String DECORATION_EXTRA_NON_QUALIFIERS = "decExtraNonQualifiers";
    private static final String SKIP_REASON = "skipReason";
    private static final String PC = "planCost";
    private static final String PC_TYPE = "pcType";
    private static final String PC_COMPLETE = "pcComplete";
    private static final String PC_AVOID_SORT = "pcAvoidSort";
    private static final String PC_SUMMARY = "pcSummary";
    private static final String CE_ESTIMATED_COST = "ceEstimatedCost";
    private static final String CE_ROW_COUNT = "ceEstimatedRowCount";
    private static final String CE_SINGLE_SCAN_ROW_COUNT = "ceSingleScanRowCount";
    private static final String SEL_COUNT = "selCount";
    private static final String SEL_SELECTIVITY = "selSelectivity";
    private static final String TABLE_FUNCTION_FLAG = "()";
    static final String PLAN_COST_VTI = "create function planCost\n(\n    xmlResourceName varchar( 32672 ),\n    rowTag varchar( 32672 ),\n    parentTags ArrayList,\n    childTags ArrayList\n)\nreturns table\n(\n    text varchar( 32672 ),\n    stmtID    int,\n    qbID   int,\n    complete  boolean,\n    summary   varchar( 32672 ),\n    type        varchar( 50 ),\n    estimatedCost        double,\n    estimatedRowCount    bigint\n)\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derby.vti.XmlVTI.xmlVTI'\n";
    static final String PLAN_COST_VIEW = "create view planCost as\nselect *\nfrom table\n(\n    planCost\n    (\n        'FILE_URL',\n        'planCost',\n        asList( 'stmtText', 'stmtID', 'qbID' ),\n        asList( 'pcComplete', 'pcSummary', 'pcType', 'ceEstimatedCost', 'ceEstimatedRowCount' )\n     )\n) v\n";
    private Document _doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
    private Element _root = this.createElement(null, "optimizerTrace", null);
    private Element _currentStatement;
    private int _currentStatementID;
    private QueryBlock _currentQueryBlock;
    private int _maxQueryID;
    private Stack<QueryBlock> _queryBlockStack;
    private ContextManager _cm;
    private LanguageConnectionContext _lcc;

    public XMLOptTrace() throws ParserConfigurationException {
        this._doc.appendChild(this._root);
    }

    @Override
    public void traceStartStatement(String string) {
        ++this._currentStatementID;
        this._maxQueryID = 0;
        this._currentQueryBlock = null;
        this._queryBlockStack = new Stack();
        this._currentStatement = this.createElement(this._root, STMT, null);
        this._currentStatement.setAttribute(STMT_ID, Integer.toString(this._currentStatementID));
        this.createElement(this._currentStatement, STMT_TEXT, string);
    }

    @Override
    public void traceStartQueryBlock(long l2, int n2, OptimizableList optimizableList) {
        ++this._maxQueryID;
        if (this._currentQueryBlock != null) {
            this._queryBlockStack.push(this._currentQueryBlock);
        }
        Element element = this.createElement(this._currentStatement, QBLOCK, null);
        element.setAttribute(QBLOCK_OPTIMIZER_ID, Integer.toString(n2));
        element.setAttribute(QBLOCK_START_TIME, this.formatTimestamp(l2));
        element.setAttribute(QBLOCK_ID, Integer.toString(this._maxQueryID));
        this._currentQueryBlock = new QueryBlock(this._maxQueryID, optimizableList, element);
        if (optimizableList != null) {
            for (int i2 = 0; i2 < optimizableList.size(); ++i2) {
                Optimizable optimizable = optimizableList.getOptimizable(i2);
                if (this._cm == null) {
                    this._cm = ((QueryTreeNode)((Object)optimizable)).getContextManager();
                    this._lcc = (LanguageConnectionContext)this._cm.getContext("LanguageConnectionContext");
                }
                Element element2 = this.createElement(element, QBLOCK_OPTIMIZABLE, this.getOptimizableName(optimizable).getFullSQLName());
                element2.setAttribute(QBLOCK_OPT_TABLE_NUMBER, Integer.toString(optimizable.getTableNumber()));
            }
        }
    }

    @Override
    public void traceEndQueryBlock() {
        if (this._queryBlockStack.size() > 0) {
            this._currentQueryBlock = this._queryBlockStack.pop();
        }
    }

    @Override
    public void traceTimeout(long l2, CostEstimate costEstimate) {
        Element element = this.createElement(this._currentQueryBlock.queryBlockElement, QBLOCK_TIMEOUT, null);
        this.formatCost(element, costEstimate);
    }

    @Override
    public void traceVacuous() {
        this.createElement(this._currentQueryBlock.queryBlockElement, QBLOCK_VACUOUS, null);
    }

    @Override
    public void traceCompleteJoinOrder() {
        if (this._currentQueryBlock.currentJoinsElement != null) {
            this._currentQueryBlock.currentJoinsElement.setAttribute(JO_COMPLETE, "true");
        }
    }

    @Override
    public void traceSortCost(CostEstimate costEstimate, CostEstimate costEstimate2) {
        Element element = this.createElement(this._currentQueryBlock.queryBlockElement, QBLOCK_SORT_COST, null);
        this.formatCost(element, costEstimate);
        Element element2 = this.createElement(this._currentQueryBlock.queryBlockElement, QBLOCK_TOTAL_COST, null);
        this.formatCost(element2, costEstimate2);
    }

    @Override
    public void traceNoBestPlan() {
        this.createElement(this._currentQueryBlock.queryBlockElement, QBLOCK_NO_BEST_PLAN, null);
    }

    @Override
    public void traceModifyingAccessPaths(int n2) {
    }

    @Override
    public void traceShortCircuiting(boolean bl2, Optimizable optimizable, int n2) {
    }

    @Override
    public void traceSkippingJoinOrder(int n2, int n3, int[] nArray, JBitSet jBitSet) {
        Optimizable optimizable = this._currentQueryBlock.optimizableList.getOptimizable(n2);
        Element element = this.formatSkip(this._currentQueryBlock.queryBlockElement, QBLOCK_SKIP, "Useless join order. " + this.getOptimizableName(optimizable).getFullSQLName() + " depends on tables after it in the join order");
        this.formatJoinOrder(element, nArray);
    }

    @Override
    public void traceIllegalUserJoinOrder() {
    }

    @Override
    public void traceUserJoinOrderOptimized() {
    }

    @Override
    public void traceJoinOrderConsideration(int n2, int[] nArray, JBitSet jBitSet) {
        this._currentQueryBlock.currentJoinsElement = this.createElement(this._currentQueryBlock.queryBlockElement, JO, null);
        this._currentQueryBlock.currentJoinOrder = nArray;
        this._currentQueryBlock.currentDecorationStrategy = null;
        this._currentQueryBlock.currentDecoration = null;
        this.formatJoinOrder(this._currentQueryBlock.currentJoinsElement, nArray);
    }

    @Override
    public void traceCostWithoutSortAvoidance(CostEstimate costEstimate) {
        this.formatPlanCost(this._currentQueryBlock.currentJoinsElement, "withoutSortAvoidance", this._currentQueryBlock.currentJoinOrder, 1, costEstimate);
    }

    @Override
    public void traceCostWithSortAvoidance(CostEstimate costEstimate) {
        this.formatPlanCost(this._currentQueryBlock.currentJoinsElement, "withSortAvoidance", this._currentQueryBlock.currentJoinOrder, 2, costEstimate);
    }

    @Override
    public void traceCurrentPlanAvoidsSort(CostEstimate costEstimate, CostEstimate costEstimate2) {
    }

    @Override
    public void traceCheapestPlanSoFar(int n2, CostEstimate costEstimate) {
    }

    @Override
    public void traceSortNeededForOrdering(int n2, RequiredRowOrdering requiredRowOrdering) {
    }

    @Override
    public void traceRememberingBestJoinOrder(int n2, int[] nArray, int n3, CostEstimate costEstimate, JBitSet jBitSet) {
        if (this._currentQueryBlock.currentBestPlan != null) {
            this._currentQueryBlock.queryBlockElement.removeChild(this._currentQueryBlock.currentBestPlan);
        }
        this._currentQueryBlock.currentBestPlan = this.formatPlanCost(this._currentQueryBlock.queryBlockElement, "bestPlan", nArray, n3, costEstimate);
    }

    @Override
    public void traceSkippingBecauseTooMuchMemory(int n2) {
        this.formatSkip(this._currentQueryBlock.currentDecoration, DECORATION_SKIP, "Exceeds limit on memory per table: " + n2);
    }

    @Override
    public void traceCostOfNScans(int n2, double d2, CostEstimate costEstimate) {
    }

    @Override
    public void traceSkipUnmaterializableHashJoin() {
        this.formatSkip(this._currentQueryBlock.currentDecoration, DECORATION_SKIP, "Hash strategy not possible because table is not materializable");
    }

    @Override
    public void traceSkipHashJoinNoHashKeys() {
        this.formatSkip(this._currentQueryBlock.currentDecoration, DECORATION_SKIP, "No hash keys");
    }

    @Override
    public void traceHashKeyColumns(int[] nArray) {
    }

    @Override
    public void traceOptimizingJoinNode() {
    }

    @Override
    public void traceConsideringJoinStrategy(JoinStrategy joinStrategy, int n2) {
        this._currentQueryBlock.currentDecorationStrategy = joinStrategy;
    }

    @Override
    public void traceRememberingBestAccessPath(AccessPath accessPath, int n2, int n3) {
    }

    @Override
    public void traceNoMoreConglomerates(int n2) {
    }

    @Override
    public void traceConsideringConglomerate(ConglomerateDescriptor conglomerateDescriptor, int n2) {
        Optimizable optimizable = this.getOptimizable(n2);
        this._currentQueryBlock.currentDecoration = this.createElement(this._currentQueryBlock.currentJoinsElement, DECORATION, null);
        this._currentQueryBlock.currentDecoration.setAttribute(DECORATION_CONGLOM_NAME, conglomerateDescriptor.getConglomerateName());
        this._currentQueryBlock.currentDecoration.setAttribute(DECORATION_TABLE_NAME, this.getOptimizableName(optimizable).toString());
        this._currentQueryBlock.currentDecoration.setAttribute(DECORATION_JOIN_STRATEGY, this._currentQueryBlock.currentDecorationStrategy.getName());
        String[] stringArray = conglomerateDescriptor.getColumnNames();
        if (conglomerateDescriptor.isIndex() && stringArray != null) {
            int[] nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                this.createElement(this._currentQueryBlock.currentDecoration, DECORATION_KEY, stringArray[nArray[i2] - 1]);
            }
        }
    }

    @Override
    public void traceScanningHeapWithUniqueKey() {
    }

    @Override
    public void traceAddingUnorderedOptimizable(int n2) {
    }

    @Override
    public void traceChangingAccessPathForTable(int n2) {
    }

    @Override
    public void traceNoStartStopPosition() {
    }

    @Override
    public void traceNonCoveringIndexCost(double d2, int n2) {
    }

    @Override
    public void traceConstantStartStopPositions() {
    }

    @Override
    public void traceEstimatingCostOfConglomerate(ConglomerateDescriptor conglomerateDescriptor, int n2) {
    }

    @Override
    public void traceLookingForSpecifiedIndex(String string, int n2) {
    }

    @Override
    public void traceSingleMatchedRowCost(double d2, int n2) {
    }

    @Override
    public void traceCostIncludingExtra1stColumnSelectivity(CostEstimate costEstimate, int n2) {
    }

    @Override
    public void traceNextAccessPath(String string, int n2) {
    }

    @Override
    public void traceCostIncludingExtraStartStop(CostEstimate costEstimate, int n2) {
    }

    @Override
    public void traceCostIncludingExtraQualifierSelectivity(CostEstimate costEstimate, int n2) {
    }

    @Override
    public void traceCostIncludingExtraNonQualifierSelectivity(CostEstimate costEstimate, int n2) {
    }

    @Override
    public void traceCostOfNoncoveringIndex(CostEstimate costEstimate, int n2) {
    }

    @Override
    public void traceRememberingJoinStrategy(JoinStrategy joinStrategy, int n2) {
    }

    @Override
    public void traceRememberingBestAccessPathSubstring(AccessPath accessPath, int n2) {
    }

    @Override
    public void traceRememberingBestSortAvoidanceAccessPathSubstring(AccessPath accessPath, int n2) {
    }

    @Override
    public void traceRememberingBestUnknownAccessPathSubstring(AccessPath accessPath, int n2) {
    }

    @Override
    public void traceCostOfConglomerateScan(int n2, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, int n3, double d2, int n4, double d3, int n5, double d4, int n6, double d5, int n7, double d6) {
        Element element = this.createElement(this._currentQueryBlock.currentDecoration, DECORATION_CONGLOM_COST, null);
        element.setAttribute("name", conglomerateDescriptor.getConglomerateName());
        this.formatCost(element, costEstimate);
        this.formatSelectivity(element, DECORATION_FIRST_COLUMN_SELECTIVITY, n3, d2);
        this.formatSelectivity(element, DECORATION_EXTRA_START_STOP_SELECTIVITY, n4, d3);
        this.formatSelectivity(element, DECORATION_START_STOP_SELECTIVITY, n5, d4);
        this.formatSelectivity(element, DECORATION_EXTRA_QUALIFIERS, n6, d5);
        this.formatSelectivity(element, DECORATION_EXTRA_NON_QUALIFIERS, n7, d6);
    }

    @Override
    public void traceCostIncludingCompositeSelectivityFromStats(CostEstimate costEstimate, int n2) {
    }

    @Override
    public void traceCompositeSelectivityFromStatistics(double d2) {
    }

    @Override
    public void traceCostIncludingStatsForIndex(CostEstimate costEstimate, int n2) {
    }

    @Override
    public void printToWriter(PrintWriter printWriter) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(this._doc);
            StreamResult streamResult = new StreamResult(printWriter);
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(dOMSource, streamResult);
        }
        catch (Throwable throwable) {
            this.printThrowable(throwable);
        }
    }

    private Optimizable getOptimizable(int n2) {
        for (int i2 = 0; i2 < this._currentQueryBlock.optimizableList.size(); ++i2) {
            Optimizable optimizable = this._currentQueryBlock.optimizableList.getOptimizable(i2);
            if (n2 != optimizable.getTableNumber()) continue;
            return optimizable;
        }
        return null;
    }

    private TableName getOptimizableName(Optimizable optimizable) {
        Object object;
        try {
            if (this.isBaseTable(optimizable)) {
                ProjectRestrictNode projectRestrictNode = (ProjectRestrictNode)optimizable;
                TableDescriptor tableDescriptor = ((FromBaseTable)projectRestrictNode.getChildResult()).getTableDescriptor();
                return this.makeTableName(tableDescriptor.getSchemaName(), tableDescriptor.getName(), this._cm);
            }
            if (OptimizerImpl.isTableFunction(optimizable)) {
                ProjectRestrictNode projectRestrictNode = (ProjectRestrictNode)optimizable;
                AliasDescriptor aliasDescriptor = ((StaticMethodCallNode)((FromVTI)projectRestrictNode.getChildResult()).getMethodCall()).ad;
                return this.makeTableName(aliasDescriptor.getSchemaName(), aliasDescriptor.getName(), this._cm);
            }
            if (this.isFromTable(optimizable) && (object = ((FromTable)((ProjectRestrictNode)optimizable).getChildResult()).getTableName()) != null) {
                return object;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        object = optimizable.getClass().getName();
        String string = ((String)object).substring(((String)object).lastIndexOf(".") + 1);
        return this.makeTableName(null, string, this._cm);
    }

    private boolean isBaseTable(Optimizable optimizable) {
        if (!(optimizable instanceof ProjectRestrictNode)) {
            return false;
        }
        ResultSetNode resultSetNode = ((ProjectRestrictNode)optimizable).getChildResult();
        return resultSetNode instanceof FromBaseTable;
    }

    private boolean isFromTable(Optimizable optimizable) {
        if (!(optimizable instanceof ProjectRestrictNode)) {
            return false;
        }
        ResultSetNode resultSetNode = ((ProjectRestrictNode)optimizable).getChildResult();
        return resultSetNode instanceof FromTable;
    }

    private TableName makeTableName(String string, String string2, ContextManager contextManager) {
        TableName tableName = new TableName(string, string2, contextManager);
        return tableName;
    }

    private void printThrowable(Throwable throwable) {
        throwable.printStackTrace(Monitor.getStream().getPrintWriter());
    }

    private Element createElement(Element element, String string, String string2) {
        Element element2 = null;
        try {
            element2 = this._doc.createElement(string);
            if (element != null) {
                element.appendChild(element2);
            }
            if (string2 != null) {
                element2.setTextContent(string2);
            }
        }
        catch (Throwable throwable) {
            this.printThrowable(throwable);
        }
        return element2;
    }

    private String formatTimestamp(long l2) {
        return new Date(l2).toString();
    }

    private Element formatSkip(Element element, String string, String string2) {
        Element element2 = this.createElement(element, string, null);
        element2.setAttribute(SKIP_REASON, string2);
        return element2;
    }

    private Element formatPlanCost(Element element, String string, int[] nArray, int n2, CostEstimate costEstimate) {
        Element element2 = this.createElement(element, PC, null);
        element2.setAttribute(PC_TYPE, string);
        if (this.isComplete(nArray)) {
            element2.setAttribute(PC_COMPLETE, "true");
        }
        if (n2 == 2) {
            element2.setAttribute(PC_AVOID_SORT, "true");
        }
        this.createElement(element2, PC_SUMMARY, this.formatPlanSummary(nArray, n2));
        this.formatCost(element2, costEstimate);
        return element2;
    }

    private boolean isComplete(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        if (nArray.length < this._currentQueryBlock.optimizableList.size()) {
            return false;
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] >= 0) continue;
            return false;
        }
        return true;
    }

    private void formatCost(Element element, CostEstimate costEstimate) {
        this.createElement(element, CE_ESTIMATED_COST, Double.toString(costEstimate.getEstimatedCost()));
        this.createElement(element, CE_ROW_COUNT, Long.toString(costEstimate.getEstimatedRowCount()));
        this.createElement(element, CE_SINGLE_SCAN_ROW_COUNT, Double.toString(costEstimate.singleScanRowCount()));
    }

    private void formatSelectivity(Element element, String string, int n2, double d2) {
        Element element2 = this.createElement(element, string, null);
        element2.setAttribute(SEL_COUNT, Integer.toString(n2));
        element2.setAttribute(SEL_SELECTIVITY, Double.toString(d2));
    }

    private void formatJoinOrder(Element element, int[] nArray) {
        if (nArray != null) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n2 = nArray[i2];
                if (n2 < 0) continue;
                Optimizable optimizable = this._currentQueryBlock.optimizableList.getOptimizable(n2);
                this.createElement(element, JO_SLOT, this.getOptimizableName(optimizable).getFullSQLName());
            }
        }
    }

    private String formatPlanSummary(int[] nArray, int n2) {
        try {
            int n3;
            Object object = null;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = n2 == 2;
            for (n3 = 0; n3 < nArray.length && nArray[n3] >= 0; ++n3) {
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                OptimizerPlan optimizerPlan;
                int n4 = nArray[i2];
                if (n4 >= this._currentQueryBlock.optimizableList.size()) {
                    stringBuilder.append("{ UNKNOWN LIST INDEX " + n4 + " } ");
                    continue;
                }
                Optimizable optimizable = this._currentQueryBlock.optimizableList.getOptimizable(n4);
                AccessPath accessPath = bl2 ? optimizable.getBestSortAvoidancePath() : optimizable.getBestAccessPath();
                JoinStrategy joinStrategy = accessPath.getJoinStrategy();
                ConglomerateDescriptor conglomerateDescriptor = OptimizerImpl.isTableFunction(optimizable) ? ((StaticMethodCallNode)((FromVTI)((ProjectRestrictNode)optimizable).getChildResult()).getMethodCall()).ad : accessPath.getConglomerateDescriptor();
                OptimizerPlan optimizerPlan2 = optimizerPlan = conglomerateDescriptor == null ? new OptimizerPlan.DeadEnd(this.getOptimizableName(optimizable).toString()) : OptimizerPlan.makeRowSource(conglomerateDescriptor, this._lcc.getDataDictionary());
                if (object != null) {
                    optimizerPlan = new OptimizerPlan.Join(joinStrategy, (OptimizerPlan)object, optimizerPlan);
                }
                object = optimizerPlan;
            }
            return object.toString();
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    public static final class QueryBlock {
        final int queryBlockID;
        final OptimizableList optimizableList;
        final Element queryBlockElement;
        Element currentJoinsElement;
        int[] currentJoinOrder;
        Element currentBestPlan;
        JoinStrategy currentDecorationStrategy;
        Element currentDecoration;

        public QueryBlock(int n2, OptimizableList optimizableList, Element element) {
            this.queryBlockID = n2;
            this.optimizableList = optimizableList;
            this.queryBlockElement = element;
        }
    }
}

