/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.ValueNode;

class VirtualColumnNode
extends ValueNode {
    private ResultSetNode sourceResultSet;
    private ResultColumn sourceColumn;
    int columnId;
    private boolean correlated = false;

    VirtualColumnNode(ResultSetNode resultSetNode, ResultColumn resultColumn, int n2, ContextManager contextManager) throws StandardException {
        super(contextManager);
        this.sourceResultSet = resultSetNode;
        this.sourceColumn = resultColumn;
        this.columnId = n2;
        this.setType(resultColumn.getTypeServices());
    }

    @Override
    void printSubNodes(int n2) {
    }

    ResultSetNode getSourceResultSet() {
        return this.sourceResultSet;
    }

    ResultColumn getSourceColumn() {
        return this.sourceColumn;
    }

    @Override
    String getTableName() {
        return this.sourceColumn.getTableName();
    }

    @Override
    String getSchemaName() throws StandardException {
        return this.sourceColumn.getSchemaName();
    }

    @Override
    public boolean updatableByCursor() {
        return this.sourceColumn.updatableByCursor();
    }

    @Override
    ResultColumn getSourceResultColumn() {
        return this.sourceColumn;
    }

    void setCorrelated() {
        this.correlated = true;
    }

    boolean getCorrelated() {
        return this.correlated;
    }

    @Override
    boolean isCloneable() {
        return true;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n2 = this.sourceColumn.getResultSetNumber();
        if (this.sourceColumn.isRedundant()) {
            this.sourceColumn.getExpression().generateExpression(expressionClassBuilder, methodBuilder);
            return;
        }
        expressionClassBuilder.pushColumnReference(methodBuilder, n2, this.sourceColumn.getVirtualColumnId());
        methodBuilder.cast(this.sourceColumn.getTypeCompiler().interfaceName());
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        return this.sourceColumn.getOrderableVariantType();
    }

    @Override
    public final DataTypeDescriptor getTypeServices() {
        return this.sourceColumn.getTypeServices();
    }

    @Override
    public final void setType(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        this.sourceColumn.setType(dataTypeDescriptor);
    }

    @Override
    boolean isEquivalent(ValueNode valueNode) throws StandardException {
        if (this.isSameNodeKind(valueNode)) {
            VirtualColumnNode virtualColumnNode = (VirtualColumnNode)valueNode;
            return this.sourceColumn.isEquivalent(virtualColumnNode.sourceColumn);
        }
        return false;
    }
}

