/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.DefaultVTIModDeferPolicy;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.vti.DeferModification;

class VTIDeferModPolicy
implements Visitor {
    private boolean deferred = false;
    private DeferModification deferralControl;
    private int statementType;
    private int tableNumber;
    private final HashSet<String> columns = new HashSet();

    public static boolean deferIt(int n2, FromVTI fromVTI, String[] stringArray, QueryTreeNode queryTreeNode) throws StandardException {
        try {
            Object object;
            int n3 = fromVTI.getResultSetType();
            if ((n2 == 2 || n2 == 3) && n3 == 1003) {
                return false;
            }
            DeferModification deferModification = fromVTI.getDeferralControl();
            if (deferModification == null) {
                object = fromVTI.getMethodCall().getJavaClassName();
                deferModification = new DefaultVTIModDeferPolicy((String)object, 1005 == n3);
            }
            if (deferModification.alwaysDefer(n2)) {
                return true;
            }
            if (queryTreeNode == null && n2 != 2) {
                return false;
            }
            object = new VTIDeferModPolicy(fromVTI, stringArray, deferModification, n2);
            if (queryTreeNode != null) {
                queryTreeNode.accept((Visitor)object);
            }
            if (n2 == 2) {
                for (String string : ((VTIDeferModPolicy)object).columns) {
                    if (!deferModification.columnRequiresDefer(n2, string, false)) continue;
                    return true;
                }
            }
            return ((VTIDeferModPolicy)object).deferred;
        }
        catch (SQLException sQLException) {
            throw StandardException.unexpectedUserException(sQLException);
        }
    }

    private VTIDeferModPolicy(FromVTI fromVTI, String[] stringArray, DeferModification deferModification, int n2) {
        this.deferralControl = deferModification;
        this.statementType = n2;
        this.tableNumber = fromVTI.getTableNumber();
        if (n2 == 2 && stringArray != null) {
            this.columns.addAll(Arrays.asList(stringArray));
        }
    }

    @Override
    public Visitable visit(Visitable visitable) throws StandardException {
        try {
            if (visitable instanceof ColumnReference && this.statementType != 1) {
                ColumnReference columnReference = (ColumnReference)visitable;
                if (columnReference.getTableNumber() == this.tableNumber) {
                    String string = columnReference.getColumnName();
                    if (this.statementType == 3) {
                        if (this.columns.add(string) && this.deferralControl.columnRequiresDefer(this.statementType, string, true)) {
                            this.deferred = true;
                        }
                    } else if (this.statementType == 2 && this.columns.remove(string) && this.deferralControl.columnRequiresDefer(this.statementType, string, true)) {
                        this.deferred = true;
                    }
                }
            } else if (visitable instanceof SelectNode) {
                SelectNode selectNode = (SelectNode)visitable;
                FromList fromList = selectNode.getFromList();
                for (int i2 = 0; i2 < fromList.size(); ++i2) {
                    Object object;
                    FromTable fromTable = (FromTable)fromList.elementAt(i2);
                    if (fromTable instanceof FromBaseTable) {
                        object = fromTable.getTableDescriptor();
                        if (!this.deferralControl.subselectRequiresDefer(this.statementType, ((TableDescriptor)object).getSchemaName(), ((TableDescriptor)object).getName())) continue;
                        this.deferred = true;
                        continue;
                    }
                    if (!(fromTable instanceof FromVTI) || !this.deferralControl.subselectRequiresDefer(this.statementType, ((FromVTI)(object = (FromVTI)fromTable)).getMethodCall().getJavaClassName())) continue;
                    this.deferred = true;
                }
            }
        }
        catch (SQLException sQLException) {
            throw StandardException.unexpectedUserException(sQLException);
        }
        return visitable;
    }

    @Override
    public boolean stopTraversal() {
        return this.deferred;
    }

    @Override
    public boolean skipChildren(Visitable visitable) {
        return false;
    }

    @Override
    public boolean visitChildrenFirst(Visitable visitable) {
        return false;
    }
}

