/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.derby.impl.sql.compile.CharStream;

public final class UCode_CharStream
implements CharStream {
    int charCnt;
    int[] charOffset;
    public static final boolean staticFlag = false;
    public int bufpos = -1;
    int bufsize;
    int available;
    int tokenBegin;
    private int[] bufline;
    private int[] bufcolumn;
    private int column = 0;
    private int line = 1;
    private boolean prevCharIsCR = false;
    private boolean prevCharIsLF = false;
    private Reader inputStream;
    private char[] nextCharBuf;
    private char[] buffer;
    private int maxNextCharInd = 0;
    private int nextCharInd = -1;
    private int inBuf = 0;

    private void ExpandBuff(boolean bl2) {
        char[] cArray = new char[this.bufsize + 2048];
        int[] nArray = new int[this.bufsize + 2048];
        int[] nArray2 = new int[this.bufsize + 2048];
        int[] nArray3 = new int[this.bufsize + 2048];
        try {
            if (bl2) {
                System.arraycopy(this.buffer, this.tokenBegin, cArray, 0, this.bufsize - this.tokenBegin);
                System.arraycopy(this.buffer, 0, cArray, this.bufsize - this.tokenBegin, this.bufpos);
                this.buffer = cArray;
                System.arraycopy(this.bufline, this.tokenBegin, nArray, 0, this.bufsize - this.tokenBegin);
                System.arraycopy(this.bufline, 0, nArray, this.bufsize - this.tokenBegin, this.bufpos);
                this.bufline = nArray;
                System.arraycopy(this.bufcolumn, this.tokenBegin, nArray2, 0, this.bufsize - this.tokenBegin);
                System.arraycopy(this.bufcolumn, 0, nArray2, this.bufsize - this.tokenBegin, this.bufpos);
                this.bufcolumn = nArray2;
                System.arraycopy(this.charOffset, this.tokenBegin, nArray3, 0, this.bufsize - this.tokenBegin);
                System.arraycopy(this.charOffset, 0, nArray3, this.bufsize - this.tokenBegin, this.bufpos);
                this.charOffset = nArray3;
                this.bufpos += this.bufsize - this.tokenBegin;
            } else {
                System.arraycopy(this.buffer, this.tokenBegin, cArray, 0, this.bufsize - this.tokenBegin);
                this.buffer = cArray;
                System.arraycopy(this.bufline, this.tokenBegin, nArray, 0, this.bufsize - this.tokenBegin);
                this.bufline = nArray;
                System.arraycopy(this.bufcolumn, this.tokenBegin, nArray2, 0, this.bufsize - this.tokenBegin);
                this.bufcolumn = nArray2;
                System.arraycopy(this.charOffset, this.tokenBegin, nArray3, 0, this.bufsize - this.tokenBegin);
                this.charOffset = nArray3;
                this.bufpos -= this.tokenBegin;
            }
        }
        catch (Throwable throwable) {
            throw new Error(throwable.getMessage());
        }
        this.available = this.bufsize += 2048;
        this.tokenBegin = 0;
    }

    private void FillBuff() throws IOException {
        if (this.maxNextCharInd == this.nextCharBuf.length) {
            this.nextCharInd = 0;
            this.maxNextCharInd = 0;
        }
        try {
            int n2 = this.inputStream.read(this.nextCharBuf, this.maxNextCharInd, this.nextCharBuf.length - this.maxNextCharInd);
            if (n2 == -1) {
                this.inputStream.close();
                throw new IOException();
            }
            this.maxNextCharInd += n2;
        }
        catch (IOException iOException) {
            if (this.bufpos != 0) {
                --this.bufpos;
                this.backup(0);
            } else {
                this.bufline[this.bufpos] = this.line;
                this.bufcolumn[this.bufpos] = this.column;
            }
            if (this.tokenBegin == -1) {
                this.tokenBegin = this.bufpos;
            }
            throw iOException;
        }
    }

    private char ReadChar() throws IOException {
        if (++this.nextCharInd >= this.maxNextCharInd) {
            this.FillBuff();
        }
        return this.nextCharBuf[this.nextCharInd];
    }

    @Override
    public char BeginToken() throws IOException {
        if (this.inBuf > 0) {
            --this.inBuf;
            this.tokenBegin = this.bufpos == this.bufsize - 1 ? (this.bufpos = 0) : (this.bufpos = this.bufpos + 1);
            return this.buffer[this.tokenBegin];
        }
        this.tokenBegin = 0;
        this.bufpos = -1;
        char c2 = this.readChar();
        return c2;
    }

    private void UpdateLineColumn(char c2) {
        ++this.column;
        if (this.prevCharIsLF) {
            this.prevCharIsLF = false;
            this.column = 1;
            ++this.line;
        } else if (this.prevCharIsCR) {
            this.prevCharIsCR = false;
            if (c2 == '\n') {
                this.prevCharIsLF = true;
            } else {
                this.column = 1;
                ++this.line;
            }
        }
        switch (c2) {
            case '\r': {
                this.prevCharIsCR = true;
                break;
            }
            case '\n': {
                this.prevCharIsLF = true;
                break;
            }
            case '\t': {
                --this.column;
                this.column += 8 - (this.column & 7);
                break;
            }
        }
        this.bufline[this.bufpos] = this.line;
        this.bufcolumn[this.bufpos] = this.column;
    }

    @Override
    public final char readChar() throws IOException {
        if (this.inBuf > 0) {
            --this.inBuf;
            return this.buffer[this.bufpos == this.bufsize - 1 ? (this.bufpos = 0) : (this.bufpos = this.bufpos + 1)];
        }
        if (++this.bufpos == this.available) {
            if (this.available == this.bufsize) {
                if (this.tokenBegin > 2048) {
                    this.bufpos = 0;
                    this.available = this.tokenBegin;
                } else if (this.tokenBegin < 0) {
                    this.bufpos = 0;
                } else {
                    this.ExpandBuff(false);
                }
            } else if (this.available > this.tokenBegin) {
                this.available = this.bufsize;
            } else if (this.tokenBegin - this.available < 2048) {
                this.ExpandBuff(true);
            } else {
                this.available = this.tokenBegin;
            }
        }
        char c2 = this.ReadChar();
        this.UpdateLineColumn(c2);
        ++this.charCnt;
        this.buffer[this.bufpos] = c2;
        return this.buffer[this.bufpos];
    }

    @Override
    @Deprecated
    public final int getColumn() {
        return this.bufcolumn[this.bufpos];
    }

    @Override
    @Deprecated
    public final int getLine() {
        return this.bufline[this.bufpos];
    }

    @Override
    public final int getEndColumn() {
        return this.bufcolumn[this.bufpos];
    }

    @Override
    public final int getEndLine() {
        return this.bufline[this.bufpos];
    }

    @Override
    public final int getBeginColumn() {
        return this.bufcolumn[this.tokenBegin];
    }

    @Override
    public final int getBeginLine() {
        return this.bufline[this.tokenBegin];
    }

    @Override
    public final int getBeginOffset() {
        return this.charOffset[this.tokenBegin];
    }

    @Override
    public final int getEndOffset() {
        return this.charOffset[this.bufpos];
    }

    @Override
    public final void backup(int n2) {
        this.inBuf += n2;
        if ((this.bufpos -= n2) < 0) {
            this.bufpos += this.bufsize;
        }
    }

    public UCode_CharStream(Reader reader, int n2, int n3, int n4) {
        this.inputStream = reader;
        this.line = n2;
        this.column = n3 - 1;
        this.available = this.bufsize = n4;
        this.buffer = new char[n4];
        this.nextCharBuf = new char[n4];
        this.bufline = new int[n4];
        this.bufcolumn = new int[n4];
        this.charOffset = new int[n4];
    }

    public UCode_CharStream(Reader reader, int n2, int n3) {
        this(reader, n2, n3, 4096);
    }

    @Override
    public void ReInit(Reader reader, int n2, int n3, int n4) {
        this.inputStream = reader;
        this.line = n2;
        this.column = n3 - 1;
        if (this.buffer == null || n4 != this.buffer.length) {
            this.available = this.bufsize = n4;
            this.buffer = new char[n4];
            this.nextCharBuf = new char[n4];
            this.bufline = new int[n4];
            this.bufcolumn = new int[n4];
        }
        this.tokenBegin = 0;
        this.charCnt = 0;
        this.maxNextCharInd = 0;
        this.inBuf = 0;
        this.bufpos = -1;
        this.nextCharInd = -1;
    }

    @Override
    public void ReInit(Reader reader, int n2, int n3) {
        this.ReInit(reader, n2, n3, 4096);
    }

    public UCode_CharStream(InputStream inputStream, int n2, int n3, int n4) {
        this(new InputStreamReader(inputStream), n2, n3, 4096);
    }

    public UCode_CharStream(InputStream inputStream, int n2, int n3) {
        this(inputStream, n2, n3, 4096);
    }

    @Override
    public void ReInit(InputStream inputStream, int n2, int n3, int n4) {
        this.ReInit(new InputStreamReader(inputStream), n2, n3, 4096);
    }

    @Override
    public void ReInit(InputStream inputStream, int n2, int n3) {
        this.ReInit(inputStream, n2, n3, 4096);
    }

    @Override
    public final String GetImage() {
        if (this.bufpos >= this.tokenBegin) {
            return new String(this.buffer, this.tokenBegin, this.bufpos - this.tokenBegin + 1);
        }
        return new String(this.buffer, this.tokenBegin, this.bufsize - this.tokenBegin) + new String(this.buffer, 0, this.bufpos + 1);
    }

    @Override
    public final char[] GetSuffix(int n2) {
        char[] cArray = new char[n2];
        if (this.bufpos + 1 >= n2) {
            System.arraycopy(this.buffer, this.bufpos - n2 + 1, cArray, 0, n2);
        } else {
            System.arraycopy(this.buffer, this.bufsize - (n2 - this.bufpos - 1), cArray, 0, n2 - this.bufpos - 1);
            System.arraycopy(this.buffer, 0, cArray, n2 - this.bufpos - 1, this.bufpos + 1);
        }
        return cArray;
    }

    @Override
    public void Done() {
        this.nextCharBuf = null;
        this.buffer = null;
        this.bufline = null;
        this.bufcolumn = null;
        this.charOffset = null;
    }

    public void adjustBeginLineColumn(int n2, int n3) {
        int n4;
        int n5 = this.tokenBegin;
        int n6 = this.bufpos >= this.tokenBegin ? this.bufpos - this.tokenBegin + this.inBuf + 1 : this.bufsize - this.tokenBegin + this.bufpos + 1 + this.inBuf;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (n4 = 0; n4 < n6 && this.bufline[n7 = n5 % this.bufsize] == this.bufline[n8 = ++n5 % this.bufsize]; ++n4) {
            this.bufline[n7] = n2;
            int n10 = n9 + this.bufcolumn[n8] - this.bufcolumn[n7];
            this.bufcolumn[n7] = n3 + n9;
            n9 = n10;
        }
        if (n4 < n6) {
            this.bufline[n7] = n2++;
            this.bufcolumn[n7] = n3 + n9;
            while (n4++ < n6) {
                n7 = n5 % this.bufsize;
                if (this.bufline[n7] != this.bufline[++n5 % this.bufsize]) {
                    this.bufline[n7] = n2++;
                    continue;
                }
                this.bufline[n7] = n2;
            }
        }
        this.line = this.bufline[n7];
        this.column = this.bufcolumn[n7];
    }
}

