/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public class TimeTypeCompiler
extends BaseTypeCompiler {
    @Override
    public boolean convertible(TypeId typeId, boolean bl2) {
        if (typeId.isStringTypeId() && !typeId.isLOBTypeId() && !typeId.isLongVarcharTypeId()) {
            return true;
        }
        if (typeId.isTimestampId()) {
            return true;
        }
        return this.getStoredFormatIdFromTypeId() == typeId.getTypeFormatId();
    }

    @Override
    public boolean compatible(TypeId typeId) {
        return this.convertible(typeId, false);
    }

    @Override
    public boolean storable(TypeId typeId, ClassFactory classFactory) {
        int n2 = typeId.getJDBCTypeId();
        if (n2 == 92 || n2 == 1 || n2 == 12) {
            return true;
        }
        return classFactory.getClassInspector().assignableTo(typeId.getCorrespondingJavaTypeName(), "java.sql.Time");
    }

    @Override
    public String interfaceName() {
        return "org.apache.derby.iapi.types.DateTimeDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        return "java.sql.Time";
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dataTypeDescriptor) {
        return 8;
    }

    public double estimatedMemoryUsage(DataTypeDescriptor dataTypeDescriptor) {
        return 12.0;
    }

    @Override
    String nullMethodName() {
        return "getNullTime";
    }
}

