/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.execute.PrivilegeInfo;
import org.apache.derby.impl.sql.execute.TablePrivilegeInfo;

class TablePrivilegesNode
extends QueryTreeNode {
    private boolean[] actionAllowed = new boolean[6];
    private ResultColumnList[] columnLists = new ResultColumnList[6];
    private FormatableBitSet[] columnBitSets = new FormatableBitSet[6];
    private TableDescriptor td;
    private List<Provider> descriptorList;

    TablePrivilegesNode(ContextManager contextManager) {
        super(contextManager);
    }

    void addAll() {
        for (int i2 = 0; i2 < 6; ++i2) {
            this.actionAllowed[i2] = true;
            this.columnLists[i2] = null;
        }
    }

    void addAction(int n2, ResultColumnList resultColumnList) {
        this.actionAllowed[n2] = true;
        if (resultColumnList == null) {
            this.columnLists[n2] = null;
        } else if (this.columnLists[n2] == null) {
            this.columnLists[n2] = resultColumnList;
        } else {
            this.columnLists[n2].appendResultColumns(resultColumnList, false);
        }
    }

    void bind(TableDescriptor tableDescriptor, boolean bl2) throws StandardException {
        this.td = tableDescriptor;
        for (int i2 = 0; i2 < 6; ++i2) {
            if (this.columnLists[i2] != null) {
                this.columnBitSets[i2] = this.columnLists[i2].bindResultColumnsByName(tableDescriptor, null);
            }
            if (tableDescriptor.getTableType() != 2 || i2 == 0 || !this.actionAllowed[i2]) continue;
            throw StandardException.newException("42509", tableDescriptor.getQualifiedName());
        }
        if (bl2 && tableDescriptor.getTableType() == 2) {
            this.bindPrivilegesForView(tableDescriptor);
        }
    }

    PrivilegeInfo makePrivilegeInfo() {
        return new TablePrivilegeInfo(this.td, this.actionAllowed, this.columnBitSets, this.descriptorList);
    }

    private void bindPrivilegesForView(TableDescriptor tableDescriptor) throws StandardException {
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        ViewDescriptor viewDescriptor = dataDictionary.getViewDescriptor(tableDescriptor);
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        ProviderInfo[] providerInfoArray = dependencyManager.getPersistentProviderInfos(viewDescriptor);
        this.descriptorList = new ArrayList<Provider>();
        int n2 = providerInfoArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Provider provider = (Provider)providerInfoArray[i2].getDependableFinder().getDependable(dataDictionary, providerInfoArray[i2].getObjectId());
            if (!(provider instanceof TableDescriptor) && !(provider instanceof ViewDescriptor) && !(provider instanceof AliasDescriptor)) continue;
            this.descriptorList.add(provider);
        }
    }
}

