/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.HasCorrelatedCRsVisitor;
import org.apache.derby.impl.sql.compile.HasVariantValueNodeVisitor;
import org.apache.derby.impl.sql.compile.IsNullNode;
import org.apache.derby.impl.sql.compile.MaterializeSubqueryNode;
import org.apache.derby.impl.sql.compile.OrNode;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

class SubqueryNode
extends ValueNode {
    ResultSetNode resultSet;
    int subqueryType;
    boolean underTopAndNode;
    boolean preprocessed;
    boolean distinctExpression;
    boolean whereSubquery;
    ValueNode leftOperand;
    boolean pushedNewPredicate;
    boolean havingSubquery = false;
    BinaryComparisonOperatorNode parentComparisonOperator;
    private BooleanConstantNode trueNode;
    private int subqueryNumber = -1;
    private int pointOfAttachment = -1;
    private boolean foundCorrelation;
    private boolean doneCorrelationCheck;
    private boolean foundVariant;
    private boolean doneInvariantCheck;
    private OrderByList orderByList;
    private ValueNode offset;
    private ValueNode fetchFirst;
    private boolean hasJDBClimitClause;
    static final int NOTIMPLEMENTED_SUBQUERY = -1;
    static final int FROM_SUBQUERY = 0;
    static final int IN_SUBQUERY = 1;
    static final int NOT_IN_SUBQUERY = 2;
    static final int EQ_ANY_SUBQUERY = 3;
    static final int EQ_ALL_SUBQUERY = 4;
    static final int NE_ANY_SUBQUERY = 5;
    static final int NE_ALL_SUBQUERY = 6;
    static final int GT_ANY_SUBQUERY = 7;
    static final int GT_ALL_SUBQUERY = 8;
    static final int GE_ANY_SUBQUERY = 9;
    static final int GE_ALL_SUBQUERY = 10;
    static final int LT_ANY_SUBQUERY = 11;
    static final int LT_ALL_SUBQUERY = 12;
    static final int LE_ANY_SUBQUERY = 13;
    static final int LE_ALL_SUBQUERY = 14;
    static final int EXISTS_SUBQUERY = 15;
    static final int NOT_EXISTS_SUBQUERY = 16;
    static final int EXPRESSION_SUBQUERY = 17;

    SubqueryNode(ResultSetNode resultSetNode, int n2, ValueNode valueNode, OrderByList orderByList, ValueNode valueNode2, ValueNode valueNode3, boolean bl2, ContextManager contextManager) {
        super(contextManager);
        this.resultSet = resultSetNode;
        this.subqueryType = n2;
        this.orderByList = orderByList;
        this.offset = valueNode2;
        this.fetchFirst = valueNode3;
        this.hasJDBClimitClause = bl2;
        this.underTopAndNode = false;
        this.leftOperand = valueNode;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    void printSubNodes(int n2) {
    }

    ResultSetNode getResultSet() {
        return this.resultSet;
    }

    int getSubqueryType() {
        return this.subqueryType;
    }

    void setSubqueryType(int n2) {
        this.subqueryType = n2;
    }

    void setPointOfAttachment(int n2) throws StandardException {
        if (!this.isMaterializable()) {
            this.pointOfAttachment = n2;
        }
    }

    boolean getUnderTopAndNode() {
        return this.underTopAndNode;
    }

    int getPointOfAttachment() {
        return this.pointOfAttachment;
    }

    boolean getPreprocessed() {
        return this.preprocessed;
    }

    void setParentComparisonOperator(BinaryComparisonOperatorNode binaryComparisonOperatorNode) {
        this.parentComparisonOperator = binaryComparisonOperatorNode;
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.resultSet.referencesSessionSchema();
    }

    @Override
    ValueNode remapColumnReferencesToExpressions() throws StandardException {
        if (this.resultSet instanceof SelectNode) {
            ResultColumnList resultColumnList = this.resultSet.getResultColumns();
            SelectNode selectNode = (SelectNode)this.resultSet;
            PredicateList predicateList = selectNode.getWherePredicates();
            resultColumnList.remapColumnReferencesToExpressions();
            predicateList.remapColumnReferencesToExpressions();
        }
        return this;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        this.checkReliability(32, "42Z91");
        ResultColumnList resultColumnList = this.resultSet.getResultColumns();
        if (this.subqueryType != 15 && resultColumnList.visibleSize() != 1) {
            throw StandardException.newException("42X39", new Object[0]);
        }
        this.resultSet.verifySelectStarSubquery(fromList, this.subqueryType);
        if (this.subqueryType == 15) {
            this.resultSet = this.resultSet.setResultToBooleanTrueNode(true);
        }
        CompilerContext compilerContext = this.getCompilerContext();
        compilerContext.pushCurrentPrivType(0);
        this.resultSet = this.resultSet.bindNonVTITables(this.getDataDictionary(), fromList);
        this.resultSet = this.resultSet.bindVTITables(fromList);
        if (this.subqueryNumber == -1) {
            this.subqueryNumber = compilerContext.getNextSubqueryNumber();
        }
        this.resultSet.rejectParameters();
        if (this.subqueryType == 15) {
            this.resultSet.bindTargetExpressions(fromList);
            this.resultSet.bindUntypedNullsToResultColumns(null);
            this.resultSet = this.resultSet.setResultToBooleanTrueNode(false);
        }
        if (this.leftOperand != null) {
            this.leftOperand = this.leftOperand.bindExpression(fromList, subqueryList, list);
        }
        if (this.orderByList != null) {
            this.orderByList.pullUpOrderByColumns(this.resultSet);
        }
        this.resultSet.bindExpressions(fromList);
        this.resultSet.bindResultColumns(fromList);
        if (this.orderByList != null) {
            this.orderByList.bindOrderByColumns(this.resultSet);
        }
        SubqueryNode.bindOffsetFetch(this.offset, this.fetchFirst);
        this.resultSet.bindUntypedNullsToResultColumns(null);
        resultColumnList = this.resultSet.getResultColumns();
        if (this.leftOperand != null && this.leftOperand.requiresTypeFromContext()) {
            this.leftOperand.setType(((ResultColumn)resultColumnList.elementAt(0)).getTypeServices());
        }
        this.setDataTypeServices(resultColumnList);
        subqueryList.addSubqueryNode(this);
        compilerContext.popCurrentPrivType();
        return this;
    }

    @Override
    ValueNode preprocess(int n2, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        SelectNode selectNode;
        boolean bl2;
        boolean bl3;
        if (this.preprocessed) {
            return this;
        }
        this.preprocessed = true;
        ValueNode valueNode = this;
        if (this.orderByList != null) {
            bl3 = true;
            if (this.orderByList.size() > 1) {
                this.orderByList.removeDupColumns();
            }
            this.resultSet.pushOrderByList(this.orderByList);
            this.orderByList = null;
        } else {
            bl3 = false;
        }
        this.resultSet = this.resultSet.preprocess(n2, null, null);
        if (this.leftOperand != null) {
            this.leftOperand = this.leftOperand.preprocess(n2, fromList, subqueryList, predicateList);
        }
        if (this.resultSet instanceof SelectNode && ((SelectNode)this.resultSet).hasDistinct()) {
            ((SelectNode)this.resultSet).clearDistinct();
            if (this.subqueryType == 17) {
                this.distinctExpression = true;
            }
        }
        if ((this.isIN() || this.isANY()) && this.resultSet.returnsAtMostOneRow() && !this.hasCorrelatedCRs()) {
            this.changeToCorrespondingExpressionType();
        }
        boolean bl4 = bl2 = this.resultSet instanceof RowResultSetNode && this.underTopAndNode && !this.havingSubquery && !bl3 && this.offset == null && this.fetchFirst == null && !this.isWhereExistsAnyInWithWhereSubquery() && this.parentComparisonOperator != null;
        if (bl2) {
            this.leftOperand = this.parentComparisonOperator.getLeftOperand();
            RowResultSetNode rowResultSetNode = (RowResultSetNode)this.resultSet;
            FromList fromList2 = new FromList(this.getContextManager());
            subqueryList.removeElement(this);
            if (rowResultSetNode.subquerys.size() != 0) {
                fromList2.addElement(rowResultSetNode);
                fromList.destructiveAppend(fromList2);
            }
            subqueryList.destructiveAppend(rowResultSetNode.subquerys);
            return this.getNewJoinCondition(this.leftOperand, this.getRightOperand());
        }
        boolean bl5 = this.isNOT_EXISTS() || this.canAllBeFlattened();
        boolean bl6 = bl2 = this.resultSet instanceof SelectNode && !((SelectNode)this.resultSet).hasWindows() && !bl3 && this.offset == null && this.fetchFirst == null && this.underTopAndNode && !this.havingSubquery && !this.isWhereExistsAnyInWithWhereSubquery() && (this.isIN() || this.isANY() || this.isEXISTS() || bl5 || this.parentComparisonOperator != null);
        if (bl2 && !(selectNode = (SelectNode)this.resultSet).hasAggregatesInSelectList() && selectNode.havingClause == null) {
            FromBaseTable fromBaseTable;
            ValueNode valueNode2 = this.leftOperand;
            boolean bl7 = this.subqueryType == 1 || this.subqueryType == 3;
            boolean bl8 = bl7 = bl7 && (this.leftOperand instanceof ConstantNode || this.leftOperand instanceof ColumnReference || this.leftOperand.requiresTypeFromContext());
            if (this.parentComparisonOperator != null) {
                this.leftOperand = this.parentComparisonOperator.getLeftOperand();
            }
            if (!bl5 && selectNode.uniqueSubquery(bl7)) {
                return this.flattenToNormalJoin(n2, fromList, subqueryList, predicateList);
            }
            if ((this.isIN() || this.isANY() || this.isEXISTS() || bl5) && (this.leftOperand == null || this.leftOperand.categorize(new JBitSet(n2), false)) && selectNode.getWherePredicates().allPushable() && (fromBaseTable = this.singleFromBaseTable(selectNode.getFromList())) != null && (!bl5 || selectNode.getWherePredicates().allReference(fromBaseTable) && this.rightOperandFlattenableToNotExists(n2, fromBaseTable))) {
                return this.flattenToExistsJoin(n2, fromList, subqueryList, predicateList, bl5);
            }
            this.leftOperand = valueNode2;
        }
        this.resultSet.pushQueryExpressionSuffix();
        this.resultSet.pushOffsetFetchFirst(this.offset, this.fetchFirst, this.hasJDBClimitClause);
        if (this.leftOperand != null) {
            valueNode = this.pushNewPredicate(n2);
            this.pushedNewPredicate = true;
        } else if (this.isEXISTS() || this.isNOT_EXISTS()) {
            valueNode = this.genIsNullTree(this.isEXISTS());
            this.subqueryType = 15;
        }
        this.isInvariant();
        this.hasCorrelatedCRs();
        if (this.parentComparisonOperator != null) {
            this.parentComparisonOperator.setRightOperand(valueNode);
            return this.parentComparisonOperator;
        }
        return valueNode;
    }

    private FromBaseTable singleFromBaseTable(FromList fromList) {
        FromBaseTable fromBaseTable = null;
        if (fromList.size() == 1) {
            ResultSetNode resultSetNode;
            FromTable fromTable = (FromTable)fromList.elementAt(0);
            if (fromTable instanceof FromBaseTable) {
                fromBaseTable = (FromBaseTable)fromTable;
            } else if (fromTable instanceof ProjectRestrictNode && (resultSetNode = ((ProjectRestrictNode)fromTable).getChildResult()) instanceof FromBaseTable) {
                fromBaseTable = (FromBaseTable)resultSetNode;
            }
        }
        return fromBaseTable;
    }

    private boolean rightOperandFlattenableToNotExists(int n2, FromBaseTable fromBaseTable) throws StandardException {
        boolean bl2 = true;
        if (this.leftOperand != null) {
            JBitSet jBitSet = new JBitSet(n2);
            this.getRightOperand().categorize(jBitSet, false);
            bl2 = jBitSet.get(fromBaseTable.getTableNumber());
        }
        return bl2;
    }

    private boolean canAllBeFlattened() throws StandardException {
        boolean bl2 = false;
        if (this.isNOT_IN() || this.isALL()) {
            bl2 = !this.leftOperand.getTypeServices().isNullable() && !this.getRightOperand().getTypeServices().isNullable();
        }
        return bl2;
    }

    private ValueNode flattenToNormalJoin(int n2, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        SelectNode selectNode = (SelectNode)this.resultSet;
        FromList fromList2 = selectNode.getFromList();
        int[] nArray = fromList2.getTableNumbers();
        subqueryList.removeElement(this);
        selectNode.decrementLevel(1);
        fromList.destructiveAppend(fromList2);
        predicateList.destructiveAppend(selectNode.getWherePredicates());
        subqueryList.destructiveAppend(selectNode.getWhereSubquerys());
        subqueryList.destructiveAppend(selectNode.getSelectSubquerys());
        if (this.leftOperand == null) {
            return new BooleanConstantNode(true, this.getContextManager());
        }
        ValueNode valueNode = this.getRightOperand();
        if (valueNode instanceof ColumnReference) {
            ColumnReference columnReference = (ColumnReference)valueNode;
            int n3 = columnReference.getTableNumber();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (n3 != nArray[i2]) continue;
                columnReference.setSourceLevel(columnReference.getSourceLevel() - 1);
                break;
            }
        }
        return this.getNewJoinCondition(this.leftOperand, valueNode);
    }

    private ValueNode flattenToExistsJoin(int n2, FromList fromList, SubqueryList subqueryList, PredicateList predicateList, boolean bl2) throws StandardException {
        SelectNode selectNode = (SelectNode)this.resultSet;
        selectNode.getFromList().genExistsBaseTables(this.resultSet.getReferencedTableMap(), fromList, bl2);
        return this.flattenToNormalJoin(n2, fromList, subqueryList, predicateList);
    }

    private ValueNode getRightOperand() {
        ResultColumn resultColumn = (ResultColumn)this.resultSet.getResultColumns().elementAt(0);
        return resultColumn.getExpression();
    }

    private boolean isInvariant() throws StandardException {
        if (this.doneInvariantCheck) {
            return !this.foundVariant;
        }
        this.doneInvariantCheck = true;
        HasVariantValueNodeVisitor hasVariantValueNodeVisitor = new HasVariantValueNodeVisitor();
        this.resultSet.accept(hasVariantValueNodeVisitor);
        this.foundVariant = hasVariantValueNodeVisitor.hasVariant();
        return !this.foundVariant;
    }

    boolean hasCorrelatedCRs() throws StandardException {
        Object object;
        if (this.doneCorrelationCheck) {
            return this.foundCorrelation;
        }
        this.doneCorrelationCheck = true;
        ResultSetNode resultSetNode = this.resultSet;
        ResultColumnList resultColumnList = null;
        if (this.pushedNewPredicate && (resultColumnList = (resultSetNode = ((ProjectRestrictNode)this.resultSet).getChildResult()).getResultColumns()).size() > 1) {
            object = new ResultColumnList(this.getContextManager());
            ((ResultColumnList)object).addResultColumn(resultColumnList.getResultColumn(1));
            resultSetNode.setResultColumns((ResultColumnList)object);
        }
        object = new HasCorrelatedCRsVisitor();
        resultSetNode.accept((Visitor)object);
        this.foundCorrelation = ((HasCorrelatedCRsVisitor)object).hasCorrelatedCRs();
        if (this.pushedNewPredicate && resultColumnList.size() > 1) {
            resultSetNode.setResultColumns(resultColumnList);
        }
        return this.foundCorrelation;
    }

    private UnaryComparisonOperatorNode pushNewPredicate(int n2) throws StandardException {
        BinaryComparisonOperatorNode binaryComparisonOperatorNode;
        UnaryComparisonOperatorNode unaryComparisonOperatorNode = null;
        ContextManager contextManager = this.getContextManager();
        this.resultSet = this.resultSet.ensurePredicateList(n2);
        ResultColumnList resultColumnList = this.resultSet.getResultColumns();
        ResultColumnList resultColumnList2 = resultColumnList.copyListAndObjects();
        resultColumnList2.genVirtualColumnNodes(this.resultSet, resultColumnList);
        this.resultSet = new ProjectRestrictNode(this.resultSet, resultColumnList2, null, null, null, null, null, contextManager);
        resultColumnList = resultColumnList2;
        ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(0);
        ValueNode valueNode = resultColumn.getExpression();
        BinaryOperatorNode binaryOperatorNode = binaryComparisonOperatorNode = this.getNewJoinCondition(this.leftOperand, valueNode);
        if (this.isNOT_IN() || this.isALL()) {
            boolean bl2 = this.leftOperand.getTypeServices().isNullable();
            boolean bl3 = valueNode.getTypeServices().isNullable();
            if (bl2 || bl3) {
                IsNullNode isNullNode;
                BooleanConstantNode booleanConstantNode = new BooleanConstantNode(false, contextManager);
                OrNode orNode = new OrNode(binaryComparisonOperatorNode, booleanConstantNode, contextManager);
                orNode.postBindFixup();
                binaryOperatorNode = orNode;
                if (bl2) {
                    isNullNode = new IsNullNode(this.leftOperand, false, contextManager);
                    isNullNode.bindComparisonOperator();
                    orNode = new OrNode(isNullNode, binaryOperatorNode, contextManager);
                    orNode.postBindFixup();
                    binaryOperatorNode = orNode;
                }
                if (bl3) {
                    isNullNode = new IsNullNode(valueNode, false, contextManager);
                    isNullNode.bindComparisonOperator();
                    orNode = new OrNode(isNullNode, binaryOperatorNode, contextManager);
                    orNode.postBindFixup();
                    binaryOperatorNode = orNode;
                }
            }
        }
        AndNode andNode = new AndNode(binaryOperatorNode, this.getTrueNode(), contextManager);
        JBitSet jBitSet = new JBitSet(n2);
        andNode.postBindFixup();
        Predicate predicate = new Predicate(andNode, jBitSet, contextManager);
        predicate.categorize();
        this.resultSet = this.resultSet.addNewPredicate(predicate);
        this.leftOperand = null;
        resultColumn.setType(this.getTypeServices());
        resultColumn.setExpression(this.getTrueNode());
        switch (this.subqueryType) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                unaryComparisonOperatorNode = new IsNullNode(this, true, contextManager);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                unaryComparisonOperatorNode = new IsNullNode(this, false, contextManager);
                break;
            }
        }
        unaryComparisonOperatorNode.bindComparisonOperator();
        return unaryComparisonOperatorNode;
    }

    private BinaryComparisonOperatorNode getNewJoinCondition(ValueNode valueNode, ValueNode valueNode2) throws StandardException {
        int n2;
        int n3 = this.subqueryType;
        if (this.subqueryType == 17) {
            n2 = -1;
            if (this.parentComparisonOperator.isRelationalOperator()) {
                RelationalOperator relationalOperator = (RelationalOperator)((Object)this.parentComparisonOperator);
                n2 = relationalOperator.getOperator();
            }
            if (n2 == 1) {
                n3 = 3;
            } else if (n2 == 2) {
                n3 = 5;
            } else if (n2 == 6) {
                n3 = 13;
            } else if (n2 == 5) {
                n3 = 11;
            } else if (n2 == 4) {
                n3 = 9;
            } else if (n2 == 3) {
                n3 = 7;
            }
        }
        n2 = 0;
        int n4 = -1;
        switch (n3) {
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                n4 = 0;
                break;
            }
            case 4: 
            case 5: {
                n4 = 5;
                break;
            }
            case 8: 
            case 13: {
                n4 = 3;
                break;
            }
            case 10: 
            case 11: {
                n4 = 4;
                break;
            }
            case 9: 
            case 12: {
                n4 = 1;
                break;
            }
            case 7: 
            case 14: {
                n4 = 2;
                break;
            }
        }
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = new BinaryRelationalOperatorNode(n4, valueNode, valueNode2, false, this.getContextManager());
        binaryRelationalOperatorNode.bindComparisonOperator();
        return binaryRelationalOperatorNode;
    }

    @Override
    ValueNode eliminateNots(boolean bl2) throws StandardException {
        ValueNode valueNode = this;
        if (bl2) {
            switch (this.subqueryType) {
                case 17: {
                    valueNode = this.genEqualsFalseTree();
                    break;
                }
                case 15: {
                    this.subqueryType = 16;
                    break;
                }
                case 1: 
                case 3: {
                    this.subqueryType = 2;
                    break;
                }
                case 5: {
                    this.subqueryType = 4;
                    break;
                }
                case 9: {
                    this.subqueryType = 12;
                    break;
                }
                case 7: {
                    this.subqueryType = 14;
                    break;
                }
                case 13: {
                    this.subqueryType = 8;
                    break;
                }
                case 11: {
                    this.subqueryType = 10;
                    break;
                }
                case 4: {
                    this.subqueryType = 5;
                    break;
                }
                case 6: {
                    this.subqueryType = 3;
                    break;
                }
                case 10: {
                    this.subqueryType = 11;
                    break;
                }
                case 8: {
                    this.subqueryType = 13;
                    break;
                }
                case 14: {
                    this.subqueryType = 7;
                    break;
                }
                case 12: {
                    this.subqueryType = 9;
                    break;
                }
            }
        }
        return valueNode;
    }

    @Override
    ValueNode changeToCNF(boolean bl2) throws StandardException {
        this.underTopAndNode = bl2;
        return this;
    }

    @Override
    boolean categorize(JBitSet jBitSet, boolean bl2) throws StandardException {
        if (bl2) {
            return false;
        }
        return this.isMaterializable();
    }

    public boolean isMaterializable() throws StandardException {
        boolean bl2;
        boolean bl3 = bl2 = this.subqueryType == 17 && !this.hasCorrelatedCRs() && this.isInvariant();
        if (bl2 && this.resultSet instanceof SelectNode) {
            SelectNode selectNode = (SelectNode)this.resultSet;
            FromList fromList = selectNode.getFromList();
            fromList.setLevel(0);
        }
        return bl2;
    }

    void optimize(DataDictionary dataDictionary, double d2) throws StandardException {
        this.resultSet = this.resultSet.optimize(dataDictionary, null, d2);
    }

    void modifyAccessPaths() throws StandardException {
        this.resultSet = this.resultSet.modifyAccessPaths();
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        if (this.isInvariant()) {
            if (!this.hasCorrelatedCRs() && this.subqueryType == 17) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n2;
        CompilerContext compilerContext = this.getCompilerContext();
        ActivationClassBuilder activationClassBuilder = (ActivationClassBuilder)expressionClassBuilder;
        String string = this.subqueryType == 17 ? "getOnceResultSet" : "getAnyResultSet";
        CostEstimate costEstimate = this.resultSet.getFinalCostEstimate();
        String string2 = this.getTypeCompiler().interfaceName();
        MethodBuilder methodBuilder2 = activationClassBuilder.newGeneratedFun(string2, 4);
        LocalField localField = activationClassBuilder.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.NoPutResultSet");
        ResultSetNode resultSetNode = null;
        if (!this.isMaterializable()) {
            MethodBuilder methodBuilder3 = activationClassBuilder.getExecuteMethod();
            if (this.pushedNewPredicate && !this.hasCorrelatedCRs()) {
                resultSetNode = ((ProjectRestrictNode)this.resultSet).getChildResult();
                LocalField localField2 = activationClassBuilder.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.NoPutResultSet");
                methodBuilder2.getField(localField2);
                methodBuilder2.conditionalIfNull();
                MaterializeSubqueryNode materializeSubqueryNode = new MaterializeSubqueryNode(localField2, this.getContextManager());
                materializeSubqueryNode.setCostEstimate(this.resultSet.getFinalCostEstimate());
                ((ProjectRestrictNode)this.resultSet).setChildResult(materializeSubqueryNode);
                resultSetNode.generate(activationClassBuilder, methodBuilder2);
                methodBuilder2.startElseCode();
                methodBuilder2.getField(localField2);
                methodBuilder2.completeConditional();
                methodBuilder2.setField(localField2);
                methodBuilder3.pushNull("org.apache.derby.iapi.sql.execute.NoPutResultSet");
                methodBuilder3.setField(localField2);
            }
            methodBuilder3.pushNull("org.apache.derby.iapi.sql.execute.NoPutResultSet");
            methodBuilder3.setField(localField);
            methodBuilder2.getField(localField);
            methodBuilder2.conditionalIfNull();
        }
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder2);
        this.resultSet.generate(activationClassBuilder, methodBuilder2);
        int n3 = compilerContext.getNextResultSetNumber();
        this.resultSet.getResultColumns().setResultSetNumber(n3);
        this.resultSet.getResultColumns().generateNulls(activationClassBuilder, methodBuilder2);
        if (this.subqueryType == 17) {
            int n4 = this.distinctExpression ? 3 : (this.resultSet.returnsAtMostOneRow() ? 2 : 1);
            methodBuilder2.push(n4);
            n2 = 8;
        } else {
            n2 = 7;
        }
        methodBuilder2.push(n3);
        methodBuilder2.push(this.subqueryNumber);
        methodBuilder2.push(this.pointOfAttachment);
        methodBuilder2.push(costEstimate.rowCount());
        methodBuilder2.push(costEstimate.getEstimatedCost());
        methodBuilder2.callMethod((short)185, null, string, "org.apache.derby.iapi.sql.execute.NoPutResultSet", n2);
        if (!this.isMaterializable()) {
            if (this.pushedNewPredicate && !this.hasCorrelatedCRs()) {
                ((ProjectRestrictNode)this.resultSet).setChildResult(resultSetNode);
            }
            methodBuilder2.startElseCode();
            methodBuilder2.getField(localField);
            methodBuilder2.completeConditional();
        }
        methodBuilder2.setField(localField);
        methodBuilder2.getField(localField);
        methodBuilder2.callMethod((short)185, null, "openCore", "void", 0);
        methodBuilder2.getField(localField);
        methodBuilder2.callMethod((short)185, null, "getNextRowCore", "org.apache.derby.iapi.sql.execute.ExecRow", 0);
        methodBuilder2.push(1);
        methodBuilder2.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "getColumn", "org.apache.derby.iapi.types.DataValueDescriptor", 1);
        methodBuilder2.cast(string2);
        if (this.isMaterializable()) {
            methodBuilder2.getField(localField);
            methodBuilder2.callMethod((short)185, "org.apache.derby.iapi.sql.ResultSet", "close", "void", 0);
        }
        methodBuilder2.methodReturn();
        methodBuilder2.complete();
        if (this.isMaterializable()) {
            LocalField localField3 = this.generateMaterialization(activationClassBuilder, methodBuilder2, string2);
            methodBuilder.getField(localField3);
        } else {
            methodBuilder.pushThis();
            methodBuilder.callMethod((short)182, null, methodBuilder2.getName(), string2, 0);
        }
    }

    private LocalField generateMaterialization(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder, String string) {
        MethodBuilder methodBuilder2 = activationClassBuilder.getExecuteMethod();
        LocalField localField = activationClassBuilder.newFieldDeclaration(2, string);
        methodBuilder2.pushThis();
        methodBuilder2.callMethod((short)182, null, methodBuilder.getName(), string, 0);
        methodBuilder2.setField(localField);
        return localField;
    }

    private BooleanConstantNode getTrueNode() throws StandardException {
        if (this.trueNode == null) {
            this.trueNode = new BooleanConstantNode(true, this.getContextManager());
        }
        return this.trueNode;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (visitor instanceof HasCorrelatedCRsVisitor && this.doneCorrelationCheck) {
            ((HasCorrelatedCRsVisitor)visitor).setHasCorrelatedCRs(this.foundCorrelation);
            return;
        }
        if (this.resultSet != null) {
            this.resultSet = (ResultSetNode)this.resultSet.accept(visitor);
        }
        if (this.leftOperand != null) {
            this.leftOperand = (ValueNode)this.leftOperand.accept(visitor);
        }
    }

    private boolean isIN() {
        return this.subqueryType == 1;
    }

    private boolean isNOT_IN() {
        return this.subqueryType == 2;
    }

    private boolean isANY() {
        switch (this.subqueryType) {
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    private boolean isALL() {
        switch (this.subqueryType) {
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    private boolean isEXISTS() {
        return this.subqueryType == 15;
    }

    private boolean isNOT_EXISTS() {
        return this.subqueryType == 16;
    }

    private void changeToCorrespondingExpressionType() throws StandardException {
        int n2 = -1;
        switch (this.subqueryType) {
            case 1: 
            case 3: {
                n2 = 0;
                break;
            }
            case 5: {
                n2 = 5;
                break;
            }
            case 13: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 4;
                break;
            }
            case 9: {
                n2 = 1;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = new BinaryRelationalOperatorNode(n2, this.leftOperand, this, false, this.getContextManager());
        this.subqueryType = 17;
        this.setDataTypeServices(this.resultSet.getResultColumns());
        this.parentComparisonOperator = binaryRelationalOperatorNode;
        this.parentComparisonOperator.bindComparisonOperator();
        this.leftOperand = null;
    }

    private void setDataTypeServices(ResultColumnList resultColumnList) throws StandardException {
        DataTypeDescriptor dataTypeDescriptor = this.subqueryType == 17 ? ((ResultColumn)resultColumnList.elementAt(0)).getTypeServices() : this.getTrueNode().getTypeServices();
        this.setType(dataTypeDescriptor.getNullabilityType(true));
    }

    @Override
    boolean isEquivalent(ValueNode valueNode) {
        return false;
    }

    public boolean isHavingSubquery() {
        return this.havingSubquery;
    }

    public void setHavingSubquery(boolean bl2) {
        this.havingSubquery = bl2;
    }

    boolean isWhereSubquery() {
        return this.whereSubquery;
    }

    void setWhereSubquery(boolean bl2) {
        this.whereSubquery = bl2;
    }

    boolean isWhereExistsAnyInWithWhereSubquery() throws StandardException {
        if (this.isWhereSubquery() && (this.isEXISTS() || this.isANY() || this.isIN())) {
            if (this.resultSet instanceof SelectNode) {
                SelectNode selectNode = (SelectNode)this.resultSet;
                if (selectNode.originalWhereClauseHadSubqueries) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public OrderByList getOrderByList() {
        return this.orderByList;
    }

    public ValueNode getOffset() {
        return this.offset;
    }

    public ValueNode getFetchFirst() {
        return this.fetchFirst;
    }

    public boolean hasJDBClimitClause() {
        return this.hasJDBClimitClause;
    }
}

