/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.BitConstantNode;
import org.apache.derby.impl.sql.compile.CharConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HasVariantValueNodeVisitor;
import org.apache.derby.impl.sql.compile.InsertNode;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.OrderByNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowCountNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

class RowResultSetNode
extends FromTable {
    SubqueryList subquerys;
    private List<AggregateNode> aggregates;
    ResultSetNode.QueryExpressionClauses qec = new ResultSetNode.QueryExpressionClauses();

    RowResultSetNode(ResultColumnList resultColumnList, Properties properties, ContextManager contextManager) {
        super(null, properties, contextManager);
        this.setResultColumns(resultColumnList);
        if (this.getResultColumns() != null) {
            this.getResultColumns().markInitialSize();
        }
    }

    String statementToString() {
        return "VALUES";
    }

    @Override
    void printSubNodes(int n2) {
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.subquerys != null && this.subquerys.referencesSessionSchema();
    }

    @Override
    ResultSetNode enhanceRCLForInsert(InsertNode insertNode, boolean bl2, int[] nArray) throws StandardException {
        if (!bl2 || this.getResultColumns().size() < insertNode.resultColumnList.size()) {
            this.setResultColumns(this.getRCLForInsert(insertNode, nArray));
        }
        return this;
    }

    @Override
    public CostEstimate estimateCost(OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        if (this.getCostEstimate() == null) {
            this.setCostEstimate(this.getOptimizerFactory().getCostEstimate());
        }
        this.getCostEstimate().setCost(0.0, 1.0, 1.0);
        rowOrdering.optimizableAlwaysOrdered(this);
        return this.getCostEstimate();
    }

    @Override
    ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromList) throws StandardException {
        if (this.tableNumber == -1) {
            this.tableNumber = this.getCompilerContext().getNextTableNumber();
        }
        return this;
    }

    @Override
    void bindExpressions(FromList fromList) throws StandardException {
        this.subquerys = new SubqueryList(this.getContextManager());
        this.aggregates = new ArrayList<AggregateNode>();
        this.getResultColumns().checkForInvalidDefaults();
        int n2 = fromList.size() == 0 ? 0 : ((FromTable)fromList.elementAt(0)).getLevel() + 1;
        this.setLevel(n2);
        fromList.insertElementAt(this, 0);
        this.getResultColumns().bindExpressions(fromList, this.subquerys, this.aggregates);
        fromList.removeElementAt(0);
        if (!this.aggregates.isEmpty()) {
            throw StandardException.newException("42903", new Object[0]);
        }
        SelectNode.checkNoWindowFunctions(this.getResultColumns(), "VALUES");
        for (int i2 = 0; i2 < this.qec.size(); ++i2) {
            OrderByList orderByList = this.qec.getOrderByList(i2);
            if (orderByList != null) {
                orderByList.pullUpOrderByColumns(this);
                orderByList.bindOrderByColumns(this);
            }
            RowResultSetNode.bindOffsetFetch(this.qec.getOffset(i2), this.qec.getFetchFirst(i2));
        }
    }

    @Override
    void bindExpressionsWithTables(FromList fromList) throws StandardException {
    }

    @Override
    void bindTargetExpressions(FromList fromList) throws StandardException {
        this.bindExpressions(fromList);
    }

    @Override
    void bindUntypedNullsToResultColumns(ResultColumnList resultColumnList) throws StandardException {
        if (resultColumnList == null) {
            resultColumnList = this.getResultColumns();
        }
        this.getResultColumns().bindUntypedNullsToResultColumns(resultColumnList);
    }

    @Override
    ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        return null;
    }

    @Override
    String getExposedName() throws StandardException {
        return null;
    }

    @Override
    void verifySelectStarSubquery(FromList fromList, int n2) throws StandardException {
    }

    @Override
    public void pushQueryExpressionSuffix() {
        this.qec.push();
    }

    @Override
    void pushOrderByList(OrderByList orderByList) {
        this.qec.setOrderByList(orderByList);
    }

    @Override
    void pushOffsetFetchFirst(ValueNode valueNode, ValueNode valueNode2, boolean bl2) {
        this.qec.setOffset(valueNode);
        this.qec.setFetchFirst(valueNode2);
        this.qec.setHasJDBCLimitClause(bl2);
    }

    @Override
    ResultSetNode preprocess(int n2, GroupByList groupByList, FromList fromList) throws StandardException {
        this.getResultColumns().preprocess(n2, fromList, this.subquerys, new PredicateList(this.getContextManager()));
        this.setReferencedTableMap(new JBitSet(n2));
        this.getReferencedTableMap().set(this.tableNumber);
        for (int i2 = 0; i2 < this.qec.size(); ++i2) {
            OrderByList orderByList = this.qec.getOrderByList(i2);
            if (orderByList == null || orderByList.size() <= 1) continue;
            orderByList.removeDupColumns();
        }
        return this;
    }

    @Override
    ResultSetNode ensurePredicateList(int n2) throws StandardException {
        return this.genProjectRestrict(n2);
    }

    @Override
    ResultSetNode addNewPredicate(Predicate predicate) throws StandardException {
        ResultColumnList resultColumnList = this.getResultColumns();
        this.setResultColumns(this.getResultColumns().copyListAndObjects());
        resultColumnList.genVirtualColumnNodes(this, this.getResultColumns());
        PredicateList predicateList = new PredicateList(this.getContextManager());
        predicateList.addPredicate(predicate);
        return new ProjectRestrictNode(this, resultColumnList, null, predicateList, null, null, this.tableProperties, this.getContextManager());
    }

    @Override
    boolean flattenableInFromSubquery(FromList fromList) {
        if (this.subquerys != null && this.subquerys.size() > 0) {
            return false;
        }
        if (this.aggregates != null && !this.aggregates.isEmpty()) {
            return false;
        }
        if (!this.getResultColumns().isCloneable()) {
            return false;
        }
        boolean bl2 = false;
        int n2 = fromList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            FromTable fromTable = (FromTable)fromList.elementAt(i2);
            if (fromTable instanceof FromSubquery) {
                ResultSetNode resultSetNode = ((FromSubquery)fromTable).getSubquery();
                if (resultSetNode instanceof RowResultSetNode) continue;
                bl2 = true;
                break;
            }
            bl2 = true;
            break;
        }
        return bl2;
    }

    @Override
    ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double d2) throws StandardException {
        this.setCostEstimate(this.getOptimizerFactory().getCostEstimate());
        this.getCostEstimate().setCost(0.0, d2, d2);
        this.subquerys.optimize(dataDictionary, d2);
        return this;
    }

    @Override
    public Optimizable modifyAccessPath(JBitSet jBitSet) throws StandardException {
        return (Optimizable)((Object)this.modifyAccessPaths());
    }

    @Override
    ResultSetNode modifyAccessPaths() throws StandardException {
        FromTable fromTable = this;
        this.subquerys.modifyAccessPaths();
        for (int i2 = 0; i2 < this.qec.size(); ++i2) {
            OrderByList orderByList = this.qec.getOrderByList(i2);
            if (orderByList != null) {
                fromTable = new OrderByNode(fromTable, orderByList, this.tableProperties, this.getContextManager());
            }
            ValueNode valueNode = this.qec.getOffset(i2);
            ValueNode valueNode2 = this.qec.getFetchFirst(i2);
            Boolean bl2 = this.qec.getHasJDBCLimitClause()[i2];
            if (valueNode == null && valueNode2 == null) continue;
            ResultColumnList resultColumnList = fromTable.getResultColumns().copyListAndObjects();
            resultColumnList.genVirtualColumnNodes(fromTable, fromTable.getResultColumns());
            fromTable = new RowCountNode(fromTable, resultColumnList, valueNode, valueNode2, bl2, this.getContextManager());
        }
        return fromTable;
    }

    @Override
    boolean returnsAtMostOneRow() {
        return true;
    }

    @Override
    void setTableConstructorTypes(ResultColumnList resultColumnList) throws StandardException {
        int n2 = this.getResultColumns().size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TypeId typeId;
            ResultColumn resultColumn;
            ResultColumn resultColumn2 = (ResultColumn)this.getResultColumns().elementAt(i2);
            ValueNode valueNode = resultColumn2.getExpression();
            if (valueNode.requiresTypeFromContext()) {
                resultColumn = (ResultColumn)resultColumnList.elementAt(i2);
                valueNode.setType(resultColumn.getTypeServices());
                continue;
            }
            if (valueNode instanceof CharConstantNode) {
                resultColumn = (ResultColumn)resultColumnList.elementAt(i2);
                typeId = resultColumn.getTypeId();
                if (typeId.isStringTypeId()) {
                    if (typeId.getJDBCTypeId() == 1) continue;
                    int n3 = valueNode.getTypeServices().getMaximumWidth();
                    valueNode.setType(new DataTypeDescriptor(typeId, true, n3));
                    continue;
                }
                if (!typeId.isBitTypeId()) continue;
                if (typeId.getJDBCTypeId() == -3) {
                    TypeId typeId2 = TypeId.getBuiltInTypeId(12);
                    valueNode.setType(new DataTypeDescriptor(typeId2, true));
                    resultColumnList.setElementAt(resultColumn, i2);
                    continue;
                }
                if (typeId.getJDBCTypeId() != -4) continue;
                TypeId typeId3 = TypeId.getBuiltInTypeId(-1);
                valueNode.setType(new DataTypeDescriptor(typeId3, true));
                resultColumnList.setElementAt(resultColumn, i2);
                continue;
            }
            if (!(valueNode instanceof BitConstantNode)) continue;
            resultColumn = (ResultColumn)resultColumnList.elementAt(i2);
            typeId = resultColumn.getTypeId();
            if (typeId.isBitTypeId()) {
                if (typeId.getJDBCTypeId() == -2 || typeId.getJDBCTypeId() == 2004) continue;
                int n4 = valueNode.getTypeServices().getMaximumWidth();
                valueNode.setType(new DataTypeDescriptor(typeId, true, n4));
                continue;
            }
            if (!typeId.isStringTypeId()) continue;
            if (typeId.getJDBCTypeId() == 12) {
                TypeId typeId4 = TypeId.getBuiltInTypeId(-3);
                valueNode.setType(new DataTypeDescriptor(typeId4, true));
                resultColumnList.setElementAt(resultColumn, i2);
                continue;
            }
            if (typeId.getJDBCTypeId() != -1) continue;
            TypeId typeId5 = TypeId.getBuiltInTypeId(-4);
            valueNode.setType(new DataTypeDescriptor(typeId5, true));
            resultColumnList.setElementAt(resultColumn, i2);
        }
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.setCostEstimate(this.getFinalCostEstimate());
        boolean bl2 = this.canWeCacheResults();
        this.assignResultSetNumber();
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        this.getResultColumns().generate(activationClassBuilder, methodBuilder);
        methodBuilder.push(bl2);
        methodBuilder.push(this.getResultSetNumber());
        methodBuilder.push(this.getCostEstimate().rowCount());
        methodBuilder.push(this.getCostEstimate().getEstimatedCost());
        methodBuilder.callMethod((short)185, null, "getRowResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 6);
    }

    @Override
    void replaceOrForbidDefaults(TableDescriptor tableDescriptor, ResultColumnList resultColumnList, boolean bl2) throws StandardException {
        this.getResultColumns().replaceOrForbidDefaults(tableDescriptor, resultColumnList, bl2);
    }

    @Override
    void optimizeSubqueries(DataDictionary dataDictionary, double d2) throws StandardException {
        this.subquerys.optimize(dataDictionary, d2);
    }

    @Override
    void adjustForSortElimination() {
    }

    private boolean canWeCacheResults() throws StandardException {
        HasVariantValueNodeVisitor hasVariantValueNodeVisitor = new HasVariantValueNodeVisitor(2, true);
        super.accept(hasVariantValueNodeVisitor);
        boolean bl2 = !hasVariantValueNodeVisitor.hasVariant();
        return bl2;
    }
}

