/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.ListIterator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.impl.sql.compile.ColumnOrdering;

class RowOrderingImpl
implements RowOrdering {
    private final ArrayList<ColumnOrdering> ordering = new ArrayList();
    ColumnOrdering columnsAlwaysOrdered;
    private final ArrayList<Optimizable> alwaysOrderedOptimizables = new ArrayList();
    ColumnOrdering currentColumnOrdering;
    private final ArrayList<Optimizable> unorderedOptimizables = new ArrayList();

    RowOrderingImpl() {
        this.columnsAlwaysOrdered = new ColumnOrdering(3);
    }

    @Override
    public boolean isColumnAlwaysOrdered(int n2, int n3) {
        return this.columnsAlwaysOrdered.contains(n2, n3);
    }

    @Override
    public boolean orderedOnColumn(int n2, int n3, int n4, int n5) throws StandardException {
        if (this.alwaysOrdered(n4)) {
            return true;
        }
        if (this.columnsAlwaysOrdered.contains(n4, n5)) {
            return true;
        }
        if (n3 >= this.ordering.size()) {
            return false;
        }
        ColumnOrdering columnOrdering = this.ordering.get(n3);
        return columnOrdering.ordered(n2, n4, n5);
    }

    @Override
    public boolean orderedOnColumn(int n2, int n3, int n4) throws StandardException {
        if (this.alwaysOrdered(n3)) {
            return true;
        }
        if (this.columnsAlwaysOrdered.contains(n3, n4)) {
            return true;
        }
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.ordering.size(); ++i2) {
            ColumnOrdering columnOrdering = this.ordering.get(i2);
            boolean bl3 = columnOrdering.ordered(n2, n3, n4);
            if (!bl3) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    @Override
    public void addOrderedColumn(int n2, int n3, int n4) {
        ColumnOrdering columnOrdering;
        if (!this.unorderedOptimizables.isEmpty()) {
            return;
        }
        if (this.ordering.isEmpty()) {
            columnOrdering = new ColumnOrdering(n2);
            this.ordering.add(columnOrdering);
        } else {
            columnOrdering = this.ordering.get(this.ordering.size() - 1);
        }
        columnOrdering.addColumn(n3, n4);
    }

    @Override
    public void nextOrderPosition(int n2) {
        if (!this.unorderedOptimizables.isEmpty()) {
            return;
        }
        this.currentColumnOrdering = new ColumnOrdering(n2);
        this.ordering.add(this.currentColumnOrdering);
    }

    @Override
    public void optimizableAlwaysOrdered(Optimizable optimizable) {
        int n2;
        if (this.unorderedOptimizablesOtherThan(optimizable)) {
            return;
        }
        boolean bl2 = optimizable.hasTableNumber();
        int n3 = n2 = bl2 ? optimizable.getTableNumber() : 0;
        if ((this.ordering.isEmpty() || bl2 && this.ordering.get(0).hasTable(n2)) && bl2 && !this.columnsAlwaysOrdered.hasAnyOtherTable(n2)) {
            if (optimizable.hasTableNumber()) {
                this.removeOptimizable(optimizable.getTableNumber());
            }
            this.alwaysOrderedOptimizables.add(optimizable);
        }
    }

    @Override
    public void columnAlwaysOrdered(Optimizable optimizable, int n2) {
        this.columnsAlwaysOrdered.addColumn(optimizable.getTableNumber(), n2);
    }

    @Override
    public boolean alwaysOrdered(int n2) {
        for (Optimizable optimizable : this.alwaysOrderedOptimizables) {
            if (!optimizable.hasTableNumber() || optimizable.getTableNumber() != n2) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeOptimizable(int n2) {
        for (int i2 = this.ordering.size() - 1; i2 >= 0; --i2) {
            ColumnOrdering columnOrdering = this.ordering.get(i2);
            columnOrdering.removeColumns(n2);
            if (!columnOrdering.empty()) continue;
            this.ordering.remove(i2);
        }
        this.columnsAlwaysOrdered.removeColumns(n2);
        this.removeOptimizable(n2, this.unorderedOptimizables);
        this.removeOptimizable(n2, this.alwaysOrderedOptimizables);
    }

    private void removeOptimizable(int n2, ArrayList<Optimizable> arrayList) {
        ListIterator<Optimizable> listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            Optimizable optimizable = listIterator.next();
            if (!optimizable.hasTableNumber() || optimizable.getTableNumber() != n2) continue;
            listIterator.remove();
        }
    }

    @Override
    public void addUnorderedOptimizable(Optimizable optimizable) {
        this.unorderedOptimizables.add(optimizable);
    }

    @Override
    public void copy(RowOrdering rowOrdering) {
        int n2;
        RowOrderingImpl rowOrderingImpl = (RowOrderingImpl)rowOrdering;
        rowOrderingImpl.ordering.clear();
        rowOrderingImpl.currentColumnOrdering = null;
        rowOrderingImpl.unorderedOptimizables.clear();
        for (n2 = 0; n2 < this.unorderedOptimizables.size(); ++n2) {
            rowOrderingImpl.unorderedOptimizables.add(this.unorderedOptimizables.get(n2));
        }
        rowOrderingImpl.alwaysOrderedOptimizables.clear();
        for (n2 = 0; n2 < this.alwaysOrderedOptimizables.size(); ++n2) {
            rowOrderingImpl.alwaysOrderedOptimizables.add(this.alwaysOrderedOptimizables.get(n2));
        }
        for (n2 = 0; n2 < this.ordering.size(); ++n2) {
            ColumnOrdering columnOrdering = this.ordering.get(n2);
            rowOrderingImpl.ordering.add(columnOrdering.cloneMe());
            if (columnOrdering != this.currentColumnOrdering) continue;
            rowOrderingImpl.rememberCurrentColumnOrdering(n2);
        }
        rowOrderingImpl.columnsAlwaysOrdered = null;
        if (this.columnsAlwaysOrdered != null) {
            rowOrderingImpl.columnsAlwaysOrdered = this.columnsAlwaysOrdered.cloneMe();
        }
    }

    private void rememberCurrentColumnOrdering(int n2) {
        this.currentColumnOrdering = this.ordering.get(n2);
    }

    public String toString() {
        String string = null;
        return string;
    }

    private boolean unorderedOptimizablesOtherThan(Optimizable optimizable) {
        for (int i2 = 0; i2 < this.unorderedOptimizables.size(); ++i2) {
            Optimizable optimizable2 = this.unorderedOptimizables.get(i2);
            if (optimizable2 == optimizable) continue;
            return true;
        }
        return false;
    }
}

