/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashMap;
import java.util.List;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.PrivilegedSQLObject;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.RoutineDesignator;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TablePrivilegesNode;
import org.apache.derby.impl.sql.execute.GenericPrivilegeInfo;
import org.apache.derby.impl.sql.execute.PrivilegeInfo;

class PrivilegeNode
extends QueryTreeNode {
    public static final int TABLE_PRIVILEGES = 0;
    public static final int ROUTINE_PRIVILEGES = 1;
    public static final int SEQUENCE_PRIVILEGES = 2;
    public static final int UDT_PRIVILEGES = 3;
    public static final int AGGREGATE_PRIVILEGES = 4;
    private int objectType;
    private TableName objectName;
    private TablePrivilegesNode specificPrivileges;
    private RoutineDesignator routineDesignator;
    private String privilege;
    private boolean restrict;
    private Provider dependencyProvider;

    PrivilegeNode(int n2, Object object, TablePrivilegesNode tablePrivilegesNode, ContextManager contextManager) throws StandardException {
        super(contextManager);
        this.objectType = n2;
        switch (this.objectType) {
            case 0: {
                this.objectName = (TableName)object;
                this.specificPrivileges = tablePrivilegesNode;
                break;
            }
            case 1: {
                this.routineDesignator = (RoutineDesignator)object;
                this.objectName = this.routineDesignator.name;
                break;
            }
            default: {
                throw this.unimplementedFeature();
            }
        }
    }

    PrivilegeNode(int n2, TableName tableName, String string, boolean bl2, ContextManager contextManager) {
        super(contextManager);
        this.objectType = n2;
        this.objectName = tableName;
        this.privilege = string;
        this.restrict = bl2;
    }

    public QueryTreeNode bind(HashMap<Provider, Provider> hashMap, List<String> list, boolean bl2) throws StandardException {
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(this.objectName.getSchemaName(), true);
        this.objectName.setSchemaName(schemaDescriptor.getSchemaName());
        if (list.contains(schemaDescriptor.getAuthorizationId())) {
            throw StandardException.newException("42509", this.objectName.getFullTableName());
        }
        switch (this.objectType) {
            case 0: {
                if (schemaDescriptor.isSystemSchema()) {
                    throw StandardException.newException("42509", this.objectName.getFullTableName());
                }
                TableDescriptor tableDescriptor = this.getTableDescriptor(this.objectName.getTableName(), schemaDescriptor);
                if (tableDescriptor == null) {
                    throw StandardException.newException("42X05", this.objectName);
                }
                if (PrivilegeNode.isSessionSchema(schemaDescriptor.getSchemaName())) {
                    throw StandardException.newException("XCL51.S", new Object[0]);
                }
                if (tableDescriptor.getTableType() != 0 && tableDescriptor.getTableType() != 2) {
                    throw StandardException.newException("42509", this.objectName.getFullTableName());
                }
                this.specificPrivileges.bind(tableDescriptor, bl2);
                this.dependencyProvider = tableDescriptor;
                break;
            }
            case 1: {
                if (!schemaDescriptor.isSchemaWithGrantableRoutines()) {
                    throw StandardException.newException("42509", this.objectName.getFullTableName());
                }
                AliasDescriptor aliasDescriptor = null;
                List<AliasDescriptor> list2 = this.getDataDictionary().getRoutineList(schemaDescriptor.getUUID().toString(), this.objectName.getTableName(), this.routineDesignator.isFunction ? (char)'F' : 'P');
                if (this.routineDesignator.paramTypeList == null) {
                    if (list2.size() > 1) {
                        throw StandardException.newException(this.routineDesignator.isFunction ? "42X46" : "42X47", this.objectName.getFullTableName());
                    }
                    if (list2.size() != 1) {
                        if (this.routineDesignator.isFunction) {
                            throw StandardException.newException("42Y03.S.2", this.objectName.getFullTableName());
                        }
                        throw StandardException.newException("42Y03.S.1", this.objectName.getFullTableName());
                    }
                    aliasDescriptor = list2.get(0);
                } else {
                    boolean bl3 = false;
                    block7: for (int i2 = list2.size() - 1; !bl3 && i2 >= 0; --i2) {
                        aliasDescriptor = list2.get(i2);
                        RoutineAliasInfo routineAliasInfo = (RoutineAliasInfo)aliasDescriptor.getAliasInfo();
                        int n2 = routineAliasInfo.getParameterCount();
                        if (n2 != this.routineDesignator.paramTypeList.size()) continue;
                        TypeDescriptor[] typeDescriptorArray = routineAliasInfo.getParameterTypes();
                        bl3 = true;
                        for (int i3 = 0; i3 < n2; ++i3) {
                            if (typeDescriptorArray[i3].equals(this.routineDesignator.paramTypeList.get(i3))) continue;
                            bl3 = false;
                            continue block7;
                        }
                    }
                    if (!bl3) {
                        StringBuilder stringBuilder = new StringBuilder(this.objectName.getFullTableName());
                        stringBuilder.append("(");
                        for (int i4 = 0; i4 < this.routineDesignator.paramTypeList.size(); ++i4) {
                            if (i4 > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(this.routineDesignator.paramTypeList.get(i4).toString());
                        }
                        throw StandardException.newException("42Y03.S.0", stringBuilder.toString());
                    }
                }
                this.routineDesignator.setAliasDescriptor(aliasDescriptor);
                this.dependencyProvider = aliasDescriptor;
                break;
            }
            case 4: {
                this.dependencyProvider = this.getDataDictionary().getAliasDescriptor(schemaDescriptor.getUUID().toString(), this.objectName.getTableName(), 'G');
                if (this.dependencyProvider != null) break;
                throw StandardException.newException("42X94", "DERBY AGGREGATE", this.objectName.getFullTableName());
            }
            case 2: {
                this.dependencyProvider = this.getDataDictionary().getSequenceDescriptor(schemaDescriptor, this.objectName.getTableName());
                if (this.dependencyProvider != null) break;
                throw StandardException.newException("42X94", "SEQUENCE", this.objectName.getFullTableName());
            }
            case 3: {
                this.dependencyProvider = this.getDataDictionary().getAliasDescriptor(schemaDescriptor.getUUID().toString(), this.objectName.getTableName(), 'A');
                if (this.dependencyProvider != null) break;
                throw StandardException.newException("42X94", "TYPE", this.objectName.getFullTableName());
            }
            default: {
                throw this.unimplementedFeature();
            }
        }
        if (this.dependencyProvider != null && hashMap.get(this.dependencyProvider) == null) {
            this.getCompilerContext().createDependency(this.dependencyProvider);
            hashMap.put(this.dependencyProvider, this.dependencyProvider);
        }
        return this;
    }

    PrivilegeInfo makePrivilegeInfo() throws StandardException {
        switch (this.objectType) {
            case 0: {
                return this.specificPrivileges.makePrivilegeInfo();
            }
            case 1: {
                return this.routineDesignator.makePrivilegeInfo();
            }
            case 2: 
            case 3: 
            case 4: {
                return new GenericPrivilegeInfo((PrivilegedSQLObject)this.dependencyProvider, this.privilege, this.restrict);
            }
        }
        throw this.unimplementedFeature();
    }

    private StandardException unimplementedFeature() {
        return StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.objectName != null) {
            this.objectName = (TableName)this.objectName.accept(visitor);
        }
    }
}

