/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.ExpressionClassBuilderInterface;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.InListOperatorNode;
import org.apache.derby.impl.sql.compile.OperatorNode;
import org.apache.derby.impl.sql.compile.OrNode;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.RemapCRsVisitor;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.UnaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

class PredicateList
extends QueryTreeNodeVector<Predicate>
implements OptimizablePredicateList {
    private int numberOfStartPredicates;
    private int numberOfStopPredicates;
    private int numberOfQualifiers;
    private static final int QUALIFIER_ORDER_EQUALS = 0;
    private static final int QUALIFIER_ORDER_OTHER_RELOP = 1;
    private static final int QUALIFIER_ORDER_NOT_EQUALS = 2;
    private static final int QUALIFIER_ORDER_NON_QUAL = 3;
    private static final int QUALIFIER_ORDER_OR_CLAUSE = 4;
    private static final int QUALIFIER_NUM_CATEGORIES = 5;

    PredicateList(ContextManager contextManager) {
        super(Predicate.class, contextManager);
    }

    @Override
    public OptimizablePredicate getOptPredicate(int n2) {
        return (OptimizablePredicate)this.elementAt(n2);
    }

    @Override
    public final void removeOptPredicate(int n2) throws StandardException {
        Predicate predicate = (Predicate)this.removeElementAt(n2);
        if (predicate.isStartKey()) {
            --this.numberOfStartPredicates;
        }
        if (predicate.isStopKey()) {
            --this.numberOfStopPredicates;
        }
        if (predicate.isQualifier()) {
            --this.numberOfQualifiers;
        }
    }

    public final void removeOptPredicate(OptimizablePredicate optimizablePredicate) {
        this.removeElement((Predicate)optimizablePredicate);
        if (optimizablePredicate.isStartKey()) {
            --this.numberOfStartPredicates;
        }
        if (optimizablePredicate.isStopKey()) {
            --this.numberOfStopPredicates;
        }
        if (optimizablePredicate.isQualifier()) {
            --this.numberOfQualifiers;
        }
    }

    @Override
    public void addOptPredicate(OptimizablePredicate optimizablePredicate) {
        this.addElement((Predicate)optimizablePredicate);
        if (optimizablePredicate.isStartKey()) {
            ++this.numberOfStartPredicates;
        }
        if (optimizablePredicate.isStopKey()) {
            ++this.numberOfStopPredicates;
        }
        if (optimizablePredicate.isQualifier()) {
            ++this.numberOfQualifiers;
        }
    }

    public void addOptPredicate(OptimizablePredicate optimizablePredicate, int n2) {
        this.insertElementAt((Predicate)optimizablePredicate, n2);
        if (optimizablePredicate.isStartKey()) {
            ++this.numberOfStartPredicates;
        }
        if (optimizablePredicate.isStopKey()) {
            ++this.numberOfStopPredicates;
        }
        if (optimizablePredicate.isQualifier()) {
            ++this.numberOfQualifiers;
        }
    }

    @Override
    public boolean useful(Optimizable optimizable, ConglomerateDescriptor conglomerateDescriptor) throws StandardException {
        boolean bl2 = false;
        if (!conglomerateDescriptor.isIndex()) {
            return false;
        }
        for (Predicate predicate : this) {
            boolean bl3;
            RelationalOperator relationalOperator = predicate.getRelop();
            InListOperatorNode inListOperatorNode = predicate.getSourceInList();
            boolean bl4 = bl3 = inListOperatorNode != null;
            if (!bl3 && relationalOperator == null || !bl3 && !relationalOperator.usefulStartKey(optimizable) && !relationalOperator.usefulStopKey(optimizable)) continue;
            ColumnReference columnReference = null;
            if (bl3) {
                if (inListOperatorNode.getLeftOperand() instanceof ColumnReference && (columnReference = (ColumnReference)inListOperatorNode.getLeftOperand()).getColumnNumber() != conglomerateDescriptor.getIndexDescriptor().baseColumnPositions()[0]) {
                    columnReference = null;
                }
            } else {
                columnReference = relationalOperator.getColumnOperand(optimizable, conglomerateDescriptor.getIndexDescriptor().baseColumnPositions()[0]);
            }
            if (columnReference == null || bl3 && inListOperatorNode.selfReference(columnReference) || !bl3 && relationalOperator.selfComparison(columnReference)) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    @Override
    public void pushUsefulPredicates(Optimizable optimizable) throws StandardException {
        AccessPath accessPath = optimizable.getTrulyTheBestAccessPath();
        this.orderUsefulPredicates(optimizable, accessPath.getConglomerateDescriptor(), true, accessPath.getNonMatchingIndexScan(), accessPath.getCoveringIndexScan());
    }

    @Override
    public void classify(Optimizable optimizable, ConglomerateDescriptor conglomerateDescriptor) throws StandardException {
        this.orderUsefulPredicates(optimizable, conglomerateDescriptor, false, false, false);
    }

    @Override
    public void markAllPredicatesQualifiers() {
        for (Predicate predicate : this) {
            predicate.markQualifier();
        }
        this.numberOfQualifiers = this.size();
    }

    @Override
    public int hasEqualityPredicateOnOrderedColumn(Optimizable optimizable, int n2, boolean bl2) throws StandardException {
        int n3 = this.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            AndNode andNode;
            ValueNode valueNode;
            Predicate predicate = (Predicate)this.elementAt(i2);
            if (predicate.getReferencedMap().hasSingleBitSet() || !(valueNode = (andNode = predicate.getAndNode()).getLeftOperand()).optimizableEqualityNode(optimizable, n2, bl2)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public boolean hasOptimizableEqualityPredicate(Optimizable optimizable, int n2, boolean bl2) throws StandardException {
        for (Predicate predicate : this) {
            AndNode andNode = predicate.getAndNode();
            ValueNode valueNode = andNode.getLeftOperand();
            if (!valueNode.optimizableEqualityNode(optimizable, n2, bl2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasOptimizableEquijoin(Optimizable optimizable, int n2) throws StandardException {
        for (Predicate predicate : this) {
            AndNode andNode;
            ValueNode valueNode;
            if (predicate.isScopedForPush() || !(valueNode = (andNode = predicate.getAndNode()).getLeftOperand()).optimizableEqualityNode(optimizable, n2, false) || !((RelationalOperator)((Object)valueNode)).isQualifier(optimizable, false) || predicate.getReferencedMap().hasSingleBitSet()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void putOptimizableEqualityPredicateFirst(Optimizable optimizable, int n2) throws StandardException {
        int n3 = this.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            Predicate predicate = (Predicate)this.elementAt(i2);
            AndNode andNode = predicate.getAndNode();
            ValueNode valueNode = andNode.getLeftOperand();
            if (!valueNode.optimizableEqualityNode(optimizable, n2, false)) continue;
            if (i2 != 0) {
                this.removeElementAt(i2);
                this.insertElementAt(predicate, 0);
            }
            return;
        }
    }

    private void orderUsefulPredicates(Optimizable optimizable, ConglomerateDescriptor conglomerateDescriptor, boolean bl2, boolean bl3, boolean bl4) throws StandardException {
        int n2;
        int n3;
        int n4 = this.size();
        Object[] objectArray = new Predicate[n4];
        int n5 = 0;
        for (Predicate[] predicateArray : this) {
            predicateArray.clearScanFlags();
        }
        if (conglomerateDescriptor == null || !conglomerateDescriptor.isIndex() || bl3 && bl4) {
            int n6;
            Predicate[] predicateArray = new Predicate[n4];
            for (n6 = 0; n6 < n4; ++n6) {
                Predicate predicate = (Predicate)this.elementAt(n6);
                if (!predicate.isRelationalOpPredicate() ? !predicate.isPushableOrClause(optimizable) : !predicate.getRelop().isQualifier(optimizable, bl2)) continue;
                predicate.markQualifier();
                if (!bl2 || !optimizable.pushOptPredicate(predicate)) continue;
                predicateArray[n6] = predicate;
            }
            for (n6 = n4 - 1; n6 >= 0; --n6) {
                if (predicateArray[n6] == null) continue;
                this.removeOptPredicate(predicateArray[n6]);
            }
            return;
        }
        int[] nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
        boolean[] blArray = conglomerateDescriptor.getIndexDescriptor().isAscending();
        boolean bl5 = bl2 && optimizable.getTrulyTheBestAccessPath().getJoinStrategy().isHashJoin();
        for (Predicate predicate : this) {
            ColumnReference columnReference = null;
            RelationalOperator relationalOperator = predicate.getRelop();
            InListOperatorNode inListOperatorNode = predicate.getSourceInList();
            int n7 = n3 = inListOperatorNode != null ? 1 : 0;
            if (n3 == 0 && (relationalOperator == null || !relationalOperator.isQualifier(optimizable, bl2)) || bl5 && predicate.isInListProbePredicate()) continue;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (n3 != 0) {
                    if (inListOperatorNode.getLeftOperand() instanceof ColumnReference) {
                        columnReference = (ColumnReference)inListOperatorNode.getLeftOperand();
                        if (optimizable.getTableNumber() != columnReference.getTableNumber() || columnReference.getColumnNumber() != nArray[n2] || inListOperatorNode.selfReference(columnReference)) {
                            columnReference = null;
                        } else if (predicate.isInListProbePredicate() && n2 > 0) {
                            columnReference = null;
                        }
                    }
                } else {
                    columnReference = relationalOperator.getColumnOperand(optimizable, nArray[n2]);
                }
                if (columnReference != null) break;
            }
            if (columnReference == null) continue;
            predicate.setIndexPosition(n2);
            objectArray[n5++] = predicate;
        }
        if (n5 == 0) {
            return;
        }
        if (objectArray.length > n5) {
            Predicate[] predicateArray;
            predicateArray = new Predicate[n5];
            System.arraycopy(objectArray, 0, predicateArray, 0, n5);
            objectArray = predicateArray;
        }
        Arrays.sort(objectArray);
        int n8 = -1;
        boolean bl6 = false;
        int n9 = -1;
        n2 = 0;
        boolean bl7 = false;
        int n10 = -1;
        n3 = -1;
        boolean bl8 = false;
        boolean bl9 = false;
        for (int i2 = 0; i2 < n5; ++i2) {
            boolean bl10;
            Object object = objectArray[i2];
            int n11 = ((Predicate)object).getIndexPosition();
            boolean bl11 = false;
            RelationalOperator relationalOperator = ((Predicate)object).getRelop();
            int n12 = -1;
            boolean bl12 = bl10 = ((Predicate)object).getSourceInList() != null;
            if (relationalOperator != null) {
                n12 = relationalOperator.getOperator();
            }
            if (n8 != n11) {
                if (n11 - n8 > 1) {
                    bl6 = true;
                } else if (n12 == 1 || n12 == 7) {
                    n3 = n11;
                }
                if (!bl6 && !bl9 && (bl10 || relationalOperator.usefulStartKey(optimizable) && blArray[n11] || relationalOperator.usefulStopKey(optimizable) && !blArray[n11])) {
                    ((Predicate)object).markStartKey();
                    n8 = n11;
                    bl11 = true;
                    boolean bl13 = bl9 = ((Predicate)object).getStartOperator(optimizable) == -1;
                }
            }
            if (n9 != n11) {
                if (n11 - n9 > 1) {
                    n2 = 1;
                }
                if (n2 == 0 && !bl8 && (bl10 || relationalOperator.usefulStopKey(optimizable) && blArray[n11] || relationalOperator.usefulStartKey(optimizable) && !blArray[n11])) {
                    ((Predicate)object).markStopKey();
                    n9 = n11;
                    bl11 = true;
                    boolean bl14 = bl8 = ((Predicate)object).getStopOperator(optimizable) == 1;
                }
            }
            if (!bl10 && (!bl11 || bl7 && n11 != n10)) {
                ((Predicate)object).markQualifier();
            }
            if (n3 != n11 && n10 == -1 && n12 != 1 && n12 != 7) {
                bl7 = true;
                n10 = n11;
            }
            if (bl2) {
                Object object2;
                if (bl10 && !bl11) continue;
                if (bl10 && !((Predicate)object).isInListProbePredicate()) {
                    AndNode andNode = new AndNode(((Predicate)object).getAndNode().getLeftOperand(), ((Predicate)object).getAndNode().getRightOperand(), this.getContextManager());
                    andNode.copyFields(((Predicate)object).getAndNode());
                    Predicate predicate = new Predicate(andNode, ((Predicate)object).getReferencedSet(), this.getContextManager());
                    predicate.copyFields((Predicate)object);
                    object2 = predicate;
                } else {
                    object2 = object;
                }
                if (!optimizable.pushOptPredicate((OptimizablePredicate)object2) || bl10 && !((Predicate)object).isInListProbePredicate()) continue;
                this.removeOptPredicate((OptimizablePredicate)object);
                continue;
            }
            this.removeOptPredicate((OptimizablePredicate)object);
            this.addOptPredicate((OptimizablePredicate)object, i2);
        }
    }

    void addPredicate(Predicate predicate) throws StandardException {
        if (predicate.isStartKey()) {
            ++this.numberOfStartPredicates;
        }
        if (predicate.isStopKey()) {
            ++this.numberOfStopPredicates;
        }
        if (predicate.isQualifier()) {
            ++this.numberOfQualifiers;
        }
        this.addElement(predicate);
    }

    protected void transferNonQualifiers(Optimizable optimizable, PredicateList predicateList) throws StandardException {
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            Predicate predicate = (Predicate)this.elementAt(i2);
            if (predicate.isRelationalOpPredicate() && predicate.getRelop().isQualifier(optimizable, false)) continue;
            predicate.clearScanFlags();
            this.removeElementAt(i2);
            predicateList.addElement(predicate);
        }
        this.markAllPredicatesQualifiers();
    }

    void categorize() throws StandardException {
        for (Predicate predicate : this) {
            predicate.categorize();
        }
    }

    void eliminateBooleanTrueAndBooleanTrue() {
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            AndNode andNode = ((Predicate)this.elementAt(i2)).getAndNode();
            if (!andNode.getLeftOperand().isBooleanTrue() || !andNode.getRightOperand().isBooleanTrue()) continue;
            this.removeElementAt(i2);
        }
    }

    ValueNode restoreConstantPredicates() throws StandardException {
        BinaryOperatorNode binaryOperatorNode = null;
        ValueNode valueNode = null;
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            AndNode andNode = ((Predicate)this.elementAt(i2)).getAndNode();
            if (!andNode.isConstantExpression()) continue;
            this.removeElementAt(i2);
            if (andNode.getLeftOperand().isBooleanTrue() && andNode.getRightOperand().isBooleanTrue()) continue;
            if (andNode.getLeftOperand().isBooleanFalse()) {
                binaryOperatorNode = andNode;
            }
            if (valueNode != null) {
                andNode.setRightOperand(valueNode);
                if (valueNode.getTypeServices().isNullable()) {
                    andNode.setNullability(true);
                }
            }
            valueNode = andNode;
        }
        if (valueNode != null && ((AndNode)valueNode).getRightOperand().isBooleanTrue()) {
            valueNode = ((AndNode)valueNode).getLeftOperand();
        } else if (binaryOperatorNode != null) {
            valueNode = binaryOperatorNode.getLeftOperand();
        }
        return valueNode;
    }

    ValueNode restorePredicates() throws StandardException {
        BinaryOperatorNode binaryOperatorNode = null;
        ValueNode valueNode = null;
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            AndNode andNode = ((Predicate)this.elementAt(i2)).getAndNode();
            if (andNode.getLeftOperand().isBooleanTrue() && andNode.getRightOperand().isBooleanTrue()) continue;
            if (andNode.getLeftOperand().isBooleanFalse()) {
                binaryOperatorNode = andNode;
            }
            if (valueNode != null) {
                andNode.setRightOperand(valueNode);
                if (valueNode.getTypeServices().isNullable()) {
                    andNode.setNullability(true);
                }
            }
            valueNode = andNode;
        }
        if (valueNode != null && ((AndNode)valueNode).getRightOperand().isBooleanTrue()) {
            valueNode = ((AndNode)valueNode).getLeftOperand();
        } else if (binaryOperatorNode != null) {
            valueNode = binaryOperatorNode.getLeftOperand();
        }
        this.removeAllElements();
        return valueNode;
    }

    void remapColumnReferencesToExpressions() throws StandardException {
        for (Predicate predicate : this) {
            predicate.setAndNode((AndNode)predicate.getAndNode().remapColumnReferencesToExpressions());
        }
    }

    void pullExpressions(int n2, ValueNode valueNode) throws StandardException {
        if (valueNode != null) {
            Predicate predicate;
            JBitSet jBitSet;
            AndNode andNode = (AndNode)valueNode;
            BooleanConstantNode booleanConstantNode = new BooleanConstantNode(true, this.getContextManager());
            while (andNode.getRightOperand() instanceof AndNode) {
                AndNode andNode2 = andNode;
                andNode = (AndNode)andNode.getRightOperand();
                andNode2.setRightOperand(null);
                andNode2.setRightOperand(booleanConstantNode);
                jBitSet = new JBitSet(n2);
                predicate = new Predicate(andNode2, jBitSet, this.getContextManager());
                this.addPredicate(predicate);
            }
            jBitSet = new JBitSet(n2);
            predicate = new Predicate(andNode, jBitSet, this.getContextManager());
            this.addPredicate(predicate);
        }
    }

    void xorReferencedSet(JBitSet jBitSet) {
        for (Predicate predicate : this) {
            predicate.getReferencedSet().xor(jBitSet);
        }
    }

    private void countScanFlags() {
        for (Predicate predicate : this) {
            if (predicate.isStartKey()) {
                ++this.numberOfStartPredicates;
            }
            if (predicate.isStopKey()) {
                ++this.numberOfStopPredicates;
            }
            if (!predicate.isQualifier()) continue;
            ++this.numberOfQualifiers;
        }
    }

    private static boolean isConstantOrParameterNode(ValueNode valueNode) {
        return valueNode instanceof ConstantNode || valueNode instanceof ParameterNode;
    }

    void pushExpressionsIntoSelect(SelectNode selectNode, boolean bl2) throws StandardException {
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            boolean bl3;
            Predicate predicate = (Predicate)this.elementAt(i2);
            CollectNodesVisitor<ColumnReference> collectNodesVisitor = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
            predicate.getAndNode().accept(collectNodesVisitor);
            List<ColumnReference> list = collectNodesVisitor.getList();
            boolean bl4 = bl3 = list.size() > 0;
            if (bl3) {
                for (ValueNode valueNode2 : list) {
                    if (valueNode2.pointsToColumnReference()) continue;
                    bl3 = false;
                    break;
                }
            }
            if (!bl3) continue;
            if (bl2) {
                ValueNode valueNode;
                ColumnReference columnReference;
                ValueNode valueNode2;
                AndNode andNode = predicate.getAndNode();
                BinaryRelationalOperatorNode binaryRelationalOperatorNode = null;
                InListOperatorNode inListOperatorNode = null;
                if (andNode.getLeftOperand() instanceof BinaryRelationalOperatorNode) {
                    binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)andNode.getLeftOperand();
                    if (!(binaryRelationalOperatorNode.getLeftOperand() instanceof ColumnReference) || !PredicateList.isConstantOrParameterNode(binaryRelationalOperatorNode.getRightOperand())) continue;
                    columnReference = (ColumnReference)binaryRelationalOperatorNode.getLeftOperand();
                } else {
                    if (!(andNode.getLeftOperand() instanceof InListOperatorNode) || !((inListOperatorNode = (InListOperatorNode)andNode.getLeftOperand()).getLeftOperand() instanceof ColumnReference) || !inListOperatorNode.getRightOperandList().isConstantExpression()) continue;
                    columnReference = (ColumnReference)inListOperatorNode.getLeftOperand();
                }
                ColumnReference columnReference2 = selectNode.findColumnReferenceInResult(columnReference.getColumnName());
                if (columnReference2 == null) continue;
                if (andNode.getLeftOperand() instanceof BinaryRelationalOperatorNode) {
                    inListOperatorNode = binaryRelationalOperatorNode.getInListOp();
                    if (inListOperatorNode != null) {
                        inListOperatorNode = inListOperatorNode.shallowCopy();
                        inListOperatorNode.setLeftOperand(columnReference2);
                    }
                    valueNode = new BinaryRelationalOperatorNode(binaryRelationalOperatorNode.kind, (ValueNode)columnReference2, binaryRelationalOperatorNode.getRightOperand(), inListOperatorNode, binaryRelationalOperatorNode.getForQueryRewrite(), this.getContextManager());
                    ((BinaryComparisonOperatorNode)valueNode).bindComparisonOperator();
                    valueNode2 = valueNode;
                } else {
                    valueNode = new InListOperatorNode(columnReference2, inListOperatorNode.getRightOperandList(), this.getContextManager());
                    valueNode.setType(inListOperatorNode.getTypeServices());
                    valueNode2 = valueNode;
                }
                valueNode = new BooleanConstantNode(true, this.getContextManager());
                AndNode andNode2 = new AndNode(valueNode2, valueNode, this.getContextManager());
                andNode2.postBindFixup();
                JBitSet jBitSet = new JBitSet(selectNode.getReferencedTableMap().size());
                predicate = new Predicate(andNode2, jBitSet, this.getContextManager());
            } else {
                if (predicate.isStartKey()) {
                    --this.numberOfStartPredicates;
                }
                if (predicate.isStopKey()) {
                    --this.numberOfStopPredicates;
                }
                if (predicate.isQualifier()) {
                    --this.numberOfQualifiers;
                }
                predicate.clearScanFlags();
                this.removeElementAt(i2);
            }
            selectNode.pushExpressionsIntoSelect(predicate);
        }
    }

    void markReferencedColumns() throws StandardException {
        CollectNodesVisitor<ColumnReference> collectNodesVisitor = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
        for (Predicate queryTreeNode : this) {
            queryTreeNode.getAndNode().accept(collectNodesVisitor);
        }
        for (ColumnReference columnReference : collectNodesVisitor.getList()) {
            ResultColumn resultColumn = columnReference.getSource();
            if (resultColumn == null) continue;
            resultColumn.markAllRCsInChainReferenced();
        }
    }

    void checkTopPredicatesForEqualsConditions(int n2, boolean[] blArray, int[] nArray, JBitSet[] jBitSetArray, boolean bl2) throws StandardException {
        for (Predicate predicate : this) {
            predicate.getAndNode().checkTopPredicatesForEqualsConditions(n2, blArray, nArray, jBitSetArray, bl2);
        }
    }

    boolean allPushable() {
        for (Predicate predicate : this) {
            if (predicate.getPushable()) continue;
            return false;
        }
        return true;
    }

    boolean allReference(FromBaseTable fromBaseTable) {
        int n2 = fromBaseTable.getTableNumber();
        for (Predicate predicate : this) {
            if (predicate.getReferencedSet().get(n2)) continue;
            return false;
        }
        return true;
    }

    PredicateList getPushablePredicates(JBitSet jBitSet) throws StandardException {
        PredicateList predicateList = null;
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            JBitSet jBitSet2;
            Predicate predicate = (Predicate)this.elementAt(i2);
            if (!predicate.getPushable() || !jBitSet.contains(jBitSet2 = predicate.getReferencedSet())) continue;
            if (predicateList == null) {
                predicateList = new PredicateList(this.getContextManager());
            }
            predicateList.addPredicate(predicate);
            RemapCRsVisitor remapCRsVisitor = new RemapCRsVisitor(true);
            predicate.getAndNode().accept(remapCRsVisitor);
            this.removeElementAt(i2);
        }
        return predicateList;
    }

    void decrementLevel(FromList fromList, int n2) {
        int[] nArray = fromList.getTableNumbers();
        block0: for (Predicate predicate : this) {
            int n3;
            UnaryOperatorNode unaryOperatorNode;
            ColumnReference columnReference = null;
            ColumnReference columnReference2 = null;
            ValueNode valueNode = predicate.getAndNode().getLeftOperand();
            if (valueNode instanceof BinaryOperatorNode) {
                BinaryOperatorNode binaryOperatorNode = (BinaryOperatorNode)valueNode;
                if (binaryOperatorNode.getLeftOperand() instanceof ColumnReference) {
                    columnReference = (ColumnReference)binaryOperatorNode.getLeftOperand();
                }
                if (binaryOperatorNode.getRightOperand() instanceof ColumnReference) {
                    columnReference2 = (ColumnReference)binaryOperatorNode.getRightOperand();
                }
            } else if (valueNode instanceof UnaryOperatorNode && (unaryOperatorNode = (UnaryOperatorNode)valueNode).getOperand() instanceof ColumnReference) {
                columnReference = (ColumnReference)unaryOperatorNode.getOperand();
            }
            if (columnReference != null) {
                int n4 = columnReference.getTableNumber();
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    if (nArray[n3] != n4) continue;
                    columnReference.setSourceLevel(columnReference.getSourceLevel() - n2);
                    break;
                }
            }
            if (columnReference2 == null) continue;
            int n5 = columnReference2.getTableNumber();
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (nArray[n3] != n5) continue;
                columnReference2.setSourceLevel(columnReference2.getSourceLevel() - n2);
                continue block0;
            }
        }
    }

    void joinClauseTransitiveClosure(int n2, FromList fromList, CompilerContext compilerContext) throws StandardException {
        ValueNode valueNode;
        QueryTreeNode queryTreeNode;
        Object object;
        if (fromList.size() < 3) {
            return;
        }
        PredicateList[] predicateListArray = new PredicateList[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            predicateListArray[i2] = new PredicateList(this.getContextManager());
        }
        for (QueryTreeNode queryTreeNode2 : this) {
            object = ((Predicate)queryTreeNode2).getAndNode().getLeftOperand();
            if (!((ValueNode)object).isBinaryEqualsOperatorNode()) continue;
            BinaryRelationalOperatorNode binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)object;
            queryTreeNode = binaryRelationalOperatorNode.getLeftOperand();
            valueNode = binaryRelationalOperatorNode.getRightOperand();
            if (!(queryTreeNode instanceof ColumnReference) || !(valueNode instanceof ColumnReference)) continue;
            ColumnReference columnReference = (ColumnReference)queryTreeNode;
            ColumnReference columnReference2 = (ColumnReference)valueNode;
            if (columnReference.getSourceLevel() != columnReference2.getSourceLevel() || columnReference.getTableNumber() == columnReference2.getTableNumber() || fromList.tableNumberIsNotExists(columnReference.getTableNumber()) || fromList.tableNumberIsNotExists(columnReference2.getTableNumber())) continue;
            predicateListArray[columnReference.getTableNumber()].addElement(queryTreeNode2);
            predicateListArray[columnReference2.getTableNumber()].addElement(queryTreeNode2);
        }
        for (int i3 = 0; i3 < n2; ++i3) {
            int n3;
            QueryTreeNode queryTreeNode2;
            queryTreeNode2 = predicateListArray[i3];
            if (((QueryTreeNodeVector)queryTreeNode2).size() == 0) continue;
            object = new ArrayList();
            for (n3 = ((QueryTreeNodeVector)queryTreeNode2).size() - 1; n3 >= 0; --n3) {
                queryTreeNode = (Predicate)((QueryTreeNodeVector)queryTreeNode2).elementAt(n3);
                if (((Predicate)queryTreeNode).getEquivalenceClass() == -1) continue;
                ((QueryTreeNodeVector)queryTreeNode2).removeElementAt(n3);
                ((ArrayList)object).add(queryTreeNode);
            }
            for (n3 = 0; n3 < ((ArrayList)object).size(); ++n3) {
                ((QueryTreeNodeVector)queryTreeNode2).insertElementAt((QueryTreeNode)((ArrayList)object).get(n3), 0);
            }
            for (n3 = 0; n3 < ((QueryTreeNodeVector)queryTreeNode2).size(); ++n3) {
                int n4;
                int n5;
                int n6;
                queryTreeNode = null;
                int n7 = i3;
                Predicate predicate = (Predicate)((QueryTreeNodeVector)queryTreeNode2).elementAt(n3);
                if (predicate.getEquivalenceClass() == -1) {
                    predicate.setEquivalenceClass(compilerContext.getNextEquivalenceClass());
                }
                int n8 = predicate.getEquivalenceClass();
                BinaryRelationalOperatorNode binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)predicate.getAndNode().getLeftOperand();
                ColumnReference columnReference = (ColumnReference)binaryRelationalOperatorNode.getLeftOperand();
                ColumnReference columnReference3 = (ColumnReference)binaryRelationalOperatorNode.getRightOperand();
                if (columnReference.getTableNumber() == n7) {
                    n6 = columnReference.getColumnNumber();
                    n5 = columnReference3.getTableNumber();
                    n4 = columnReference3.getColumnNumber();
                    valueNode = columnReference;
                } else {
                    n6 = columnReference3.getColumnNumber();
                    n5 = columnReference.getTableNumber();
                    n4 = columnReference.getColumnNumber();
                    valueNode = columnReference3;
                }
                PredicateList predicateList = predicateListArray[n5];
                for (Predicate predicate2 : predicateList) {
                    ValueNode valueNode2;
                    ValueNode valueNode3;
                    BinaryRelationalOperatorNode binaryRelationalOperatorNode2;
                    int n9;
                    int n10;
                    int n11;
                    if (predicate2.getEquivalenceClass() != -1 && predicate2.getEquivalenceClass() != n8) continue;
                    BinaryRelationalOperatorNode binaryRelationalOperatorNode3 = (BinaryRelationalOperatorNode)predicate2.getAndNode().getLeftOperand();
                    ColumnReference columnReference4 = (ColumnReference)binaryRelationalOperatorNode3.getLeftOperand();
                    ColumnReference columnReference5 = (ColumnReference)binaryRelationalOperatorNode3.getRightOperand();
                    if (columnReference4.getTableNumber() == n5) {
                        if (columnReference4.getColumnNumber() != n4) continue;
                        n11 = columnReference5.getTableNumber();
                        n10 = columnReference5.getColumnNumber();
                    } else {
                        if (columnReference5.getColumnNumber() != n4) continue;
                        n11 = columnReference4.getTableNumber();
                        n10 = columnReference4.getColumnNumber();
                    }
                    if (n7 == n11 && n6 == n10) continue;
                    predicate2.setEquivalenceClass(n8);
                    Predicate predicate3 = null;
                    PredicateList predicateList2 = predicateListArray[n11];
                    for (n9 = 0; n9 < predicateList2.size(); ++n9) {
                        int n12;
                        int n13;
                        predicate3 = (Predicate)predicateList2.elementAt(n9);
                        if (predicate3.getEquivalenceClass() != -1 && predicate3.getEquivalenceClass() != n8) continue;
                        binaryRelationalOperatorNode2 = (BinaryRelationalOperatorNode)predicate3.getAndNode().getLeftOperand();
                        valueNode3 = (ColumnReference)binaryRelationalOperatorNode2.getLeftOperand();
                        valueNode2 = (ColumnReference)binaryRelationalOperatorNode2.getRightOperand();
                        if (((ColumnReference)valueNode3).getTableNumber() == n11) {
                            if (((ColumnReference)valueNode3).getColumnNumber() != n10) continue;
                            n13 = ((ColumnReference)valueNode2).getTableNumber();
                            n12 = ((ColumnReference)valueNode2).getColumnNumber();
                            queryTreeNode = valueNode3;
                        } else {
                            if (((ColumnReference)valueNode2).getColumnNumber() != n10) continue;
                            n13 = ((ColumnReference)valueNode3).getTableNumber();
                            n12 = ((ColumnReference)valueNode3).getColumnNumber();
                            queryTreeNode = valueNode2;
                        }
                        if (n13 == n7 && n12 == n6) break;
                    }
                    if (n9 != predicateList2.size()) {
                        predicate3.setEquivalenceClass(n8);
                        continue;
                    }
                    binaryRelationalOperatorNode2 = new BinaryRelationalOperatorNode(0, ((ColumnReference)valueNode).getClone(), ((ColumnReference)queryTreeNode).getClone(), false, this.getContextManager());
                    binaryRelationalOperatorNode2.bindComparisonOperator();
                    valueNode3 = new BooleanConstantNode(true, this.getContextManager());
                    valueNode2 = new AndNode(binaryRelationalOperatorNode2, valueNode3, this.getContextManager());
                    ((AndNode)valueNode2).postBindFixup();
                    JBitSet jBitSet = new JBitSet(n2);
                    ((BinaryOperatorNode)valueNode2).categorize(jBitSet, false);
                    Predicate predicate4 = new Predicate((AndNode)valueNode2, jBitSet, this.getContextManager());
                    predicate4.setEquivalenceClass(n8);
                    this.addPredicate(predicate4);
                    if (n3 != ((QueryTreeNodeVector)queryTreeNode2).size() - 1) {
                        ((QueryTreeNodeVector)queryTreeNode2).insertElementAt(predicate4, n3 + 1);
                    } else {
                        ((QueryTreeNodeVector)queryTreeNode2).addElement(predicate4);
                    }
                    if (queryTreeNode2 == predicateList2) continue;
                    predicateList2.addElement(predicate4);
                }
            }
        }
    }

    void searchClauseTransitiveClosure(int n2, boolean bl2) throws StandardException {
        ValueNode valueNode;
        RelationalOperator relationalOperator;
        QueryTreeNode queryTreeNode;
        Object object;
        int n3;
        PredicateList predicateList = new PredicateList(this.getContextManager());
        PredicateList predicateList2 = new PredicateList(this.getContextManager());
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = null;
        int n4 = this.size();
        for (n3 = 0; n3 < n4; ++n3) {
            Object object2;
            ValueNode valueNode2;
            BinaryComparisonOperatorNode binaryComparisonOperatorNode;
            object = (Predicate)this.elementAt(n3);
            queryTreeNode = ((Predicate)object).getAndNode();
            if (!((Predicate)object).isRelationalOpPredicate()) continue;
            relationalOperator = (RelationalOperator)((Object)((BinaryOperatorNode)queryTreeNode).getLeftOperand());
            if (((ValueNode)((Object)relationalOperator)).isBinaryEqualsOperatorNode()) {
                binaryComparisonOperatorNode = (BinaryRelationalOperatorNode)relationalOperator;
                binaryRelationalOperatorNode = binaryComparisonOperatorNode;
                valueNode2 = binaryComparisonOperatorNode.getLeftOperand();
                object2 = binaryComparisonOperatorNode.getRightOperand();
                if (valueNode2 instanceof ColumnReference && object2 instanceof ColumnReference) {
                    QueryTreeNode queryTreeNode2 = (ColumnReference)valueNode2;
                    valueNode = (ColumnReference)object2;
                    if (((ColumnReference)queryTreeNode2).getSourceLevel() != ((ColumnReference)valueNode).getSourceLevel() || ((ColumnReference)queryTreeNode2).getTableNumber() == ((ColumnReference)valueNode).getTableNumber()) continue;
                    predicateList.addElement(object);
                    continue;
                }
            }
            if (relationalOperator instanceof UnaryComparisonOperatorNode) {
                if (!(((UnaryComparisonOperatorNode)((Object)relationalOperator)).getOperand() instanceof ColumnReference)) continue;
                predicateList2.addElement(object);
                continue;
            }
            if (!(relationalOperator instanceof BinaryComparisonOperatorNode)) continue;
            binaryComparisonOperatorNode = (BinaryComparisonOperatorNode)((Object)relationalOperator);
            valueNode2 = binaryComparisonOperatorNode.getLeftOperand();
            object2 = binaryComparisonOperatorNode.getRightOperand();
            if (valueNode2 instanceof ColumnReference && PredicateList.isConstantOrParameterNode((ValueNode)object2)) {
                predicateList2.addElement(object);
                continue;
            }
            if (!PredicateList.isConstantOrParameterNode(valueNode2) || !(object2 instanceof ColumnReference)) continue;
            ((BinaryOperatorNode)queryTreeNode).setLeftOperand(binaryComparisonOperatorNode.getSwappedEquivalent());
            predicateList2.addElement(object);
        }
        if (predicateList.size() == 0 || predicateList2.size() == 0) {
            return;
        }
        for (n3 = 0; n3 < predicateList2.size(); ++n3) {
            object = null;
            relationalOperator = (RelationalOperator)((Object)((Predicate)predicateList2.elementAt(n3)).getAndNode().getLeftOperand());
            if (relationalOperator instanceof UnaryComparisonOperatorNode) {
                queryTreeNode = (ColumnReference)((UnaryComparisonOperatorNode)((Object)relationalOperator)).getOperand();
            } else {
                queryTreeNode = (ColumnReference)((BinaryComparisonOperatorNode)((Object)relationalOperator)).getLeftOperand();
                if (((BinaryComparisonOperatorNode)((Object)relationalOperator)).getRightOperand() instanceof ConstantNode) {
                    ConstantNode constantNode = (ConstantNode)((BinaryComparisonOperatorNode)((Object)relationalOperator)).getRightOperand();
                    object = constantNode.getValue();
                } else {
                    object = null;
                }
            }
            int n5 = ((ColumnReference)queryTreeNode).getTableNumber();
            int n6 = ((ColumnReference)queryTreeNode).getColumnNumber();
            for (QueryTreeNode queryTreeNode2 : predicateList) {
                Object object3;
                Object object4;
                QueryTreeNode queryTreeNode32;
                ColumnReference columnReference;
                if (((Predicate)queryTreeNode2).transitiveSearchClauseAdded(relationalOperator)) continue;
                valueNode = (BinaryRelationalOperatorNode)((Predicate)queryTreeNode2).getAndNode().getLeftOperand();
                ColumnReference columnReference2 = (ColumnReference)((BinaryOperatorNode)valueNode).getLeftOperand();
                ColumnReference columnReference3 = (ColumnReference)((BinaryOperatorNode)valueNode).getRightOperand();
                if (columnReference2.getTableNumber() == n5 && columnReference2.getColumnNumber() == n6) {
                    columnReference = columnReference3;
                } else {
                    if (columnReference3.getTableNumber() != n5 || columnReference3.getColumnNumber() != n6) continue;
                    columnReference = columnReference2;
                }
                ((Predicate)queryTreeNode2).setTransitiveSearchClauseAdded(relationalOperator);
                boolean bl3 = false;
                for (QueryTreeNode queryTreeNode32 : predicateList2) {
                    ColumnReference columnReference4;
                    object4 = null;
                    RelationalOperator relationalOperator2 = (RelationalOperator)((Object)queryTreeNode32.getAndNode().getLeftOperand());
                    if (relationalOperator2 instanceof UnaryComparisonOperatorNode) {
                        columnReference4 = (ColumnReference)((UnaryComparisonOperatorNode)((Object)relationalOperator2)).getOperand();
                    } else {
                        columnReference4 = (ColumnReference)((BinaryComparisonOperatorNode)((Object)relationalOperator2)).getLeftOperand();
                        if (((BinaryComparisonOperatorNode)((Object)relationalOperator2)).getRightOperand() instanceof ConstantNode) {
                            object3 = (ConstantNode)((BinaryComparisonOperatorNode)((Object)relationalOperator2)).getRightOperand();
                            object4 = ((ConstantNode)object3).getValue();
                        } else {
                            object4 = null;
                        }
                    }
                    if (columnReference4.getTableNumber() != columnReference.getTableNumber() || columnReference4.getColumnNumber() != columnReference.getColumnNumber() || (object4 == null || object == null || object4.compare((DataValueDescriptor)object) != 0) && (object4 != null || object != null) || relationalOperator2.getOperator() != relationalOperator.getOperator() || !relationalOperator2.getClass().getName().equals(relationalOperator.getClass().getName())) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) continue;
                OperatorNode operatorNode = (OperatorNode)((Object)relationalOperator.getTransitiveSearchClause((ColumnReference)columnReference.getClone()));
                if (operatorNode instanceof BinaryComparisonOperatorNode) {
                    ((BinaryComparisonOperatorNode)operatorNode).bindComparisonOperator();
                } else {
                    ((UnaryComparisonOperatorNode)operatorNode).bindComparisonOperator();
                }
                queryTreeNode32 = new BooleanConstantNode(true, this.getContextManager());
                object4 = new AndNode(operatorNode, (ValueNode)queryTreeNode32, this.getContextManager());
                ((AndNode)object4).postBindFixup();
                object3 = new JBitSet(n2);
                ((BinaryOperatorNode)object4).categorize((JBitSet)object3, false);
                Predicate predicate = new Predicate((AndNode)object4, (JBitSet)object3, this.getContextManager());
                this.addPredicate(predicate);
                predicateList2.addElement(predicate);
            }
        }
        if (bl2) {
            return;
        }
        for (n3 = this.size() - 1; n3 >= 0; --n3) {
            queryTreeNode = (Predicate)this.elementAt(n3);
            if (!((Predicate)queryTreeNode).transitiveSearchClauseAdded(binaryRelationalOperatorNode)) continue;
            this.removeElementAt(n3);
        }
    }

    void removeRedundantPredicates() {
        int n2 = this.size() - 1;
        while (n2 >= 0) {
            Predicate predicate = (Predicate)this.elementAt(n2);
            int n3 = predicate.getEquivalenceClass();
            if (n3 == -1) {
                --n2;
                continue;
            }
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                Predicate predicate2 = (Predicate)this.elementAt(i2);
                if (predicate2.getEquivalenceClass() != n3) continue;
                if (predicate2.isStartKey()) {
                    predicate.markStartKey();
                }
                if (predicate2.isStopKey()) {
                    predicate.markStopKey();
                }
                if ((predicate2.isStartKey() || predicate2.isStopKey()) && predicate2.isQualifier() && !predicate.isQualifier()) {
                    predicate.markQualifier();
                    ++this.numberOfQualifiers;
                }
                if (predicate2.isQualifier()) {
                    --this.numberOfQualifiers;
                }
                this.removeElementAt(i2);
                --n2;
            }
            --n2;
        }
    }

    @Override
    public void transferPredicates(OptimizablePredicateList optimizablePredicateList, JBitSet jBitSet, Optimizable optimizable) throws StandardException {
        PredicateList predicateList = (PredicateList)optimizablePredicateList;
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            Predicate predicate = (Predicate)this.elementAt(i2);
            if (!jBitSet.contains(predicate.getReferencedSet())) continue;
            if (predicate.isStartKey()) {
                --this.numberOfStartPredicates;
            }
            if (predicate.isStopKey()) {
                --this.numberOfStopPredicates;
            }
            if (predicate.isQualifier()) {
                --this.numberOfQualifiers;
            }
            predicate.clearScanFlags();
            predicateList.addPredicate(predicate);
            this.removeElementAt(i2);
        }
        AccessPath accessPath = optimizable.getTrulyTheBestAccessPath();
        predicateList.orderUsefulPredicates(optimizable, accessPath.getConglomerateDescriptor(), false, accessPath.getNonMatchingIndexScan(), accessPath.getCoveringIndexScan());
        predicateList.countScanFlags();
    }

    @Override
    public void transferAllPredicates(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        PredicateList predicateList = (PredicateList)optimizablePredicateList;
        for (Predicate predicate : this) {
            predicate.clearScanFlags();
            predicateList.addPredicate(predicate);
        }
        this.removeAllElements();
        this.numberOfStartPredicates = 0;
        this.numberOfStopPredicates = 0;
        this.numberOfQualifiers = 0;
    }

    @Override
    public void copyPredicatesToOtherList(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            optimizablePredicateList.addOptPredicate(this.getOptPredicate(i2));
        }
    }

    @Override
    public boolean isRedundantPredicate(int n2) {
        Predicate predicate = (Predicate)this.elementAt(n2);
        if (predicate.getEquivalenceClass() == -1) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (((Predicate)this.elementAt(i2)).getEquivalenceClass() != predicate.getEquivalenceClass()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setPredicatesAndProperties(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        PredicateList predicateList = (PredicateList)optimizablePredicateList;
        predicateList.removeAllElements();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            predicateList.addOptPredicate(this.getOptPredicate(i2));
        }
        predicateList.numberOfStartPredicates = this.numberOfStartPredicates;
        predicateList.numberOfStopPredicates = this.numberOfStopPredicates;
        predicateList.numberOfQualifiers = this.numberOfQualifiers;
    }

    @Override
    public int startOperator(Optimizable optimizable) {
        int n2 = -1;
        int n3 = this.size();
        for (int i2 = n3 - 1; i2 >= 0; --i2) {
            Predicate predicate = (Predicate)this.elementAt(i2);
            if (!predicate.isStartKey()) continue;
            n2 = predicate.getStartOperator(optimizable);
            break;
        }
        return n2;
    }

    @Override
    public void generateStopKey(ExpressionClassBuilderInterface expressionClassBuilderInterface, MethodBuilder methodBuilder, Optimizable optimizable) throws StandardException {
        ExpressionClassBuilder expressionClassBuilder = (ExpressionClassBuilder)expressionClassBuilderInterface;
        if (this.numberOfStopPredicates != 0) {
            MethodBuilder methodBuilder2 = expressionClassBuilder.newExprFun();
            LocalField localField = this.generateIndexableRow(expressionClassBuilder, this.numberOfStopPredicates);
            int n2 = 0;
            for (Predicate predicate : this) {
                if (!predicate.isStopKey()) continue;
                this.generateSetColumn(expressionClassBuilder, methodBuilder2, n2, predicate, optimizable, localField, false);
                ++n2;
            }
            this.finishKey(expressionClassBuilder, methodBuilder, methodBuilder2, localField);
            return;
        }
        methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
    }

    @Override
    public int stopOperator(Optimizable optimizable) {
        int n2 = -1;
        int n3 = this.size();
        for (int i2 = n3 - 1; i2 >= 0; --i2) {
            Predicate predicate = (Predicate)this.elementAt(i2);
            if (!predicate.isStopKey()) continue;
            n2 = predicate.getStopOperator(optimizable);
            break;
        }
        return n2;
    }

    private void generateSingleQualifierCode(MethodBuilder methodBuilder, Optimizable optimizable, boolean bl2, ExpressionClassBuilder expressionClassBuilder, RelationalOperator relationalOperator, LocalField localField, int n2, int n3) throws StandardException {
        methodBuilder.getField(localField);
        methodBuilder.pushThis();
        methodBuilder.callMethod((short)182, expressionClassBuilder.getBaseClassName(), "getExecutionFactory", "org.apache.derby.iapi.sql.execute.ExecutionFactory", 0);
        if (bl2) {
            relationalOperator.generateAbsoluteColumnId(methodBuilder, optimizable);
        } else {
            relationalOperator.generateRelativeColumnId(methodBuilder, optimizable);
        }
        relationalOperator.generateOperator(methodBuilder, optimizable);
        relationalOperator.generateQualMethod(expressionClassBuilder, methodBuilder, optimizable);
        expressionClassBuilder.pushThisAsActivation(methodBuilder);
        relationalOperator.generateOrderedNulls(methodBuilder);
        relationalOperator.generateNegate(methodBuilder, optimizable);
        relationalOperator.generateNegate(methodBuilder, optimizable);
        methodBuilder.push(relationalOperator.getOrderableVariantType(optimizable));
        methodBuilder.callMethod((short)185, "org.apache.derby.iapi.sql.execute.ExecutionFactory", "getQualifier", "org.apache.derby.iapi.store.access.Qualifier", 8);
        methodBuilder.push(n2);
        methodBuilder.push(n3);
        methodBuilder.callMethod((short)184, expressionClassBuilder.getBaseClassName(), "setQualifier", "void", 4);
    }

    void generateInListValues(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            Predicate predicate = (Predicate)this.elementAt(i2);
            if (!predicate.isInListProbePredicate()) continue;
            this.removeOptPredicate(predicate);
            InListOperatorNode inListOperatorNode = predicate.getSourceInList();
            methodBuilder.getField(inListOperatorNode.generateListAsArray(expressionClassBuilder, methodBuilder));
            if (inListOperatorNode.sortDescending()) {
                methodBuilder.push(2);
            } else if (!inListOperatorNode.isOrdered()) {
                methodBuilder.push(1);
            } else {
                methodBuilder.push(3);
            }
            return;
        }
    }

    @Override
    public void generateQualifiers(ExpressionClassBuilderInterface expressionClassBuilderInterface, MethodBuilder methodBuilder, Optimizable optimizable, boolean bl2) throws StandardException {
        int n2;
        int n3;
        String string = "org.apache.derby.iapi.store.access.Qualifier[][]";
        if (this.numberOfQualifiers == 0) {
            methodBuilder.pushNull(string);
            return;
        }
        ExpressionClassBuilder expressionClassBuilder = (ExpressionClassBuilder)expressionClassBuilderInterface;
        MethodBuilder methodBuilder2 = expressionClassBuilder.getConstructor();
        MethodBuilder methodBuilder3 = expressionClassBuilder.getExecuteMethod();
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, string);
        methodBuilder3.getField(localField);
        methodBuilder3.callMethod((short)184, expressionClassBuilder.getBaseClassName(), "reinitializeQualifiers", "void", 1);
        int n4 = 0;
        for (n3 = 0; n3 < this.numberOfQualifiers; ++n3) {
            if (!((Predicate)this.elementAt(n3)).isOrList()) continue;
            ++n4;
        }
        methodBuilder2.pushNewArray("org.apache.derby.iapi.store.access.Qualifier[]", n4 + 1);
        methodBuilder2.setField(localField);
        methodBuilder2.getField(localField);
        methodBuilder2.push(0);
        methodBuilder2.push(this.numberOfQualifiers - n4);
        methodBuilder2.callMethod((short)184, expressionClassBuilder.getBaseClassName(), "allocateQualArray", "void", 3);
        this.orderQualifiers();
        n3 = 0;
        int n5 = this.size();
        boolean bl3 = false;
        for (n2 = 0; n2 < n5; ++n2) {
            Predicate predicate = (Predicate)this.elementAt(n2);
            if (!predicate.isQualifier()) continue;
            if (predicate.isOrList()) {
                bl3 = true;
                break;
            }
            this.generateSingleQualifierCode(methodBuilder2, optimizable, bl2, expressionClassBuilder, predicate.getRelop(), localField, 0, n3);
            ++n3;
        }
        if (bl3) {
            n2 = 1;
            int n6 = n3;
            while (n6 < n5) {
                Predicate predicate = (Predicate)this.elementAt(n6);
                ArrayList<RelationalOperator> arrayList = new ArrayList<RelationalOperator>();
                ValueNode valueNode = predicate.getAndNode().getLeftOperand();
                while (valueNode instanceof OrNode) {
                    OrNode orNode = (OrNode)valueNode;
                    if (orNode.getLeftOperand() instanceof RelationalOperator) {
                        arrayList.add((RelationalOperator)((Object)orNode.getLeftOperand()));
                    }
                    valueNode = orNode.getRightOperand();
                }
                methodBuilder2.getField(localField);
                methodBuilder2.push(n2);
                methodBuilder2.push(arrayList.size());
                methodBuilder2.callMethod((short)184, expressionClassBuilder.getBaseClassName(), "allocateQualArray", "void", 3);
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    this.generateSingleQualifierCode(methodBuilder2, optimizable, bl2, expressionClassBuilder, (RelationalOperator)arrayList.get(i2), localField, n2, i2);
                }
                ++n3;
                ++n6;
                ++n2;
            }
        }
        methodBuilder.getField(localField);
    }

    private void orderQualifiers() {
        int n2;
        PredicateList[] predicateListArray = new PredicateList[5];
        for (n2 = predicateListArray.length - 1; n2 >= 0; --n2) {
            predicateListArray[n2] = new PredicateList(this.getContextManager());
        }
        for (Predicate predicate : this) {
            if (!predicate.isQualifier()) {
                predicateListArray[3].addElement(predicate);
                continue;
            }
            AndNode andNode = predicate.getAndNode();
            if (!(andNode.getLeftOperand() instanceof OrNode)) {
                RelationalOperator relationalOperator = (RelationalOperator)((Object)andNode.getLeftOperand());
                int n3 = relationalOperator.getOperator();
                switch (n3) {
                    case 1: 
                    case 7: {
                        predicateListArray[0].addElement(predicate);
                        break;
                    }
                    case 2: 
                    case 8: {
                        predicateListArray[2].addElement(predicate);
                        break;
                    }
                    default: {
                        predicateListArray[1].addElement(predicate);
                        break;
                    }
                }
                continue;
            }
            predicateListArray[4].addElement(predicate);
        }
        n2 = 0;
        for (int i2 = 0; i2 < 5; ++i2) {
            for (int i3 = 0; i3 < predicateListArray[i2].size(); ++i3) {
                this.setElementAt(predicateListArray[i2].elementAt(i3), n2++);
            }
        }
    }

    @Override
    public void generateStartKey(ExpressionClassBuilderInterface expressionClassBuilderInterface, MethodBuilder methodBuilder, Optimizable optimizable) throws StandardException {
        ExpressionClassBuilder expressionClassBuilder = (ExpressionClassBuilder)expressionClassBuilderInterface;
        if (this.numberOfStartPredicates != 0) {
            MethodBuilder methodBuilder2 = expressionClassBuilder.newExprFun();
            LocalField localField = this.generateIndexableRow(expressionClassBuilder, this.numberOfStartPredicates);
            int n2 = 0;
            for (Predicate predicate : this) {
                if (!predicate.isStartKey()) continue;
                this.generateSetColumn(expressionClassBuilder, methodBuilder2, n2, predicate, optimizable, localField, true);
                ++n2;
            }
            this.finishKey(expressionClassBuilder, methodBuilder, methodBuilder2, localField);
            return;
        }
        methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
    }

    @Override
    public boolean sameStartStopPosition() throws StandardException {
        if (this.numberOfStartPredicates != this.numberOfStopPredicates) {
            return false;
        }
        for (Predicate predicate : this) {
            if (predicate.isStartKey() && !predicate.isStopKey() || predicate.isStopKey() && !predicate.isStartKey()) {
                return false;
            }
            if (!(predicate.getAndNode().getLeftOperand() instanceof InListOperatorNode)) continue;
            return false;
        }
        return true;
    }

    private LocalField generateIndexableRow(ExpressionClassBuilder expressionClassBuilder, int n2) {
        MethodBuilder methodBuilder = expressionClassBuilder.getConstructor();
        expressionClassBuilder.pushGetExecutionFactoryExpression(methodBuilder);
        methodBuilder.push(n2);
        methodBuilder.callMethod((short)185, "org.apache.derby.iapi.sql.execute.ExecutionFactory", "getIndexableRow", "org.apache.derby.iapi.sql.execute.ExecIndexRow", 1);
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.ExecIndexRow");
        methodBuilder.setField(localField);
        return localField;
    }

    private void generateSetColumn(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, int n2, Predicate predicate, Optimizable optimizable, LocalField localField, boolean bl2) throws StandardException {
        MethodBuilder methodBuilder2;
        boolean bl3 = false;
        if (predicate.compareWithKnownConstant(optimizable, false)) {
            bl3 = true;
            methodBuilder2 = expressionClassBuilder.getConstructor();
        } else {
            methodBuilder2 = methodBuilder;
        }
        int[] nArray = optimizable.getTrulyTheBestAccessPath().getConglomerateDescriptor().getIndexDescriptor().baseColumnPositions();
        boolean[] blArray = optimizable.getTrulyTheBestAccessPath().getConglomerateDescriptor().getIndexDescriptor().isAscending();
        boolean bl4 = predicate.getAndNode().getLeftOperand() instanceof InListOperatorNode;
        methodBuilder2.getField(localField);
        methodBuilder2.push(n2 + 1);
        if (bl4) {
            predicate.getSourceInList().generateStartStopKey(blArray[n2], bl2, expressionClassBuilder, methodBuilder2);
        } else {
            predicate.generateExpressionOperand(optimizable, nArray[n2], expressionClassBuilder, methodBuilder2);
        }
        methodBuilder2.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
        methodBuilder2.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
        if (!bl4) {
            RelationalOperator relationalOperator = predicate.getRelop();
            boolean bl5 = relationalOperator.orderedNulls();
            if (!bl5 && !relationalOperator.getColumnOperand(optimizable).getTypeServices().isNullable()) {
                if (bl3) {
                    bl5 = true;
                } else {
                    ValueNode valueNode = relationalOperator.getExpressionOperand(optimizable.getTableNumber(), nArray[n2], (FromTable)optimizable);
                    if (valueNode instanceof ColumnReference) {
                        boolean bl6 = bl5 = !((ColumnReference)valueNode).getTypeServices().isNullable();
                    }
                }
            }
            if (bl5) {
                methodBuilder2.getField(localField);
                methodBuilder2.push(n2);
                methodBuilder2.callMethod((short)185, "org.apache.derby.iapi.sql.execute.ExecIndexRow", "orderedNulls", "void", 1);
            }
        }
    }

    private void finishKey(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, MethodBuilder methodBuilder2, LocalField localField) {
        methodBuilder2.getField(localField);
        methodBuilder2.methodReturn();
        methodBuilder2.complete();
        expressionClassBuilder.pushMethodReference(methodBuilder, methodBuilder2);
    }

    boolean constantColumn(ColumnReference columnReference) {
        boolean bl2 = false;
        for (Predicate predicate : this) {
            ValueNode valueNode;
            RelationalOperator relationalOperator = predicate.getRelop();
            if (!predicate.isRelationalOpPredicate()) continue;
            if (relationalOperator.getOperator() == 1) {
                valueNode = relationalOperator.getOperand(columnReference, predicate.getReferencedSet().size(), true);
                if (valueNode == null || !valueNode.isConstantExpression()) continue;
                bl2 = true;
                break;
            }
            if (relationalOperator.getOperator() != 7 || (valueNode = (ColumnReference)relationalOperator.getOperand(columnReference, predicate.getReferencedSet().size(), false)) == null) continue;
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public void adjustForSortElimination(RequiredRowOrdering requiredRowOrdering) throws StandardException {
        if (requiredRowOrdering == null) {
            return;
        }
        OrderByList orderByList = (OrderByList)requiredRowOrdering;
        for (Predicate predicate : this) {
            BinaryRelationalOperatorNode binaryRelationalOperatorNode;
            if (!predicate.isInListProbePredicate() || !orderByList.requiresDescending((ColumnReference)(binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)predicate.getRelop()).getLeftOperand(), predicate.getReferencedSet().size())) continue;
            predicate.getSourceInList(true).markSortDescending();
        }
    }

    @Override
    public double selectivity(Optimizable optimizable) throws StandardException {
        Object object;
        int n2;
        int n3;
        int n4;
        TableDescriptor tableDescriptor = optimizable.getTableDescriptor();
        ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
        int n5 = this.size();
        int n6 = conglomerateDescriptorArray.length;
        if (n6 == 1) {
            return -1.0;
        }
        if (n5 == 0) {
            return -1.0;
        }
        boolean bl2 = true;
        PredicateList predicateList = new PredicateList(this.getContextManager());
        for (n4 = 0; n4 < n5; ++n4) {
            if (this.isRedundantPredicate(n4)) continue;
            predicateList.addOptPredicate((OptimizablePredicate)this.elementAt(n4));
        }
        n4 = predicateList.size();
        PredicateWrapperList[] predicateWrapperListArray = new PredicateWrapperList[n6];
        for (n3 = 0; n3 < n6; ++n3) {
            ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[n3];
            if (!conglomerateDescriptor.isIndex() || !tableDescriptor.statisticsExist(conglomerateDescriptor)) continue;
            int[] nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
            for (int i2 = 0; i2 < n4; ++i2) {
                Predicate predicate = (Predicate)predicateList.elementAt(i2);
                n2 = predicate.hasEqualOnColumnList(nArray, optimizable);
                if (n2 < 0) continue;
                bl2 = false;
                if (predicateWrapperListArray[n3] == null) {
                    predicateWrapperListArray[n3] = new PredicateWrapperList(n4);
                }
                object = new PredicateWrapper(n2, predicate, i2);
                predicateWrapperListArray[n3].insert((PredicateWrapper)object);
            }
        }
        if (bl2) {
            return -1.0;
        }
        n3 = -1;
        for (int i3 = 0; i3 < n6; ++i3) {
            if (predicateWrapperListArray[i3] == null) continue;
            predicateWrapperListArray[i3].retainLeadingContiguous();
        }
        this.calculateWeight(predicateWrapperListArray, n4);
        double d2 = 1.0;
        ArrayList<Predicate> arrayList = new ArrayList<Predicate>();
        do {
            arrayList.clear();
            int n7 = this.chooseLongestMatch(predicateWrapperListArray, arrayList, n4);
            if (n7 == -1) break;
            d2 *= tableDescriptor.selectivityForConglomerate(conglomerateDescriptorArray[n7], arrayList.size());
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                object = arrayList.get(n2);
                predicateList.removeOptPredicate((OptimizablePredicate)object);
            }
        } while (predicateList.size() != 0);
        if (predicateList.size() != 0) {
            d2 *= predicateList.selectivityNoStatistics(optimizable);
        }
        return d2;
    }

    private void calculateWeight(PredicateWrapperList[] predicateWrapperListArray, int n2) {
        int n3;
        int n4;
        int[] nArray = new int[n2];
        for (n4 = 0; n4 < predicateWrapperListArray.length; ++n4) {
            if (predicateWrapperListArray[n4] == null) continue;
            for (n3 = 0; n3 < predicateWrapperListArray[n4].size(); ++n3) {
                int n5 = predicateWrapperListArray[n4].elementAt(n3).getPredicateID();
                nArray[n5] = nArray[n5] + (n2 - n3);
            }
        }
        for (n4 = 0; n4 < predicateWrapperListArray.length; ++n4) {
            n3 = 0;
            if (predicateWrapperListArray[n4] == null) continue;
            for (int i2 = 0; i2 < predicateWrapperListArray[n4].size(); ++i2) {
                n3 += nArray[predicateWrapperListArray[n4].elementAt(i2).getPredicateID()];
            }
            predicateWrapperListArray[n4].setWeight(n3);
        }
    }

    private int chooseLongestMatch(PredicateWrapperList[] predicateWrapperListArray, List<Predicate> list, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        for (int i2 = 0; i2 < predicateWrapperListArray.length; ++i2) {
            if (predicateWrapperListArray[i2] == null || predicateWrapperListArray[i2].uniqueSize() == 0) continue;
            if (predicateWrapperListArray[i2].uniqueSize() > n4) {
                n4 = predicateWrapperListArray[i2].uniqueSize();
                n6 = i2;
                n5 = predicateWrapperListArray[i2].getWeight();
            }
            if (predicateWrapperListArray[i2].uniqueSize() != n4 || predicateWrapperListArray[i2].getWeight() > n5) continue;
            n6 = i2;
            n4 = predicateWrapperListArray[i2].uniqueSize();
            n5 = predicateWrapperListArray[i2].getWeight();
        }
        if (n6 == -1) {
            return -1;
        }
        PredicateWrapperList predicateWrapperList = predicateWrapperListArray[n6];
        List list2 = predicateWrapperList.createLeadingUnique();
        for (n3 = 0; n3 < list2.size(); ++n3) {
            Predicate predicate = ((PredicateWrapper)list2.get(n3)).getPredicate();
            list.add(predicate);
            for (int i3 = 0; i3 < predicateWrapperListArray.length; ++i3) {
                if (predicateWrapperListArray[i3] == null) continue;
                predicateWrapperList = predicateWrapperListArray[i3];
                predicateWrapperList.removeElement(predicate);
            }
        }
        for (n3 = 0; n3 < predicateWrapperListArray.length; ++n3) {
            if (predicateWrapperListArray[n3] == null) continue;
            predicateWrapperListArray[n3].retainLeadingContiguous();
        }
        this.calculateWeight(predicateWrapperListArray, n2);
        return n6;
    }

    private double selectivityNoStatistics(Optimizable optimizable) throws StandardException {
        double d2 = 1.0;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            OptimizablePredicate optimizablePredicate = (OptimizablePredicate)this.elementAt(i2);
            d2 *= optimizablePredicate.selectivity(optimizable);
        }
        return d2;
    }

    private static class PredicateWrapperList {
        private final ArrayList<PredicateWrapper> pwList;
        int numPreds;
        int numDuplicates;
        int weight;

        PredicateWrapperList(int n2) {
            this.pwList = new ArrayList(n2);
        }

        void removeElement(Predicate predicate) {
            for (int i2 = this.numPreds - 1; i2 >= 0; --i2) {
                Predicate predicate2 = this.elementAt(i2).getPredicate();
                if (predicate2 != predicate) continue;
                this.removeElementAt(i2);
            }
        }

        void removeElementAt(int n2) {
            PredicateWrapper predicateWrapper;
            if (n2 < this.numPreds - 1 && (predicateWrapper = this.elementAt(n2 + 1)).getIndexPosition() == n2) {
                --this.numDuplicates;
            }
            this.pwList.remove(n2);
            --this.numPreds;
        }

        PredicateWrapper elementAt(int n2) {
            return this.pwList.get(n2);
        }

        void insert(PredicateWrapper predicateWrapper) {
            int n2;
            for (n2 = 0; n2 < this.pwList.size(); ++n2) {
                if (predicateWrapper.getIndexPosition() == this.elementAt(n2).getIndexPosition()) {
                    ++this.numDuplicates;
                }
                if (predicateWrapper.before(this.elementAt(n2))) break;
            }
            ++this.numPreds;
            this.pwList.add(n2, predicateWrapper);
        }

        int size() {
            return this.numPreds;
        }

        int uniqueSize() {
            if (this.numPreds > 0) {
                return this.numPreds - this.numDuplicates;
            }
            return 0;
        }

        void retainLeadingContiguous() {
            int n2;
            if (this.pwList.isEmpty()) {
                return;
            }
            if (this.elementAt(0).getIndexPosition() != 0) {
                this.pwList.clear();
                this.numDuplicates = 0;
                this.numPreds = 0;
                return;
            }
            for (n2 = 0; n2 < this.numPreds - 1 && this.elementAt(n2).contiguous(this.elementAt(n2 + 1)); ++n2) {
            }
            for (int i2 = this.numPreds - 1; i2 > n2; --i2) {
                if (this.elementAt(i2).getIndexPosition() == this.elementAt(i2 - 1).getIndexPosition()) {
                    --this.numDuplicates;
                }
                this.pwList.remove(i2);
            }
            this.numPreds = n2 + 1;
        }

        private List<PredicateWrapper> createLeadingUnique() {
            if (this.numPreds == 0) {
                return null;
            }
            int n2 = this.elementAt(0).getIndexPosition();
            if (n2 != 0) {
                return null;
            }
            ArrayList<PredicateWrapper> arrayList = new ArrayList<PredicateWrapper>();
            arrayList.add(this.elementAt(0));
            for (int i2 = 1; i2 < this.numPreds; ++i2) {
                if (this.elementAt(i2).getIndexPosition() == n2) continue;
                n2 = this.elementAt(i2).getIndexPosition();
                arrayList.add(this.elementAt(i2));
            }
            return arrayList;
        }

        void setWeight(int n2) {
            this.weight = n2;
        }

        int getWeight() {
            return this.weight;
        }
    }

    private static class PredicateWrapper {
        int indexPosition;
        Predicate pred;
        int predicateID;

        PredicateWrapper(int n2, Predicate predicate, int n3) {
            this.indexPosition = n2;
            this.pred = predicate;
            this.predicateID = n3;
        }

        int getIndexPosition() {
            return this.indexPosition;
        }

        Predicate getPredicate() {
            return this.pred;
        }

        int getPredicateID() {
            return this.predicateID;
        }

        boolean before(PredicateWrapper predicateWrapper) {
            return this.indexPosition < predicateWrapper.getIndexPosition();
        }

        boolean contiguous(PredicateWrapper predicateWrapper) {
            int n2 = predicateWrapper.getIndexPosition();
            return this.indexPosition == n2 || this.indexPosition - n2 == 1 || this.indexPosition - n2 == -1;
        }
    }
}

