/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashSet;
import java.util.Set;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BaseTableNumbersVisitor;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.InListOperatorNode;
import org.apache.derby.impl.sql.compile.OrNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

public final class Predicate
extends QueryTreeNode
implements Comparable<Predicate>,
OptimizablePredicate {
    AndNode andNode;
    boolean pushable;
    JBitSet referencedSet;
    int equivalenceClass = -1;
    int indexPosition;
    protected boolean startKey;
    protected boolean stopKey;
    protected boolean isQualifier;
    private Set<Integer> searchClauses;
    private boolean scoped;

    Predicate(AndNode andNode, JBitSet jBitSet, ContextManager contextManager) {
        super(contextManager);
        this.andNode = andNode;
        this.pushable = false;
        this.referencedSet = jBitSet;
        this.scoped = false;
    }

    @Override
    public JBitSet getReferencedMap() {
        return this.referencedSet;
    }

    @Override
    public boolean hasSubquery() {
        return !this.pushable;
    }

    @Override
    public boolean hasMethodCall() {
        return !this.pushable;
    }

    @Override
    public void markStartKey() {
        this.startKey = true;
    }

    @Override
    public boolean isStartKey() {
        return this.startKey;
    }

    @Override
    public void markStopKey() {
        this.stopKey = true;
    }

    @Override
    public boolean isStopKey() {
        return this.stopKey;
    }

    @Override
    public void markQualifier() {
        this.isQualifier = true;
    }

    @Override
    public boolean isQualifier() {
        return this.isQualifier;
    }

    @Override
    public boolean compareWithKnownConstant(Optimizable optimizable, boolean bl2) {
        boolean bl3 = false;
        RelationalOperator relationalOperator = this.getRelop();
        if (!this.isRelationalOpPredicate()) {
            return false;
        }
        if (relationalOperator.compareWithKnownConstant(optimizable, bl2)) {
            bl3 = true;
        }
        return bl3;
    }

    @Override
    public int hasEqualOnColumnList(int[] nArray, Optimizable optimizable) throws StandardException {
        RelationalOperator relationalOperator = this.getRelop();
        if (!this.isRelationalOpPredicate()) {
            return -1;
        }
        if (relationalOperator.getOperator() != 1) {
            return -1;
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            ColumnReference columnReference = relationalOperator.getColumnOperand(optimizable, nArray[i2]);
            if (columnReference == null || relationalOperator.selfComparison(columnReference)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public DataValueDescriptor getCompareValue(Optimizable optimizable) throws StandardException {
        RelationalOperator relationalOperator = this.getRelop();
        return relationalOperator.getCompareValue(optimizable);
    }

    @Override
    public boolean equalsComparisonWithConstantExpression(Optimizable optimizable) {
        boolean bl2 = false;
        if (this.isRelationalOpPredicate()) {
            bl2 = this.getRelop().equalsComparisonWithConstantExpression(optimizable);
        }
        return bl2;
    }

    @Override
    public double selectivity(Optimizable optimizable) throws StandardException {
        return this.andNode.getLeftOperand().selectivity(optimizable);
    }

    @Override
    public int getIndexPosition() {
        return this.indexPosition;
    }

    @Override
    public int compareTo(Predicate predicate) {
        boolean bl2;
        int n2;
        Predicate predicate2 = predicate;
        int n3 = predicate2.getIndexPosition();
        if (this.indexPosition < n3) {
            return -1;
        }
        if (this.indexPosition > n3) {
            return 1;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        boolean bl6 = true;
        if (this.isRelationalOpPredicate() || this.isInListProbePredicate()) {
            n2 = ((RelationalOperator)((Object)this.andNode.getLeftOperand())).getOperator();
            bl3 = n2 == 1 || n2 == 7;
            boolean bl7 = bl5 = n2 == 2 || n2 == 8;
        }
        if (predicate2.isRelationalOpPredicate() || predicate2.isInListProbePredicate()) {
            n2 = ((RelationalOperator)((Object)predicate2.getAndNode().getLeftOperand())).getOperator();
            bl4 = n2 == 1 || n2 == 7;
            bl6 = n2 == 2 || n2 == 8;
        }
        int n4 = n2 = bl3 && !bl4 || !bl5 && bl6 ? 1 : 0;
        if (n2 != 0) {
            return -1;
        }
        boolean bl8 = bl2 = bl4 && !bl3 || !bl6 && bl5;
        if (bl2) {
            return 1;
        }
        return 0;
    }

    AndNode getAndNode() {
        return this.andNode;
    }

    void setAndNode(AndNode andNode) {
        this.andNode = andNode;
    }

    boolean getPushable() {
        return this.pushable;
    }

    void setPushable(boolean bl2) {
        this.pushable = bl2;
    }

    JBitSet getReferencedSet() {
        return this.referencedSet;
    }

    void setEquivalenceClass(int n2) {
        this.equivalenceClass = n2;
    }

    int getEquivalenceClass() {
        return this.equivalenceClass;
    }

    void categorize() throws StandardException {
        this.pushable = this.andNode.categorize(this.referencedSet, false);
    }

    RelationalOperator getRelop() {
        if (this.andNode.getLeftOperand() instanceof RelationalOperator) {
            return (RelationalOperator)((Object)this.andNode.getLeftOperand());
        }
        return null;
    }

    final boolean isOrList() {
        return this.andNode.getLeftOperand() instanceof OrNode;
    }

    final boolean isStoreQualifier() {
        return this.andNode.getLeftOperand() instanceof RelationalOperator || this.andNode.getLeftOperand() instanceof OrNode;
    }

    final boolean isPushableOrClause(Optimizable optimizable) throws StandardException {
        boolean bl2 = true;
        if (this.andNode.getLeftOperand() instanceof OrNode) {
            ValueNode valueNode = this.andNode.getLeftOperand();
            while (valueNode instanceof OrNode) {
                OrNode orNode = (OrNode)valueNode;
                if (orNode.getLeftOperand() instanceof RelationalOperator) {
                    if (!((RelationalOperator)((Object)orNode.getLeftOperand())).isQualifier(optimizable, true)) {
                        return false;
                    }
                    valueNode = orNode.getRightOperand();
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    boolean transitiveSearchClauseAdded(RelationalOperator relationalOperator) {
        return this.searchClauses != null && this.searchClauses.contains(relationalOperator.getOperator());
    }

    void setTransitiveSearchClauseAdded(RelationalOperator relationalOperator) {
        if (this.searchClauses == null) {
            this.searchClauses = new HashSet<Integer>();
        }
        this.searchClauses.add(relationalOperator.getOperator());
    }

    int getStartOperator(Optimizable optimizable) {
        if (this.andNode.getLeftOperand() instanceof InListOperatorNode) {
            return 1;
        }
        return this.getRelop().getStartOperator(optimizable);
    }

    int getStopOperator(Optimizable optimizable) {
        if (this.andNode.getLeftOperand() instanceof InListOperatorNode) {
            return -1;
        }
        return this.getRelop().getStopOperator(optimizable);
    }

    void setIndexPosition(int n2) {
        this.indexPosition = n2;
    }

    void clearScanFlags() {
        this.startKey = false;
        this.stopKey = false;
        this.isQualifier = false;
    }

    void generateExpressionOperand(Optimizable optimizable, int n2, ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.getRelop().generateExpressionOperand(optimizable, n2, expressionClassBuilder, methodBuilder);
    }

    @Override
    public String toString() {
        return "";
    }

    String binaryRelOpColRefsToString() {
        if (!(this.getAndNode().getLeftOperand() instanceof BinaryRelationalOperatorNode)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)this.getAndNode().getLeftOperand();
        if (binaryRelationalOperatorNode.getLeftOperand() instanceof ColumnReference) {
            stringBuilder.append(((ColumnReference)binaryRelationalOperatorNode.getLeftOperand()).getTableName());
            stringBuilder.append('.');
            stringBuilder.append(((ColumnReference)binaryRelationalOperatorNode.getLeftOperand()).getColumnName());
        } else {
            stringBuilder.append("<expr>");
        }
        stringBuilder.append(' ');
        stringBuilder.append(binaryRelationalOperatorNode.operator);
        stringBuilder.append(' ');
        if (binaryRelationalOperatorNode.getRightOperand() instanceof ColumnReference) {
            stringBuilder.append(((ColumnReference)binaryRelationalOperatorNode.getRightOperand()).getTableName() + "." + ((ColumnReference)binaryRelationalOperatorNode.getRightOperand()).getColumnName());
        } else {
            stringBuilder.append("<expr>");
        }
        return stringBuilder.toString();
    }

    @Override
    void printSubNodes(int n2) {
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.andNode != null) {
            this.andNode = (AndNode)this.andNode.accept(visitor);
        }
    }

    void copyFields(Predicate predicate) {
        this.equivalenceClass = predicate.getEquivalenceClass();
        this.indexPosition = predicate.getIndexPosition();
        this.startKey = predicate.isStartKey();
        this.stopKey = predicate.isStopKey();
        this.isQualifier = predicate.isQualifier();
        this.searchClauses = predicate.searchClauses;
    }

    protected boolean pushableToSubqueries() throws StandardException {
        if (!this.isJoinPredicate()) {
            return false;
        }
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)this.getAndNode().getLeftOperand();
        JBitSet jBitSet = new JBitSet(this.getReferencedSet().size());
        BaseTableNumbersVisitor baseTableNumbersVisitor = new BaseTableNumbersVisitor(jBitSet);
        binaryRelationalOperatorNode.getLeftOperand().accept(baseTableNumbersVisitor);
        if (jBitSet.getFirstSetBit() == -1) {
            return false;
        }
        jBitSet.clearAll();
        binaryRelationalOperatorNode.getRightOperand().accept(baseTableNumbersVisitor);
        return jBitSet.getFirstSetBit() != -1;
    }

    protected boolean isJoinPredicate() {
        if (!(this.getAndNode().getLeftOperand() instanceof BinaryRelationalOperatorNode)) {
            return false;
        }
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)this.getAndNode().getLeftOperand();
        return binaryRelationalOperatorNode.getLeftOperand() instanceof ColumnReference && binaryRelationalOperatorNode.getRightOperand() instanceof ColumnReference && ((ColumnReference)binaryRelationalOperatorNode.getLeftOperand()).getTableNumber() != ((ColumnReference)binaryRelationalOperatorNode.getRightOperand()).getTableNumber();
    }

    protected Predicate getPredScopedForResultSet(JBitSet jBitSet, ResultSetNode resultSetNode, int[] nArray) throws StandardException {
        if (!(this.getAndNode().getLeftOperand() instanceof BinaryRelationalOperatorNode)) {
            return this;
        }
        BooleanConstantNode booleanConstantNode = new BooleanConstantNode(true, this.getContextManager());
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)this.getAndNode().getLeftOperand();
        BinaryRelationalOperatorNode binaryRelationalOperatorNode2 = new BinaryRelationalOperatorNode(binaryRelationalOperatorNode.kind, binaryRelationalOperatorNode.getScopedOperand(-1, jBitSet, resultSetNode, nArray), binaryRelationalOperatorNode.getScopedOperand(1, jBitSet, resultSetNode, nArray), binaryRelationalOperatorNode.getForQueryRewrite(), this.getContextManager());
        binaryRelationalOperatorNode2.bindComparisonOperator();
        AndNode andNode = new AndNode(binaryRelationalOperatorNode2, booleanConstantNode, this.getContextManager());
        andNode.postBindFixup();
        JBitSet jBitSet2 = new JBitSet(resultSetNode.getReferencedTableMap().size());
        andNode.categorize(jBitSet2, false);
        Predicate predicate = new Predicate(andNode, jBitSet2, this.getContextManager());
        predicate.clearScanFlags();
        predicate.copyFields(this);
        predicate.setPushable(this.getPushable());
        predicate.markAsScopedForPush();
        return predicate;
    }

    protected void markAsScopedForPush() {
        this.scoped = true;
    }

    protected boolean isScopedForPush() {
        return this.scoped;
    }

    protected boolean remapScopedPred() {
        if (!this.scoped) {
            return false;
        }
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)this.andNode.getLeftOperand();
        ValueNode valueNode = binaryRelationalOperatorNode.getLeftOperand();
        if (valueNode instanceof ColumnReference && ((ColumnReference)valueNode).isScoped()) {
            ((ColumnReference)valueNode).remapColumnReferences();
        } else {
            valueNode = binaryRelationalOperatorNode.getRightOperand();
            if (valueNode instanceof ColumnReference && ((ColumnReference)valueNode).isScoped()) {
                ((ColumnReference)valueNode).remapColumnReferences();
            }
        }
        return true;
    }

    protected boolean isScopedToSourceResultSet() throws StandardException {
        if (!this.scoped) {
            return false;
        }
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)this.andNode.getLeftOperand();
        ValueNode valueNode = binaryRelationalOperatorNode.getLeftOperand();
        if (!(valueNode instanceof ColumnReference)) {
            return false;
        }
        ColumnReference columnReference = (ColumnReference)valueNode;
        if (columnReference.isScoped()) {
            ValueNode valueNode2 = columnReference.getSource().getExpression();
            return valueNode2 instanceof VirtualColumnNode || valueNode2 instanceof ColumnReference;
        }
        valueNode = binaryRelationalOperatorNode.getRightOperand();
        if (!(valueNode instanceof ColumnReference)) {
            return false;
        }
        columnReference = (ColumnReference)valueNode;
        ValueNode valueNode3 = columnReference.getSource().getExpression();
        return valueNode3 instanceof VirtualColumnNode || valueNode3 instanceof ColumnReference;
    }

    protected boolean isRelationalOpPredicate() {
        return this.andNode.getLeftOperand().isRelationalOperator();
    }

    protected boolean isInListProbePredicate() {
        return this.andNode.getLeftOperand().isInListProbeNode();
    }

    protected InListOperatorNode getSourceInList() {
        return this.getSourceInList(false);
    }

    protected InListOperatorNode getSourceInList(boolean bl2) {
        ValueNode valueNode = this.andNode.getLeftOperand();
        if (this.isInListProbePredicate()) {
            return ((BinaryRelationalOperatorNode)valueNode).getInListOp();
        }
        if (bl2) {
            return null;
        }
        if (valueNode instanceof InListOperatorNode) {
            return (InListOperatorNode)valueNode;
        }
        return null;
    }
}

