/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashMap;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.OptTrace;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizableList;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.OptimizerPlan;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueTupleDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.BaseTableNumbersVisitor;
import org.apache.derby.impl.sql.compile.CostEstimateImpl;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowOrderingImpl;
import org.apache.derby.impl.sql.compile.StaticMethodCallNode;

class OptimizerImpl
implements Optimizer {
    private LanguageConnectionContext lcc;
    private DataDictionary dDictionary;
    private int numTablesInQuery;
    private int numOptimizables;
    private JBitSet assignedTableMap;
    private OptimizableList optimizableList;
    private OptimizerPlan overridingPlan;
    private OptimizerPlan currentPlan;
    private OptimizablePredicateList predicateList;
    private JBitSet nonCorrelatedTableMap;
    private int[] proposedJoinOrder;
    private int[] bestJoinOrder;
    private int joinPosition;
    private boolean desiredJoinOrderFound;
    private static final int NO_JUMP = 0;
    private static final int READY_TO_JUMP = 1;
    private static final int JUMPING = 2;
    private static final int WALK_HIGH = 3;
    private static final int WALK_LOW = 4;
    private int permuteState;
    private int[] firstLookOrder;
    private boolean ruleBasedOptimization;
    private CostEstimateImpl outermostCostEstimate;
    private CostEstimateImpl currentCost;
    private CostEstimateImpl currentSortAvoidanceCost;
    private CostEstimateImpl bestCost;
    private long timeOptimizationStarted;
    private long currentTime;
    private boolean timeExceeded;
    private boolean noTimeout;
    private boolean useStatistics;
    private int tableLockThreshold;
    private JoinStrategy[] joinStrategies;
    private RequiredRowOrdering requiredRowOrdering;
    private boolean foundABestPlan;
    private CostEstimate sortCost;
    private RowOrdering currentRowOrdering = new RowOrderingImpl();
    private RowOrdering bestRowOrdering = new RowOrderingImpl();
    private int maxMemoryPerTable;
    private boolean reloadBestPlan;
    private HashMap<Object, int[]> savedJoinOrders;
    private double timeLimit;
    private CostEstimate finalCostEstimate;
    private boolean usingPredsPushedFromAbove;
    private boolean bestJoinOrderUsedPredsFromAbove;

    OptimizerImpl(OptimizableList optimizableList, OptimizablePredicateList optimizablePredicateList, DataDictionary dataDictionary, boolean bl2, boolean bl3, boolean bl4, int n2, JoinStrategy[] joinStrategyArray, int n3, RequiredRowOrdering requiredRowOrdering, int n4, OptimizerPlan optimizerPlan, LanguageConnectionContext languageConnectionContext) throws StandardException {
        int n5;
        this.outermostCostEstimate = this.getNewCostEstimate(0.0, 1.0, 1.0);
        this.currentCost = this.getNewCostEstimate(0.0, 0.0, 0.0);
        this.currentSortAvoidanceCost = this.getNewCostEstimate(0.0, 0.0, 0.0);
        this.bestCost = this.getNewCostEstimate(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        optimizableList.verifyProperties(dataDictionary);
        this.numTablesInQuery = n4;
        this.numOptimizables = optimizableList.size();
        this.proposedJoinOrder = new int[this.numOptimizables];
        if (this.initJumpState() == 1) {
            this.firstLookOrder = new int[this.numOptimizables];
        }
        for (n5 = 0; n5 < this.numOptimizables; ++n5) {
            this.proposedJoinOrder[n5] = -1;
        }
        this.bestJoinOrder = new int[this.numOptimizables];
        this.joinPosition = -1;
        this.optimizableList = optimizableList;
        this.overridingPlan = optimizerPlan;
        this.predicateList = optimizablePredicateList;
        this.dDictionary = dataDictionary;
        this.ruleBasedOptimization = bl2;
        this.noTimeout = bl3;
        this.maxMemoryPerTable = n2;
        this.joinStrategies = joinStrategyArray;
        this.tableLockThreshold = n3;
        this.requiredRowOrdering = requiredRowOrdering;
        this.useStatistics = bl4;
        this.lcc = languageConnectionContext;
        this.assignedTableMap = new JBitSet(n4);
        this.nonCorrelatedTableMap = new JBitSet(n4);
        for (n5 = 0; n5 < this.numOptimizables; ++n5) {
            Optimizable optimizable = optimizableList.getOptimizable(n5);
            this.nonCorrelatedTableMap.or(optimizable.getReferencedTableMap());
        }
        this.timeOptimizationStarted = System.currentTimeMillis();
        this.reloadBestPlan = false;
        this.savedJoinOrders = null;
        this.timeLimit = Double.MAX_VALUE;
        this.usingPredsPushedFromAbove = false;
        this.bestJoinOrderUsedPredsFromAbove = false;
        if (this.tracingIsOn()) {
            this.tracer().traceStartQueryBlock(this.timeOptimizationStarted, this.hashCode(), optimizableList);
        }
        if (optimizerPlan != null) {
            int n6;
            if (!optimizerPlan.isBound()) {
                throw StandardException.newException("42ZCE", new Object[0]);
            }
            n5 = optimizableList.size();
            if (n5 != (n6 = optimizerPlan.countLeafNodes())) {
                throw StandardException.newException("42ZCC", n6, n5);
            }
        }
    }

    @Override
    public void prepForNextRound() {
        this.reloadBestPlan = false;
        this.bestCost = this.getNewCostEstimate(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        this.usingPredsPushedFromAbove = false;
        if (this.predicateList != null && this.predicateList.size() > 0) {
            for (int i2 = this.predicateList.size() - 1; i2 >= 0; --i2) {
                if (!((Predicate)this.predicateList.getOptPredicate(i2)).isScopedForPush()) continue;
                this.usingPredsPushedFromAbove = true;
                break;
            }
        }
        if (this.usingPredsPushedFromAbove) {
            this.timeOptimizationStarted = System.currentTimeMillis();
            this.timeExceeded = false;
        }
        this.desiredJoinOrderFound = false;
        this.initJumpState();
    }

    private int initJumpState() {
        this.permuteState = this.numTablesInQuery >= 6 ? 1 : 0;
        return this.permuteState;
    }

    private boolean tracingIsOn() {
        return this.lcc.optimizerTracingIsOn();
    }

    @Override
    public int getMaxMemoryPerTable() {
        return this.maxMemoryPerTable;
    }

    @Override
    public boolean getNextPermutation() throws StandardException {
        boolean bl2;
        if (this.numOptimizables < 1) {
            if (this.tracingIsOn()) {
                this.tracer().traceVacuous();
            }
            this.endOfRoundCleanup();
            return false;
        }
        this.optimizableList.initAccessPaths(this);
        if (!this.timeExceeded && this.numTablesInQuery > 6 && !this.noTimeout) {
            this.currentTime = System.currentTimeMillis();
            boolean bl3 = this.timeExceeded = (double)(this.currentTime - this.timeOptimizationStarted) > this.timeLimit;
            if (this.tracingIsOn() && this.timeExceeded) {
                this.tracer().traceTimeout(this.currentTime, this.bestCost);
            }
        }
        if (this.bestCost.isUninitialized() && this.foundABestPlan && (!this.usingPredsPushedFromAbove && !this.bestJoinOrderUsedPredsFromAbove || this.timeExceeded)) {
            if (this.permuteState != 2) {
                if (this.firstLookOrder == null) {
                    this.firstLookOrder = new int[this.numOptimizables];
                }
                System.arraycopy(this.bestJoinOrder, 0, this.firstLookOrder, 0, this.numOptimizables);
                this.permuteState = 2;
                if (this.joinPosition >= 0) {
                    this.rewindJoinOrder();
                    this.joinPosition = -1;
                }
            }
            this.timeExceeded = false;
        }
        boolean bl4 = false;
        boolean bl5 = bl2 = !this.bestCost.isUninitialized() && this.currentCost.compare(this.bestCost) > 0.0 && (this.requiredRowOrdering == null || this.currentSortAvoidanceCost.compare(this.bestCost) > 0.0);
        if (this.joinPosition < this.numOptimizables - 1 && !bl2 && !this.timeExceeded) {
            if (this.joinPosition < 0 || this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]).getBestAccessPath().getCostEstimate() != null) {
                ++this.joinPosition;
                bl4 = true;
                this.bestRowOrdering.copy(this.currentRowOrdering);
            }
        } else if (this.joinPosition < this.numOptimizables - 1) {
            if (this.tracingIsOn()) {
                this.tracer().traceShortCircuiting(this.timeExceeded, this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]), this.joinPosition);
            }
            this.reloadBestPlan = true;
        }
        if (this.permuteState == 2 && !bl4 && this.joinPosition >= 0) {
            this.reloadBestPlan = true;
            this.rewindJoinOrder();
            this.permuteState = 0;
        }
        while (this.joinPosition >= 0) {
            int n2;
            int n3;
            int n4;
            int n5 = this.proposedJoinOrder[this.joinPosition] + 1;
            if (this.proposedJoinOrder[this.joinPosition] >= 0) {
                this.pullOptimizableFromJoinOrder();
            }
            if (this.desiredJoinOrderFound || this.timeExceeded) {
                n5 = this.numOptimizables;
            } else if (this.permuteState == 2) {
                n5 = n4 = this.firstLookOrder[this.joinPosition];
                n3 = this.numOptimizables;
                n2 = -1;
                Optimizable optimizable = this.optimizableList.getOptimizable(n5);
                while (!optimizable.legalJoinOrder(this.assignedTableMap)) {
                    if (n2 >= 0) {
                        this.firstLookOrder[this.joinPosition] = n4;
                        this.firstLookOrder[n3] = n2;
                    }
                    if (n3 <= this.joinPosition + 1) {
                        if (this.joinPosition > 0) {
                            --this.joinPosition;
                            this.reloadBestPlan = true;
                            this.rewindJoinOrder();
                        }
                        this.permuteState = 0;
                        break;
                    }
                    this.firstLookOrder[this.joinPosition] = n2 = this.firstLookOrder[--n3];
                    this.firstLookOrder[n3] = n4;
                    n5 = n2;
                    optimizable = this.optimizableList.getOptimizable(n5);
                }
                if (this.permuteState == 0) continue;
                if (this.joinPosition == this.numOptimizables - 1) {
                    this.permuteState = 3;
                }
            } else {
                while (n5 < this.numOptimizables) {
                    n4 = 0;
                    for (n3 = 0; n3 < this.joinPosition; ++n3) {
                        if (this.proposedJoinOrder[n3] != n5) continue;
                        n4 = 1;
                        break;
                    }
                    if (n4 == 0) {
                        if (n5 >= this.numOptimizables || this.joinOrderMeetsDependencies(n5)) break;
                        if (this.tracingIsOn()) {
                            this.tracer().traceSkippingJoinOrder(n5, this.joinPosition, ArrayUtil.copy(this.proposedJoinOrder), (JBitSet)this.assignedTableMap.clone());
                        }
                        if (!this.optimizableList.optimizeJoinOrder()) {
                            if (this.tracingIsOn()) {
                                this.tracer().traceIllegalUserJoinOrder();
                            }
                            throw StandardException.newException("42Y70", new Object[0]);
                        }
                    }
                    ++n5;
                }
            }
            if (n5 >= this.numOptimizables) {
                if (!this.optimizableList.optimizeJoinOrder()) {
                    if (!this.optimizableList.legalJoinOrder(this.numTablesInQuery)) {
                        if (this.tracingIsOn()) {
                            this.tracer().traceIllegalUserJoinOrder();
                        }
                        throw StandardException.newException("42Y70", new Object[0]);
                    }
                    if (this.tracingIsOn()) {
                        this.tracer().traceUserJoinOrderOptimized();
                    }
                    this.desiredJoinOrderFound = true;
                }
                if (this.permuteState == 1 && this.joinPosition > 0 && this.joinPosition == this.numOptimizables - 1) {
                    this.permuteState = 2;
                    double[] dArray = new double[this.numOptimizables];
                    for (n3 = 0; n3 < this.numOptimizables; ++n3) {
                        this.firstLookOrder[n3] = n3;
                        CostEstimate costEstimate = this.optimizableList.getOptimizable(n3).getBestAccessPath().getCostEstimate();
                        if (costEstimate == null) {
                            this.permuteState = 1;
                            break;
                        }
                        dArray[n3] = costEstimate.singleScanRowCount();
                    }
                    if (this.permuteState == 2) {
                        n3 = 0;
                        for (int i2 = 0; i2 < this.numOptimizables; ++i2) {
                            int n6 = i2;
                            for (int i3 = i2 + 1; i3 < this.numOptimizables; ++i3) {
                                if (!(dArray[i3] < dArray[n6])) continue;
                                n6 = i3;
                            }
                            if (n6 == i2) continue;
                            dArray[n6] = dArray[i2];
                            n2 = this.firstLookOrder[i2];
                            this.firstLookOrder[i2] = this.firstLookOrder[n6];
                            this.firstLookOrder[n6] = n2;
                            n3 = 1;
                        }
                        if (n3 != 0) {
                            --this.joinPosition;
                            this.rewindJoinOrder();
                            continue;
                        }
                        this.permuteState = 0;
                    }
                }
                --this.joinPosition;
                if (this.joinPosition >= 0 || this.permuteState != 3) continue;
                this.joinPosition = 0;
                this.permuteState = 4;
                continue;
            }
            this.proposedJoinOrder[this.joinPosition] = n5;
            if (this.permuteState == 4) {
                n4 = 1;
                for (n3 = 0; n3 < this.numOptimizables; ++n3) {
                    if (this.proposedJoinOrder[n3] < this.firstLookOrder[n3]) {
                        n4 = 0;
                        break;
                    }
                    if (this.proposedJoinOrder[n3] > this.firstLookOrder[n3]) break;
                }
                if (n4 != 0) {
                    this.proposedJoinOrder[this.joinPosition] = -1;
                    --this.joinPosition;
                    if (this.joinPosition >= 0) {
                        this.reloadBestPlan = true;
                        this.rewindJoinOrder();
                        this.joinPosition = -1;
                    }
                    this.permuteState = 1;
                    this.endOfRoundCleanup();
                    return false;
                }
            }
            this.optimizableList.getOptimizable(n5).getBestAccessPath().setCostEstimate(null);
            if (this.tracingIsOn()) {
                this.tracer().traceJoinOrderConsideration(this.joinPosition, ArrayUtil.copy(this.proposedJoinOrder), (JBitSet)this.assignedTableMap.clone());
            }
            Optimizable optimizable = this.optimizableList.getOptimizable(n5);
            this.assignedTableMap.or(optimizable.getReferencedTableMap());
            optimizable.startOptimizing(this, this.currentRowOrdering);
            this.pushPredicates(this.optimizableList.getOptimizable(n5), this.assignedTableMap);
            return true;
        }
        this.endOfRoundCleanup();
        return false;
    }

    private void rewindJoinOrder() throws StandardException {
        while (true) {
            Optimizable optimizable = this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]);
            optimizable.pullOptPredicates(this.predicateList);
            if (this.reloadBestPlan) {
                optimizable.updateBestPlanMap((short)2, this);
            }
            this.proposedJoinOrder[this.joinPosition] = -1;
            if (this.joinPosition == 0) break;
            --this.joinPosition;
        }
        this.currentCost.setCost(0.0, 0.0, 0.0);
        this.currentSortAvoidanceCost.setCost(0.0, 0.0, 0.0);
        this.assignedTableMap.clearAll();
    }

    private void endOfRoundCleanup() throws StandardException {
        for (int i2 = 0; i2 < this.numOptimizables; ++i2) {
            this.optimizableList.getOptimizable(i2).updateBestPlanMap((short)0, this);
        }
    }

    private double recoverCostFromProposedJoinOrder(boolean bl2) throws StandardException {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.joinPosition; ++i2) {
            if (bl2) {
                d2 += this.optimizableList.getOptimizable(this.proposedJoinOrder[i2]).getBestSortAvoidancePath().getCostEstimate().getEstimatedCost();
                continue;
            }
            d2 += this.optimizableList.getOptimizable(this.proposedJoinOrder[i2]).getBestAccessPath().getCostEstimate().getEstimatedCost();
        }
        return d2;
    }

    private boolean joinOrderMeetsDependencies(int n2) throws StandardException {
        Optimizable optimizable = this.optimizableList.getOptimizable(n2);
        return optimizable.legalJoinOrder(this.assignedTableMap);
    }

    private void pullOptimizableFromJoinOrder() throws StandardException {
        double d2;
        double d3;
        double d4;
        Optimizable optimizable = this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]);
        int n2 = 0;
        if (this.joinPosition == 0) {
            d4 = this.outermostCostEstimate.rowCount();
            d3 = this.outermostCostEstimate.singleScanRowCount();
        } else {
            n2 = this.proposedJoinOrder[this.joinPosition - 1];
            CostEstimate costEstimate = this.optimizableList.getOptimizable(n2).getBestAccessPath().getCostEstimate();
            d4 = costEstimate.rowCount();
            d3 = costEstimate.singleScanRowCount();
        }
        double d5 = this.currentCost.getEstimatedCost();
        CostEstimate costEstimate = optimizable.getBestAccessPath().getCostEstimate();
        if (costEstimate != null && (d5 -= (d2 = costEstimate.getEstimatedCost())) <= 0.0) {
            d5 = this.joinPosition == 0 ? 0.0 : this.recoverCostFromProposedJoinOrder(false);
        }
        if (this.joinPosition == 0) {
            d5 = this.outermostCostEstimate != null ? this.outermostCostEstimate.getEstimatedCost() : 0.0;
        }
        this.currentCost.setCost(d5, d4, d3);
        if (this.requiredRowOrdering != null && optimizable.considerSortAvoidancePath()) {
            double d6;
            AccessPath accessPath = optimizable.getBestSortAvoidancePath();
            if (this.joinPosition == 0) {
                d4 = this.outermostCostEstimate.rowCount();
                d3 = this.outermostCostEstimate.singleScanRowCount();
                d6 = this.outermostCostEstimate.getEstimatedCost();
            } else {
                CostEstimate costEstimate2 = this.optimizableList.getOptimizable(n2).getBestSortAvoidancePath().getCostEstimate();
                d4 = costEstimate2.rowCount();
                d3 = costEstimate2.singleScanRowCount();
                d6 = this.currentSortAvoidanceCost.getEstimatedCost() - accessPath.getCostEstimate().getEstimatedCost();
            }
            if (d6 <= 0.0) {
                d6 = this.joinPosition == 0 ? 0.0 : this.recoverCostFromProposedJoinOrder(true);
            }
            this.currentSortAvoidanceCost.setCost(d6, d4, d3);
            this.bestRowOrdering.removeOptimizable(optimizable.getTableNumber());
            this.bestRowOrdering.copy(this.currentRowOrdering);
        }
        optimizable.pullOptPredicates(this.predicateList);
        if (this.reloadBestPlan) {
            optimizable.updateBestPlanMap((short)2, this);
        }
        this.proposedJoinOrder[this.joinPosition] = -1;
        this.assignedTableMap.xor(optimizable.getReferencedTableMap());
    }

    void pushPredicates(Optimizable optimizable, JBitSet jBitSet) throws StandardException {
        int n2 = this.predicateList.size();
        JBitSet jBitSet2 = new JBitSet(this.numTablesInQuery);
        JBitSet jBitSet3 = null;
        BaseTableNumbersVisitor baseTableNumbersVisitor = null;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            int n3;
            Predicate predicate = (Predicate)this.predicateList.getOptPredicate(i2);
            if (!this.isPushable(predicate)) continue;
            jBitSet2.setTo(predicate.getReferencedMap());
            for (n3 = 0; n3 < jBitSet2.size(); ++n3) {
                if (!jBitSet.get(n3)) continue;
                jBitSet2.clear(n3);
            }
            jBitSet2.and(this.nonCorrelatedTableMap);
            int n4 = n3 = jBitSet2.getFirstSetBit() == -1 ? 1 : 0;
            if (n3 != 0 && predicate.isScopedForPush() && this.numOptimizables > 1) {
                if (baseTableNumbersVisitor == null) {
                    jBitSet3 = new JBitSet(this.numTablesInQuery);
                    baseTableNumbersVisitor = new BaseTableNumbersVisitor(jBitSet3);
                }
                int n5 = ((FromTable)optimizable).getTableNumber();
                jBitSet3.clearAll();
                baseTableNumbersVisitor.setTableMap(jBitSet3);
                ((FromTable)optimizable).accept(baseTableNumbersVisitor);
                if (n5 >= 0) {
                    jBitSet3.set(n5);
                }
                baseTableNumbersVisitor.setTableMap(jBitSet2);
                predicate.accept(baseTableNumbersVisitor);
                jBitSet2.and(jBitSet3);
                if (jBitSet2.getFirstSetBit() == -1) {
                    n3 = 0;
                }
            }
            if (n3 == 0 || !optimizable.pushOptPredicate(predicate)) continue;
            this.predicateList.removeOptPredicate(i2);
        }
    }

    @Override
    public boolean getNextDecoratedPermutation() throws StandardException {
        boolean bl2;
        Object object;
        double d2;
        Optimizable optimizable;
        block29: {
            optimizable = this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]);
            d2 = 0.0;
            do {
                bl2 = optimizable.nextAccessPath(this, null, this.currentRowOrdering);
                if (this.overridingPlan == null || !bl2) break block29;
                if (this.currentPlan != null && this.currentPlan.countLeafNodes() == this.joinPosition + 1) {
                    bl2 = false;
                    break block29;
                }
                object = OptimizerPlan.makeRowSource(this.getTupleDescriptor(optimizable), this.dDictionary);
                if (object == null) {
                    bl2 = false;
                    break block29;
                }
                if (this.currentPlan == null) continue;
                object = new OptimizerPlan.Join(optimizable.getCurrentAccessPath().getJoinStrategy(), this.currentPlan, (OptimizerPlan)object);
            } while (!((OptimizerPlan)object).isLeftPrefixOf(this.overridingPlan));
            this.currentPlan = object;
        }
        if (optimizable.getBestAccessPath().getCostEstimate() != null && optimizable.getCurrentAccessPath().getCostEstimate() != null) {
            if (optimizable.getBestAccessPath().getCostEstimate().compare(optimizable.getCurrentAccessPath().getCostEstimate()) != 0.0) {
                optimizable.updateBestPlanMap((short)2, optimizable);
            } else if (optimizable.getBestAccessPath().getCostEstimate().rowCount() < optimizable.getCurrentAccessPath().getCostEstimate().rowCount()) {
                optimizable.updateBestPlanMap((short)2, optimizable);
            }
        }
        optimizable.updateBestPlanMap((short)0, optimizable);
        object = optimizable.getBestAccessPath().getCostEstimate();
        if (!bl2 && object != null) {
            this.currentCost.setCost(this.currentCost.getEstimatedCost() + object.getEstimatedCost(), object.rowCount(), object.singleScanRowCount());
            if (optimizable.considerSortAvoidancePath() && this.requiredRowOrdering != null) {
                object = optimizable.getBestSortAvoidancePath().getCostEstimate();
                this.currentSortAvoidanceCost.setCost(this.currentSortAvoidanceCost.getEstimatedCost() + object.getEstimatedCost(), object.rowCount(), object.singleScanRowCount());
            }
            if (this.tracingIsOn()) {
                this.tracer().traceCostWithoutSortAvoidance(this.currentCost);
                if (optimizable.considerSortAvoidancePath()) {
                    this.tracer().traceCostWithSortAvoidance(this.currentSortAvoidanceCost);
                }
            }
            if (this.joinPosition == this.numOptimizables - 1) {
                if (this.tracingIsOn()) {
                    this.tracer().traceCompleteJoinOrder();
                }
                if (this.requiredRowOrdering != null) {
                    boolean bl3 = false;
                    if (this.sortCost == null) {
                        this.sortCost = this.newCostEstimate();
                    } else if (this.requiredRowOrdering.getSortNeeded()) {
                        if (this.bestCost.rowCount() > this.currentCost.rowCount()) {
                            this.requiredRowOrdering.estimateCost(this.bestCost.rowCount(), this.bestRowOrdering, this.sortCost);
                            double d3 = this.sortCost.getEstimatedCost();
                            this.requiredRowOrdering.estimateCost(this.currentCost.rowCount(), this.bestRowOrdering, this.sortCost);
                            bl3 = true;
                            this.bestCost.setCost(this.bestCost.getEstimatedCost() - d3 + this.sortCost.getEstimatedCost(), this.sortCost.rowCount(), this.currentCost.singleScanRowCount());
                        } else if (this.bestCost.rowCount() < this.currentCost.rowCount()) {
                            this.currentCost.setCost(this.currentCost.getEstimatedCost(), this.bestCost.rowCount(), this.currentCost.singleScanRowCount());
                        }
                    }
                    if (!bl3) {
                        this.requiredRowOrdering.estimateCost(this.currentCost.rowCount(), this.bestRowOrdering, this.sortCost);
                    }
                    d2 = this.currentCost.rowCount();
                    this.currentCost.setCost(this.currentCost.getEstimatedCost() + this.sortCost.getEstimatedCost(), this.sortCost.rowCount(), this.currentCost.singleScanRowCount());
                    if (this.tracingIsOn()) {
                        this.tracer().traceSortCost(this.sortCost, this.currentCost);
                    }
                }
                if (!this.foundABestPlan || this.currentCost.compare(this.bestCost) < 0.0 || this.bestCost.isUninitialized()) {
                    this.rememberBestCost(this.currentCost, 1);
                    this.reloadBestPlan = false;
                } else {
                    this.reloadBestPlan = true;
                }
                if (this.requiredRowOrdering != null) {
                    double d4 = this.currentCost.getEstimatedCost() - this.sortCost.getEstimatedCost();
                    if (d4 < 0.0) {
                        d4 = 0.0;
                    }
                    this.currentCost.setCost(d4, d2, this.currentCost.singleScanRowCount());
                }
                if (this.requiredRowOrdering != null && optimizable.considerSortAvoidancePath() && this.requiredRowOrdering.sortRequired(this.bestRowOrdering, this.optimizableList, this.proposedJoinOrder) == 3) {
                    if (this.tracingIsOn()) {
                        this.tracer().traceCurrentPlanAvoidsSort(this.bestCost, this.currentSortAvoidanceCost);
                    }
                    if (this.currentSortAvoidanceCost.compare(this.bestCost) <= 0.0 || this.bestCost.isUninitialized()) {
                        this.rememberBestCost(this.currentSortAvoidanceCost, 2);
                    }
                }
            }
        }
        return bl2;
    }

    private UniqueTupleDescriptor getTupleDescriptor(Optimizable optimizable) throws StandardException {
        if (OptimizerImpl.isTableFunction(optimizable)) {
            ProjectRestrictNode projectRestrictNode = (ProjectRestrictNode)optimizable;
            return ((StaticMethodCallNode)((FromVTI)projectRestrictNode.getChildResult()).getMethodCall()).ad;
        }
        return optimizable.getCurrentAccessPath().getConglomerateDescriptor();
    }

    static boolean isTableFunction(Optimizable optimizable) {
        if (!(optimizable instanceof ProjectRestrictNode)) {
            return false;
        }
        ResultSetNode resultSetNode = ((ProjectRestrictNode)optimizable).getChildResult();
        if (!(resultSetNode instanceof FromVTI)) {
            return false;
        }
        return ((FromVTI)resultSetNode).getMethodCall() instanceof StaticMethodCallNode;
    }

    private void rememberBestCost(CostEstimate costEstimate, int n2) throws StandardException {
        this.foundABestPlan = true;
        if (this.tracingIsOn()) {
            this.tracer().traceCheapestPlanSoFar(n2, costEstimate);
        }
        this.bestCost.setCost(costEstimate);
        if (this.bestCost.getEstimatedCost() < this.timeLimit) {
            this.timeLimit = this.bestCost.getEstimatedCost();
        }
        this.bestJoinOrderUsedPredsFromAbove = this.usingPredsPushedFromAbove;
        System.arraycopy(this.proposedJoinOrder, 0, this.bestJoinOrder, 0, this.numOptimizables);
        for (int i2 = 0; i2 < this.numOptimizables; ++i2) {
            this.optimizableList.getOptimizable(this.bestJoinOrder[i2]).rememberAsBest(n2, this);
        }
        if (this.requiredRowOrdering != null) {
            if (n2 == 2) {
                this.requiredRowOrdering.sortNotNeeded();
            } else {
                this.requiredRowOrdering.sortNeeded();
            }
        }
        if (this.tracingIsOn()) {
            if (this.requiredRowOrdering != null) {
                this.tracer().traceSortNeededForOrdering(n2, this.requiredRowOrdering);
            }
            this.tracer().traceRememberingBestJoinOrder(this.joinPosition, ArrayUtil.copy(this.bestJoinOrder), n2, costEstimate, (JBitSet)this.assignedTableMap.clone());
        }
    }

    @Override
    public void costPermutation() throws StandardException {
        CostEstimate costEstimate = this.joinPosition == 0 ? this.outermostCostEstimate : this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition - 1]).getBestAccessPath().getCostEstimate();
        Optimizable optimizable = this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]);
        if (!optimizable.feasibleJoinStrategy(this.predicateList, this)) {
            return;
        }
        optimizable.optimizeIt(this, this.predicateList, costEstimate, this.currentRowOrdering);
    }

    @Override
    public void costOptimizable(Optimizable optimizable, TableDescriptor tableDescriptor, ConglomerateDescriptor conglomerateDescriptor, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate) throws StandardException {
        if (!optimizable.feasibleJoinStrategy(optimizablePredicateList, this)) {
            return;
        }
        if (this.ruleBasedOptimization) {
            this.ruleBasedCostOptimizable(optimizable, tableDescriptor, conglomerateDescriptor, optimizablePredicateList, costEstimate);
        } else {
            this.costBasedCostOptimizable(optimizable, tableDescriptor, conglomerateDescriptor, optimizablePredicateList, costEstimate);
        }
    }

    private void ruleBasedCostOptimizable(Optimizable optimizable, TableDescriptor tableDescriptor, ConglomerateDescriptor conglomerateDescriptor, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate) throws StandardException {
        AccessPath accessPath = optimizable.getBestAccessPath();
        if (optimizablePredicateList != null && optimizablePredicateList.useful(optimizable, conglomerateDescriptor)) {
            boolean bl2 = optimizable.isCoveringIndex(conglomerateDescriptor);
            if (!accessPath.getCoveringIndexScan() || accessPath.getNonMatchingIndexScan() || bl2) {
                accessPath.setCostEstimate(this.estimateTotalCost(optimizablePredicateList, conglomerateDescriptor, costEstimate, optimizable));
                accessPath.setConglomerateDescriptor(conglomerateDescriptor);
                accessPath.setNonMatchingIndexScan(false);
                accessPath.setCoveringIndexScan(bl2);
                accessPath.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
                optimizable.rememberJoinStrategyAsBest(accessPath);
            }
            return;
        }
        if (optimizable.isCoveringIndex(conglomerateDescriptor)) {
            accessPath.setCostEstimate(this.estimateTotalCost(optimizablePredicateList, conglomerateDescriptor, costEstimate, optimizable));
            accessPath.setConglomerateDescriptor(conglomerateDescriptor);
            accessPath.setNonMatchingIndexScan(true);
            accessPath.setCoveringIndexScan(true);
            accessPath.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(accessPath);
            return;
        }
        if (!accessPath.getCoveringIndexScan() && accessPath.getNonMatchingIndexScan() && !conglomerateDescriptor.isIndex()) {
            accessPath.setCostEstimate(this.estimateTotalCost(optimizablePredicateList, conglomerateDescriptor, costEstimate, optimizable));
            accessPath.setConglomerateDescriptor(conglomerateDescriptor);
            accessPath.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(accessPath);
            return;
        }
        ConglomerateDescriptor conglomerateDescriptor2 = accessPath.getConglomerateDescriptor();
        if (conglomerateDescriptor2 == null) {
            accessPath.setCostEstimate(this.estimateTotalCost(optimizablePredicateList, conglomerateDescriptor, costEstimate, optimizable));
            accessPath.setConglomerateDescriptor(conglomerateDescriptor);
            accessPath.setCoveringIndexScan(false);
            accessPath.setNonMatchingIndexScan(conglomerateDescriptor.isIndex());
            accessPath.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(accessPath);
        }
    }

    private void costBasedCostOptimizable(Optimizable optimizable, TableDescriptor tableDescriptor, ConglomerateDescriptor conglomerateDescriptor, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate) throws StandardException {
        CostEstimate costEstimate2 = this.estimateTotalCost(optimizablePredicateList, conglomerateDescriptor, costEstimate, optimizable);
        optimizable.getCurrentAccessPath().setCostEstimate(costEstimate2);
        if (!optimizable.memoryUsageOK(costEstimate2.rowCount() / costEstimate.rowCount(), this.maxMemoryPerTable)) {
            if (this.tracingIsOn()) {
                this.tracer().traceSkippingBecauseTooMuchMemory(this.maxMemoryPerTable);
            }
            return;
        }
        AccessPath accessPath = optimizable.getBestAccessPath();
        CostEstimate costEstimate3 = accessPath.getCostEstimate();
        if (costEstimate3 == null || costEstimate3.isUninitialized() || costEstimate2.compare(costEstimate3) < 0.0) {
            accessPath.setConglomerateDescriptor(conglomerateDescriptor);
            accessPath.setCostEstimate(costEstimate2);
            accessPath.setCoveringIndexScan(optimizable.isCoveringIndex(conglomerateDescriptor));
            accessPath.setNonMatchingIndexScan(optimizablePredicateList == null || !optimizablePredicateList.useful(optimizable, conglomerateDescriptor));
            accessPath.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(accessPath);
        }
        if (this.requiredRowOrdering != null && (this.joinPosition == 0 || this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition - 1]).considerSortAvoidancePath()) && this.requiredRowOrdering.sortRequired(this.currentRowOrdering, this.assignedTableMap, this.optimizableList, this.proposedJoinOrder) == 3 && ((costEstimate3 = (accessPath = optimizable.getBestSortAvoidancePath()).getCostEstimate()) == null || costEstimate3.isUninitialized() || costEstimate2.compare(costEstimate3) < 0.0)) {
            accessPath.setConglomerateDescriptor(conglomerateDescriptor);
            accessPath.setCostEstimate(costEstimate2);
            accessPath.setCoveringIndexScan(optimizable.isCoveringIndex(conglomerateDescriptor));
            accessPath.setNonMatchingIndexScan(optimizablePredicateList == null || !optimizablePredicateList.useful(optimizable, conglomerateDescriptor));
            accessPath.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(accessPath);
            optimizable.rememberSortAvoidancePath();
            this.currentRowOrdering.copy(this.bestRowOrdering);
        }
    }

    @Override
    public void considerCost(Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate, CostEstimate costEstimate2) throws StandardException {
        if (!optimizable.feasibleJoinStrategy(optimizablePredicateList, this)) {
            return;
        }
        optimizable.getCurrentAccessPath().setCostEstimate(costEstimate);
        if (!optimizable.memoryUsageOK(costEstimate.rowCount() / costEstimate2.rowCount(), this.maxMemoryPerTable)) {
            if (this.tracingIsOn()) {
                this.tracer().traceSkippingBecauseTooMuchMemory(this.maxMemoryPerTable);
            }
            return;
        }
        AccessPath accessPath = optimizable.getBestAccessPath();
        CostEstimate costEstimate3 = accessPath.getCostEstimate();
        if (costEstimate3 == null || costEstimate3.isUninitialized() || costEstimate.compare(costEstimate3) <= 0.0) {
            accessPath.setCostEstimate(costEstimate);
            optimizable.rememberJoinStrategyAsBest(accessPath);
        }
        if (this.requiredRowOrdering != null && (this.joinPosition == 0 || this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition - 1]).considerSortAvoidancePath()) && this.requiredRowOrdering.sortRequired(this.currentRowOrdering, this.assignedTableMap, this.optimizableList, this.proposedJoinOrder) == 3 && ((costEstimate3 = (accessPath = optimizable.getBestSortAvoidancePath()).getCostEstimate()) == null || costEstimate3.isUninitialized() || costEstimate.compare(costEstimate3) < 0.0)) {
            accessPath.setCostEstimate(costEstimate);
            optimizable.rememberJoinStrategyAsBest(accessPath);
            optimizable.rememberSortAvoidancePath();
            this.currentRowOrdering.copy(this.bestRowOrdering);
        }
    }

    @Override
    public DataDictionary getDataDictionary() {
        return this.dDictionary;
    }

    @Override
    public void modifyAccessPaths() throws StandardException {
        if (this.tracingIsOn()) {
            this.tracer().traceModifyingAccessPaths(this.hashCode());
        }
        if (!this.foundABestPlan) {
            if (this.tracingIsOn()) {
                this.tracer().traceNoBestPlan();
            }
            throw StandardException.newException("42Y69", new Object[0]);
        }
        this.optimizableList.reOrder(this.bestJoinOrder);
        JBitSet jBitSet = new JBitSet(this.numOptimizables);
        for (int i2 = 0; i2 < this.numOptimizables; ++i2) {
            Optimizable optimizable = this.optimizableList.getOptimizable(i2);
            jBitSet.or(optimizable.getReferencedTableMap());
            this.pushPredicates(optimizable, jBitSet);
            this.optimizableList.setOptimizable(i2, optimizable.modifyAccessPath(jBitSet));
        }
    }

    private CostEstimate newCostEstimate() {
        return new CostEstimateImpl();
    }

    @Override
    public CostEstimate getOptimizedCost() {
        return this.bestCost;
    }

    @Override
    public CostEstimate getFinalCost() {
        if (this.finalCostEstimate != null) {
            return this.finalCostEstimate;
        }
        this.finalCostEstimate = this.getNewCostEstimate(0.0, 0.0, 0.0);
        for (int i2 = 0; i2 < this.bestJoinOrder.length; ++i2) {
            CostEstimate costEstimate = this.optimizableList.getOptimizable(this.bestJoinOrder[i2]).getTrulyTheBestAccessPath().getCostEstimate();
            this.finalCostEstimate.setCost(this.finalCostEstimate.getEstimatedCost() + costEstimate.getEstimatedCost(), costEstimate.rowCount(), costEstimate.singleScanRowCount());
        }
        return this.finalCostEstimate;
    }

    @Override
    public void setOuterRows(double d2) {
        this.outermostCostEstimate.setCost(this.outermostCostEstimate.getEstimatedCost(), d2, this.outermostCostEstimate.singleScanRowCount());
    }

    @Override
    public int tableLockThreshold() {
        return this.tableLockThreshold;
    }

    @Override
    public int getNumberOfJoinStrategies() {
        return this.joinStrategies.length;
    }

    @Override
    public JoinStrategy getJoinStrategy(int n2) {
        return this.joinStrategies[n2];
    }

    @Override
    public JoinStrategy getJoinStrategy(String string) {
        JoinStrategy joinStrategy = null;
        String string2 = StringUtil.SQLToUpperCase(string);
        for (int i2 = 0; i2 < this.joinStrategies.length; ++i2) {
            if (!string2.equals(this.joinStrategies[i2].getName())) continue;
            joinStrategy = this.joinStrategies[i2];
        }
        return joinStrategy;
    }

    @Override
    public double uniqueJoinWithOuterTable(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        double d2 = -1.0;
        double d3 = 1.0;
        double d4 = this.currentCost.rowCount();
        if (optimizablePredicateList != null) {
            for (int i2 = this.joinPosition - 1; i2 >= 0; --i2) {
                Optimizable optimizable = this.optimizableList.getOptimizable(this.proposedJoinOrder[i2]);
                double d5 = optimizable.uniqueJoin(optimizablePredicateList);
                if (!(d5 > 0.0)) continue;
                d3 *= optimizable.uniqueJoin(optimizablePredicateList);
            }
        }
        if (d3 != 1.0) {
            d2 = d3 / d4;
        }
        return d2;
    }

    private boolean isPushable(OptimizablePredicate optimizablePredicate) {
        return !optimizablePredicate.hasSubquery();
    }

    private CostEstimate estimateTotalCost(OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizable optimizable) throws StandardException {
        CostEstimate costEstimate2 = optimizable.estimateCost(optimizablePredicateList, conglomerateDescriptor, costEstimate, this, this.currentRowOrdering);
        return costEstimate2;
    }

    @Override
    public int getLevel() {
        return 2;
    }

    CostEstimateImpl getNewCostEstimate(double d2, double d3, double d4) {
        return new CostEstimateImpl(d2, d3, d4);
    }

    @Override
    public boolean useStatistics() {
        return this.useStatistics && this.optimizableList.useStatistics();
    }

    @Override
    public void updateBestPlanMaps(short s2, Object object) throws StandardException {
        if (this.numOptimizables > 1) {
            int[] nArray = null;
            if (s2 == 0) {
                if (this.savedJoinOrders != null) {
                    this.savedJoinOrders.remove(object);
                    if (this.savedJoinOrders.isEmpty()) {
                        this.savedJoinOrders = null;
                    }
                }
            } else if (s2 == 1) {
                if (this.savedJoinOrders == null) {
                    this.savedJoinOrders = new HashMap();
                } else {
                    nArray = this.savedJoinOrders.get(object);
                }
                if (nArray == null) {
                    nArray = new int[this.numOptimizables];
                }
                System.arraycopy(this.bestJoinOrder, 0, nArray, 0, this.bestJoinOrder.length);
                this.savedJoinOrders.put(object, nArray);
            } else if (this.savedJoinOrders != null && (nArray = this.savedJoinOrders.get(object)) != null) {
                System.arraycopy(nArray, 0, this.bestJoinOrder, 0, nArray.length);
            }
        }
        for (int i2 = this.optimizableList.size() - 1; i2 >= 0; --i2) {
            this.optimizableList.getOptimizable(i2).updateBestPlanMap(s2, object);
        }
    }

    void addScopedPredicatesToList(PredicateList predicateList, ContextManager contextManager) throws StandardException {
        Predicate predicate;
        int n2;
        if (predicateList == null || predicateList == this.predicateList) {
            return;
        }
        if (this.predicateList == null) {
            this.predicateList = new PredicateList(contextManager);
        }
        for (n2 = this.predicateList.size() - 1; n2 >= 0; --n2) {
            predicate = (Predicate)this.predicateList.getOptPredicate(n2);
            if (!predicate.isScopedForPush()) continue;
            this.predicateList.removeOptPredicate(n2);
        }
        for (n2 = predicateList.size() - 1; n2 >= 0; --n2) {
            predicate = (Predicate)predicateList.getOptPredicate(n2);
            if (!predicate.isScopedToSourceResultSet()) continue;
            predicate.clearScanFlags();
            this.predicateList.addOptPredicate(predicate);
            predicateList.removeOptPredicate(n2);
        }
    }

    private OptTrace tracer() {
        return this.lcc.getOptimizerTracer();
    }

    @Override
    public int getOptimizableCount() {
        return this.optimizableList.size();
    }

    @Override
    public Optimizable getOptimizable(int n2) {
        return this.optimizableList.getOptimizable(n2);
    }
}

