/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.lang.reflect.Member;
import java.util.List;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;

class NewInvocationNode
extends MethodCallNode {
    private boolean singleInstantiation = false;
    private boolean delimitedIdentifier;
    private boolean isBuiltinVTI = false;

    NewInvocationNode(String string, List<ValueNode> list, boolean bl2, ContextManager contextManager) throws StandardException {
        super("<init>", contextManager);
        this.addParms(list);
        this.javaClassName = string;
        this.delimitedIdentifier = bl2;
    }

    NewInvocationNode(TableName tableName, TableDescriptor tableDescriptor, List<ValueNode> list, boolean bl2, ContextManager contextManager) throws StandardException {
        super("<init>", contextManager);
        boolean bl3;
        this.addParms(list);
        TableName tableName2 = tableName;
        TableDescriptor tableDescriptor2 = tableDescriptor;
        boolean bl4 = bl3 = tableName != null;
        if (bl3) {
            tableDescriptor2 = new TableDescriptor(this.getDataDictionary(), tableName2.getTableName(), this.getSchemaDescriptor(tableName2.getSchemaName()), 5, 'R');
        }
        this.javaClassName = this.getDataDictionary().getVTIClass(tableDescriptor2, bl3);
        boolean bl5 = this.isBuiltinVTI = this.getDataDictionary().getBuiltinVTIClass(tableDescriptor2, bl3) != null;
        if (this.javaClassName == null) {
            if (!bl3) {
                tableName2 = this.makeTableName(tableDescriptor2.getSchemaName(), tableDescriptor2.getDescriptorName());
            }
            throw StandardException.newException(bl3 ? "42Y03.S.0" : "42X05", tableName2.getFullTableName());
        }
        this.delimitedIdentifier = bl2;
    }

    boolean isBuiltinVTI() {
        return this.isBuiltinVTI;
    }

    void setSingleInstantiation() {
        this.singleInstantiation = true;
    }

    @Override
    JavaValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        TypeDescriptor typeDescriptor;
        Object object;
        this.bindParameters(fromList, subqueryList, list);
        this.verifyClassExist(this.javaClassName);
        String[] stringArray = this.getObjectSignature();
        boolean[] blArray = this.getIsParam();
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        try {
            this.method = classInspector.findPublicConstructor(this.javaClassName, stringArray, null, blArray);
            if (this.method == null) {
                object = this.getPrimitiveSignature(false);
                this.method = classInspector.findPublicConstructor(this.javaClassName, stringArray, (String[])object, blArray);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.method = null;
        }
        if (this.method == null) {
            object = "";
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (i2 != 0) {
                    object = (String)object + ", ";
                }
                object = (String)object + (stringArray[i2].length() != 0 ? stringArray[i2] : MessageService.getTextMessage("42Z01.U", new Object[0]));
            }
            throw StandardException.newException("42X75", this.javaClassName, object);
        }
        this.methodParameterTypes = classInspector.getParameterTypes(this.method);
        for (int i3 = 0; i3 < this.methodParameterTypes.length; ++i3) {
            if (!ClassInspector.primitiveType(this.methodParameterTypes[i3])) continue;
            this.methodParms[i3].castToPrimitive(true);
        }
        if (this.someParametersAreNull()) {
            this.setNullParameterInfo(this.methodParameterTypes);
        }
        this.setJavaTypeName(this.javaClassName);
        if (this.routineInfo != null && (typeDescriptor = this.routineInfo.getReturnType()) != null) {
            this.setCollationType(typeDescriptor.getCollationType());
        }
        return this;
    }

    @Override
    boolean categorize(JBitSet jBitSet, boolean bl2) throws StandardException {
        if (bl2) {
            return false;
        }
        boolean bl3 = true;
        bl3 = bl3 && super.categorize(jBitSet, bl2);
        return bl3;
    }

    protected boolean assignableTo(String string) throws StandardException {
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        return classInspector.assignableTo(this.javaClassName, string);
    }

    protected Member findPublicMethod(String string, boolean bl2) throws StandardException {
        Member member;
        String[] stringArray = this.getObjectSignature();
        boolean[] blArray = this.getIsParam();
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        try {
            member = classInspector.findPublicMethod(this.javaClassName, string, stringArray, null, blArray, bl2, false, this.hasVarargs());
            if (member == null) {
                String[] stringArray2 = this.getPrimitiveSignature(false);
                member = classInspector.findPublicMethod(this.javaClassName, string, stringArray, stringArray2, blArray, bl2, false, this.hasVarargs());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        return member;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        LocalField localField = null;
        if (this.singleInstantiation) {
            localField = expressionClassBuilder.newFieldDeclaration(2, this.javaClassName);
            methodBuilder.getField(localField);
            methodBuilder.conditionalIfNull();
        }
        methodBuilder.pushNewStart(this.javaClassName);
        int n2 = this.generateParameters(expressionClassBuilder, methodBuilder);
        methodBuilder.pushNewComplete(n2);
        if (this.singleInstantiation) {
            methodBuilder.putField(localField);
            methodBuilder.startElseCode();
            methodBuilder.getField(localField);
            methodBuilder.completeConditional();
        }
    }
}

