/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public class LOBTypeCompiler
extends BaseTypeCompiler {
    @Override
    public boolean convertible(TypeId typeId, boolean bl2) {
        return typeId.isBlobTypeId();
    }

    @Override
    public boolean compatible(TypeId typeId) {
        return this.convertible(typeId, false);
    }

    @Override
    public boolean storable(TypeId typeId, ClassFactory classFactory) {
        return typeId.isBlobTypeId();
    }

    @Override
    public String interfaceName() {
        return "org.apache.derby.iapi.types.BitDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        int n2 = this.getStoredFormatIdFromTypeId();
        switch (n2) {
            case 440: {
                return "java.sql.Blob";
            }
        }
        return null;
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dataTypeDescriptor) {
        return dataTypeDescriptor.getMaximumWidth();
    }

    @Override
    String nullMethodName() {
        int n2 = this.getStoredFormatIdFromTypeId();
        switch (n2) {
            case 440: {
                return "getNullBlob";
            }
        }
        return null;
    }

    @Override
    String dataValueMethodName() {
        int n2 = this.getStoredFormatIdFromTypeId();
        switch (n2) {
            case 440: {
                return "getBlobDataValue";
            }
        }
        return null;
    }
}

