/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.BitSet;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.NumericConstantNode;
import org.apache.derby.impl.sql.compile.OrderByColumn;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.OrderByNode;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowCountNode;
import org.apache.derby.impl.sql.compile.SetOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class IntersectOrExceptNode
extends SetOperatorNode {
    private int opType;
    public static final int INTERSECT_OP = 1;
    public static final int EXCEPT_OP = 2;
    private boolean addNewNodesCalled;
    private int[] intermediateOrderByColumns;
    private int[] intermediateOrderByDirection;
    private boolean[] intermediateOrderByNullsLow;

    IntersectOrExceptNode(int n2, ResultSetNode resultSetNode, ResultSetNode resultSetNode2, boolean bl2, Properties properties, ContextManager contextManager) throws StandardException {
        super(resultSetNode, resultSetNode2, bl2, properties, contextManager);
        this.opType = n2;
    }

    private int getOpType() {
        return this.opType;
    }

    @Override
    ResultSetNode preprocess(int n2, GroupByList groupByList, FromList fromList) throws StandardException {
        this.intermediateOrderByColumns = new int[this.getResultColumns().size()];
        this.intermediateOrderByDirection = new int[this.intermediateOrderByColumns.length];
        this.intermediateOrderByNullsLow = new boolean[this.intermediateOrderByColumns.length];
        OrderByList orderByList = this.qec.getOrderByList(0);
        if (orderByList != null) {
            int n3;
            BitSet bitSet = new BitSet(this.intermediateOrderByColumns.length);
            int n4 = orderByList.size();
            int n5 = 0;
            for (n3 = 0; n3 < n4; ++n3) {
                int n6;
                if (bitSet.get(n3)) continue;
                OrderByColumn orderByColumn = orderByList.getOrderByColumn(n3);
                this.intermediateOrderByDirection[n5] = orderByColumn.isAscending() ? 1 : -1;
                this.intermediateOrderByNullsLow[n5] = orderByColumn.isNullsOrderedLow();
                this.intermediateOrderByColumns[n5] = n6 = orderByColumn.getResultColumn().getColumnPosition() - 1;
                bitSet.set(n6);
                ++n5;
            }
            for (n3 = 0; n3 < this.intermediateOrderByColumns.length; ++n3) {
                if (bitSet.get(n3)) continue;
                this.intermediateOrderByDirection[n5] = 1;
                this.intermediateOrderByNullsLow[n5] = false;
                this.intermediateOrderByColumns[n5] = n3;
                ++n5;
            }
            this.qec.setOrderByList(0, null);
        } else {
            for (int i2 = 0; i2 < this.intermediateOrderByColumns.length; ++i2) {
                this.intermediateOrderByDirection[i2] = 1;
                this.intermediateOrderByNullsLow[i2] = false;
                this.intermediateOrderByColumns[i2] = i2;
            }
        }
        this.pushOrderingDown(this.leftResultSet);
        this.pushOrderingDown(this.rightResultSet);
        return super.preprocess(n2, groupByList, fromList);
    }

    private void pushOrderingDown(ResultSetNode resultSetNode) throws StandardException {
        ContextManager contextManager = this.getContextManager();
        OrderByList orderByList = new OrderByList(null, contextManager);
        for (int i2 = 0; i2 < this.intermediateOrderByColumns.length; ++i2) {
            OrderByColumn orderByColumn = new OrderByColumn(new NumericConstantNode(TypeId.getBuiltInTypeId(4), this.intermediateOrderByColumns[i2] + 1, contextManager), contextManager);
            if (this.intermediateOrderByDirection[i2] < 0) {
                orderByColumn.setDescending();
            }
            if (this.intermediateOrderByNullsLow[i2]) {
                orderByColumn.setNullsOrderedLow();
            }
            orderByList.addOrderByColumn(orderByColumn);
        }
        orderByList.bindOrderByColumns(resultSetNode);
        resultSetNode.pushQueryExpressionSuffix();
        resultSetNode.pushOrderByList(orderByList);
    }

    @Override
    public CostEstimate estimateCost(OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        this.leftResultSet = this.optimizeSource(optimizer, this.leftResultSet, null, costEstimate);
        this.rightResultSet = this.optimizeSource(optimizer, this.rightResultSet, null, costEstimate);
        CostEstimate costEstimate2 = this.getCostEstimate(optimizer);
        CostEstimate costEstimate3 = this.leftResultSet.getCostEstimate();
        CostEstimate costEstimate4 = this.rightResultSet.getCostEstimate();
        costEstimate2.setCost(costEstimate3.getEstimatedCost() + costEstimate4.getEstimatedCost(), this.getRowCountEstimate(costEstimate3.rowCount(), costEstimate4.rowCount()), this.getSingleScanRowCountEstimate(costEstimate3.singleScanRowCount(), costEstimate4.singleScanRowCount()));
        return costEstimate2;
    }

    @Override
    public Optimizable modifyAccessPath(JBitSet jBitSet) throws StandardException {
        Optimizable optimizable = super.modifyAccessPath(jBitSet);
        if (this.addNewNodesCalled) {
            return optimizable;
        }
        return (Optimizable)((Object)this.addNewNodes());
    }

    @Override
    ResultSetNode modifyAccessPaths() throws StandardException {
        ResultSetNode resultSetNode = super.modifyAccessPaths();
        if (this.addNewNodesCalled) {
            return resultSetNode;
        }
        return this.addNewNodes();
    }

    private ResultSetNode addNewNodes() throws StandardException {
        if (this.addNewNodesCalled) {
            return this;
        }
        this.addNewNodesCalled = true;
        FromTable fromTable = this;
        for (int i2 = 0; i2 < this.qec.size(); ++i2) {
            OrderByList orderByList = this.qec.getOrderByList(i2);
            if (orderByList != null) {
                fromTable = new OrderByNode(fromTable, orderByList, this.tableProperties, this.getContextManager());
            }
            ValueNode valueNode = this.qec.getOffset(i2);
            ValueNode valueNode2 = this.qec.getFetchFirst(i2);
            if (valueNode == null && valueNode2 == null) continue;
            ResultColumnList resultColumnList = fromTable.getResultColumns().copyListAndObjects();
            resultColumnList.genVirtualColumnNodes(fromTable, fromTable.getResultColumns());
            fromTable = new RowCountNode(fromTable, resultColumnList, valueNode, valueNode2, this.qec.getHasJDBCLimitClause()[i2], this.getContextManager());
        }
        return fromTable;
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.assignResultSetNumber();
        this.setCostEstimate(this.getFinalCostEstimate());
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        this.getLeftResultSet().generate(activationClassBuilder, methodBuilder);
        this.getRightResultSet().generate(activationClassBuilder, methodBuilder);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.push(this.getResultSetNumber());
        methodBuilder.push(this.getCostEstimate().getEstimatedRowCount());
        methodBuilder.push(this.getCostEstimate().getEstimatedCost());
        methodBuilder.push(this.getOpType());
        methodBuilder.push(this.all);
        methodBuilder.push(this.getCompilerContext().addSavedObject(this.intermediateOrderByColumns));
        methodBuilder.push(this.getCompilerContext().addSavedObject(this.intermediateOrderByDirection));
        methodBuilder.push(this.getCompilerContext().addSavedObject(this.intermediateOrderByNullsLow));
        methodBuilder.callMethod((short)185, null, "getSetOpResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 11);
    }

    @Override
    CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.getCandidateFinalCostEstimate() != null) {
            return this.getCandidateFinalCostEstimate();
        }
        CostEstimate costEstimate = this.leftResultSet.getFinalCostEstimate();
        CostEstimate costEstimate2 = this.rightResultSet.getFinalCostEstimate();
        this.setCandidateFinalCostEstimate(this.getNewCostEstimate());
        this.getCandidateFinalCostEstimate().setCost(costEstimate.getEstimatedCost() + costEstimate2.getEstimatedCost(), this.getRowCountEstimate(costEstimate.rowCount(), costEstimate2.rowCount()), this.getSingleScanRowCountEstimate(costEstimate.singleScanRowCount(), costEstimate2.singleScanRowCount()));
        return this.getCandidateFinalCostEstimate();
    }

    @Override
    String getOperatorName() {
        switch (this.opType) {
            case 1: {
                return "INTERSECT";
            }
            case 2: {
                return "EXCEPT";
            }
        }
        return "?";
    }

    double getRowCountEstimate(double d2, double d3) {
        switch (this.opType) {
            case 1: {
                return Math.min(d2, d3) / 2.0;
            }
            case 2: {
                return (d2 + Math.max(0.0, d2 - d3)) / 2.0;
            }
        }
        return 1.0;
    }

    double getSingleScanRowCountEstimate(double d2, double d3) {
        return this.getRowCountEstimate(d2, d3);
    }
}

