/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import java.util.Properties;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

class IndexToBaseRowNode
extends FromTable {
    protected FromBaseTable source;
    protected ConglomerateDescriptor baseCD;
    protected boolean cursorTargetTable;
    protected PredicateList restrictionList;
    protected boolean forUpdate;
    private FormatableBitSet heapReferencedCols;
    private FormatableBitSet indexReferencedCols;
    private FormatableBitSet allReferencedCols;
    private FormatableBitSet heapOnlyReferencedCols;

    IndexToBaseRowNode(FromBaseTable fromBaseTable, ConglomerateDescriptor conglomerateDescriptor, ResultColumnList resultColumnList, boolean bl2, FormatableBitSet formatableBitSet, FormatableBitSet formatableBitSet2, PredicateList predicateList, boolean bl3, Properties properties, ContextManager contextManager) {
        super(null, properties, contextManager);
        this.source = fromBaseTable;
        this.baseCD = conglomerateDescriptor;
        this.setResultColumns(resultColumnList);
        this.cursorTargetTable = bl2;
        this.restrictionList = predicateList;
        this.forUpdate = bl3;
        this.heapReferencedCols = formatableBitSet;
        this.indexReferencedCols = formatableBitSet2;
        if (this.indexReferencedCols == null) {
            this.allReferencedCols = this.heapReferencedCols;
            this.heapOnlyReferencedCols = this.heapReferencedCols;
        } else {
            this.allReferencedCols = new FormatableBitSet(this.heapReferencedCols);
            this.allReferencedCols.or(this.indexReferencedCols);
            this.heapOnlyReferencedCols = new FormatableBitSet(this.allReferencedCols);
            this.heapOnlyReferencedCols.xor(this.indexReferencedCols);
        }
    }

    @Override
    public boolean forUpdate() {
        return this.source.forUpdate();
    }

    @Override
    public AccessPath getTrulyTheBestAccessPath() {
        return this.source.getTrulyTheBestAccessPath();
    }

    @Override
    CostEstimate getCostEstimate() {
        return this.source.getTrulyTheBestAccessPath().getCostEstimate();
    }

    @Override
    CostEstimate getFinalCostEstimate() {
        return this.source.getFinalCostEstimate();
    }

    @Override
    boolean isOrderedOn(ColumnReference[] columnReferenceArray, boolean bl2, List<FromBaseTable> list) throws StandardException {
        return this.source.isOrderedOn(columnReferenceArray, bl2, list);
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        ValueNode valueNode = null;
        this.assignResultSetNumber();
        this.setCostEstimate(this.getFinalCostEstimate());
        if (this.restrictionList != null) {
            valueNode = this.restrictionList.restorePredicates();
            this.restrictionList = null;
        }
        int n2 = -1;
        if (this.heapReferencedCols != null) {
            n2 = activationClassBuilder.addItem(this.heapReferencedCols);
        }
        int n3 = -1;
        if (this.allReferencedCols != null) {
            n3 = activationClassBuilder.addItem(this.allReferencedCols);
        }
        int n4 = -1;
        if (this.heapOnlyReferencedCols != null) {
            n4 = activationClassBuilder.addItem(this.heapOnlyReferencedCols);
        }
        int n5 = activationClassBuilder.addItem(new ReferencedColumnsDescriptorImpl(this.getIndexColMapping()));
        long l2 = this.baseCD.getConglomerateNumber();
        StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo = this.getLanguageConnectionContext().getTransactionCompile().getStaticCompiledConglomInfo(l2);
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        methodBuilder.push(l2);
        methodBuilder.push(activationClassBuilder.addItem(staticCompiledOpenConglomInfo));
        this.source.generate(activationClassBuilder, methodBuilder);
        methodBuilder.upCast("org.apache.derby.iapi.sql.execute.NoPutResultSet");
        boolean bl2 = this.indexReferencedCols != null && this.indexReferencedCols.getNumBitsSet() != 0;
        methodBuilder.push(activationClassBuilder.addItem(this.getResultColumns().buildRowTemplate(this.heapReferencedCols, bl2)));
        methodBuilder.push(this.getResultSetNumber());
        methodBuilder.push(this.source.getBaseTableName());
        methodBuilder.push(n2);
        methodBuilder.push(n3);
        methodBuilder.push(n4);
        methodBuilder.push(n5);
        if (valueNode == null) {
            methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder methodBuilder2 = activationClassBuilder.newUserExprFun();
            valueNode.generate(activationClassBuilder, methodBuilder2);
            methodBuilder2.methodReturn();
            methodBuilder2.complete();
            activationClassBuilder.pushMethodReference(methodBuilder, methodBuilder2);
        }
        methodBuilder.push(this.forUpdate);
        methodBuilder.push(this.getCostEstimate().rowCount());
        methodBuilder.push(this.getCostEstimate().getEstimatedCost());
        methodBuilder.push(this.source.getTableDescriptor().getNumberOfColumns());
        methodBuilder.callMethod((short)185, null, "getIndexRowToBaseRowResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 15);
        if (this.cursorTargetTable) {
            activationClassBuilder.rememberCursorTarget(methodBuilder);
        }
    }

    @Override
    boolean isOneRowResultSet() throws StandardException {
        return this.source.isOneRowResultSet();
    }

    @Override
    boolean isNotExists() {
        return this.source.isNotExists();
    }

    @Override
    void decrementLevel(int n2) {
        this.source.decrementLevel(n2);
    }

    @Override
    int updateTargetLockMode() {
        return this.source.updateTargetLockMode();
    }

    @Override
    void adjustForSortElimination() {
        this.source.disableBulkFetch();
    }

    @Override
    void adjustForSortElimination(RequiredRowOrdering requiredRowOrdering) throws StandardException {
        this.adjustForSortElimination();
        this.source.adjustForSortElimination(requiredRowOrdering);
    }

    private int[] getIndexColMapping() {
        int n2 = this.getResultColumns().size();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            ResultColumn resultColumn = (ResultColumn)this.getResultColumns().elementAt(i2);
            if (this.indexReferencedCols != null && resultColumn.getExpression() instanceof VirtualColumnNode) {
                VirtualColumnNode virtualColumnNode = (VirtualColumnNode)resultColumn.getExpression();
                nArray[i2] = virtualColumnNode.getSourceColumn().getVirtualColumnId() - 1;
                continue;
            }
            nArray[i2] = -1;
        }
        return nArray;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.source != null) {
            this.source = (FromBaseTable)this.source.accept(visitor);
        }
    }
}

