/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.ValueNode;

class HasVariantValueNodeVisitor
implements Visitor {
    private boolean hasVariant;
    private int variantType;
    private boolean ignoreParameters;

    HasVariantValueNodeVisitor() {
        this.variantType = 0;
        this.ignoreParameters = false;
    }

    HasVariantValueNodeVisitor(int n2, boolean bl2) {
        this.variantType = n2;
        this.ignoreParameters = bl2;
    }

    @Override
    public Visitable visit(Visitable visitable) throws StandardException {
        if (visitable instanceof ValueNode) {
            if (this.ignoreParameters && ((ValueNode)visitable).requiresTypeFromContext()) {
                return visitable;
            }
            if (((ValueNode)visitable).getOrderableVariantType() <= this.variantType) {
                this.hasVariant = true;
            }
        }
        return visitable;
    }

    @Override
    public boolean skipChildren(Visitable visitable) {
        return false;
    }

    @Override
    public boolean visitChildrenFirst(Visitable visitable) {
        return false;
    }

    @Override
    public boolean stopTraversal() {
        return this.hasVariant;
    }

    boolean hasVariant() {
        return this.hasVariant;
    }
}

