/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.FormatableIntHolder;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.services.daemon.IndexStatisticsDaemonImpl;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.CreateViewNode;
import org.apache.derby.impl.sql.compile.CurrentRowLocationNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.InListOperatorNode;
import org.apache.derby.impl.sql.compile.IndexToBaseRowNode;
import org.apache.derby.impl.sql.compile.LikeEscapeOperatorNode;
import org.apache.derby.impl.sql.compile.NewInvocationNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

class FromBaseTable
extends FromTable {
    static final int UNSET = -1;
    private boolean hasCheckedIndexStats;
    TableName tableName;
    TableDescriptor tableDescriptor;
    ConglomerateDescriptor baseConglomerateDescriptor;
    ConglomerateDescriptor[] conglomDescs;
    int updateOrDelete;
    int bulkFetch = -1;
    private String targetTableUUIDString;
    private boolean validatingCheckConstraint = false;
    boolean bulkFetchTurnedOff;
    boolean multiProbing = false;
    private double singleScanRowCount;
    private FormatableBitSet referencedCols;
    private ResultColumnList templateColumns;
    private String[] columnNames;
    private boolean specialMaxScan;
    private boolean distinctScan;
    private boolean raDependentScan;
    private String raParentResultSetId;
    private long fkIndexConglomId;
    private int[] fkColArray;
    PredicateList baseTableRestrictionList;
    PredicateList nonBaseTableRestrictionList;
    PredicateList restrictionList;
    PredicateList storeRestrictionList;
    PredicateList nonStoreRestrictionList;
    PredicateList requalificationRestrictionList;
    static final int UPDATE = 1;
    static final int DELETE = 2;
    private boolean existsBaseTable;
    private boolean isNotExists;
    private JBitSet dependencyMap;
    private boolean getUpdateLocks;
    private boolean authorizeSYSUSERS;
    private String rowLocationColumnName;
    private boolean gotRowCount = false;
    private long rowCount = 0L;

    FromBaseTable(TableName tableName, String string, ResultColumnList resultColumnList, Properties properties, ContextManager contextManager) {
        super(string, properties, contextManager);
        this.tableName = tableName;
        this.setResultColumns(resultColumnList);
        this.setOrigTableName(this.tableName);
        this.templateColumns = this.getResultColumns();
    }

    FromBaseTable(TableName tableName, String string, int n2, ResultColumnList resultColumnList, ContextManager contextManager) {
        super(string, null, contextManager);
        this.tableName = tableName;
        this.updateOrDelete = n2;
        this.setResultColumns(resultColumnList);
        this.setOrigTableName(this.tableName);
        this.templateColumns = this.getResultColumns();
    }

    void setRowLocationColumnName(String string) {
        this.rowLocationColumnName = string;
    }

    @Override
    boolean LOJ_reorderable(int n2) throws StandardException {
        return false;
    }

    @Override
    JBitSet LOJgetReferencedTables(int n2) throws StandardException {
        JBitSet jBitSet = new JBitSet(n2);
        this.fillInReferencedTableMap(jBitSet);
        return jBitSet;
    }

    @Override
    public boolean nextAccessPath(Optimizer optimizer, OptimizablePredicateList optimizablePredicateList, RowOrdering rowOrdering) throws StandardException {
        ConglomerateDescriptor conglomerateDescriptor;
        AccessPath accessPath;
        block22: {
            Object object;
            block23: {
                block24: {
                    String string = this.getUserSpecifiedIndexName();
                    accessPath = this.getCurrentAccessPath();
                    conglomerateDescriptor = accessPath.getConglomerateDescriptor();
                    if (this.optimizerTracingIsOn()) {
                        this.getOptimizerTracer().traceNextAccessPath(this.getExposedName(), optimizablePredicateList == null ? 0 : optimizablePredicateList.size());
                    }
                    rowOrdering.removeOptimizable(this.getTableNumber());
                    if (string != null) {
                        if (conglomerateDescriptor != null) {
                            if (!super.nextAccessPath(optimizer, optimizablePredicateList, rowOrdering)) {
                                conglomerateDescriptor = null;
                            }
                        } else {
                            if (this.optimizerTracingIsOn()) {
                                this.getOptimizerTracer().traceLookingForSpecifiedIndex(string, this.tableNumber);
                            }
                            if (StringUtil.SQLToUpperCase(string).equals("NULL")) {
                                conglomerateDescriptor = this.tableDescriptor.getConglomerateDescriptor(this.tableDescriptor.getHeapConglomerateId());
                            } else {
                                this.getConglomDescs();
                                for (int i2 = 0; !(i2 >= this.conglomDescs.length || (object = (Object)(conglomerateDescriptor = this.conglomDescs[i2]).getConglomerateName()) != null && ((String)object).equals(string)); ++i2) {
                                }
                            }
                            if (!super.nextAccessPath(optimizer, optimizablePredicateList, rowOrdering)) {
                                // empty if block
                            }
                        }
                    } else if (conglomerateDescriptor != null) {
                        if (!super.nextAccessPath(optimizer, optimizablePredicateList, rowOrdering)) {
                            conglomerateDescriptor = this.getNextConglom(conglomerateDescriptor);
                            this.resetJoinStrategies(optimizer);
                            if (!super.nextAccessPath(optimizer, optimizablePredicateList, rowOrdering)) {
                                // empty if block
                            }
                        }
                    } else {
                        conglomerateDescriptor = this.getFirstConglom();
                        if (!super.nextAccessPath(optimizer, optimizablePredicateList, rowOrdering)) {
                            // empty if block
                        }
                    }
                    if (conglomerateDescriptor == null) {
                        if (this.optimizerTracingIsOn()) {
                            this.getOptimizerTracer().traceNoMoreConglomerates(this.tableNumber);
                        }
                    } else {
                        conglomerateDescriptor.setColumnNames(this.columnNames);
                        if (this.optimizerTracingIsOn()) {
                            this.getOptimizerTracer().traceConsideringConglomerate(conglomerateDescriptor, this.tableNumber);
                        }
                    }
                    if (conglomerateDescriptor == null) break block22;
                    if (conglomerateDescriptor.isIndex()) break block23;
                    if (this.isOneRowResultSet(optimizablePredicateList)) break block24;
                    if (this.optimizerTracingIsOn()) {
                        this.getOptimizerTracer().traceAddingUnorderedOptimizable(optimizablePredicateList == null ? 0 : optimizablePredicateList.size());
                    }
                    rowOrdering.addUnorderedOptimizable(this);
                    break block22;
                }
                if (!this.optimizerTracingIsOn()) break block22;
                this.getOptimizerTracer().traceScanningHeapWithUniqueKey();
                break block22;
            }
            IndexRowGenerator indexRowGenerator = conglomerateDescriptor.getIndexDescriptor();
            object = indexRowGenerator.baseColumnPositions();
            boolean[] blArray = indexRowGenerator.isAscending();
            for (int i3 = 0; i3 < ((int[])object).length; ++i3) {
                if (rowOrdering.orderedOnColumn(blArray[i3] ? 1 : 2, this.getTableNumber(), (int)object[i3])) continue;
                rowOrdering.nextOrderPosition(blArray[i3] ? 1 : 2);
                rowOrdering.addOrderedColumn(blArray[i3] ? 1 : 2, this.getTableNumber(), (int)object[i3]);
            }
        }
        accessPath.setConglomerateDescriptor(conglomerateDescriptor);
        return conglomerateDescriptor != null;
    }

    @Override
    protected boolean canBeOrdered() {
        return true;
    }

    @Override
    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate, RowOrdering rowOrdering) throws StandardException {
        optimizer.costOptimizable(this, this.tableDescriptor, this.getCurrentAccessPath().getConglomerateDescriptor(), optimizablePredicateList, costEstimate);
        return this.getCurrentAccessPath().getCostEstimate();
    }

    @Override
    public TableDescriptor getTableDescriptor() {
        return this.tableDescriptor;
    }

    @Override
    public boolean isMaterializable() throws StandardException {
        return true;
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        this.restrictionList.addPredicate((Predicate)optimizablePredicate);
        return true;
    }

    @Override
    public void pullOptPredicates(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        for (int i2 = this.restrictionList.size() - 1; i2 >= 0; --i2) {
            optimizablePredicateList.addOptPredicate(this.restrictionList.getOptPredicate(i2));
            this.restrictionList.removeOptPredicate(i2);
        }
    }

    @Override
    public boolean isCoveringIndex(ConglomerateDescriptor conglomerateDescriptor) throws StandardException {
        boolean bl2 = true;
        if (!conglomerateDescriptor.isIndex()) {
            return false;
        }
        IndexRowGenerator indexRowGenerator = conglomerateDescriptor.getIndexDescriptor();
        int[] nArray = indexRowGenerator.baseColumnPositions();
        for (ResultColumn resultColumn : this.getResultColumns()) {
            if (!resultColumn.isReferenced() || resultColumn.getExpression() instanceof ConstantNode) continue;
            bl2 = false;
            int n2 = resultColumn.getColumnPosition();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (n2 != nArray[i2]) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            break;
        }
        return bl2;
    }

    @Override
    public void verifyProperties(DataDictionary dataDictionary) throws StandardException {
        String string;
        Object object;
        if (this.tableProperties == null) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        ConstraintDescriptor constraintDescriptor = null;
        Enumeration<Object> enumeration = this.tableProperties.keys();
        StringUtil.SQLEqualsIgnoreCase(this.tableDescriptor.getSchemaName(), "SYS");
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            string = (String)this.tableProperties.get(object);
            if (((String)object).equals("index")) {
                String string2;
                if (bl3) {
                    throw StandardException.newException("42Y50", this.getBaseTableName());
                }
                bl2 = true;
                if (StringUtil.SQLToUpperCase(string).equals("NULL")) continue;
                ConglomerateDescriptor conglomerateDescriptor = null;
                ConglomerateDescriptor[] conglomerateDescriptorArray = this.tableDescriptor.getConglomerateDescriptors();
                for (int i2 = 0; !(i2 >= conglomerateDescriptorArray.length || (string2 = (conglomerateDescriptor = conglomerateDescriptorArray[i2]).getConglomerateName()) != null && string2.equals(string)); ++i2) {
                    conglomerateDescriptor = null;
                }
                if (conglomerateDescriptor == null) {
                    throw StandardException.newException("42Y46", string, this.getBaseTableName());
                }
                this.getCompilerContext().createDependency(conglomerateDescriptor);
                continue;
            }
            if (((String)object).equals("constraint")) {
                if (bl2) {
                    throw StandardException.newException("42Y50", this.getBaseTableName());
                }
                bl3 = true;
                if (StringUtil.SQLToUpperCase(string).equals("NULL")) continue;
                constraintDescriptor = dataDictionary.getConstraintDescriptorByName(this.tableDescriptor, null, string, false);
                if (constraintDescriptor == null || !constraintDescriptor.hasBackingIndex()) {
                    throw StandardException.newException("42Y48", string, this.getBaseTableName());
                }
                this.getCompilerContext().createDependency(constraintDescriptor);
                continue;
            }
            if (((String)object).equals("joinStrategy")) {
                this.userSpecifiedJoinStrategy = StringUtil.SQLToUpperCase(string);
                continue;
            }
            if (((String)object).equals("hashInitialCapacity")) {
                this.initialCapacity = this.getIntProperty(string, (String)object);
                if (this.initialCapacity > 0) continue;
                throw StandardException.newException("42Y59", String.valueOf(this.initialCapacity));
            }
            if (((String)object).equals("hashLoadFactor")) {
                try {
                    this.loadFactor = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw StandardException.newException("42Y58", string, object);
                }
                if (!((double)this.loadFactor <= 0.0) && !((double)this.loadFactor > 1.0)) continue;
                throw StandardException.newException("42Y60", string);
            }
            if (((String)object).equals("hashMaxCapacity")) {
                this.maxCapacity = this.getIntProperty(string, (String)object);
                if (this.maxCapacity > 0) continue;
                throw StandardException.newException("42Y61", String.valueOf(this.maxCapacity));
            }
            if (((String)object).equals("bulkFetch")) {
                this.bulkFetch = this.getIntProperty(string, (String)object);
                if (this.bulkFetch <= 0) {
                    throw StandardException.newException("42Y64", String.valueOf(this.bulkFetch));
                }
                if (!this.forUpdate()) continue;
                throw StandardException.newException("42Y66", new Object[0]);
            }
            if (((String)object).equals("validateCheckConstraint")) continue;
            throw StandardException.newException("42Y44", object, "index, constraint, joinStrategy");
        }
        if (bl3 && constraintDescriptor != null) {
            object = dataDictionary.getConglomerateDescriptor(constraintDescriptor.getConglomerateId());
            string = ((ConglomerateDescriptor)object).getConglomerateName();
            this.tableProperties.remove("constraint");
            this.tableProperties.put("index", string);
        }
    }

    private boolean isValidatingCheckConstraint() throws StandardException {
        if (this.tableProperties == null) {
            return false;
        }
        Enumeration<Object> enumeration = this.tableProperties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.tableProperties.get(string);
            if (!string.equals("validateCheckConstraint")) continue;
            this.targetTableUUIDString = string2;
            this.validatingCheckConstraint = true;
            return true;
        }
        return false;
    }

    @Override
    public String getBaseTableName() {
        return this.tableName.getTableName();
    }

    @Override
    public void startOptimizing(Optimizer optimizer, RowOrdering rowOrdering) {
        AccessPath accessPath = this.getCurrentAccessPath();
        AccessPath accessPath2 = this.getBestAccessPath();
        AccessPath accessPath3 = this.getBestSortAvoidancePath();
        accessPath.setConglomerateDescriptor(null);
        accessPath2.setConglomerateDescriptor(null);
        accessPath3.setConglomerateDescriptor(null);
        accessPath.setCoveringIndexScan(false);
        accessPath2.setCoveringIndexScan(false);
        accessPath3.setCoveringIndexScan(false);
        accessPath.setLockMode(0);
        accessPath2.setLockMode(0);
        accessPath3.setLockMode(0);
        CostEstimate costEstimate = this.getCostEstimate(optimizer);
        accessPath.setCostEstimate(costEstimate);
        costEstimate.setCost(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        super.startOptimizing(optimizer, rowOrdering);
    }

    @Override
    public int convertAbsoluteToRelativeColumnPosition(int n2) {
        return this.mapAbsoluteToRelativeColumnPosition(n2);
    }

    @Override
    public CostEstimate estimateCost(OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        boolean bl2 = false;
        boolean bl3 = false;
        PredicateList predicateList = null;
        if (optimizer.useStatistics() && optimizablePredicateList != null) {
            bl3 = this.tableDescriptor.statisticsExist(conglomerateDescriptor);
            bl2 = this.tableDescriptor.statisticsExist(null);
            predicateList = new PredicateList(this.getContextManager());
            optimizablePredicateList.copyPredicatesToOtherList(predicateList);
            if (!this.hasCheckedIndexStats) {
                this.hasCheckedIndexStats = true;
                if (this.qualifiesForStatisticsUpdateCheck(this.tableDescriptor)) {
                    this.tableDescriptor.markForIndexStatsUpdate(this.baseRowCount());
                }
            }
        }
        AccessPath accessPath = this.getCurrentAccessPath();
        JoinStrategy joinStrategy = accessPath.getJoinStrategy();
        if (this.optimizerTracingIsOn()) {
            this.getOptimizerTracer().traceEstimatingCostOfConglomerate(conglomerateDescriptor, this.tableNumber);
        }
        double d2 = optimizer.uniqueJoinWithOuterTable(optimizablePredicateList);
        boolean bl4 = this.isOneRowResultSet(optimizablePredicateList);
        this.baseTableRestrictionList.removeAllElements();
        joinStrategy.getBasePredicates(optimizablePredicateList, this.baseTableRestrictionList, this);
        StoreCostController storeCostController = this.getStoreCostController(conglomerateDescriptor);
        CostEstimate costEstimate2 = this.getScratchCostEstimate(optimizer);
        if (this.isOneRowResultSet(conglomerateDescriptor, this.baseTableRestrictionList)) {
            OptimizablePredicate optimizablePredicate;
            rowOrdering.optimizableAlwaysOrdered(this);
            this.singleScanRowCount = 1.0;
            double d3 = storeCostController.getFetchFromFullKeyCost(null, 0);
            if (this.optimizerTracingIsOn()) {
                this.getOptimizerTracer().traceSingleMatchedRowCost(d3, this.tableNumber);
            }
            costEstimate2.setCost(d3, 1.0, 1.0);
            double d4 = costEstimate2.getEstimatedCost();
            if (joinStrategy.multiplyBaseCostByOuterRows()) {
                d4 *= costEstimate.rowCount();
            }
            costEstimate2.setCost(d4, costEstimate2.rowCount() * costEstimate.rowCount(), costEstimate2.singleScanRowCount());
            boolean bl5 = true;
            for (int i2 = 0; i2 < optimizablePredicateList.size() && ((optimizablePredicate = optimizablePredicateList.getOptPredicate(i2)).isStartKey() || optimizablePredicate.isStopKey()); ++i2) {
                if (optimizablePredicate.getReferencedMap().hasSingleBitSet()) continue;
                bl5 = false;
                break;
            }
            if (bl5) {
                accessPath.setLockMode(6);
                if (this.optimizerTracingIsOn()) {
                    this.getOptimizerTracer().traceConstantStartStopPositions();
                }
            } else {
                this.setLockingBasedOnThreshold(optimizer, costEstimate2.rowCount());
            }
            if (this.optimizerTracingIsOn()) {
                this.getOptimizerTracer().traceCostOfNScans(this.tableNumber, costEstimate.rowCount(), costEstimate2);
            }
            if (conglomerateDescriptor.isIndex() && !this.isCoveringIndex(conglomerateDescriptor)) {
                double d5 = this.getBaseCostController().getFetchFromRowLocationCost(null, 0);
                d3 = d5 * costEstimate2.rowCount();
                costEstimate2.setEstimatedCost(costEstimate2.getEstimatedCost() + d3);
                if (this.optimizerTracingIsOn()) {
                    this.getOptimizerTracer().traceNonCoveringIndexCost(d3, this.tableNumber);
                }
            }
        } else {
            double d6;
            double d7;
            double d8;
            double d9;
            int n2;
            int n3;
            OptimizablePredicate optimizablePredicate;
            double d10 = 1.0;
            double d11 = 1.0;
            double d12 = 1.0;
            double d13 = 1.0;
            double d14 = 1.0;
            double d15 = 1.0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = true;
            boolean bl10 = false;
            int n8 = 0;
            int n9 = 0;
            int n10 = optimizablePredicateList != null ? this.baseTableRestrictionList.size() : 0;
            int n11 = 0;
            ColumnReference columnReference = null;
            for (int i3 = 0; i3 < n10; ++i3) {
                ValueNode valueNode;
                optimizablePredicate = this.baseTableRestrictionList.getOptPredicate(i3);
                boolean bl11 = optimizablePredicate.isStartKey();
                boolean bl12 = optimizablePredicate.isStopKey();
                if (bl11 || bl12) {
                    bl10 = true;
                    if (!optimizablePredicate.getReferencedMap().hasSingleBitSet()) {
                        bl9 = false;
                    }
                    n3 = optimizablePredicate.compareWithKnownConstant(this, true);
                    if (bl11) {
                        if (n3 != 0 && !bl6) {
                            ++n8;
                            if (predicateList != null) {
                                predicateList.removeOptPredicate(optimizablePredicate);
                            }
                        } else {
                            bl6 = true;
                        }
                    }
                    if (bl12) {
                        if (n3 != 0 && !bl7) {
                            ++n9;
                            if (predicateList != null) {
                                predicateList.removeOptPredicate(optimizablePredicate);
                            }
                        } else {
                            bl7 = true;
                        }
                    }
                    if (!bl6 && !bl7 || this.baseTableRestrictionList.isRedundantPredicate(i3)) continue;
                    if (bl11 && bl12) {
                        ++n11;
                    }
                    if (optimizablePredicate.getIndexPosition() == 0) {
                        d10 *= optimizablePredicate.selectivity(this);
                        if (bl8) continue;
                        valueNode = ((Predicate)optimizablePredicate).getAndNode().getLeftOperand();
                        if (valueNode instanceof BinaryRelationalOperatorNode) {
                            columnReference = ((BinaryRelationalOperatorNode)valueNode).getColumnOperand(this);
                        }
                        bl8 = true;
                        continue;
                    }
                    d11 *= optimizablePredicate.selectivity(this);
                    ++n5;
                    continue;
                }
                if (this.baseTableRestrictionList.isRedundantPredicate(i3)) continue;
                if (optimizablePredicate instanceof Predicate) {
                    ColumnReference columnReference2;
                    ValueNode valueNode2;
                    ValueNode valueNode3 = ((Predicate)optimizablePredicate).getAndNode().getLeftOperand();
                    if (columnReference != null && valueNode3 instanceof LikeEscapeOperatorNode && (valueNode = (LikeEscapeOperatorNode)valueNode3).getLeftOperand().requiresTypeFromContext() && (valueNode2 = valueNode.getReceiver()) instanceof ColumnReference && (columnReference2 = (ColumnReference)valueNode2).getTableNumber() == columnReference.getTableNumber() && columnReference2.getColumnNumber() == columnReference.getColumnNumber()) {
                        d10 *= 0.2;
                    }
                }
                if (optimizablePredicate.isQualifier()) {
                    d12 *= optimizablePredicate.selectivity(this);
                    ++n6;
                } else {
                    d13 *= optimizablePredicate.selectivity(this);
                    ++n7;
                }
                bl6 = true;
                bl7 = true;
            }
            if (predicateList != null && (d15 = predicateList.selectivity(this)) == -1.0) {
                d15 = 1.0;
            }
            if (bl8 && n11 > 0) {
                IndexRowGenerator indexRowGenerator;
                if (bl3) {
                    d14 = this.tableDescriptor.selectivityForConglomerate(conglomerateDescriptor, n11);
                } else if (conglomerateDescriptor.isIndex() && (indexRowGenerator = conglomerateDescriptor.getIndexDescriptor()).isUnique() && indexRowGenerator.numberOfOrderedColumns() == 1 && n11 == 1) {
                    d14 = 1.0 / (double)this.baseRowCount();
                }
            }
            d13 *= joinStrategy.nonBasePredicateSelectivity(this, optimizablePredicateList);
            DataValueDescriptor[] dataValueDescriptorArray = n8 > 0 ? new DataValueDescriptor[n8] : null;
            DataValueDescriptor[] dataValueDescriptorArray2 = n9 > 0 ? new DataValueDescriptor[n9] : null;
            n8 = 0;
            n9 = 0;
            bl6 = false;
            bl7 = false;
            InListOperatorNode inListOperatorNode = null;
            for (n3 = 0; n3 < n10; ++n3) {
                optimizablePredicate = this.baseTableRestrictionList.getOptPredicate(n3);
                boolean bl13 = optimizablePredicate.isStartKey();
                boolean bl14 = optimizablePredicate.isStopKey();
                if (bl13 || bl14) {
                    inListOperatorNode = ((Predicate)optimizablePredicate).getSourceInList(true);
                    boolean bl15 = optimizablePredicate.compareWithKnownConstant(this, true);
                    if (bl13) {
                        if (bl15 && !bl6) {
                            dataValueDescriptorArray[n8] = optimizablePredicate.getCompareValue(this);
                            ++n8;
                        } else {
                            bl6 = true;
                        }
                    }
                    if (!bl14) continue;
                    if (bl15 && !bl7) {
                        dataValueDescriptorArray2[n9] = optimizablePredicate.getCompareValue(this);
                        ++n9;
                        continue;
                    }
                    bl7 = true;
                    continue;
                }
                bl6 = true;
                bl7 = true;
            }
            if (this.baseTableRestrictionList != null) {
                n3 = this.baseTableRestrictionList.startOperator(this);
                n2 = this.baseTableRestrictionList.stopOperator(this);
            } else {
                n3 = 0;
                n2 = 0;
            }
            DataValueDescriptor[] dataValueDescriptorArray3 = this.getRowTemplate(conglomerateDescriptor, this.getBaseCostController());
            long l2 = dataValueDescriptorArray != null || dataValueDescriptorArray2 != null ? this.baseRowCount() : this.baseRowCount() + 5L;
            storeCostController.getScanCost(joinStrategy.scanCostType(), l2, 1, this.forUpdate(), null, dataValueDescriptorArray3, dataValueDescriptorArray, n3, dataValueDescriptorArray2, n2, false, 0, costEstimate2);
            double d16 = 0.0;
            if (conglomerateDescriptor.isIndex()) {
                d16 = storeCostController.getFetchFromFullKeyCost(null, 0);
                if (bl4 && costEstimate2.rowCount() <= 1.0) {
                    costEstimate2.setCost(costEstimate2.getEstimatedCost() * 2.0, costEstimate2.rowCount() + 2.0, costEstimate2.singleScanRowCount() + 2.0);
                }
            }
            if (this.optimizerTracingIsOn()) {
                this.getOptimizerTracer().traceCostOfConglomerateScan(this.tableNumber, conglomerateDescriptor, costEstimate2, n4, d10, n5, d11, n11, d14, n6, d12, n7, d13);
            }
            double d17 = costEstimate2.rowCount();
            if (d14 != 1.0) {
                costEstimate2.setCost(this.scanCostAfterSelectivity(costEstimate2.getEstimatedCost(), d16, d14, bl4), costEstimate2.rowCount() * d14, costEstimate2.singleScanRowCount() * d14);
                if (this.optimizerTracingIsOn()) {
                    this.getOptimizerTracer().traceCostIncludingStatsForIndex(costEstimate2, this.tableNumber);
                }
            } else {
                if (d10 != 1.0) {
                    costEstimate2.setCost(this.scanCostAfterSelectivity(costEstimate2.getEstimatedCost(), d16, d10, bl4), costEstimate2.rowCount() * d10, costEstimate2.singleScanRowCount() * d10);
                    if (this.optimizerTracingIsOn()) {
                        this.getOptimizerTracer().traceCostIncludingExtra1stColumnSelectivity(costEstimate2, this.tableNumber);
                    }
                }
                if (d11 != 1.0) {
                    costEstimate2.setCost(costEstimate2.getEstimatedCost(), costEstimate2.rowCount() * d11, costEstimate2.singleScanRowCount() * d11);
                    if (this.optimizerTracingIsOn()) {
                        this.getOptimizerTracer().traceCostIncludingExtraStartStop(costEstimate2, this.tableNumber);
                    }
                }
            }
            if (inListOperatorNode != null) {
                int n12 = inListOperatorNode.getRightOperandList().size();
                double d18 = costEstimate2.rowCount() * (double)n12;
                double d19 = costEstimate2.singleScanRowCount() * (double)n12;
                costEstimate2.setCost(costEstimate2.getEstimatedCost() * (double)n12, d18 > d17 ? d17 : d18, d19 > d17 ? d17 : d19);
            }
            if (!bl10) {
                accessPath.setLockMode(7);
                if (this.optimizerTracingIsOn()) {
                    this.getOptimizerTracer().traceNoStartStopPosition();
                }
            } else {
                double d20 = costEstimate2.rowCount();
                if (!bl9 && joinStrategy.multiplyBaseCostByOuterRows()) {
                    d9 = this.baseRowCount();
                    if (d9 > 0.0) {
                        double d21;
                        d8 = costEstimate2.rowCount();
                        d7 = costEstimate.rowCount();
                        d6 = 1.0 - d8 / d9;
                        double d22 = Math.pow(d6, d7);
                        double d23 = 1.0 - d22;
                        d20 = d21 = d9 * d23;
                    } else {
                        d20 = optimizer.tableLockThreshold() + 1;
                    }
                }
                this.setLockingBasedOnThreshold(optimizer, d20);
            }
            if (conglomerateDescriptor.isIndex() && !this.isCoveringIndex(conglomerateDescriptor)) {
                double d24 = this.getBaseCostController().getFetchFromRowLocationCost(null, 0);
                d9 = costEstimate2.rowCount();
                if (bl4) {
                    d9 = Math.max(1.0, d9);
                }
                double d25 = d24 * d9;
                costEstimate2.setEstimatedCost(costEstimate2.getEstimatedCost() + d25);
                if (this.optimizerTracingIsOn()) {
                    this.getOptimizerTracer().traceCostOfNoncoveringIndex(costEstimate2, this.tableNumber);
                }
            }
            if (d12 != 1.0) {
                costEstimate2.setCost(costEstimate2.getEstimatedCost(), costEstimate2.rowCount() * d12, costEstimate2.singleScanRowCount() * d12);
                if (this.optimizerTracingIsOn()) {
                    this.getOptimizerTracer().traceCostIncludingExtraQualifierSelectivity(costEstimate2, this.tableNumber);
                }
            }
            this.singleScanRowCount = costEstimate2.singleScanRowCount();
            double d26 = costEstimate2.getEstimatedCost();
            d9 = costEstimate2.rowCount();
            if (joinStrategy.multiplyBaseCostByOuterRows()) {
                d26 *= costEstimate.rowCount();
            }
            d9 *= costEstimate.rowCount();
            d17 *= costEstimate.rowCount();
            if (bl4 && costEstimate.rowCount() < d9) {
                d9 = costEstimate.rowCount();
            }
            if (conglomerateDescriptor.isIndex() && bl10 && !bl9 && (d8 = optimizer.uniqueJoinWithOuterTable(this.baseTableRestrictionList)) > 0.0 && d9 > (d7 = (double)this.baseRowCount() / d8)) {
                d26 *= d7 / d9;
            }
            if (d2 > 0.0 && d9 > (d8 = (double)this.baseRowCount() / d2)) {
                d9 = d8;
            }
            costEstimate2.setCost(d26, d9, costEstimate2.singleScanRowCount());
            if (this.optimizerTracingIsOn()) {
                this.getOptimizerTracer().traceCostOfNScans(this.tableNumber, costEstimate.rowCount(), costEstimate2);
            }
            d8 = -1.0;
            d7 = -1.0;
            if (this.existsBaseTable) {
                d7 = 1.0;
                d8 = 1.0;
            } else if (d13 != 1.0) {
                d8 = bl4 ? costEstimate2.rowCount() : costEstimate2.rowCount() * d13;
                d7 = costEstimate2.singleScanRowCount() * d13;
            }
            if (d8 != -1.0) {
                costEstimate2.setCost(costEstimate2.getEstimatedCost(), d8, d7);
                if (this.optimizerTracingIsOn()) {
                    this.getOptimizerTracer().traceCostIncludingExtraNonQualifierSelectivity(costEstimate2, this.tableNumber);
                }
            }
            if (bl2 && !bl4 && d15 != 1.0) {
                d6 = d17 * d15;
                if (this.optimizerTracingIsOn()) {
                    this.getOptimizerTracer().traceCompositeSelectivityFromStatistics(d15);
                }
                if (!(d2 > 0.0) || !(d6 > (double)this.baseRowCount() * d2)) {
                    costEstimate2.setCost(costEstimate2.getEstimatedCost(), d6, this.existsBaseTable ? 1.0 : d6 / costEstimate.rowCount());
                    if (this.optimizerTracingIsOn()) {
                        this.getOptimizerTracer().traceCostIncludingCompositeSelectivityFromStats(costEstimate2, this.tableNumber);
                    }
                }
            }
        }
        joinStrategy.putBasePredicates(optimizablePredicateList, this.baseTableRestrictionList);
        return costEstimate2;
    }

    private double scanCostAfterSelectivity(double d2, double d3, double d4, boolean bl2) throws StandardException {
        double d5;
        double d6;
        if (bl2 && (d6 = (double)this.baseRowCount()) > 0.0 && (d5 = 2.0 / d6) > d4) {
            d4 = d5;
        }
        if ((d6 = (d2 - d3) * d4) < 0.0) {
            d6 = 0.0;
        }
        return d3 + d6;
    }

    private void setLockingBasedOnThreshold(Optimizer optimizer, double d2) {
        this.getCurrentAccessPath().setLockMode(6);
    }

    @Override
    public boolean isBaseTable() {
        return true;
    }

    @Override
    public boolean forUpdate() {
        return this.updateOrDelete != 0 || this.isCursorTargetTable() || this.getUpdateLocks;
    }

    @Override
    public int initialCapacity() {
        return this.initialCapacity;
    }

    @Override
    public float loadFactor() {
        return this.loadFactor;
    }

    @Override
    public boolean memoryUsageOK(double d2, int n2) throws StandardException {
        return super.memoryUsageOK(this.singleScanRowCount, n2);
    }

    @Override
    public boolean isTargetTable() {
        return this.updateOrDelete != 0;
    }

    @Override
    public double uniqueJoin(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        double d2 = -1.0;
        PredicateList predicateList = (PredicateList)optimizablePredicateList;
        int n2 = this.getTableDescriptor().getNumberOfColumns();
        int n3 = this.getTableNumber();
        int[] nArray = new int[]{};
        JBitSet[] jBitSetArray = new JBitSet[]{new JBitSet(n2 + 1)};
        predicateList.checkTopPredicatesForEqualsConditions(n3, null, nArray, jBitSetArray, false);
        if (this.supersetOfUniqueIndex(jBitSetArray)) {
            d2 = this.getBestAccessPath().getCostEstimate().singleScanRowCount();
        }
        return d2;
    }

    @Override
    public boolean isOneRowScan() throws StandardException {
        if (this.existsBaseTable) {
            return false;
        }
        return super.isOneRowScan();
    }

    @Override
    public boolean legalJoinOrder(JBitSet jBitSet) {
        if (this.existsBaseTable) {
            return jBitSet.contains(this.dependencyMap);
        }
        return true;
    }

    @Override
    public String toString() {
        return "";
    }

    boolean getExistsBaseTable() {
        return this.existsBaseTable;
    }

    void setExistsBaseTable(boolean bl2, JBitSet jBitSet, boolean bl3) {
        this.existsBaseTable = bl2;
        this.isNotExists = bl3;
        this.dependencyMap = bl2 ? jBitSet : null;
    }

    void clearDependency(List<Integer> list) {
        if (this.dependencyMap != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                this.dependencyMap.clear(list.get(i2));
            }
        }
    }

    void setTableProperties(Properties properties) {
        this.tableProperties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromList) throws StandardException {
        String string;
        String string2;
        this.tableName.bind();
        TableDescriptor tableDescriptor = this.bindTableDescriptor();
        if (tableDescriptor.getTableType() == 5) {
            ResultSetNode resultSetNode = this.mapTableAsVTI(tableDescriptor, this.getCorrelationName(), this.getResultColumns(), this.getProperties(), this.getContextManager());
            return resultSetNode.bindNonVTITables(dataDictionary, fromList);
        }
        ResultColumnList resultColumnList = this.getResultColumns();
        this.restrictionList = new PredicateList(this.getContextManager());
        this.baseTableRestrictionList = new PredicateList(this.getContextManager());
        CompilerContext compilerContext = this.getCompilerContext();
        this.setResultColumns(this.genResultColList());
        this.templateColumns = this.getResultColumns();
        if (tableDescriptor.getTableType() == 2) {
            ViewDescriptor viewDescriptor = dataDictionary.getViewDescriptor(tableDescriptor);
            SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(viewDescriptor.getCompSchemaId(), null);
            compilerContext.pushCompilationSchema(schemaDescriptor);
            try {
                Object object3;
                Object object22;
                compilerContext.createDependency(viewDescriptor);
                CreateViewNode createViewNode = (CreateViewNode)this.parseStatement(viewDescriptor.getViewText(), false);
                ResultSetNode resultSetNode = createViewNode.getParsedQueryExpression();
                if (resultSetNode.getResultColumns().containsAllResultColumn()) {
                    this.getResultColumns().setCountMismatchAllowed(true);
                }
                for (Object object22 : this.getResultColumns()) {
                    if (!this.isPrivilegeCollectionRequired()) continue;
                    compilerContext.addRequiredColumnPriv(((ResultColumn)object22).getTableColumnDescriptor());
                }
                FromSubquery fromSubquery = new FromSubquery(resultSetNode, createViewNode.getOrderByList(), createViewNode.getOffset(), createViewNode.getFetchFirst(), createViewNode.hasJDBClimitClause(), this.correlationName != null ? this.correlationName : this.getOrigTableName().getTableName(), this.getResultColumns(), this.tableProperties, this.getContextManager());
                fromSubquery.setLevel(this.level);
                CollectNodesVisitor<QueryTreeNode> collectNodesVisitor = new CollectNodesVisitor<QueryTreeNode>(QueryTreeNode.class);
                fromSubquery.accept(collectNodesVisitor);
                for (Object object3 : collectNodesVisitor.getList()) {
                    ((QueryTreeNode)object3).disablePrivilegeCollection();
                }
                fromSubquery.setOrigTableName(this.getOrigTableName());
                fromSubquery.setOrigCompilationSchema(schemaDescriptor);
                object22 = fromSubquery.bindNonVTITables(dataDictionary, fromList);
                if (resultColumnList != null) {
                    ((ResultSetNode)object22).getResultColumns().propagateDCLInfo(resultColumnList, this.origTableName.getFullTableName());
                }
                object3 = object22;
                return object3;
            }
            finally {
                compilerContext.popCompilationSchema();
            }
        }
        compilerContext.createDependency(tableDescriptor);
        this.baseConglomerateDescriptor = tableDescriptor.getConglomerateDescriptor(tableDescriptor.getHeapConglomerateId());
        if (this.baseConglomerateDescriptor == null) {
            throw StandardException.newException("XSAI2.S", tableDescriptor.getHeapConglomerateId());
        }
        this.columnNames = this.getResultColumns().getColumnNames();
        if (resultColumnList != null) {
            this.getResultColumns().propagateDCLInfo(resultColumnList, this.origTableName.getFullTableName());
        }
        if (this.tableNumber == -1) {
            this.tableNumber = compilerContext.getNextTableNumber();
        }
        boolean bl2 = this.authorizeSYSUSERS = dataDictionary.usesSqlAuthorization() && tableDescriptor.getUUID().toString().equals("9810800c-0134-14a5-40c1-000004f61f90");
        if (this.authorizeSYSUSERS && !(string2 = dataDictionary.getAuthorizationDatabaseOwner()).equals(string = this.getLanguageConnectionContext().getStatementContext().getSQLSessionContext().getCurrentUser())) {
            throw StandardException.newException("4251D", new Object[0]);
        }
        return this;
    }

    private ResultSetNode mapTableAsVTI(TableDescriptor tableDescriptor, String string, ResultColumnList resultColumnList, Properties properties, ContextManager contextManager) throws StandardException {
        FromVTI fromVTI;
        List<ValueNode> list = Collections.emptyList();
        NewInvocationNode newInvocationNode = new NewInvocationNode(null, tableDescriptor, list, false, contextManager);
        if (string != null) {
            fromVTI = new FromVTI(newInvocationNode, string, resultColumnList, properties, contextManager);
        } else {
            TableName tableName = newInvocationNode.makeTableName(tableDescriptor.getSchemaName(), tableDescriptor.getDescriptorName());
            fromVTI = new FromVTI(newInvocationNode, null, resultColumnList, properties, tableName, contextManager);
        }
        return fromVTI;
    }

    @Override
    FromTable getFromTableByName(String string, String string2, boolean bl2) throws StandardException {
        String string3;
        String string4 = this.getOrigTableName().getSchemaName();
        String string5 = string3 = string2 != null ? string2 + '.' + string : string;
        if (bl2) {
            if (string2 != null && string4 == null || string2 == null && string4 != null) {
                return null;
            }
            if (this.getExposedName().equals(string3)) {
                return this;
            }
            return null;
        }
        if (this.getExposedName().equals(string3)) {
            return this;
        }
        if (string2 != null && string4 != null || string2 == null && string4 == null) {
            return null;
        }
        if (string2 != null && string4 == null) {
            if (this.tableName.equals(this.origTableName) && !string2.equals(this.tableDescriptor.getSchemaDescriptor().getSchemaName())) {
                return null;
            }
            if (!this.getExposedName().equals(string)) {
                return null;
            }
            if (!this.getExposedName().equals(this.getOrigTableName().getTableName())) {
                return null;
            }
            return this;
        }
        if (!this.getExposedName().equals(this.getOrigTableName().getSchemaName() + "." + string)) {
            return null;
        }
        return this;
    }

    private TableDescriptor bindTableDescriptor() throws StandardException {
        String string = this.tableName.getSchemaName();
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(string);
        this.tableDescriptor = this.getTableDescriptor(this.tableName.getTableName(), schemaDescriptor);
        if (this.tableDescriptor == null) {
            TableName tableName = this.resolveTableToSynonym(this.tableName);
            if (tableName == null) {
                throw StandardException.newException("42X05", this.tableName);
            }
            this.tableName = tableName;
            schemaDescriptor = this.getSchemaDescriptor(this.tableName.getSchemaName());
            this.tableDescriptor = this.getTableDescriptor(tableName.getTableName(), schemaDescriptor);
            if (this.tableDescriptor == null) {
                throw StandardException.newException("42X05", this.tableName);
            }
        }
        return this.tableDescriptor;
    }

    @Override
    void bindExpressions(FromList fromList) throws StandardException {
    }

    @Override
    void bindResultColumns(FromList fromList) throws StandardException {
    }

    @Override
    ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        TableName tableName;
        ResultColumn resultColumn = null;
        TableName tableName2 = columnReference.getQualifiedTableName();
        if (tableName2 != null && tableName2.getSchemaName() == null && this.correlationName == null) {
            tableName2.bind();
        }
        if ((tableName = this.getExposedTableName()).getSchemaName() == null && this.correlationName == null) {
            tableName.bind();
        }
        if (tableName2 == null || tableName2.equals(tableName)) {
            if (this.getResultColumns() == null) {
                throw StandardException.newException("42ZB7", columnReference.getColumnName());
            }
            resultColumn = this.getResultColumns().getResultColumn(columnReference.getColumnName());
            if (resultColumn != null) {
                columnReference.setTableNumber(this.tableNumber);
                columnReference.setColumnNumber(resultColumn.getColumnPosition());
                if (!(this.tableDescriptor == null || this.rowLocationColumnName != null && this.rowLocationColumnName.equals(columnReference.getColumnName()))) {
                    FormatableBitSet formatableBitSet;
                    if (columnReference.isPrivilegeCollectionRequired() && columnReference.taggedWith("updatePrivs")) {
                        this.getCompilerContext().addRequiredColumnPriv(this.tableDescriptor.getColumnDescriptor(columnReference.getColumnName()));
                    }
                    if ((formatableBitSet = this.tableDescriptor.getReferencedColumnMap()) == null) {
                        formatableBitSet = new FormatableBitSet(this.tableDescriptor.getNumberOfColumns() + 1);
                    }
                    formatableBitSet.set(resultColumn.getColumnPosition());
                    this.tableDescriptor.setReferencedColumnMap(formatableBitSet);
                }
            }
        }
        return resultColumn;
    }

    @Override
    ResultSetNode preprocess(int n2, GroupByList groupByList, FromList fromList) throws StandardException {
        if (this.authorizeSYSUSERS) {
            int n3 = 3;
            FormatableBitSet formatableBitSet = this.getResultColumns().getReferencedFormatableBitSet(false, true, false);
            if (formatableBitSet.getLength() >= n3 && formatableBitSet.isSet(n3 - 1)) {
                throw StandardException.newException("4251E", "SYSUSERS", "PASSWORD");
            }
        }
        this.setReferencedTableMap(new JBitSet(n2));
        this.getReferencedTableMap().set(this.tableNumber);
        return this.genProjectRestrict(n2);
    }

    @Override
    protected ResultSetNode genProjectRestrict(int n2) throws StandardException {
        ResultColumnList resultColumnList = this.getResultColumns();
        this.setResultColumns(this.getResultColumns().copyListAndObjects());
        this.getResultColumns().setIndexRow(this.baseConglomerateDescriptor.getConglomerateNumber(), this.forUpdate());
        resultColumnList.genVirtualColumnNodes(this, this.getResultColumns(), false);
        resultColumnList.doProjection();
        ProjectRestrictNode projectRestrictNode = new ProjectRestrictNode(this, resultColumnList, null, null, null, null, null, this.getContextManager());
        if (this.isValidatingCheckConstraint()) {
            CompilerContext compilerContext = this.getCompilerContext();
            if ((compilerContext.getReliability() & 0x400) != 0) {
                throw StandardException.newException("42X01", "validateCheckConstraint");
            }
            projectRestrictNode.setValidatingCheckConstraints(this.targetTableUUIDString);
        }
        return projectRestrictNode;
    }

    @Override
    ResultSetNode changeAccessPath() throws StandardException {
        FormatableBitSet formatableBitSet;
        Object object2;
        AccessPath accessPath = this.getTrulyTheBestAccessPath();
        ConglomerateDescriptor conglomerateDescriptor = accessPath.getConglomerateDescriptor();
        JoinStrategy joinStrategy = accessPath.getJoinStrategy();
        Optimizer optimizer = accessPath.getOptimizer();
        if (this.optimizerTracingIsOn()) {
            this.getOptimizerTracer().traceChangingAccessPathForTable(this.tableNumber);
        }
        if (this.bulkFetch != -1) {
            if (!joinStrategy.bulkFetchOK()) {
                throw StandardException.newException("42Y65", joinStrategy.getName());
            }
            if (joinStrategy.ignoreBulkFetch()) {
                this.disableBulkFetch();
            } else if (this.isOneRowResultSet()) {
                this.disableBulkFetch();
            }
        }
        if (this.bulkFetch == 1) {
            this.disableBulkFetch();
        }
        this.restrictionList.removeRedundantPredicates();
        this.storeRestrictionList = new PredicateList(this.getContextManager());
        this.nonStoreRestrictionList = new PredicateList(this.getContextManager());
        this.requalificationRestrictionList = new PredicateList(this.getContextManager());
        joinStrategy.divideUpPredicateLists(this, this.restrictionList, this.storeRestrictionList, this.nonStoreRestrictionList, this.requalificationRestrictionList, this.getDataDictionary());
        for (Object object2 : this.restrictionList) {
            if (!((Predicate)object2).isInListProbePredicate() || !((Predicate)object2).isStartKey()) continue;
            this.disableBulkFetch();
            this.multiProbing = true;
            break;
        }
        if (!(!joinStrategy.bulkFetchOK() || joinStrategy.ignoreBulkFetch() || this.bulkFetchTurnedOff || this.bulkFetch != -1 || this.forUpdate() || this.isOneRowResultSet() || this.getLevel() != 0 || this.validatingCheckConstraint)) {
            this.bulkFetch = this.getDefaultBulkFetch();
        }
        this.getCompilerContext().createDependency(conglomerateDescriptor);
        if (!conglomerateDescriptor.isIndex()) {
            boolean bl2 = this.tableName.equals("SYS", "SYSSTATEMENTS");
            this.templateColumns = this.getResultColumns();
            this.referencedCols = this.getResultColumns().getReferencedFormatableBitSet(this.isCursorTargetTable(), bl2, false);
            this.setResultColumns(this.getResultColumns().compactColumns(this.isCursorTargetTable(), bl2));
            return this;
        }
        if (accessPath.getCoveringIndexScan() && !this.isCursorTargetTable()) {
            this.setResultColumns(this.newResultColumns(this.getResultColumns(), conglomerateDescriptor, this.baseConglomerateDescriptor, false));
            this.templateColumns = this.newResultColumns(this.getResultColumns(), conglomerateDescriptor, this.baseConglomerateDescriptor, false);
            this.templateColumns.addRCForRID();
            if (this.forUpdate()) {
                this.getResultColumns().addRCForRID();
            }
            this.referencedCols = this.getResultColumns().getReferencedFormatableBitSet(this.isCursorTargetTable(), true, false);
            this.setResultColumns(this.getResultColumns().compactColumns(this.isCursorTargetTable(), true));
            this.getResultColumns().setIndexRow(this.baseConglomerateDescriptor.getConglomerateNumber(), this.forUpdate());
            return this;
        }
        this.getCompilerContext().createDependency(this.baseConglomerateDescriptor);
        if (this.bulkFetch != -1) {
            this.restrictionList.copyPredicatesToOtherList(this.requalificationRestrictionList);
        }
        ResultColumnList resultColumnList = this.newResultColumns(this.getResultColumns(), conglomerateDescriptor, this.baseConglomerateDescriptor, true);
        object2 = null;
        if (this.bulkFetch == -1 && (this.requalificationRestrictionList == null || this.requalificationRestrictionList.size() == 0)) {
            object2 = this.getResultColumns().getReferencedFormatableBitSet(this.isCursorTargetTable(), true, false);
            formatableBitSet = this.getResultColumns().getReferencedFormatableBitSet(this.isCursorTargetTable(), true, true);
            if (formatableBitSet != null) {
                ((FormatableBitSet)object2).xor(formatableBitSet);
            }
        } else {
            formatableBitSet = this.getResultColumns().getReferencedFormatableBitSet(this.isCursorTargetTable(), true, false);
        }
        ResultColumnList resultColumnList2 = this.getResultColumns().compactColumns(this.isCursorTargetTable(), false);
        resultColumnList2.setIndexRow(this.baseConglomerateDescriptor.getConglomerateNumber(), this.forUpdate());
        IndexToBaseRowNode indexToBaseRowNode = new IndexToBaseRowNode(this, this.baseConglomerateDescriptor, resultColumnList2, this.isCursorTargetTable(), formatableBitSet, (FormatableBitSet)object2, this.requalificationRestrictionList, this.forUpdate(), this.tableProperties, this.getContextManager());
        this.setResultColumns(resultColumnList);
        this.templateColumns = this.newResultColumns(this.getResultColumns(), conglomerateDescriptor, this.baseConglomerateDescriptor, false);
        if (this.bulkFetch != -1) {
            this.getResultColumns().markAllUnreferenced();
            this.storeRestrictionList.markReferencedColumns();
            if (this.nonStoreRestrictionList != null) {
                this.nonStoreRestrictionList.markReferencedColumns();
            }
        }
        this.getResultColumns().addRCForRID();
        this.templateColumns.addRCForRID();
        this.referencedCols = this.getResultColumns().getReferencedFormatableBitSet(this.isCursorTargetTable(), false, false);
        this.setResultColumns(this.getResultColumns().compactColumns(this.isCursorTargetTable(), false));
        this.getResultColumns().setIndexRow(this.baseConglomerateDescriptor.getConglomerateNumber(), this.forUpdate());
        this.getUpdateLocks = this.isCursorTargetTable();
        this.setCursorTargetTable(false);
        return indexToBaseRowNode;
    }

    private ResultColumnList newResultColumns(ResultColumnList resultColumnList, ConglomerateDescriptor conglomerateDescriptor, ConglomerateDescriptor conglomerateDescriptor2, boolean bl2) throws StandardException {
        IndexRowGenerator indexRowGenerator = conglomerateDescriptor.getIndexDescriptor();
        int[] nArray = indexRowGenerator.baseColumnPositions();
        ResultColumnList resultColumnList2 = new ResultColumnList(this.getContextManager());
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            ResultColumn resultColumn;
            int n2 = nArray[i2];
            ResultColumn resultColumn2 = resultColumnList.getResultColumn(n2);
            if (bl2) {
                resultColumn = resultColumn2.cloneMe();
                resultColumn2.setExpression(new VirtualColumnNode(this, resultColumn, resultColumn2.getVirtualColumnId(), this.getContextManager()));
            } else {
                resultColumn = resultColumn2;
            }
            resultColumnList2.addResultColumn(resultColumn);
        }
        resultColumnList2.setIndexRow(conglomerateDescriptor2.getConglomerateNumber(), this.forUpdate());
        return resultColumnList2;
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        if (this.rowLocationColumnName != null) {
            this.getResultColumns().conglomerateId = this.tableDescriptor.getHeapConglomerateId();
        }
        this.generateResultSet(activationClassBuilder, methodBuilder);
        if (this.isCursorTargetTable()) {
            activationClassBuilder.rememberCursorTarget(methodBuilder);
        }
    }

    @Override
    void generateResultSet(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.assignResultSetNumber();
        if (this.specialMaxScan) {
            this.generateMaxSpecialResultSet(expressionClassBuilder, methodBuilder);
            return;
        }
        if (this.distinctScan) {
            this.generateDistinctScan(expressionClassBuilder, methodBuilder);
            return;
        }
        if (this.raDependentScan) {
            this.generateRefActionDependentTableScan(expressionClassBuilder, methodBuilder);
            return;
        }
        JoinStrategy joinStrategy = this.getTrulyTheBestAccessPath().getJoinStrategy();
        expressionClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        int n2 = this.getScanArguments(expressionClassBuilder, methodBuilder);
        methodBuilder.callMethod((short)185, null, joinStrategy.resultSetMethodName(this.bulkFetch != -1, this.multiProbing, this.validatingCheckConstraint), "org.apache.derby.iapi.sql.execute.NoPutResultSet", n2);
        if (this.updateOrDelete == 1 || this.updateOrDelete == 2) {
            methodBuilder.cast("org.apache.derby.iapi.sql.execute.CursorResultSet");
            methodBuilder.putField(expressionClassBuilder.getRowLocationScanResultSetName(), "org.apache.derby.iapi.sql.execute.CursorResultSet");
            methodBuilder.cast("org.apache.derby.iapi.sql.execute.NoPutResultSet");
        }
    }

    @Override
    CostEstimate getFinalCostEstimate() {
        return this.getTrulyTheBestAccessPath().getCostEstimate();
    }

    private void pushIndexName(ConglomerateDescriptor conglomerateDescriptor, MethodBuilder methodBuilder) throws StandardException {
        if (conglomerateDescriptor.isConstraint()) {
            DataDictionary dataDictionary = this.getDataDictionary();
            ConstraintDescriptor constraintDescriptor = dataDictionary.getConstraintDescriptor(this.tableDescriptor, conglomerateDescriptor.getUUID());
            methodBuilder.push(constraintDescriptor.getConstraintName());
        } else if (conglomerateDescriptor.isIndex()) {
            methodBuilder.push(conglomerateDescriptor.getConglomerateName());
        } else {
            methodBuilder.pushNull("java.lang.String");
        }
    }

    private void generateMaxSpecialResultSet(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        ConglomerateDescriptor conglomerateDescriptor = this.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        CostEstimate costEstimate = this.getFinalCostEstimate();
        int n2 = this.referencedCols == null ? -1 : expressionClassBuilder.addItem(this.referencedCols);
        boolean bl2 = this.tableDescriptor.getLockGranularity() == 'T';
        expressionClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        expressionClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.push(this.getResultSetNumber());
        methodBuilder.push(expressionClassBuilder.addItem(this.getResultColumns().buildRowTemplate(this.referencedCols, false)));
        methodBuilder.push(conglomerateDescriptor.getConglomerateNumber());
        methodBuilder.push(this.tableDescriptor.getName());
        if (this.tableProperties != null) {
            methodBuilder.push(org.apache.derby.iapi.util.PropertyUtil.sortProperties(this.tableProperties));
        } else {
            methodBuilder.pushNull("java.lang.String");
        }
        this.pushIndexName(conglomerateDescriptor, methodBuilder);
        methodBuilder.push(n2);
        methodBuilder.push(this.getTrulyTheBestAccessPath().getLockMode());
        methodBuilder.push(bl2);
        methodBuilder.push(this.getCompilerContext().getScanIsolationLevel());
        methodBuilder.push(costEstimate.singleScanRowCount());
        methodBuilder.push(costEstimate.getEstimatedCost());
        methodBuilder.callMethod((short)185, null, "getLastIndexKeyResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 13);
    }

    private void generateDistinctScan(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n2;
        ConglomerateDescriptor conglomerateDescriptor = this.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        CostEstimate costEstimate = this.getFinalCostEstimate();
        int n3 = this.referencedCols == null ? -1 : expressionClassBuilder.addItem(this.referencedCols);
        boolean bl2 = this.tableDescriptor.getLockGranularity() == 'T';
        int[] nArray = new int[this.getResultColumns().size()];
        if (this.referencedCols == null) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray[n2] = n2;
            }
        } else {
            n2 = 0;
            int n4 = this.referencedCols.anySetBit();
            while (n4 != -1) {
                nArray[n2++] = n4;
                n4 = this.referencedCols.anySetBit(n4);
            }
        }
        Object[] objectArray = FormatableIntHolder.getFormatableIntHolders(nArray);
        FormatableArrayHolder formatableArrayHolder = new FormatableArrayHolder(objectArray);
        int n5 = expressionClassBuilder.addItem(formatableArrayHolder);
        long l2 = conglomerateDescriptor.getConglomerateNumber();
        StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo = this.getLanguageConnectionContext().getTransactionCompile().getStaticCompiledConglomInfo(l2);
        expressionClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        expressionClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.push(l2);
        methodBuilder.push(expressionClassBuilder.addItem(staticCompiledOpenConglomInfo));
        methodBuilder.push(expressionClassBuilder.addItem(this.getResultColumns().buildRowTemplate(this.referencedCols, false)));
        methodBuilder.push(this.getResultSetNumber());
        methodBuilder.push(n5);
        methodBuilder.push(this.tableDescriptor.getName());
        if (this.tableProperties != null) {
            methodBuilder.push(org.apache.derby.iapi.util.PropertyUtil.sortProperties(this.tableProperties));
        } else {
            methodBuilder.pushNull("java.lang.String");
        }
        this.pushIndexName(conglomerateDescriptor, methodBuilder);
        methodBuilder.push(conglomerateDescriptor.isConstraint());
        methodBuilder.push(n3);
        methodBuilder.push(this.getTrulyTheBestAccessPath().getLockMode());
        methodBuilder.push(bl2);
        methodBuilder.push(this.getCompilerContext().getScanIsolationLevel());
        methodBuilder.push(costEstimate.singleScanRowCount());
        methodBuilder.push(costEstimate.getEstimatedCost());
        methodBuilder.callMethod((short)185, null, "getDistinctScanResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 16);
    }

    private void generateRefActionDependentTableScan(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        expressionClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        int n2 = this.getScanArguments(expressionClassBuilder, methodBuilder);
        methodBuilder.push(this.raParentResultSetId);
        methodBuilder.push(this.fkIndexConglomId);
        methodBuilder.push(expressionClassBuilder.addItem(this.fkColArray));
        methodBuilder.push(expressionClassBuilder.addItem(this.getDataDictionary().getRowLocationTemplate(this.getLanguageConnectionContext(), this.tableDescriptor)));
        int n3 = n2 + 4;
        methodBuilder.callMethod((short)185, null, "getRaDependentTableScanResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", n3);
        if (this.updateOrDelete == 1 || this.updateOrDelete == 2) {
            methodBuilder.cast("org.apache.derby.iapi.sql.execute.CursorResultSet");
            methodBuilder.putField(expressionClassBuilder.getRowLocationScanResultSetName(), "org.apache.derby.iapi.sql.execute.CursorResultSet");
            methodBuilder.cast("org.apache.derby.iapi.sql.execute.NoPutResultSet");
        }
    }

    private int getScanArguments(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        Object object;
        Object object2;
        int n2 = expressionClassBuilder.addItem(this.getResultColumns().buildRowTemplate(this.referencedCols, false));
        int n3 = -1;
        if (this.referencedCols != null) {
            n3 = expressionClassBuilder.addItem(this.referencedCols);
        }
        int n4 = -1;
        if ((this.isCursorTargetTable() || this.getUpdateLocks) && ((ConglomerateDescriptor)(object2 = this.getTrulyTheBestAccessPath().getConglomerateDescriptor())).isIndex()) {
            object = ((ConglomerateDescriptor)object2).getIndexDescriptor().baseColumnPositions();
            boolean[] blArray = ((ConglomerateDescriptor)object2).getIndexDescriptor().isAscending();
            int[] nArray = new int[((Object)object).length];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = (int)(blArray[i2] ? object[i2] : -object[i2]);
            }
            n4 = expressionClassBuilder.addItem(nArray);
        }
        object2 = this.getTrulyTheBestAccessPath();
        object = object2.getJoinStrategy();
        int n5 = object.getScanArgs(this.getLanguageConnectionContext().getTransactionCompile(), methodBuilder, this, this.storeRestrictionList, this.nonStoreRestrictionList, expressionClassBuilder, this.bulkFetch, n2, n3, n4, this.getTrulyTheBestAccessPath().getLockMode(), this.tableDescriptor.getLockGranularity() == 'T', this.getCompilerContext().getScanIsolationLevel(), object2.getOptimizer().getMaxMemoryPerTable(), this.multiProbing);
        return n5;
    }

    private int mapAbsoluteToRelativeColumnPosition(int n2) {
        if (this.referencedCols == null) {
            return n2;
        }
        int n3 = 0;
        for (int i2 = 0; i2 < this.referencedCols.size() && i2 < n2; ++i2) {
            if (!this.referencedCols.get(i2)) continue;
            ++n3;
        }
        return n3;
    }

    @Override
    String getExposedName() {
        if (this.correlationName != null) {
            return this.correlationName;
        }
        return this.getOrigTableName().getFullTableName();
    }

    TableName getExposedTableName() throws StandardException {
        if (this.correlationName != null) {
            return this.makeTableName(null, this.correlationName);
        }
        return this.getOrigTableName();
    }

    TableName getTableNameField() {
        return this.tableName;
    }

    @Override
    ResultColumnList getAllResultColumns(TableName tableName) throws StandardException {
        return this.getResultColumnsForList(tableName, this.getResultColumns(), this.getOrigTableName());
    }

    ResultColumnList genResultColList() throws StandardException {
        Object object;
        TableName tableName = this.getExposedTableName();
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        ColumnDescriptorList columnDescriptorList = this.tableDescriptor.getColumnDescriptorList();
        int n2 = columnDescriptorList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            object = columnDescriptorList.elementAt(i2);
            ((ColumnDescriptor)object).setTableDescriptor(this.tableDescriptor);
            BaseColumnNode baseColumnNode = new BaseColumnNode(((ColumnDescriptor)object).getColumnName(), tableName, ((ColumnDescriptor)object).getType(), this.getContextManager());
            ResultColumn resultColumn = new ResultColumn((ColumnDescriptor)object, (ValueNode)baseColumnNode, this.getContextManager());
            resultColumnList.addResultColumn(resultColumn);
        }
        if (this.rowLocationColumnName != null) {
            CurrentRowLocationNode currentRowLocationNode = new CurrentRowLocationNode(this.getContextManager());
            object = new ResultColumn(this.rowLocationColumnName, (ValueNode)currentRowLocationNode, this.getContextManager());
            ((ResultColumn)object).markGenerated();
            currentRowLocationNode.bindExpression(null, null, null);
            ((ResultColumn)object).bindResultColumnToExpression();
            resultColumnList.addResultColumn((ResultColumn)object);
        }
        return resultColumnList;
    }

    ResultColumnList addColsToList(ResultColumnList resultColumnList, FormatableBitSet formatableBitSet) throws StandardException {
        TableName tableName = this.getExposedTableName();
        ResultColumnList resultColumnList2 = new ResultColumnList(this.getContextManager());
        ColumnDescriptorList columnDescriptorList = this.tableDescriptor.getColumnDescriptorList();
        int n2 = columnDescriptorList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(i2);
            int n3 = columnDescriptor.getPosition();
            if (!formatableBitSet.get(n3)) continue;
            ResultColumn resultColumn = resultColumnList.getResultColumn(n3);
            if (resultColumn == null) {
                ColumnReference columnReference = new ColumnReference(columnDescriptor.getColumnName(), tableName, this.getContextManager());
                if (this.getMergeTableID() != 0) {
                    columnReference.setMergeTableID(this.getMergeTableID());
                }
                resultColumn = new ResultColumn(columnDescriptor, (ValueNode)columnReference, this.getContextManager());
            }
            resultColumnList2.addResultColumn(resultColumn);
        }
        return resultColumnList2;
    }

    @Override
    TableName getTableName() throws StandardException {
        TableName tableName = super.getTableName();
        if (tableName != null && tableName.getSchemaName() == null && this.correlationName == null) {
            tableName.bind();
        }
        return tableName != null ? tableName : this.tableName;
    }

    @Override
    boolean markAsCursorTargetTable() {
        this.setCursorTargetTable(true);
        return true;
    }

    @Override
    protected boolean cursorTargetTable() {
        return this.isCursorTargetTable();
    }

    void markUpdated(ResultColumnList resultColumnList) {
        this.getResultColumns().markUpdated(resultColumnList);
    }

    @Override
    boolean referencesTarget(String string, boolean bl2) throws StandardException {
        return bl2 && string.equals(this.getBaseTableName());
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.tableDescriptor.getSchemaDescriptor());
    }

    @Override
    boolean isOneRowResultSet() throws StandardException {
        if (this.existsBaseTable) {
            return true;
        }
        AccessPath accessPath = this.getTrulyTheBestAccessPath();
        JoinStrategy joinStrategy = accessPath.getJoinStrategy();
        if (joinStrategy.isHashJoin()) {
            PredicateList predicateList = new PredicateList(this.getContextManager());
            if (this.storeRestrictionList != null) {
                predicateList.nondestructiveAppend(this.storeRestrictionList);
            }
            if (this.nonStoreRestrictionList != null) {
                predicateList.nondestructiveAppend(this.nonStoreRestrictionList);
            }
            return this.isOneRowResultSet(predicateList);
        }
        return this.isOneRowResultSet(this.getTrulyTheBestAccessPath().getConglomerateDescriptor(), this.restrictionList);
    }

    @Override
    boolean isNotExists() {
        return this.isNotExists;
    }

    boolean isOneRowResultSet(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        ConglomerateDescriptor[] conglomerateDescriptorArray = this.tableDescriptor.getConglomerateDescriptors();
        for (int i2 = 0; i2 < conglomerateDescriptorArray.length; ++i2) {
            if (!this.isOneRowResultSet(conglomerateDescriptorArray[i2], optimizablePredicateList)) continue;
            return true;
        }
        return false;
    }

    protected boolean supersetOfUniqueIndex(boolean[] blArray) throws StandardException {
        ConglomerateDescriptor[] conglomerateDescriptorArray = this.tableDescriptor.getConglomerateDescriptors();
        for (int i2 = 0; i2 < conglomerateDescriptorArray.length; ++i2) {
            int n2;
            IndexRowGenerator indexRowGenerator;
            ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[i2];
            if (!conglomerateDescriptor.isIndex() || !(indexRowGenerator = conglomerateDescriptor.getIndexDescriptor()).isUnique()) continue;
            int[] nArray = indexRowGenerator.baseColumnPositions();
            for (n2 = 0; n2 < nArray.length && blArray[nArray[n2]]; ++n2) {
            }
            if (n2 != nArray.length) continue;
            return true;
        }
        return false;
    }

    protected boolean supersetOfUniqueIndex(JBitSet[] jBitSetArray) throws StandardException {
        ConglomerateDescriptor[] conglomerateDescriptorArray = this.tableDescriptor.getConglomerateDescriptors();
        for (int i2 = 0; i2 < conglomerateDescriptorArray.length; ++i2) {
            IndexRowGenerator indexRowGenerator;
            ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[i2];
            if (!conglomerateDescriptor.isIndex() || !(indexRowGenerator = conglomerateDescriptor.getIndexDescriptor()).isUnique()) continue;
            int[] nArray = indexRowGenerator.baseColumnPositions();
            int n2 = jBitSetArray[0].size();
            JBitSet jBitSet = new JBitSet(n2);
            JBitSet jBitSet2 = new JBitSet(n2);
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                jBitSet.set(nArray[i3]);
            }
            for (int i4 = 0; i4 < jBitSetArray.length; ++i4) {
                jBitSet2.setTo(jBitSetArray[i4]);
                jBitSet2.and(jBitSet);
                if (!jBitSet.equals(jBitSet2)) continue;
                jBitSetArray[i4].set(0);
                return true;
            }
        }
        return false;
    }

    @Override
    int updateTargetLockMode() {
        if (this.getTrulyTheBestAccessPath().getConglomerateDescriptor().isIndex()) {
            return 6;
        }
        int n2 = this.getLanguageConnectionContext().getCurrentIsolationLevel();
        if (n2 != 4 && this.tableDescriptor.getLockGranularity() != 'T') {
            int n3 = this.getTrulyTheBestAccessPath().getLockMode();
            n3 = n3 != 6 ? (n3 & 0xFF) << 16 : 0;
            return n3 += 6;
        }
        return this.getTrulyTheBestAccessPath().getLockMode();
    }

    @Override
    boolean isOrderedOn(ColumnReference[] columnReferenceArray, boolean bl2, List<FromBaseTable> list) throws StandardException {
        for (int i2 = 0; i2 < columnReferenceArray.length; ++i2) {
            if (columnReferenceArray[i2].getTableNumber() == this.tableNumber) continue;
            return false;
        }
        ConglomerateDescriptor conglomerateDescriptor = this.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        if (!conglomerateDescriptor.isIndex()) {
            return false;
        }
        boolean bl3 = bl2 ? this.isOrdered(columnReferenceArray, conglomerateDescriptor) : this.isStrictlyOrdered(columnReferenceArray, conglomerateDescriptor);
        if (list != null) {
            list.add(this);
        }
        return bl3;
    }

    void disableBulkFetch() {
        this.bulkFetchTurnedOff = true;
        this.bulkFetch = -1;
    }

    void doSpecialMaxScan() {
        this.specialMaxScan = true;
    }

    @Override
    boolean isPossibleDistinctScan(Set<BaseColumnNode> set) {
        if (this.restrictionList != null && this.restrictionList.size() != 0) {
            return false;
        }
        HashSet<ValueNode> hashSet = new HashSet<ValueNode>();
        for (ResultColumn resultColumn : this.getResultColumns()) {
            hashSet.add(resultColumn.getExpression());
        }
        return hashSet.equals(set);
    }

    @Override
    void markForDistinctScan() {
        this.distinctScan = true;
    }

    @Override
    void adjustForSortElimination() {
    }

    @Override
    void adjustForSortElimination(RequiredRowOrdering requiredRowOrdering) throws StandardException {
        if (this.restrictionList != null) {
            this.restrictionList.adjustForSortElimination(requiredRowOrdering);
        }
    }

    private boolean isOrdered(ColumnReference[] columnReferenceArray, ConglomerateDescriptor conglomerateDescriptor) throws StandardException {
        int n2;
        int n3;
        int n4;
        boolean[] blArray = new boolean[columnReferenceArray.length];
        int[] nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
        for (n4 = 0; n4 < nArray.length; ++n4) {
            n3 = 0;
            for (n2 = 0; n2 < columnReferenceArray.length; ++n2) {
                if (columnReferenceArray[n2].getColumnNumber() != nArray[n4]) continue;
                blArray[n2] = true;
                n3 = 1;
                break;
            }
            if (n3 == 0 && !this.storeRestrictionList.hasOptimizableEqualityPredicate(this, nArray[n4], true)) break;
        }
        n3 = 0;
        for (n2 = 0; n2 < blArray.length; ++n2) {
            if (!blArray[n2]) continue;
            ++n3;
        }
        if (n3 == blArray.length) {
            return true;
        }
        if (n4 == nArray.length) {
            return conglomerateDescriptor.getIndexDescriptor().isUnique();
        }
        return false;
    }

    private boolean isStrictlyOrdered(ColumnReference[] columnReferenceArray, ConglomerateDescriptor conglomerateDescriptor) throws StandardException {
        int n2 = 0;
        int[] nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
        block0: for (int i2 = 0; i2 < columnReferenceArray.length; ++i2) {
            if (n2 == nArray.length) {
                if (conglomerateDescriptor.getIndexDescriptor().isUnique()) break;
                return false;
            }
            if (columnReferenceArray[i2].getColumnNumber() == nArray[n2]) {
                ++n2;
                continue;
            }
            while (columnReferenceArray[i2].getColumnNumber() != nArray[n2]) {
                if (!this.storeRestrictionList.hasOptimizableEqualityPredicate(this, nArray[n2], true)) {
                    return false;
                }
                if (++n2 != nArray.length) continue;
                if (conglomerateDescriptor.getIndexDescriptor().isUnique()) continue block0;
                return false;
            }
        }
        return true;
    }

    private boolean isOneRowResultSet(ConglomerateDescriptor conglomerateDescriptor, OptimizablePredicateList optimizablePredicateList) throws StandardException {
        if (optimizablePredicateList == null) {
            return false;
        }
        PredicateList predicateList = (PredicateList)optimizablePredicateList;
        if (!conglomerateDescriptor.isIndex()) {
            return false;
        }
        IndexRowGenerator indexRowGenerator = conglomerateDescriptor.getIndexDescriptor();
        if (!indexRowGenerator.isUnique()) {
            return false;
        }
        int[] nArray = indexRowGenerator.baseColumnPositions();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            if (predicateList.hasOptimizableEqualityPredicate(this, n2, true)) continue;
            return false;
        }
        return true;
    }

    private int getDefaultBulkFetch() throws StandardException {
        String string = PropertyUtil.getServiceProperty(this.getLanguageConnectionContext().getTransactionCompile(), "derby.language.bulkFetchDefault", "16");
        int n2 = this.getIntProperty(string, "derby.language.bulkFetchDefault");
        if (n2 <= 0) {
            throw StandardException.newException("42Y64", String.valueOf(n2));
        }
        return n2 <= 1 ? -1 : n2;
    }

    private String getUserSpecifiedIndexName() {
        String string = null;
        if (this.tableProperties != null) {
            string = this.tableProperties.getProperty("index");
        }
        return string;
    }

    private StoreCostController getStoreCostController(ConglomerateDescriptor conglomerateDescriptor) throws StandardException {
        return this.getCompilerContext().getStoreCostController(conglomerateDescriptor.getConglomerateNumber());
    }

    private StoreCostController getBaseCostController() throws StandardException {
        return this.getStoreCostController(this.baseConglomerateDescriptor);
    }

    private long baseRowCount() throws StandardException {
        if (!this.gotRowCount) {
            StoreCostController storeCostController = this.getBaseCostController();
            this.rowCount = storeCostController.getEstimatedRowCount();
            this.gotRowCount = true;
        }
        return this.rowCount;
    }

    private DataValueDescriptor[] getRowTemplate(ConglomerateDescriptor conglomerateDescriptor, StoreCostController storeCostController) throws StandardException {
        if (!conglomerateDescriptor.isIndex()) {
            return this.templateColumns.buildEmptyRow().getRowArray();
        }
        ExecRow execRow = this.templateColumns.buildEmptyIndexRow(this.tableDescriptor, conglomerateDescriptor, storeCostController, this.getDataDictionary());
        return execRow.getRowArray();
    }

    private ConglomerateDescriptor getFirstConglom() throws StandardException {
        this.getConglomDescs();
        return this.conglomDescs[0];
    }

    private ConglomerateDescriptor getNextConglom(ConglomerateDescriptor conglomerateDescriptor) {
        int n2;
        for (n2 = 0; n2 < this.conglomDescs.length && conglomerateDescriptor != this.conglomDescs[n2]; ++n2) {
        }
        if (n2 < this.conglomDescs.length - 1) {
            return this.conglomDescs[n2 + 1];
        }
        return null;
    }

    private void getConglomDescs() throws StandardException {
        if (this.conglomDescs == null) {
            this.conglomDescs = this.tableDescriptor.getConglomerateDescriptors();
        }
    }

    @Override
    void setRefActionInfo(long l2, int[] nArray, String string, boolean bl2) {
        this.fkIndexConglomId = l2;
        this.fkColArray = nArray;
        this.raParentResultSetId = string;
        this.raDependentScan = bl2;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.nonStoreRestrictionList != null) {
            this.nonStoreRestrictionList.accept(visitor);
        }
        if (this.restrictionList != null) {
            this.restrictionList.accept(visitor);
        }
        if (this.nonBaseTableRestrictionList != null) {
            this.nonBaseTableRestrictionList.accept(visitor);
        }
        if (this.requalificationRestrictionList != null) {
            this.requalificationRestrictionList.accept(visitor);
        }
        if (this.tableName != null) {
            this.tableName = (TableName)this.tableName.accept(visitor);
        }
    }

    private boolean qualifiesForStatisticsUpdateCheck(TableDescriptor tableDescriptor) throws StandardException {
        int n2 = 0;
        if (tableDescriptor.getTableType() == 0) {
            IndexStatisticsDaemonImpl indexStatisticsDaemonImpl = (IndexStatisticsDaemonImpl)this.getDataDictionary().getIndexStatsRefresher(false);
            n2 = indexStatisticsDaemonImpl == null ? 0 : (indexStatisticsDaemonImpl.skipDisposableStats ? tableDescriptor.getQualifiedNumberOfIndexes(2, true) : tableDescriptor.getTotalNumberOfIndexes());
        }
        return n2 > 0;
    }
}

