/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.ClassBuilder;
import org.apache.derby.iapi.services.compiler.JavaFactory;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.ExpressionClassBuilderInterface;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.sql.compile.OrderedColumnList;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.execute.IndexColumnOrder;

abstract class ExpressionClassBuilder
implements ExpressionClassBuilderInterface {
    protected static final String currentDatetimeFieldName = "cdt";
    protected ClassBuilder cb;
    protected GeneratedClass gc;
    protected int nextExprNum;
    protected int nextNonFastExpr;
    protected int nextFieldNum;
    protected MethodBuilder constructor;
    CompilerContext myCompCtx;
    MethodBuilder executeMethod;
    protected LocalField cdtField;
    private String currentRowScanResultSetName;
    private Object getDVF;
    private Object getRSF;
    private Object getEF;

    ExpressionClassBuilder(String string, String string2, CompilerContext compilerContext) throws StandardException {
        int n2 = 17;
        this.myCompCtx = compilerContext;
        JavaFactory javaFactory = this.myCompCtx.getJavaFactory();
        if (string2 == null) {
            string2 = this.myCompCtx.getUniqueClassName();
        }
        this.cb = javaFactory.newClassBuilder(this.myCompCtx.getClassFactory(), this.getPackageName(), n2, string2, string);
        this.beginConstructor();
    }

    abstract String getPackageName();

    abstract int getRowCount() throws StandardException;

    abstract void setNumSubqueries() throws StandardException;

    abstract String getBaseClassName();

    MethodBuilder getConstructor() {
        return this.constructor;
    }

    ClassBuilder getClassBuilder() {
        return this.cb;
    }

    MethodBuilder getExecuteMethod() {
        if (this.executeMethod == null) {
            this.executeMethod = this.cb.newMethodBuilder(4, "void", "reinit");
            this.executeMethod.addThrownException("org.apache.derby.iapi.error.StandardException");
        }
        return this.executeMethod;
    }

    private void beginConstructor() {
        MethodBuilder methodBuilder = this.cb.newConstructorBuilder(1);
        methodBuilder.callSuper();
        methodBuilder.methodReturn();
        methodBuilder.complete();
        this.constructor = this.cb.newMethodBuilder(1, "void", "postConstructor");
        this.constructor.addThrownException("org.apache.derby.iapi.error.StandardException");
    }

    void finishConstructor() throws StandardException {
        this.setNumSubqueries();
        int n2 = this.getRowCount();
        if (n2 >= 1) {
            this.addNewArrayOfRows(n2);
        }
        this.constructor.methodReturn();
        this.constructor.complete();
    }

    private void addNewArrayOfRows(int n2) {
        this.constructor.pushThis();
        this.constructor.pushNewArray("org.apache.derby.iapi.sql.execute.ExecRow", n2);
        this.constructor.putField("org.apache.derby.impl.sql.execute.BaseActivation", "row", "org.apache.derby.iapi.sql.execute.ExecRow[]");
        this.constructor.endStatement();
    }

    LocalField newFieldDeclaration(int n2, String string, String string2) {
        return this.cb.addField(string, string2, n2);
    }

    LocalField newFieldDeclaration(int n2, String string) {
        return this.cb.addField(string, this.newFieldName(), n2);
    }

    MethodBuilder newGeneratedFun(String string, int n2) {
        return this.newGeneratedFun(string, n2, null);
    }

    MethodBuilder newGeneratedFun(String string, int n2, String[] stringArray) {
        String string2 = "g".concat(Integer.toString(this.nextNonFastExpr++));
        return this.newGeneratedFun(string2, string, n2, stringArray);
    }

    private MethodBuilder newGeneratedFun(String string, String string2, int n2, String[] stringArray) {
        MethodBuilder methodBuilder = stringArray == null ? this.cb.newMethodBuilder(n2, string2, string) : this.cb.newMethodBuilder(n2, string2, string, stringArray);
        methodBuilder.addThrownException("org.apache.derby.iapi.error.StandardException");
        return methodBuilder;
    }

    MethodBuilder newExprFun() {
        String string = "e".concat(Integer.toString(this.nextExprNum++));
        return this.newGeneratedFun(string, "java.lang.Object", 1, null);
    }

    void pushMethodReference(MethodBuilder methodBuilder, MethodBuilder methodBuilder2) {
        methodBuilder.pushThis();
        methodBuilder.push(methodBuilder2.getName());
        methodBuilder.callMethod((short)185, "org.apache.derby.iapi.services.loader.GeneratedByteCode", "getMethod", "org.apache.derby.iapi.services.loader.GeneratedMethod", 1);
    }

    MethodBuilder newUserExprFun() {
        MethodBuilder methodBuilder = this.newExprFun();
        methodBuilder.addThrownException("java.lang.Exception");
        return methodBuilder;
    }

    void getCurrentDateExpression(MethodBuilder methodBuilder) {
        LocalField localField = this.getCurrentSetup();
        methodBuilder.getField(localField);
        methodBuilder.callMethod((short)182, null, "getCurrentDate", "java.sql.Date", 0);
    }

    void getCurrentTimeExpression(MethodBuilder methodBuilder) {
        LocalField localField = this.getCurrentSetup();
        methodBuilder.getField(localField);
        methodBuilder.callMethod((short)182, null, "getCurrentTime", "java.sql.Time", 0);
    }

    void getCurrentTimestampExpression(MethodBuilder methodBuilder) {
        LocalField localField = this.getCurrentSetup();
        methodBuilder.getField(localField);
        methodBuilder.callMethod((short)182, null, "getCurrentTimestamp", "java.sql.Timestamp", 0);
    }

    FormatableArrayHolder getColumnOrdering(ResultColumnList resultColumnList) {
        int n2;
        int n3 = resultColumnList == null ? 0 : resultColumnList.size();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (resultColumnList.getResultColumn(n2 + 1).isGeneratedForUnmatchedColumnInInsert()) continue;
            ++n4;
        }
        Object[] objectArray = new IndexColumnOrder[n4];
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (resultColumnList.getResultColumn(n2 + 1).isGeneratedForUnmatchedColumnInInsert()) continue;
            objectArray[n5] = new IndexColumnOrder(n2);
            ++n5;
        }
        return new FormatableArrayHolder(objectArray);
    }

    FormatableArrayHolder addColumnToOrdering(FormatableArrayHolder formatableArrayHolder, int n2) {
        ColumnOrdering[] columnOrderingArray = (ColumnOrdering[])formatableArrayHolder.getArray(ColumnOrdering[].class);
        int n3 = columnOrderingArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (columnOrderingArray[i2].getColumnId() != n2) continue;
            return formatableArrayHolder;
        }
        Object[] objectArray = new IndexColumnOrder[n3 + 1];
        System.arraycopy(columnOrderingArray, 0, objectArray, 0, n3);
        objectArray[n3] = new IndexColumnOrder(n2);
        return new FormatableArrayHolder(objectArray);
    }

    FormatableArrayHolder getColumnOrdering(OrderedColumnList<?> orderedColumnList) {
        int n2;
        int n3 = n2 = orderedColumnList == null ? 0 : orderedColumnList.size();
        if (n2 == 0) {
            return new FormatableArrayHolder(new IndexColumnOrder[0]);
        }
        return new FormatableArrayHolder(orderedColumnList.getColumnOrdering());
    }

    int addItem(Object object) {
        return this.myCompCtx.addSavedObject(object);
    }

    void pushDataValueFactory(MethodBuilder methodBuilder) {
        if (this.getDVF == null) {
            this.getDVF = methodBuilder.describeMethod((short)182, this.getBaseClassName(), "getDataValueFactory", "org.apache.derby.iapi.types.DataValueFactory");
        }
        methodBuilder.pushThis();
        methodBuilder.callMethod(this.getDVF);
    }

    void pushGetResultSetFactoryExpression(MethodBuilder methodBuilder) {
        if (this.getRSF == null) {
            this.getRSF = methodBuilder.describeMethod((short)182, this.getBaseClassName(), "getResultSetFactory", "org.apache.derby.iapi.sql.execute.ResultSetFactory");
        }
        methodBuilder.pushThis();
        methodBuilder.callMethod(this.getRSF);
    }

    void pushGetExecutionFactoryExpression(MethodBuilder methodBuilder) {
        if (this.getEF == null) {
            this.getEF = methodBuilder.describeMethod((short)182, this.getBaseClassName(), "getExecutionFactory", "org.apache.derby.iapi.sql.execute.ExecutionFactory");
        }
        methodBuilder.pushThis();
        methodBuilder.callMethod(this.getEF);
    }

    void pushColumnReference(MethodBuilder methodBuilder, int n2, int n3) {
        methodBuilder.pushThis();
        methodBuilder.push(n2);
        methodBuilder.push(n3);
        methodBuilder.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "getColumnFromRow", "org.apache.derby.iapi.types.DataValueDescriptor", 2);
    }

    void pushPVSReference(MethodBuilder methodBuilder) {
        methodBuilder.pushThis();
        methodBuilder.getField("org.apache.derby.impl.sql.execute.BaseActivation", "pvs", "org.apache.derby.iapi.sql.ParameterValueSet");
    }

    protected LocalField getCurrentSetup() {
        if (this.cdtField != null) {
            return this.cdtField;
        }
        this.cdtField = this.newFieldDeclaration(2, "org.apache.derby.impl.sql.execute.CurrentDatetime", currentDatetimeFieldName);
        this.constructor.pushNewStart("org.apache.derby.impl.sql.execute.CurrentDatetime");
        this.constructor.pushNewComplete(0);
        this.constructor.setField(this.cdtField);
        return this.cdtField;
    }

    private String newFieldName() {
        return "e".concat(Integer.toString(this.nextFieldNum++));
    }

    protected TypeCompiler getTypeCompiler(TypeId typeId) {
        return this.myCompCtx.getTypeCompilerFactory().getTypeCompiler(typeId);
    }

    GeneratedClass getGeneratedClass(ByteArray byteArray) throws StandardException {
        if (this.gc != null) {
            return this.gc;
        }
        if (byteArray != null) {
            ByteArray byteArray2 = this.cb.getClassBytecode();
            byteArray.setBytes(byteArray2.getArray());
            byteArray.setLength(byteArray2.getLength());
        }
        this.gc = this.cb.getGeneratedClass();
        return this.gc;
    }

    void pushThisAsActivation(MethodBuilder methodBuilder) {
        methodBuilder.pushThis();
        methodBuilder.upCast("org.apache.derby.iapi.sql.Activation");
    }

    void generateNull(MethodBuilder methodBuilder, TypeCompiler typeCompiler, int n2) {
        this.pushDataValueFactory(methodBuilder);
        methodBuilder.pushNull(typeCompiler.interfaceName());
        typeCompiler.generateNull(methodBuilder, n2);
    }

    void generateNullWithExpress(MethodBuilder methodBuilder, TypeCompiler typeCompiler, int n2) {
        this.pushDataValueFactory(methodBuilder);
        methodBuilder.swap();
        methodBuilder.cast(typeCompiler.interfaceName());
        typeCompiler.generateNull(methodBuilder, n2);
    }

    void generateDataValue(MethodBuilder methodBuilder, TypeCompiler typeCompiler, int n2, LocalField localField) {
        this.pushDataValueFactory(methodBuilder);
        methodBuilder.swap();
        typeCompiler.generateDataValue(methodBuilder, n2, localField);
    }

    String newRowLocationScanResultSetName() {
        this.currentRowScanResultSetName = this.newFieldName();
        return this.currentRowScanResultSetName;
    }

    String getRowLocationScanResultSetName() {
        return this.currentRowScanResultSetName;
    }
}

