/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.io.PrintWriter;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.OptTrace;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizableList;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.util.JBitSet;

public class DefaultOptTrace
implements OptTrace {
    private StringBuilder _buffer = new StringBuilder();

    @Override
    public void traceStartStatement(String string) {
        this.appendTraceString(string);
    }

    @Override
    public void traceStartQueryBlock(long l2, int n2, OptimizableList optimizableList) {
        this.appendTraceString("Optimization started at time " + l2 + " using optimizer " + n2);
    }

    @Override
    public void traceEndQueryBlock() {
    }

    @Override
    public void traceTimeout(long l2, CostEstimate costEstimate) {
        this.appendTraceString("Optimization time exceeded at time " + l2 + "\n" + costEstimate);
    }

    @Override
    public void traceVacuous() {
        this.appendTraceString("No tables to optimize.");
    }

    @Override
    public void traceCompleteJoinOrder() {
        this.appendTraceString("We have a complete join order.");
    }

    @Override
    public void traceSortCost(CostEstimate costEstimate, CostEstimate costEstimate2) {
        this.appendTraceString("Cost of sorting is " + costEstimate);
        this.appendTraceString("Total cost of non-sort-avoidance plan with sort cost added is " + costEstimate2);
    }

    @Override
    public void traceNoBestPlan() {
        this.appendTraceString("No best plan found.");
    }

    @Override
    public void traceModifyingAccessPaths(int n2) {
        this.appendTraceString("Modifying access paths using optimizer " + n2);
    }

    @Override
    public void traceShortCircuiting(boolean bl2, Optimizable optimizable, int n2) {
        String string;
        String string2 = string = bl2 ? "time exceeded" : "cost";
        if (optimizable.getBestAccessPath().getCostEstimate() == null) {
            string = "no best plan found";
        }
        this.appendTraceString("Short circuiting based on " + string + " at join position " + n2);
    }

    @Override
    public void traceSkippingJoinOrder(int n2, int n3, int[] nArray, JBitSet jBitSet) {
        this.appendTraceString(this.reportJoinOrder("\n\nSkipping join order: ", true, n2, n3, nArray, jBitSet));
    }

    @Override
    public void traceIllegalUserJoinOrder() {
        this.appendTraceString("User specified join order is not legal.");
    }

    @Override
    public void traceUserJoinOrderOptimized() {
        this.appendTraceString("User-specified join order has now been optimized.");
    }

    @Override
    public void traceJoinOrderConsideration(int n2, int[] nArray, JBitSet jBitSet) {
        this.appendTraceString(this.reportJoinOrder("\n\nConsidering join order: ", false, 0, n2, nArray, jBitSet));
    }

    @Override
    public void traceCostWithoutSortAvoidance(CostEstimate costEstimate) {
        this.appendTraceString("Total cost of non-sort-avoidance plan is " + costEstimate);
    }

    @Override
    public void traceCostWithSortAvoidance(CostEstimate costEstimate) {
        this.appendTraceString("Total cost of sort avoidance plan is " + costEstimate);
    }

    @Override
    public void traceCurrentPlanAvoidsSort(CostEstimate costEstimate, CostEstimate costEstimate2) {
        this.appendTraceString("Current plan is a sort avoidance plan.\n\tBest cost is : " + costEstimate + "\n\tThis cost is : " + costEstimate2);
    }

    @Override
    public void traceCheapestPlanSoFar(int n2, CostEstimate costEstimate) {
        this.appendTraceString("This is the cheapest plan so far.");
        this.appendTraceString("Plan is a " + (n2 == 1 ? "normal" : "sort avoidance") + " plan.");
        this.appendTraceString("Cost of cheapest plan is " + costEstimate);
    }

    @Override
    public void traceSortNeededForOrdering(int n2, RequiredRowOrdering requiredRowOrdering) {
        this.appendTraceString("Sort needed for ordering: " + (n2 != 2) + "\n\tRow ordering: " + requiredRowOrdering);
    }

    @Override
    public void traceRememberingBestJoinOrder(int n2, int[] nArray, int n3, CostEstimate costEstimate, JBitSet jBitSet) {
        this.appendTraceString(this.reportJoinOrder("\n\nRemembering join order as best: ", false, 0, n2, nArray, jBitSet));
    }

    @Override
    public void traceSkippingBecauseTooMuchMemory(int n2) {
        this.appendTraceString("Skipping access path due to excess memory usage, maximum is " + n2);
    }

    @Override
    public void traceCostOfNScans(int n2, double d2, CostEstimate costEstimate) {
        this.appendTraceString("Cost of " + d2 + " scans is: " + costEstimate + " for table " + n2);
    }

    @Override
    public void traceSkipUnmaterializableHashJoin() {
        this.appendTraceString("Skipping HASH JOIN because optimizable is not materializable");
    }

    @Override
    public void traceSkipHashJoinNoHashKeys() {
        this.appendTraceString("Skipping HASH JOIN because there are no hash key columns");
    }

    @Override
    public void traceHashKeyColumns(int[] nArray) {
        String string = "# hash key columns = " + nArray.length;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            string = "\n" + string + "hashKeyColumns[" + i2 + "] = " + nArray[i2];
        }
        this.appendTraceString(string);
    }

    @Override
    public void traceOptimizingJoinNode() {
        this.appendTraceString("Calling optimizeIt() for join node");
    }

    @Override
    public void traceConsideringJoinStrategy(JoinStrategy joinStrategy, int n2) {
        this.appendTraceString("\nConsidering join strategy " + joinStrategy + " for table " + n2);
    }

    @Override
    public void traceRememberingBestAccessPath(AccessPath accessPath, int n2, int n3) {
        this.appendTraceString("Remembering access path " + accessPath + " as truly the best for table " + n2 + " for plan type " + (n3 == 1 ? " normal " : "sort avoidance") + "\n");
    }

    @Override
    public void traceNoMoreConglomerates(int n2) {
        this.appendTraceString("No more conglomerates to consider for table " + n2);
    }

    @Override
    public void traceConsideringConglomerate(ConglomerateDescriptor conglomerateDescriptor, int n2) {
        this.appendTraceString("\nConsidering conglomerate " + this.reportConglomerateDescriptor(conglomerateDescriptor) + " for table " + n2);
    }

    @Override
    public void traceScanningHeapWithUniqueKey() {
        this.appendTraceString("Scanning heap, but we have a full match on a unique key.");
    }

    @Override
    public void traceAddingUnorderedOptimizable(int n2) {
        this.appendTraceString("Adding unordered optimizable, # of predicates = " + n2);
    }

    @Override
    public void traceChangingAccessPathForTable(int n2) {
        this.appendTraceString("Changing access path for table " + n2);
    }

    @Override
    public void traceNoStartStopPosition() {
        this.appendTraceString("Lock mode set to MODE_TABLE because no start or stop position");
    }

    @Override
    public void traceNonCoveringIndexCost(double d2, int n2) {
        this.appendTraceString("Index does not cover query - cost including base row fetch is: " + d2 + " for table " + n2);
    }

    @Override
    public void traceConstantStartStopPositions() {
        this.appendTraceString("Lock mode set to MODE_RECORD because all start and stop positions are constant");
    }

    @Override
    public void traceEstimatingCostOfConglomerate(ConglomerateDescriptor conglomerateDescriptor, int n2) {
        String string = this.reportConglomerateDescriptor(conglomerateDescriptor);
        this.appendTraceString("Estimating cost of conglomerate: " + this.reportCostForTable(string, n2));
    }

    @Override
    public void traceLookingForSpecifiedIndex(String string, int n2) {
        this.appendTraceString("Looking for user-specified index: " + string + " for table " + n2);
    }

    @Override
    public void traceSingleMatchedRowCost(double d2, int n2) {
        this.appendTraceString("Guaranteed to match a single row - cost is: " + d2 + " for table " + n2);
    }

    @Override
    public void traceCostIncludingExtra1stColumnSelectivity(CostEstimate costEstimate, int n2) {
        this.appendTraceString("Cost including extra first column selectivity is : " + costEstimate + " for table " + n2);
    }

    @Override
    public void traceNextAccessPath(String string, int n2) {
        this.appendTraceString("Calling nextAccessPath() for base table " + string + " with " + n2 + " predicates.");
    }

    @Override
    public void traceCostIncludingExtraStartStop(CostEstimate costEstimate, int n2) {
        this.appendTraceString(this.reportCostIncluding("start/stop", costEstimate, n2));
    }

    @Override
    public void traceCostIncludingExtraQualifierSelectivity(CostEstimate costEstimate, int n2) {
        this.appendTraceString(this.reportCostIncluding("qualifier", costEstimate, n2));
    }

    @Override
    public void traceCostIncludingExtraNonQualifierSelectivity(CostEstimate costEstimate, int n2) {
        this.appendTraceString(this.reportCostIncluding("non-qualifier", costEstimate, n2));
    }

    @Override
    public void traceCostOfNoncoveringIndex(CostEstimate costEstimate, int n2) {
        this.appendTraceString("Index does not cover query: cost including row fetch is: " + this.reportCostForTable(costEstimate, n2));
    }

    @Override
    public void traceRememberingJoinStrategy(JoinStrategy joinStrategy, int n2) {
        this.appendTraceString("\nRemembering join strategy " + joinStrategy + " as best for table " + n2);
    }

    @Override
    public void traceRememberingBestAccessPathSubstring(AccessPath accessPath, int n2) {
        this.appendTraceString("in best access path");
    }

    @Override
    public void traceRememberingBestSortAvoidanceAccessPathSubstring(AccessPath accessPath, int n2) {
        this.appendTraceString("in best sort avoidance access path");
    }

    @Override
    public void traceRememberingBestUnknownAccessPathSubstring(AccessPath accessPath, int n2) {
        this.appendTraceString("in best unknown access path");
    }

    @Override
    public void traceCostOfConglomerateScan(int n2, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, int n3, double d2, int n4, double d3, int n5, double d4, int n6, double d5, int n7, double d6) {
        this.appendTraceString("Cost of conglomerate " + this.reportConglomerateDescriptor(conglomerateDescriptor) + " scan for table number " + n2 + " is : ");
        this.appendTraceString(costEstimate.toString());
        this.appendTraceString("\tNumber of extra first column predicates is : " + n3 + ", extra first column selectivity is : " + d2);
        this.appendTraceString("\tNumber of extra start/stop predicates is : " + n4 + ", extra start/stop selectivity is : " + d3);
        this.appendTraceString("\tNumber of start/stop statistics predicates is : " + n5 + ", statistics start/stop selectivity is : " + d4);
        this.appendTraceString("\tNumber of extra qualifiers is : " + n6 + ", extra qualifier selectivity is : " + d5);
        this.appendTraceString("\tNumber of extra non-qualifiers is : " + n7 + ", extra non-qualifier selectivity is : " + d6);
    }

    @Override
    public void traceCostIncludingCompositeSelectivityFromStats(CostEstimate costEstimate, int n2) {
        this.appendTraceString(this.reportCostIncluding("selectivity from statistics", costEstimate, n2));
    }

    @Override
    public void traceCompositeSelectivityFromStatistics(double d2) {
        this.appendTraceString("Selectivity from statistics found. It is " + d2);
    }

    @Override
    public void traceCostIncludingStatsForIndex(CostEstimate costEstimate, int n2) {
        this.appendTraceString(this.reportCostIncluding("statistics for index being considered", costEstimate, n2));
    }

    @Override
    public void printToWriter(PrintWriter printWriter) {
        printWriter.println(this._buffer.toString());
    }

    private String reportJoinOrder(String string, boolean bl2, int n2, int n3, int[] nArray, JBitSet jBitSet) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        for (int i2 = 0; i2 <= n3; ++i2) {
            stringBuilder.append(" ").append(nArray[i2]);
        }
        if (bl2) {
            stringBuilder.append(" ").append(n2);
        }
        stringBuilder.append(" with assignedTableMap = ").append(jBitSet).append("\n\n");
        return stringBuilder.toString();
    }

    private String reportConglomerateDescriptor(ConglomerateDescriptor conglomerateDescriptor) {
        String string = "";
        String[] stringArray = conglomerateDescriptor.getColumnNames();
        if (conglomerateDescriptor.isIndex() && stringArray != null) {
            IndexRowGenerator indexRowGenerator = conglomerateDescriptor.getIndexDescriptor();
            int[] nArray = indexRowGenerator.baseColumnPositions();
            string = ", key columns = {" + stringArray[nArray[0] - 1];
            for (int i2 = 1; i2 < nArray.length; ++i2) {
                string = string + ", " + stringArray[nArray[i2] - 1];
            }
            string = string + "}";
        }
        return "CD: conglomerateNumber = " + conglomerateDescriptor.getConglomerateNumber() + " name = " + conglomerateDescriptor.getConglomerateName() + " uuid = " + conglomerateDescriptor.getUUID() + " indexable = " + conglomerateDescriptor.isIndex() + string;
    }

    private String reportCostForTable(Object object, int n2) {
        return object + " for table " + n2;
    }

    private String reportCostIncluding(String string, CostEstimate costEstimate, int n2) {
        return "Cost including extra " + string + " start/stop selectivity is : " + this.reportCostForTable(costEstimate, n2);
    }

    private void appendTraceString(String string) {
        this._buffer.append(string);
        this._buffer.append("\n");
    }
}

