/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.TableElementList;
import org.apache.derby.impl.sql.compile.TableName;

abstract class DDLStatementNode
extends StatementNode {
    public static final int UNKNOWN_TYPE = 0;
    public static final int ADD_TYPE = 1;
    public static final int DROP_TYPE = 2;
    public static final int MODIFY_TYPE = 3;
    public static final int LOCKING_TYPE = 4;
    public static final int UPDATE_STATISTICS = 5;
    public static final int DROP_STATISTICS = 6;
    private TableName tableName;
    private boolean initOk;
    boolean implicitCreateSchema;

    DDLStatementNode(TableName tableName, ContextManager contextManager) {
        super(contextManager);
        this.tableName = tableName;
        this.initOk = true;
    }

    DDLStatementNode(ContextManager contextManager) {
        super(contextManager);
    }

    protected void initAndCheck(Object object) throws StandardException {
        this.tableName = (TableName)object;
        this.initOk = true;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    String getRelativeName() {
        return this.tableName.getTableName();
    }

    String getFullName() {
        return this.tableName.getFullTableName();
    }

    public final TableName getObjectName() {
        return this.tableName;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    int activationKind() {
        return 5;
    }

    @Override
    final void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.callMethod((short)185, null, "getDDLResultSet", "org.apache.derby.iapi.sql.ResultSet", 1);
    }

    protected final SchemaDescriptor getSchemaDescriptor() throws StandardException {
        return this.getSchemaDescriptor(true, true);
    }

    protected final SchemaDescriptor getSchemaDescriptor(boolean bl2, boolean bl3) throws StandardException {
        String string = this.tableName.getSchemaName();
        boolean bl4 = !this.implicitCreateSchema;
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(string, bl4);
        CompilerContext compilerContext = this.getCompilerContext();
        if (schemaDescriptor == null) {
            if (string.startsWith("SYS")) {
                throw StandardException.newException("42X62", this.statementToString(), string);
            }
            schemaDescriptor = new SchemaDescriptor(this.getDataDictionary(), string, null, null, false);
            if (this.isPrivilegeCollectionRequired()) {
                compilerContext.addRequiredSchemaPriv(string, null, 16);
            }
        }
        if (bl2 && this.isPrivilegeCollectionRequired()) {
            compilerContext.addRequiredSchemaPriv(schemaDescriptor.getSchemaName(), null, 17);
        }
        if (bl3 && schemaDescriptor.isSystemSchema()) {
            throw StandardException.newException("42X62", this.statementToString(), schemaDescriptor);
        }
        return schemaDescriptor;
    }

    protected final TableDescriptor getTableDescriptor() throws StandardException {
        return this.getTableDescriptor(this.tableName);
    }

    protected final TableDescriptor getTableDescriptor(boolean bl2) throws StandardException {
        TableDescriptor tableDescriptor = this.justGetDescriptor(this.tableName);
        tableDescriptor = this.checkTableDescriptor(tableDescriptor, bl2);
        return tableDescriptor;
    }

    protected final TableDescriptor getTableDescriptor(UUID uUID) throws StandardException {
        TableDescriptor tableDescriptor = this.getDataDictionary().getTableDescriptor(uUID);
        tableDescriptor = this.checkTableDescriptor(tableDescriptor, true);
        return tableDescriptor;
    }

    protected final TableDescriptor getTableDescriptor(TableName tableName) throws StandardException {
        TableDescriptor tableDescriptor = this.justGetDescriptor(tableName);
        tableDescriptor = this.checkTableDescriptor(tableDescriptor, true);
        return tableDescriptor;
    }

    private TableDescriptor justGetDescriptor(TableName tableName) throws StandardException {
        String string = tableName.getSchemaName();
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(string);
        TableDescriptor tableDescriptor = this.getTableDescriptor(tableName.getTableName(), schemaDescriptor);
        if (tableDescriptor == null) {
            throw StandardException.newException("42Y55", this.statementToString(), tableName);
        }
        return tableDescriptor;
    }

    private TableDescriptor checkTableDescriptor(TableDescriptor tableDescriptor, boolean bl2) throws StandardException {
        String string = null;
        switch (tableDescriptor.getTableType()) {
            case 5: {
                string = "X0Y56.S";
                break;
            }
            case 1: {
                if (bl2) {
                    string = "X0Y56.S";
                    break;
                }
                return tableDescriptor;
            }
            case 0: {
                return this.lockTableForCompilation(tableDescriptor);
            }
            case 3: {
                return tableDescriptor;
            }
            case 2: {
                string = "42Y62";
            }
        }
        throw StandardException.newException(string, this.statementToString(), tableDescriptor.getQualifiedName());
    }

    FromList makeFromList(DataDictionary dataDictionary, TableElementList tableElementList, boolean bl2) throws StandardException {
        TableName tableName = this.getObjectName();
        if (tableName.getSchemaName() == null) {
            tableName.setSchemaName(this.getSchemaDescriptor().getSchemaName());
        }
        FromList fromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
        FromBaseTable fromBaseTable = new FromBaseTable(tableName, null, null, null, this.getContextManager());
        if (bl2) {
            fromBaseTable.setTableNumber(0);
            fromList.addFromTable(fromBaseTable);
            fromBaseTable.setResultColumns(new ResultColumnList(this.getContextManager()));
        } else {
            fromList.addFromTable(fromBaseTable);
            fromList.bindTables(dataDictionary, new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager()));
        }
        tableElementList.appendNewColumnsToRCL(fromBaseTable);
        return fromList;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.tableName != null) {
            this.tableName = (TableName)this.tableName.accept(visitor);
        }
    }
}

