/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TriggerReferencingStruct;
import org.apache.derby.impl.sql.compile.ValueNode;

class CreateTriggerNode
extends DDLStatementNode {
    private TableName triggerName;
    private TableName tableName;
    private int triggerEventMask;
    private ResultColumnList triggerCols;
    private boolean isBefore;
    private boolean isRow;
    private boolean isEnabled;
    private List<TriggerReferencingStruct> refClause;
    private ValueNode whenClause;
    private String whenText;
    private StatementNode actionNode;
    private String actionText;
    private String originalWhenText;
    private String originalActionText;
    private ProviderInfo[] providerInfo;
    private SchemaDescriptor triggerSchemaDescriptor;
    private SchemaDescriptor compSchemaDescriptor;
    private int[] referencedColInts;
    private int[] referencedColsInTriggerAction;
    private TableDescriptor triggerTableDescriptor;
    private String oldTableName;
    private String newTableName;
    private boolean oldTableInReferencingClause;
    private boolean newTableInReferencingClause;
    private final ArrayList<int[]> actionTransformations = new ArrayList();
    private final ArrayList<int[]> whenClauseTransformations = new ArrayList();
    private static final Comparator<FromBaseTable> OFFSET_COMPARATOR = new Comparator<FromBaseTable>(){

        @Override
        public int compare(FromBaseTable fromBaseTable, FromBaseTable fromBaseTable2) {
            return fromBaseTable.getTableNameField().getBeginOffset() - fromBaseTable2.getTableNameField().getBeginOffset();
        }
    };

    CreateTriggerNode(TableName tableName, TableName tableName2, int n2, ResultColumnList resultColumnList, boolean bl2, boolean bl3, boolean bl4, List<TriggerReferencingStruct> list, ValueNode valueNode, String string, StatementNode statementNode, String string2, ContextManager contextManager) throws StandardException {
        super(tableName, contextManager);
        this.triggerName = tableName;
        this.tableName = tableName2;
        this.triggerEventMask = n2;
        this.triggerCols = resultColumnList;
        this.isBefore = bl2;
        this.isRow = bl3;
        this.isEnabled = bl4;
        this.refClause = list;
        this.whenClause = valueNode;
        this.originalWhenText = string;
        this.whenText = string == null ? null : string.trim();
        this.actionNode = statementNode;
        this.originalActionText = string2;
        this.actionText = string2 == null ? null : string2.trim();
        this.implicitCreateSchema = true;
    }

    @Override
    String statementToString() {
        return "CREATE TRIGGER";
    }

    @Override
    void printSubNodes(int n2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindStatement() throws StandardException {
        HashSet<String> hashSet;
        CompilerContext compilerContext = this.getCompilerContext();
        DataDictionary dataDictionary = this.getDataDictionary();
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        this.compSchemaDescriptor = languageConnectionContext.getDefaultSchema();
        this.triggerSchemaDescriptor = this.getSchemaDescriptor();
        this.triggerTableDescriptor = this.getTableDescriptor(this.tableName);
        if (this.isSessionSchema(this.triggerTableDescriptor.getSchemaDescriptor())) {
            throw StandardException.newException("XCL51.S", new Object[0]);
        }
        if (this.isPrivilegeCollectionRequired()) {
            compilerContext.pushCurrentPrivType(5);
            compilerContext.addRequiredTablePriv(this.triggerTableDescriptor);
            compilerContext.popCurrentPrivType();
        }
        boolean bl2 = this.bindReferencesClause(dataDictionary);
        SortedSet<TableName> sortedSet = this.actionNode.getOffsetOrderedNodes(TableName.class);
        SortedSet<TableName> sortedSet2 = this.whenClause != null ? this.whenClause.getOffsetOrderedNodes(TableName.class) : null;
        ProviderList providerList = compilerContext.getCurrentAuxiliaryProviderList();
        ProviderList providerList2 = new ProviderList();
        languageConnectionContext.pushTriggerTable(this.triggerTableDescriptor);
        try {
            compilerContext.setCurrentAuxiliaryProviderList(providerList2);
            if (bl2) {
                compilerContext.setReliability(0);
            }
            if (this.isBefore) {
                compilerContext.setReliability(2048);
            }
            this.actionNode.bindStatement();
            if (this.whenClause != null) {
                hashSet = this.getContextManager();
                this.whenClause = this.whenClause.bindExpression(new FromList((ContextManager)((Object)hashSet)), new SubqueryList((ContextManager)((Object)hashSet)), new ArrayList<AggregateNode>(0));
                this.whenClause.checkIsBoolean();
            }
        }
        finally {
            languageConnectionContext.popTriggerTable(this.triggerTableDescriptor);
            compilerContext.setCurrentAuxiliaryProviderList(providerList);
        }
        this.qualifyNames(sortedSet, sortedSet2);
        compilerContext.createDependency(this.triggerTableDescriptor);
        if (this.triggerCols != null && this.triggerCols.size() != 0) {
            hashSet = new HashSet<String>();
            for (ResultColumn resultColumn : this.triggerCols) {
                if (!hashSet.add(resultColumn.getName())) {
                    throw StandardException.newException("42Y40", resultColumn.getName(), this.triggerName);
                }
                ColumnDescriptor columnDescriptor = this.triggerTableDescriptor.getColumnDescriptor(resultColumn.getName());
                if (columnDescriptor != null) continue;
                throw StandardException.newException("42X14", resultColumn.getName(), this.tableName);
            }
        }
        if (this.referencesSessionSchema()) {
            throw StandardException.newException("XCL51.S", new Object[0]);
        }
        hashSet = dataDictionary.getDependencyManager();
        this.providerInfo = hashSet.getPersistentProviderInfos(providerList2);
        hashSet.clearColumnInfoInProviders(providerList2);
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return CreateTriggerNode.isSessionSchema(this.triggerTableDescriptor.getSchemaName()) || this.actionNode.referencesSessionSchema() || this.whenClause != null && this.whenClause.referencesSessionSchema();
    }

    private boolean bindReferencesClause(DataDictionary dataDictionary) throws StandardException {
        String string;
        this.validateReferencesClause(dataDictionary);
        if (this.isBefore) {
            this.forbidActionsOnGenCols();
        }
        String string2 = null;
        if (this.triggerCols != null && this.triggerCols.size() != 0) {
            this.referencedColInts = new int[this.triggerCols.size()];
            for (int i2 = 0; i2 < this.triggerCols.size(); ++i2) {
                ResultColumn resultColumn = (ResultColumn)this.triggerCols.elementAt(i2);
                ColumnDescriptor columnDescriptor = this.triggerTableDescriptor.getColumnDescriptor(resultColumn.getName());
                if (columnDescriptor == null) {
                    throw StandardException.newException("42X14", resultColumn.getName(), this.tableName);
                }
                this.referencedColInts[i2] = columnDescriptor.getPosition();
            }
            Arrays.sort(this.referencedColInts);
        }
        if (this.isRow) {
            this.referencedColsInTriggerAction = new int[this.triggerTableDescriptor.getNumberOfColumns()];
            Arrays.fill(this.referencedColsInTriggerAction, -1);
            int[] nArray = this.getDataDictionary().examineTriggerNodeAndCols(this.actionNode, this.oldTableName, this.newTableName, this.originalActionText, this.referencedColInts, this.referencedColsInTriggerAction, this.actionNode.getBeginOffset(), this.triggerTableDescriptor, this.triggerEventMask, true, this.actionTransformations);
            if (this.whenClause != null) {
                nArray = this.getDataDictionary().examineTriggerNodeAndCols(this.whenClause, this.oldTableName, this.newTableName, this.originalActionText, this.referencedColInts, this.referencedColsInTriggerAction, this.actionNode.getBeginOffset(), this.triggerTableDescriptor, this.triggerEventMask, true, this.actionTransformations);
            }
            string = this.getDataDictionary().getTriggerActionString(this.actionNode, this.oldTableName, this.newTableName, this.originalActionText, this.referencedColInts, this.referencedColsInTriggerAction, this.actionNode.getBeginOffset(), this.triggerTableDescriptor, this.triggerEventMask, true, this.actionTransformations, nArray);
            if (this.whenClause != null) {
                string2 = this.getDataDictionary().getTriggerActionString(this.whenClause, this.oldTableName, this.newTableName, this.originalWhenText, this.referencedColInts, this.referencedColsInTriggerAction, this.whenClause.getBeginOffset(), this.triggerTableDescriptor, this.triggerEventMask, true, this.whenClauseTransformations, nArray);
            }
            this.referencedColsInTriggerAction = this.justTheRequiredColumns(this.referencedColsInTriggerAction);
        } else {
            string = this.transformStatementTriggerText(this.actionNode, this.originalActionText, this.actionTransformations);
            if (this.whenClause != null) {
                string2 = this.transformStatementTriggerText(this.whenClause, this.originalWhenText, this.whenClauseTransformations);
            }
        }
        if (this.referencedColsInTriggerAction != null) {
            Arrays.sort(this.referencedColsInTriggerAction);
        }
        boolean bl2 = false;
        if (!string.equals(this.actionText)) {
            bl2 = true;
            this.actionText = string;
            this.actionNode = this.parseStatement(this.actionText, true);
        }
        if (this.whenClause != null && !string2.equals(this.whenText)) {
            bl2 = true;
            this.whenText = string2;
            this.whenClause = this.parseSearchCondition(this.whenText, true);
        }
        return bl2;
    }

    private void qualifyNames(SortedSet<TableName> sortedSet, SortedSet<TableName> sortedSet2) throws StandardException {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        this.qualifyNames(this.actionNode, sortedSet, this.originalActionText, this.actionText, this.actionTransformations, stringBuilder, stringBuilder2);
        this.originalActionText = stringBuilder.toString();
        this.actionText = stringBuilder2.toString();
        if (this.whenClause != null) {
            stringBuilder.setLength(0);
            stringBuilder2.setLength(0);
            this.qualifyNames(this.whenClause, sortedSet2, this.originalWhenText, this.whenText, this.whenClauseTransformations, stringBuilder, stringBuilder2);
            this.originalWhenText = stringBuilder.toString();
            this.whenText = stringBuilder2.toString();
        }
    }

    private void qualifyNames(QueryTreeNode queryTreeNode, SortedSet<TableName> sortedSet, String string, String string2, List<int[]> list, StringBuilder stringBuilder, StringBuilder stringBuilder2) throws StandardException {
        int n2 = 0;
        int n3 = 0;
        for (TableName tableName : sortedSet) {
            String string3 = tableName.getFullSQLName();
            int n4 = tableName.getBeginOffset() - queryTreeNode.getBeginOffset();
            int n5 = tableName.getEndOffset() + 1 - tableName.getBeginOffset();
            stringBuilder2.append(string2, n3, n4);
            stringBuilder2.append(string3);
            n3 = n4 + n5;
            Integer n6 = CreateTriggerNode.getOriginalPosition(list, n4);
            if (n6 == null) continue;
            stringBuilder.append(string, n2, (int)n6);
            stringBuilder.append(string3);
            n2 = n6 + n5;
        }
        stringBuilder2.append(string2, n3, string2.length());
        stringBuilder.append(string, n2, string.length());
    }

    private static Integer getOriginalPosition(List<int[]> list, int n2) {
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            int[] nArray = list.get(i2);
            if (n2 < nArray[2]) continue;
            if (n2 < nArray[3]) {
                return null;
            }
            return nArray[1] + (n2 - nArray[3]);
        }
        return n2;
    }

    private int[] justTheRequiredColumns(int[] nArray) {
        int n2 = 0;
        int n3 = this.triggerTableDescriptor.getNumberOfColumns();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (nArray[i2] == -1) continue;
            ++n2;
        }
        if (n2 > 0) {
            int[] nArray2 = new int[n2];
            int n4 = 0;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (nArray[i3] == -1) continue;
                nArray2[n4++] = nArray[i3];
            }
            return nArray2;
        }
        return null;
    }

    private String transformStatementTriggerText(QueryTreeNode queryTreeNode, String string, List<int[]> list) throws StandardException {
        int n2 = queryTreeNode.getBeginOffset();
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (FromBaseTable fromBaseTable : this.getTransitionTables(queryTreeNode)) {
            String string2 = fromBaseTable.getBaseTableName();
            int n4 = fromBaseTable.getTableNameField().getBeginOffset();
            int n5 = fromBaseTable.getTableNameField().getEndOffset();
            int n6 = n5 - n2 + 1;
            this.checkInvalidTriggerReference(string2);
            stringBuilder.append(string, n3, n4 - n2);
            int n7 = stringBuilder.length();
            stringBuilder.append(string2.equals(this.oldTableName) ? "new org.apache.derby.catalog.TriggerOldTransitionRows() " : "new org.apache.derby.catalog.TriggerNewTransitionRows() ");
            if (fromBaseTable.getCorrelationName() == null) {
                stringBuilder.append(string2).append(' ');
            }
            list.add(new int[]{n4 - n2, n6, n7, stringBuilder.length()});
            n3 = n6;
        }
        stringBuilder.append(string, n3, string.length());
        return stringBuilder.toString();
    }

    private SortedSet<FromBaseTable> getTransitionTables(Visitable visitable) throws StandardException {
        CollectNodesVisitor<FromBaseTable> collectNodesVisitor = new CollectNodesVisitor<FromBaseTable>(FromBaseTable.class);
        visitable.accept(collectNodesVisitor);
        TreeSet<FromBaseTable> treeSet = new TreeSet<FromBaseTable>(OFFSET_COMPARATOR);
        for (FromBaseTable fromBaseTable : collectNodesVisitor.getList()) {
            int n2;
            if (!this.isTransitionTable(fromBaseTable) || (n2 = fromBaseTable.getTableNameField().getBeginOffset()) == -1) continue;
            treeSet.add(fromBaseTable);
        }
        return treeSet;
    }

    private boolean isTransitionTable(FromBaseTable fromBaseTable) {
        String string;
        if (!fromBaseTable.getOrigTableName().hasSchema() && (string = fromBaseTable.getBaseTableName()) != null) {
            return string.equals(this.oldTableName) || string.equals(this.newTableName);
        }
        return false;
    }

    private void forbidActionsOnGenCols() throws StandardException {
        ColumnDescriptorList columnDescriptorList = this.triggerTableDescriptor.getGeneratedColumns();
        int n2 = columnDescriptorList.size();
        if (n2 == 0) {
            return;
        }
        CollectNodesVisitor<ColumnReference> collectNodesVisitor = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
        this.actionNode.accept(collectNodesVisitor);
        if (this.whenClause != null) {
            this.whenClause.accept(collectNodesVisitor);
        }
        for (ColumnReference columnReference : collectNodesVisitor.getList()) {
            String string = columnReference.getColumnName();
            String string2 = columnReference.getTableName();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string3 = columnDescriptorList.elementAt(i2).getColumnName();
                if (!string3.equals(string) || !this.equals(this.newTableName, string2)) continue;
                throw StandardException.newException("42XAA", string3);
            }
        }
    }

    private boolean equals(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    private void checkInvalidTriggerReference(String string) throws StandardException {
        if (string.equals(this.oldTableName) && (this.triggerEventMask & 4) == 4) {
            throw StandardException.newException("42Y92", "INSERT", "new");
        }
        if (string.equals(this.newTableName) && (this.triggerEventMask & 2) == 2) {
            throw StandardException.newException("42Y92", "DELETE", "old");
        }
    }

    private void validateReferencesClause(DataDictionary dataDictionary) throws StandardException {
        if (this.refClause == null || this.refClause.isEmpty()) {
            return;
        }
        for (TriggerReferencingStruct triggerReferencingStruct : this.refClause) {
            if (this.isRow && !triggerReferencingStruct.isRow) {
                throw StandardException.newException("42Y92", "ROW", "row");
            }
            if (!this.isRow && triggerReferencingStruct.isRow) {
                throw StandardException.newException("42Y92", "STATEMENT", "table");
            }
            if (triggerReferencingStruct.isNew) {
                if (this.newTableInReferencingClause) {
                    throw StandardException.newException("42Y93", new Object[0]);
                }
                if ((this.triggerEventMask & 2) == 2) {
                    throw StandardException.newException("42Y92", "DELETE", "old");
                }
                this.newTableName = triggerReferencingStruct.identifier;
                this.newTableInReferencingClause = true;
            } else {
                if (this.oldTableInReferencingClause) {
                    throw StandardException.newException("42Y93", new Object[0]);
                }
                if ((this.triggerEventMask & 4) == 4) {
                    throw StandardException.newException("42Y92", "INSERT", "new");
                }
                this.oldTableName = triggerReferencingStruct.identifier;
                this.oldTableInReferencingClause = true;
            }
            if (!this.isBefore || triggerReferencingStruct.isRow) continue;
            throw StandardException.newException("42Y92", "BEFORE", "row");
        }
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        String string = this.oldTableInReferencingClause ? this.oldTableName : null;
        String string2 = this.newTableInReferencingClause ? this.newTableName : null;
        return this.getGenericConstantActionFactory().getCreateTriggerConstantAction(this.triggerSchemaDescriptor.getSchemaName(), this.getRelativeName(), this.triggerEventMask, this.isBefore, this.isRow, this.isEnabled, this.triggerTableDescriptor, null, this.whenText, null, this.actionText, this.compSchemaDescriptor.getUUID(), this.referencedColInts, this.referencedColsInTriggerAction, this.originalWhenText, this.originalActionText, this.oldTableInReferencingClause, this.newTableInReferencingClause, string, string2, this.providerInfo);
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.triggerName != null) {
            this.triggerName = (TableName)this.triggerName.accept(visitor);
        }
        if (this.tableName != null) {
            this.tableName = (TableName)this.tableName.accept(visitor);
        }
    }
}

