/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.sql.compile.CostEstimate;

class CostEstimateImpl
implements CostEstimate {
    double cost;
    double rowCount;
    double singleScanRowCount;

    CostEstimateImpl() {
    }

    CostEstimateImpl(double d2, double d3, double d4) {
        this.cost = d2;
        this.rowCount = d3;
        this.singleScanRowCount = d4;
    }

    @Override
    public void setCost(double d2, double d3, double d4) {
        this.cost = d2;
        this.rowCount = d3;
        this.singleScanRowCount = d4;
    }

    @Override
    public void setCost(CostEstimate costEstimate) {
        this.cost = costEstimate.getEstimatedCost();
        this.rowCount = costEstimate.rowCount();
        this.singleScanRowCount = costEstimate.singleScanRowCount();
    }

    @Override
    public void setSingleScanRowCount(double d2) {
        this.singleScanRowCount = d2;
    }

    @Override
    public double compare(CostEstimate costEstimate) {
        if (this.cost != Double.POSITIVE_INFINITY || costEstimate.getEstimatedCost() != Double.POSITIVE_INFINITY) {
            return this.cost - ((CostEstimateImpl)costEstimate).cost;
        }
        if (this.rowCount != Double.POSITIVE_INFINITY || costEstimate.rowCount() != Double.POSITIVE_INFINITY) {
            return this.rowCount - costEstimate.rowCount();
        }
        if (this.singleScanRowCount != Double.POSITIVE_INFINITY || costEstimate.singleScanRowCount() != Double.POSITIVE_INFINITY) {
            return this.singleScanRowCount - costEstimate.singleScanRowCount();
        }
        return 0.0;
    }

    @Override
    public CostEstimate add(CostEstimate costEstimate, CostEstimate costEstimate2) {
        CostEstimateImpl costEstimateImpl = (CostEstimateImpl)costEstimate;
        double d2 = this.cost + costEstimateImpl.cost;
        double d3 = this.rowCount + costEstimateImpl.rowCount;
        return this.setState(d2, d3, (CostEstimateImpl)costEstimate2);
    }

    @Override
    public CostEstimate multiply(double d2, CostEstimate costEstimate) {
        double d3 = this.cost * d2;
        double d4 = this.rowCount * d2;
        return this.setState(d3, d4, (CostEstimateImpl)costEstimate);
    }

    @Override
    public CostEstimate divide(double d2, CostEstimate costEstimate) {
        double d3 = this.cost / d2;
        double d4 = this.rowCount / d2;
        return this.setState(d3, d4, (CostEstimateImpl)costEstimate);
    }

    @Override
    public double rowCount() {
        return this.rowCount;
    }

    @Override
    public double singleScanRowCount() {
        return this.singleScanRowCount;
    }

    @Override
    public CostEstimate cloneMe() {
        return new CostEstimateImpl(this.cost, this.rowCount, this.singleScanRowCount);
    }

    @Override
    public boolean isUninitialized() {
        return this.cost == Double.MAX_VALUE && this.rowCount == Double.MAX_VALUE && this.singleScanRowCount == Double.MAX_VALUE;
    }

    @Override
    public double getEstimatedCost() {
        return this.cost;
    }

    @Override
    public void setEstimatedCost(double d2) {
        this.cost = d2;
    }

    @Override
    public long getEstimatedRowCount() {
        return (long)this.rowCount;
    }

    @Override
    public void setEstimatedRowCount(long l2) {
        this.rowCount = l2;
        this.singleScanRowCount = l2;
    }

    CostEstimateImpl setState(double d2, double d3, CostEstimateImpl costEstimateImpl) {
        if (costEstimateImpl == null) {
            costEstimateImpl = new CostEstimateImpl();
        }
        costEstimateImpl.cost = d2;
        costEstimateImpl.rowCount = d3;
        return costEstimateImpl;
    }

    public String toString() {
        return "CostEstimateImpl: at " + this.hashCode() + ", cost == " + this.cost + ", rowCount == " + this.rowCount + ", singleScanRowCount == " + this.singleScanRowCount;
    }
}

