/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.DefaultNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.GenerationClauseNode;
import org.apache.derby.impl.sql.compile.SpecialFunctionNode;
import org.apache.derby.impl.sql.compile.TableElementNode;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class ColumnDefinitionNode
extends TableElementNode {
    boolean isAutoincrement;
    DataTypeDescriptor type;
    DataValueDescriptor defaultValue;
    DefaultInfoImpl defaultInfo;
    DefaultNode defaultNode;
    boolean keepCurrentDefault;
    GenerationClauseNode generationClauseNode;
    long autoincrementIncrement;
    long autoincrementStart;
    long autoincrementCycle;
    long autoinc_create_or_modify_Start_Increment;
    boolean autoincrementVerify;
    public static final int CREATE_AUTOINCREMENT = 0;
    public static final int MODIFY_AUTOINCREMENT_RESTART_VALUE = 1;
    public static final int MODIFY_AUTOINCREMENT_INC_VALUE = 2;
    public static final int MODIFY_AUTOINCREMENT_ALWAYS_VS_DEFAULT = 3;

    ColumnDefinitionNode(String string, ValueNode valueNode, DataTypeDescriptor dataTypeDescriptor, long[] lArray, ContextManager contextManager) throws StandardException {
        super(string, contextManager);
        this.type = dataTypeDescriptor;
        if (valueNode instanceof UntypedNullConstantNode) {
            if (dataTypeDescriptor != null) {
                this.defaultValue = ((UntypedNullConstantNode)valueNode).convertDefaultNode(this.type);
            }
        } else if (valueNode instanceof GenerationClauseNode) {
            this.generationClauseNode = (GenerationClauseNode)valueNode;
        } else {
            this.defaultNode = (DefaultNode)valueNode;
            if (lArray != null) {
                long[] lArray2 = lArray;
                this.autoincrementStart = lArray2[0];
                this.autoincrementIncrement = lArray2[1];
                this.autoincrementCycle = lArray2[4];
                this.autoinc_create_or_modify_Start_Increment = lArray2[3];
                this.autoincrementVerify = lArray2[2] <= 0L;
                this.isAutoincrement = true;
                if (dataTypeDescriptor != null) {
                    this.setNullability(false);
                }
            }
        }
        this.keepCurrentDefault = valueNode == null;
    }

    @Override
    public String toString() {
        return "";
    }

    String getColumnName() {
        return this.name;
    }

    final DataTypeDescriptor getType() {
        return this.type;
    }

    public void setType(DataTypeDescriptor dataTypeDescriptor) {
        this.type = dataTypeDescriptor;
    }

    final void setNullability(boolean bl2) {
        this.type = this.getType().getNullabilityType(bl2);
    }

    void setCollationType(int n2) {
        this.type = this.getType().getCollatedType(n2, 1);
    }

    DataValueDescriptor getDefaultValue() {
        return this.defaultValue;
    }

    DefaultInfo getDefaultInfo() {
        return this.defaultInfo;
    }

    public void setDefaultInfo(DefaultInfoImpl defaultInfoImpl) {
        this.defaultInfo = defaultInfoImpl;
    }

    DefaultNode getDefaultNode() {
        return this.defaultNode;
    }

    public boolean hasGenerationClause() {
        return this.generationClauseNode != null;
    }

    GenerationClauseNode getGenerationClauseNode() {
        return this.generationClauseNode;
    }

    boolean isAutoincrementColumn() {
        return this.isAutoincrement;
    }

    long getAutoincrementStart() {
        return this.autoincrementStart;
    }

    long getAutoincrementIncrement() {
        return this.autoincrementIncrement;
    }

    long getAutoincrementCycle() {
        return this.autoincrementCycle;
    }

    long getAutoinc_create_or_modify_Start_Increment() {
        return this.autoinc_create_or_modify_Start_Increment;
    }

    void checkUserType(TableDescriptor tableDescriptor) throws StandardException {
        if (this.hasGenerationClause() && this.getType() == null) {
            return;
        }
        if (!this.getType().getTypeId().userType()) {
            return;
        }
        this.setType(this.bindUserType(this.getType()));
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        String string = this.getType().getTypeId().getCorrespondingJavaTypeName();
        boolean bl2 = false;
        ClassNotFoundException classNotFoundException = null;
        try {
            bl2 = classInspector.accessible(string);
        }
        catch (ClassNotFoundException classNotFoundException2) {
            classNotFoundException = classNotFoundException2;
        }
        if (!bl2) {
            throw StandardException.newException("42X26", classNotFoundException, string, this.name);
        }
        if (!classInspector.assignableTo(string, "java.io.Serializable") && !classInspector.assignableTo(string, "java.sql.SQLData")) {
            this.getCompilerContext().addWarning(StandardException.newWarning("01J04", string, this.name));
        }
    }

    UUID getOldDefaultUUID() {
        return null;
    }

    int getAction() {
        return 0;
    }

    void bindAndValidateDefault(DataDictionary dataDictionary, TableDescriptor tableDescriptor) throws StandardException {
        if (!(tableDescriptor == null || this.hasGenerationClause() || this.getType().isNullable() || this.defaultNode != null || this.isAutoincrement)) {
            throw StandardException.newException("42601", this.getColumnName());
        }
        if (this.defaultNode == null) {
            return;
        }
        if (this.defaultValue != null) {
            return;
        }
        this.validateDefault(dataDictionary, tableDescriptor);
    }

    void validateAutoincrement(DataDictionary dataDictionary, TableDescriptor tableDescriptor, int n2) throws StandardException {
        if (!this.isAutoincrement) {
            return;
        }
        if (n2 == 3) {
            throw StandardException.newException("42995", new Object[0]);
        }
        if (this.autoincrementIncrement == 0L && (this.autoinc_create_or_modify_Start_Increment == 0L || this.autoinc_create_or_modify_Start_Increment == 2L)) {
            throw StandardException.newException("42Z21", this.getColumnName());
        }
        int n3 = this.getType().getTypeId().getJDBCTypeId();
        switch (n3) {
            case -6: {
                this.autoincrementCheckRange(-128L, 127L, "TINYINT");
                break;
            }
            case 5: {
                this.autoincrementCheckRange(-32768L, 32767L, "SMALLINT");
                break;
            }
            case 4: {
                this.autoincrementCheckRange(Integer.MIN_VALUE, Integer.MAX_VALUE, "INTEGER");
                break;
            }
            case -5: {
                this.autoincrementCheckRange(Long.MIN_VALUE, Long.MAX_VALUE, "BIGINT");
                break;
            }
            default: {
                throw StandardException.newException("42Z22", this.getColumnName());
            }
        }
    }

    private void autoincrementCheckRange(long l2, long l3, String string) throws StandardException {
        if (l2 > this.autoincrementIncrement || l3 < this.autoincrementIncrement) {
            throw StandardException.newException("22003", string);
        }
        if (l2 > this.autoincrementStart || l3 < this.autoincrementStart) {
            throw StandardException.newException("22003", string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateDefault(DataDictionary dataDictionary, TableDescriptor tableDescriptor) throws StandardException {
        if (this.defaultNode == null) {
            return;
        }
        if (this.isAutoincrement) {
            this.defaultInfo = ColumnDefinitionNode.createDefaultInfoOfAutoInc();
            return;
        }
        CompilerContext compilerContext = this.getCompilerContext();
        ValueNode valueNode = this.defaultNode.getDefaultTree();
        int n2 = compilerContext.getReliability();
        try {
            Object var6_6 = null;
            Object var7_7 = null;
            compilerContext.setReliability(1192);
            valueNode = valueNode.bindExpression(new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager()), null, null);
            TypeId typeId = this.getType().getTypeId();
            TypeId typeId2 = valueNode.getTypeId();
            if (!this.defaultTypeIsValid(typeId, this.getType(), typeId2, valueNode, this.defaultNode.getDefaultText())) {
                throw StandardException.newException("42894", this.name);
            }
            if (!this.getTypeCompiler(typeId).storable(typeId2, this.getClassFactory())) {
                throw StandardException.newException("42821", typeId.getSQLTypeName(), typeId2.getSQLTypeName());
            }
            this.defaultInfo = new DefaultInfoImpl(false, this.defaultNode.getDefaultText(), this.defaultValue);
        }
        finally {
            compilerContext.setReliability(n2);
        }
    }

    protected static DefaultInfoImpl createDefaultInfoOfAutoInc() {
        return new DefaultInfoImpl(true, null, null);
    }

    boolean defaultTypeIsValid(TypeId typeId, DataTypeDescriptor dataTypeDescriptor, TypeId typeId2, ValueNode valueNode, String string) throws StandardException {
        int n2;
        int n3 = typeId.getTypeFormatId();
        int n4 = n2 = typeId2 == null ? -1 : typeId2.getTypeFormatId();
        if (!valueNode.isConstantExpression()) {
            boolean bl2;
            boolean bl3 = bl2 = n3 == 5 || n3 == 13 || n3 == 230;
            if (valueNode instanceof SpecialFunctionNode) {
                switch (((SpecialFunctionNode)valueNode).kind) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return bl2 && dataTypeDescriptor.getMaximumWidth() >= 8;
                    }
                    case 2: {
                        return bl2 && dataTypeDescriptor.getMaximumWidth() >= 128;
                    }
                }
                return false;
            }
        }
        switch (n3) {
            case 4: {
                return valueNode instanceof BooleanConstantNode;
            }
            case 7: {
                return n2 == 7;
            }
            case 11: {
                return n2 == 7 || n2 == 11;
            }
            case 197: {
                if (n2 == 197) {
                    DataTypeDescriptor dataTypeDescriptor2 = valueNode.getTypeServices();
                    int n5 = string.length();
                    int n6 = dataTypeDescriptor2.getPrecision();
                    int n7 = dataTypeDescriptor2.getScale();
                    int n8 = 1;
                    while (n8 <= n7 && string.charAt(n5 - n8) == '0') {
                        --n7;
                        --n6;
                    }
                    return n7 <= dataTypeDescriptor.getScale() && n6 - n7 <= dataTypeDescriptor.getPrecision() - dataTypeDescriptor.getScale();
                }
                return n2 == 11 || n2 == 7;
            }
            case 5: 
            case 13: 
            case 230: {
                return n2 == 5;
            }
            case 27: 
            case 29: 
            case 232: {
                return n2 == 27;
            }
            case 267: {
                return n2 == n3;
            }
            case 6: 
            case 8: 
            case 10: 
            case 35: 
            case 36: 
            case 40: 
            case 440: 
            case 444: {
                return true;
            }
        }
        return false;
    }

    @Override
    void printSubNodes(int n2) {
    }
}

