/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;

class CoalesceFunctionNode
extends ValueNode {
    String functionName;
    ValueNodeList argumentsList;
    private int firstNonParameterNodeIdx = -1;

    CoalesceFunctionNode(String string, ValueNodeList valueNodeList, ContextManager contextManager) {
        super(contextManager);
        this.functionName = string;
        this.argumentsList = valueNodeList;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        this.argumentsList.bindExpression(fromList, subqueryList, list);
        if (this.argumentsList.size() < 2) {
            throw StandardException.newException("42605", this.functionName);
        }
        if (this.argumentsList.containsAllParameterNodes()) {
            throw StandardException.newException("42610", new Object[0]);
        }
        int n2 = this.argumentsList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (((ValueNode)this.argumentsList.elementAt(i2)).requiresTypeFromContext()) continue;
            this.firstNonParameterNodeIdx = i2;
            break;
        }
        for (ValueNode valueNode : this.argumentsList) {
            if (valueNode.requiresTypeFromContext()) continue;
            this.argumentsList.compatible(valueNode);
        }
        this.setType(this.argumentsList.getDominantTypeServices());
        for (ValueNode valueNode : this.argumentsList) {
            if (!valueNode.requiresTypeFromContext()) continue;
            valueNode.setType(this.getTypeServices());
        }
        return this;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n2 = this.argumentsList.size();
        String string = "org.apache.derby.iapi.types.DataValueDescriptor";
        String string2 = "org.apache.derby.iapi.types.DataValueDescriptor[]";
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, string2);
        MethodBuilder methodBuilder2 = expressionClassBuilder.getConstructor();
        methodBuilder2.pushNewArray("org.apache.derby.iapi.types.DataValueDescriptor", n2);
        methodBuilder2.setField(localField);
        int n3 = 0;
        MethodBuilder methodBuilder3 = null;
        MethodBuilder methodBuilder4 = methodBuilder2;
        for (int i2 = 0; i2 < n2; ++i2) {
            MethodBuilder methodBuilder5;
            if (this.argumentsList.elementAt(i2) instanceof ConstantNode) {
                ++n3;
                if (methodBuilder4.statementNumHitLimit(1)) {
                    MethodBuilder methodBuilder6 = expressionClassBuilder.newGeneratedFun("void", 2);
                    methodBuilder4.pushThis();
                    methodBuilder4.callMethod((short)182, null, methodBuilder6.getName(), "void", 0);
                    if (methodBuilder4 != methodBuilder2) {
                        methodBuilder4.methodReturn();
                        methodBuilder4.complete();
                    }
                    methodBuilder4 = methodBuilder6;
                }
                methodBuilder5 = methodBuilder4;
            } else {
                if (methodBuilder3 == null) {
                    methodBuilder3 = expressionClassBuilder.newGeneratedFun("void", 4);
                }
                methodBuilder5 = methodBuilder3;
            }
            methodBuilder5.getField(localField);
            ((ValueNode)this.argumentsList.elementAt(i2)).generateExpression(expressionClassBuilder, methodBuilder5);
            methodBuilder5.upCast(string);
            methodBuilder5.setArrayElement(i2);
        }
        if (methodBuilder4 != methodBuilder2) {
            methodBuilder4.methodReturn();
            methodBuilder4.complete();
        }
        if (methodBuilder3 != null) {
            methodBuilder3.methodReturn();
            methodBuilder3.complete();
            methodBuilder.pushThis();
            methodBuilder.callMethod((short)182, null, methodBuilder3.getName(), "void", 0);
        }
        ((ValueNode)this.argumentsList.elementAt(this.firstNonParameterNodeIdx)).generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
        methodBuilder.getField(localField);
        LocalField localField2 = expressionClassBuilder.newFieldDeclaration(2, string);
        expressionClassBuilder.generateNull(methodBuilder, this.getTypeCompiler(), this.getTypeServices().getCollationType());
        methodBuilder.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
        methodBuilder.putField(localField2);
        methodBuilder.callMethod((short)185, string, "coalesce", string, 2);
        if (this.getTypeId().variableLength()) {
            boolean bl2 = this.getTypeId().isNumericTypeId();
            methodBuilder.dup();
            methodBuilder.push(bl2 ? this.getTypeServices().getPrecision() : this.getTypeServices().getMaximumWidth());
            methodBuilder.push(this.getTypeServices().getScale());
            methodBuilder.push(true);
            methodBuilder.callMethod((short)185, "org.apache.derby.iapi.types.VariableSizeDataValue", "setWidth", "void", 3);
        }
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    void printSubNodes(int n2) {
    }

    @Override
    boolean isEquivalent(ValueNode valueNode) throws StandardException {
        if (!this.isSameNodeKind(valueNode)) {
            return false;
        }
        CoalesceFunctionNode coalesceFunctionNode = (CoalesceFunctionNode)valueNode;
        return this.argumentsList.isEquivalent(coalesceFunctionNode.argumentsList);
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        this.argumentsList = (ValueNodeList)this.argumentsList.accept(visitor);
    }

    @Override
    public boolean categorize(JBitSet jBitSet, boolean bl2) throws StandardException {
        return this.argumentsList.categorize(jBitSet, bl2);
    }

    @Override
    ValueNode preprocess(int n2, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        this.argumentsList.preprocess(n2, fromList, subqueryList, predicateList);
        return this;
    }

    @Override
    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.argumentsList = this.argumentsList.remapColumnReferencesToExpressions();
        return this;
    }
}

