/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public final class CharTypeCompiler
extends BaseTypeCompiler {
    @Override
    public boolean convertible(TypeId typeId, boolean bl2) {
        if (typeId.getBaseTypeId().isAnsiUDT()) {
            return false;
        }
        if (this.getTypeId().isLongVarcharTypeId()) {
            return typeId.isStringTypeId() || typeId.isBooleanTypeId();
        }
        if (bl2 && typeId.isDoubleTypeId()) {
            return this.getTypeId().isStringTypeId();
        }
        return !typeId.isFloatingPointTypeId() && !typeId.isBitTypeId() && !typeId.isBlobTypeId() && !typeId.isXMLTypeId();
    }

    @Override
    public boolean compatible(TypeId typeId) {
        return typeId.isStringTypeId() || typeId.isDateTimeTimeStampTypeId() && !this.getTypeId().isLongVarcharTypeId();
    }

    @Override
    public boolean storable(TypeId typeId, ClassFactory classFactory) {
        if (this.convertible(typeId, false) && !typeId.isBlobTypeId() && !typeId.isNumericTypeId()) {
            return true;
        }
        return this.userTypeStorable(this.getTypeId(), typeId, classFactory);
    }

    @Override
    public String interfaceName() {
        return "org.apache.derby.iapi.types.StringDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        return "java.lang.String";
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dataTypeDescriptor) {
        return dataTypeDescriptor.getMaximumWidth();
    }

    @Override
    String nullMethodName() {
        int n2 = this.getStoredFormatIdFromTypeId();
        switch (n2) {
            case 5: {
                return "getNullChar";
            }
            case 230: {
                return "getNullLongvarchar";
            }
            case 13: {
                return "getNullVarchar";
            }
        }
        return null;
    }

    @Override
    boolean pushCollationForDataValue(int n2) {
        return n2 != 0;
    }

    @Override
    String dataValueMethodName() {
        int n2 = this.getStoredFormatIdFromTypeId();
        switch (n2) {
            case 5: {
                return "getCharDataValue";
            }
            case 230: {
                return "getLongvarcharDataValue";
            }
            case 13: {
                return "getVarcharDataValue";
            }
        }
        return null;
    }
}

