/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public final class CharConstantNode
extends ConstantNode {
    static final int K_CHAR = 0;
    static final int K_VARCHAR = 1;
    static final int K_LONGVARCHAR = 2;
    static final int K_CLOB = 3;
    final int kind;

    CharConstantNode(String string, ContextManager contextManager) throws StandardException {
        super(TypeId.CHAR_ID, string == null, string != null ? string.length() : 0, contextManager);
        this.setValue(this.getDataValueFactory().getCharDataValue(string));
        this.kind = 0;
    }

    CharConstantNode(TypeId typeId, ContextManager contextManager) throws StandardException {
        super(typeId, true, 0, contextManager);
        this.kind = 0;
    }

    CharConstantNode(int n2, TypeId typeId, ContextManager contextManager) throws StandardException {
        super(typeId, true, 0, contextManager);
        this.kind = n2;
    }

    CharConstantNode(String string, int n2, ContextManager contextManager) throws StandardException {
        super(TypeId.CHAR_ID, string == null, n2, contextManager);
        this.kind = 0;
        if (string.length() > n2) {
            throw StandardException.newException("22001", "CHAR", string, String.valueOf(n2));
        }
        while (string.length() < n2) {
            string = string + ' ';
        }
        this.setValue(this.getDataValueFactory().getCharDataValue(string));
    }

    String getString() throws StandardException {
        return this.value.getString();
    }

    @Override
    Object getConstantValueAsObject() throws StandardException {
        return this.value.getString();
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        this.setCollationUsingCompilationSchema();
        this.value = ((StringDataValue)this.value).getValue(this.getLanguageConnectionContext().getDataValueFactory().getCharacterCollator(this.getTypeServices().getCollationType()));
        return this;
    }

    @Override
    void generateConstant(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        methodBuilder.push(this.getString());
    }

    @Override
    boolean isSameNodeKind(ValueNode valueNode) {
        return super.isSameNodeKind(valueNode) && ((CharConstantNode)valueNode).kind == this.kind;
    }
}

