/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public class BitTypeCompiler
extends BaseTypeCompiler {
    @Override
    public boolean convertible(TypeId typeId, boolean bl2) {
        if (typeId.getBaseTypeId().isAnsiUDT()) {
            return false;
        }
        return typeId.isBitTypeId() || typeId.isBlobTypeId() || typeId.userType();
    }

    @Override
    public boolean compatible(TypeId typeId) {
        if (typeId.isBlobTypeId()) {
            return false;
        }
        return typeId.isBitTypeId();
    }

    @Override
    public boolean storable(TypeId typeId, ClassFactory classFactory) {
        if (typeId.isBlobTypeId()) {
            return false;
        }
        if (typeId.isBitTypeId()) {
            return true;
        }
        return this.userTypeStorable(this.getTypeId(), typeId, classFactory);
    }

    @Override
    public String interfaceName() {
        return "org.apache.derby.iapi.types.BitDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        return "byte[]";
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dataTypeDescriptor) {
        return dataTypeDescriptor.getMaximumWidth();
    }

    @Override
    String nullMethodName() {
        int n2 = this.getStoredFormatIdFromTypeId();
        switch (n2) {
            case 27: {
                return "getNullBit";
            }
            case 232: {
                return "getNullLongVarbit";
            }
            case 29: {
                return "getNullVarbit";
            }
        }
        return null;
    }

    @Override
    String dataValueMethodName() {
        int n2 = this.getStoredFormatIdFromTypeId();
        switch (n2) {
            case 27: {
                return "getBitDataValue";
            }
            case 232: {
                return "getLongVarbitDataValue";
            }
            case 29: {
                return "getVarbitDataValue";
            }
        }
        return null;
    }
}

