/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.ExpressionClassBuilderInterface;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.BaseTableNumbersVisitor;
import org.apache.derby.impl.sql.compile.BinaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.InListOperatorNode;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

class BinaryRelationalOperatorNode
extends BinaryComparisonOperatorNode
implements RelationalOperator {
    static final int K_EQUALS = 0;
    static final int K_GREATER_EQUALS = 1;
    static final int K_GREATER_THAN = 2;
    static final int K_LESS_EQUALS = 3;
    static final int K_LESS_THAN = 4;
    static final int K_NOT_EQUALS = 5;
    final int kind;
    private int relOpType;
    private BaseTableNumbersVisitor btnVis;
    JBitSet optBaseTables;
    JBitSet valNodeBaseTables;
    private InListOperatorNode inListProbeSource = null;
    protected static final int LEFT = -1;
    protected static final int NEITHER = 0;
    protected static final int RIGHT = 1;

    BinaryRelationalOperatorNode(int n2, ValueNode valueNode, ValueNode valueNode2, boolean bl2, ContextManager contextManager) throws StandardException {
        super(valueNode, valueNode2, BinaryRelationalOperatorNode.getOperatorName(n2), BinaryRelationalOperatorNode.getMethodName(n2), bl2, contextManager);
        this.kind = n2;
        this.constructorMinion();
    }

    BinaryRelationalOperatorNode(int n2, ValueNode valueNode, ValueNode valueNode2, InListOperatorNode inListOperatorNode, boolean bl2, ContextManager contextManager) throws StandardException {
        super(valueNode, valueNode2, BinaryRelationalOperatorNode.getOperatorName(n2), BinaryRelationalOperatorNode.getMethodName(n2), bl2, contextManager);
        this.kind = n2;
        this.constructorMinion();
        this.inListProbeSource = inListOperatorNode;
    }

    private void constructorMinion() {
        this.relOpType = this.getRelOpType(this.kind);
        this.btnVis = null;
    }

    private static String getMethodName(int n2) {
        String string = "";
        switch (n2) {
            case 0: {
                string = "equals";
                break;
            }
            case 1: {
                string = "greaterOrEquals";
                break;
            }
            case 2: {
                string = "greaterThan";
                break;
            }
            case 3: {
                string = "lessOrEquals";
                break;
            }
            case 4: {
                string = "lessThan";
                break;
            }
            case 5: {
                string = "notEquals";
                break;
            }
        }
        return string;
    }

    private static String getOperatorName(int n2) {
        String string = "";
        switch (n2) {
            case 0: {
                string = "=";
                break;
            }
            case 1: {
                string = ">=";
                break;
            }
            case 2: {
                string = ">";
                break;
            }
            case 3: {
                string = "<=";
                break;
            }
            case 4: {
                string = "<";
                break;
            }
            case 5: {
                string = "<>";
                break;
            }
        }
        return string;
    }

    private int getRelOpType(int n2) {
        switch (n2) {
            case 0: {
                return 1;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 2;
            }
        }
        return 0;
    }

    protected InListOperatorNode getInListOp() {
        if (this.inListProbeSource != null) {
            this.inListProbeSource.setLeftOperand(this.leftOperand);
        }
        return this.inListProbeSource;
    }

    @Override
    public ColumnReference getColumnOperand(Optimizable optimizable, int n2) {
        ColumnReference columnReference;
        FromTable fromTable = (FromTable)optimizable;
        boolean bl2 = true;
        if (this.leftOperand instanceof ColumnReference) {
            columnReference = (ColumnReference)this.leftOperand;
            if (this.valNodeReferencesOptTable(columnReference, fromTable, false, bl2) && columnReference.getSource().getColumnPosition() == n2) {
                return columnReference;
            }
            bl2 = false;
        }
        if (this.rightOperand instanceof ColumnReference && this.valNodeReferencesOptTable(columnReference = (ColumnReference)this.rightOperand, fromTable, false, bl2) && columnReference.getSource().getColumnPosition() == n2) {
            return columnReference;
        }
        return null;
    }

    @Override
    public ColumnReference getColumnOperand(Optimizable optimizable) {
        ColumnReference columnReference;
        boolean bl2 = true;
        if (this.leftOperand instanceof ColumnReference) {
            columnReference = (ColumnReference)this.leftOperand;
            if (this.valNodeReferencesOptTable(columnReference, (FromTable)optimizable, false, bl2)) {
                return columnReference;
            }
            bl2 = false;
        }
        if (this.rightOperand instanceof ColumnReference && this.valNodeReferencesOptTable(columnReference = (ColumnReference)this.rightOperand, (FromTable)optimizable, false, bl2)) {
            return columnReference;
        }
        return null;
    }

    @Override
    public ValueNode getExpressionOperand(int n2, int n3, Optimizable optimizable) {
        ColumnReference columnReference;
        boolean bl2 = true;
        if (this.leftOperand instanceof ColumnReference) {
            columnReference = (ColumnReference)this.leftOperand;
            if (this.valNodeReferencesOptTable(columnReference, optimizable, false, bl2) && columnReference.getSource().getColumnPosition() == n3) {
                return this.rightOperand;
            }
            bl2 = false;
        }
        if (this.rightOperand instanceof ColumnReference && this.valNodeReferencesOptTable(columnReference = (ColumnReference)this.rightOperand, optimizable, false, bl2) && columnReference.getSource().getColumnPosition() == n3) {
            return this.leftOperand;
        }
        return null;
    }

    @Override
    public ValueNode getOperand(ColumnReference columnReference, int n2, boolean bl2) {
        this.initBaseTableVisitor(n2, true);
        try {
            ColumnReference columnReference2;
            this.btnVis.setTableMap(this.optBaseTables);
            columnReference.accept(this.btnVis);
            this.btnVis.setTableMap(this.valNodeBaseTables);
            if (this.leftOperand instanceof ColumnReference) {
                columnReference2 = (ColumnReference)this.leftOperand;
                columnReference2.accept(this.btnVis);
                this.valNodeBaseTables.and(this.optBaseTables);
                if (this.valNodeBaseTables.getFirstSetBit() != -1 && columnReference2.getSource().getColumnPosition() == columnReference.getColumnNumber()) {
                    if (bl2) {
                        return this.rightOperand;
                    }
                    return this.leftOperand;
                }
            }
            if (this.rightOperand instanceof ColumnReference) {
                this.valNodeBaseTables.clearAll();
                columnReference2 = (ColumnReference)this.rightOperand;
                columnReference2.accept(this.btnVis);
                this.valNodeBaseTables.and(this.optBaseTables);
                if (this.valNodeBaseTables.getFirstSetBit() != -1 && columnReference2.getSource().getColumnPosition() == columnReference.getColumnNumber()) {
                    if (bl2) {
                        return this.leftOperand;
                    }
                    return this.rightOperand;
                }
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void generateExpressionOperand(Optimizable optimizable, int n2, ExpressionClassBuilderInterface expressionClassBuilderInterface, MethodBuilder methodBuilder) throws StandardException {
        ExpressionClassBuilder expressionClassBuilder = (ExpressionClassBuilder)expressionClassBuilderInterface;
        FromBaseTable fromBaseTable = (FromBaseTable)optimizable;
        ValueNode valueNode = this.getExpressionOperand(fromBaseTable.getTableNumber(), n2, fromBaseTable);
        valueNode.generateExpression(expressionClassBuilder, methodBuilder);
    }

    @Override
    public boolean selfComparison(ColumnReference columnReference) throws StandardException {
        ValueNode valueNode = this.leftOperand == columnReference ? this.rightOperand : (this.rightOperand == columnReference ? this.leftOperand : null);
        JBitSet jBitSet = valueNode.getTablesReferenced();
        return jBitSet.get(columnReference.getTableNumber());
    }

    @Override
    public boolean usefulStartKey(Optimizable optimizable) {
        int n2 = this.columnOnOneSide(optimizable);
        if (n2 == 0) {
            return false;
        }
        return this.usefulStartKey(n2 == -1);
    }

    protected boolean keyColumnOnLeft(Optimizable optimizable) {
        ColumnReference columnReference;
        boolean bl2 = false;
        if (this.leftOperand instanceof ColumnReference && this.valNodeReferencesOptTable(columnReference = (ColumnReference)this.leftOperand, (FromTable)optimizable, false, true)) {
            bl2 = true;
        }
        return bl2;
    }

    protected int columnOnOneSide(Optimizable optimizable) {
        ColumnReference columnReference;
        boolean bl2 = false;
        boolean bl3 = true;
        if (this.leftOperand instanceof ColumnReference) {
            columnReference = (ColumnReference)this.leftOperand;
            if (this.valNodeReferencesOptTable(columnReference, (FromTable)optimizable, false, bl3)) {
                return -1;
            }
            bl3 = false;
        }
        if (this.rightOperand instanceof ColumnReference && this.valNodeReferencesOptTable(columnReference = (ColumnReference)this.rightOperand, (FromTable)optimizable, false, bl3)) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean usefulStopKey(Optimizable optimizable) {
        int n2 = this.columnOnOneSide(optimizable);
        if (n2 == 0) {
            return false;
        }
        return this.usefulStopKey(n2 == -1);
    }

    @Override
    public void generateAbsoluteColumnId(MethodBuilder methodBuilder, Optimizable optimizable) {
        int n2 = this.getAbsoluteColumnPosition(optimizable);
        methodBuilder.push(n2);
    }

    @Override
    public void generateRelativeColumnId(MethodBuilder methodBuilder, Optimizable optimizable) {
        int n2 = this.getAbsoluteColumnPosition(optimizable);
        n2 = optimizable.convertAbsoluteToRelativeColumnPosition(n2);
        methodBuilder.push(n2);
    }

    private int getAbsoluteColumnPosition(Optimizable optimizable) {
        ColumnReference columnReference = this.keyColumnOnLeft(optimizable) ? (ColumnReference)this.leftOperand : (ColumnReference)this.rightOperand;
        ConglomerateDescriptor conglomerateDescriptor = optimizable.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        int n2 = columnReference.getSource().getColumnPosition();
        if (conglomerateDescriptor != null && conglomerateDescriptor.isIndex()) {
            n2 = conglomerateDescriptor.getIndexDescriptor().getKeyColumnPosition(n2);
        }
        return n2 - 1;
    }

    @Override
    public void generateQualMethod(ExpressionClassBuilderInterface expressionClassBuilderInterface, MethodBuilder methodBuilder, Optimizable optimizable) throws StandardException {
        ExpressionClassBuilder expressionClassBuilder = (ExpressionClassBuilder)expressionClassBuilderInterface;
        MethodBuilder methodBuilder2 = expressionClassBuilder.newUserExprFun();
        if (this.keyColumnOnLeft(optimizable)) {
            this.rightOperand.generateExpression(expressionClassBuilder, methodBuilder2);
        } else {
            this.leftOperand.generateExpression(expressionClassBuilder, methodBuilder2);
        }
        methodBuilder2.methodReturn();
        methodBuilder2.complete();
        expressionClassBuilder.pushMethodReference(methodBuilder, methodBuilder2);
    }

    @Override
    public void generateOrderedNulls(MethodBuilder methodBuilder) {
        methodBuilder.push(false);
    }

    @Override
    public boolean orderedNulls() {
        return false;
    }

    @Override
    public boolean isQualifier(Optimizable optimizable, boolean bl2) throws StandardException {
        ColumnReference columnReference;
        if (this.isInListProbeNode()) {
            return false;
        }
        ValueNode valueNode = null;
        boolean bl3 = false;
        boolean bl4 = true;
        FromTable fromTable = (FromTable)optimizable;
        if (this.leftOperand instanceof ColumnReference) {
            columnReference = (ColumnReference)this.leftOperand;
            if (this.valNodeReferencesOptTable(columnReference, fromTable, bl2, bl4)) {
                valueNode = this.rightOperand;
                bl3 = true;
            }
            bl4 = false;
        }
        if (!bl3 && this.rightOperand instanceof ColumnReference && this.valNodeReferencesOptTable(columnReference = (ColumnReference)this.rightOperand, fromTable, bl2, bl4)) {
            valueNode = this.leftOperand;
            bl3 = true;
        }
        if (!bl3) {
            return false;
        }
        return !this.valNodeReferencesOptTable(valueNode, fromTable, bl2, true);
    }

    @Override
    public int getOrderableVariantType(Optimizable optimizable) throws StandardException {
        if (this.keyColumnOnLeft(optimizable)) {
            return this.rightOperand.getOrderableVariantType();
        }
        return this.leftOperand.getOrderableVariantType();
    }

    @Override
    public boolean compareWithKnownConstant(Optimizable optimizable, boolean bl2) {
        ValueNode valueNode;
        ValueNode valueNode2 = valueNode = this.keyColumnOnLeft(optimizable) ? this.rightOperand : this.leftOperand;
        if (bl2) {
            return valueNode instanceof ConstantNode || valueNode.requiresTypeFromContext() && ((ParameterNode)valueNode).getDefaultValue() != null;
        }
        return valueNode instanceof ConstantNode;
    }

    @Override
    public DataValueDescriptor getCompareValue(Optimizable optimizable) throws StandardException {
        ValueNode valueNode;
        ValueNode valueNode2 = valueNode = this.keyColumnOnLeft(optimizable) ? this.rightOperand : this.leftOperand;
        if (valueNode instanceof ConstantNode) {
            return ((ConstantNode)valueNode).getValue();
        }
        if (valueNode.requiresTypeFromContext()) {
            ParameterNode parameterNode = valueNode instanceof UnaryOperatorNode ? ((UnaryOperatorNode)valueNode).getParameterOperand() : (ParameterNode)valueNode;
            return parameterNode.getDefaultValue();
        }
        return null;
    }

    protected double booleanSelectivity(Optimizable optimizable) throws StandardException {
        TypeId typeId = null;
        double d2 = -1.0;
        int n2 = this.columnOnOneSide(optimizable);
        if (n2 == -1) {
            typeId = this.leftOperand.getTypeId();
        } else if (n2 == 1) {
            typeId = this.rightOperand.getTypeId();
        }
        if (typeId != null && (typeId.getJDBCTypeId() == -7 || typeId.getJDBCTypeId() == 16)) {
            d2 = 0.5;
        }
        return d2;
    }

    @Override
    String getReceiverInterfaceName() {
        return "org.apache.derby.iapi.types.DataValueDescriptor";
    }

    @Override
    ValueNode evaluateConstantExpressions() throws StandardException {
        if (this.leftOperand instanceof ConstantNode && this.rightOperand instanceof ConstantNode) {
            ConstantNode constantNode = (ConstantNode)this.leftOperand;
            ConstantNode constantNode2 = (ConstantNode)this.rightOperand;
            DataValueDescriptor dataValueDescriptor = constantNode.getValue();
            DataValueDescriptor dataValueDescriptor2 = constantNode2.getValue();
            if (!dataValueDescriptor.isNull() && !dataValueDescriptor2.isNull()) {
                int n2 = dataValueDescriptor.compare(dataValueDescriptor2);
                switch (this.relOpType) {
                    case 1: {
                        return this.newBool(n2 == 0);
                    }
                    case 2: {
                        return this.newBool(n2 != 0);
                    }
                    case 3: {
                        return this.newBool(n2 > 0);
                    }
                    case 4: {
                        return this.newBool(n2 >= 0);
                    }
                    case 5: {
                        return this.newBool(n2 < 0);
                    }
                    case 6: {
                        return this.newBool(n2 <= 0);
                    }
                }
            }
        }
        return this;
    }

    private ValueNode newBool(boolean bl2) throws StandardException {
        return new BooleanConstantNode(bl2, this.getContextManager());
    }

    @Override
    BinaryOperatorNode getNegation(ValueNode valueNode, ValueNode valueNode2) throws StandardException {
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = new BinaryRelationalOperatorNode(this.getNegationNode(), valueNode, valueNode2, false, this.getContextManager());
        binaryRelationalOperatorNode.setType(this.getTypeServices());
        return binaryRelationalOperatorNode;
    }

    private int getNegationNode() {
        switch (this.kind) {
            case 0: {
                return 5;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 3;
            }
            case 4: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 5: {
                return 0;
            }
        }
        return -1;
    }

    @Override
    BinaryOperatorNode getSwappedEquivalent() throws StandardException {
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = new BinaryRelationalOperatorNode(this.getKindForSwap(), this.rightOperand, this.leftOperand, false, this.getContextManager());
        binaryRelationalOperatorNode.setType(this.getTypeServices());
        return binaryRelationalOperatorNode;
    }

    private int getKindForSwap() {
        switch (this.kind) {
            case 0: {
                return 0;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 4: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case 5: {
                return 5;
            }
        }
        return -1;
    }

    protected boolean usefulStartKey(boolean bl2) {
        switch (this.relOpType) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: 
            case 4: {
                return bl2;
            }
            case 5: 
            case 6: {
                return !bl2;
            }
        }
        return false;
    }

    protected boolean usefulStopKey(boolean bl2) {
        switch (this.relOpType) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: 
            case 4: {
                return !bl2;
            }
            case 5: 
            case 6: {
                return bl2;
            }
        }
        return false;
    }

    @Override
    public int getStartOperator(Optimizable optimizable) {
        switch (this.relOpType) {
            case 1: 
            case 4: 
            case 6: {
                return 1;
            }
            case 3: 
            case 5: {
                return -1;
            }
            case 2: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public int getStopOperator(Optimizable optimizable) {
        switch (this.relOpType) {
            case 1: 
            case 4: 
            case 6: {
                return -1;
            }
            case 3: 
            case 5: {
                return 1;
            }
            case 2: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public void generateOperator(MethodBuilder methodBuilder, Optimizable optimizable) {
        switch (this.relOpType) {
            case 1: {
                methodBuilder.push(2);
                break;
            }
            case 2: {
                methodBuilder.push(2);
                break;
            }
            case 4: 
            case 5: {
                methodBuilder.push(this.keyColumnOnLeft(optimizable) ? 1 : 3);
                break;
            }
            case 3: 
            case 6: {
                methodBuilder.push(this.keyColumnOnLeft(optimizable) ? 3 : 1);
            }
        }
    }

    @Override
    public void generateNegate(MethodBuilder methodBuilder, Optimizable optimizable) {
        switch (this.relOpType) {
            case 1: {
                methodBuilder.push(false);
                break;
            }
            case 2: {
                methodBuilder.push(true);
                break;
            }
            case 5: 
            case 6: {
                methodBuilder.push(!this.keyColumnOnLeft(optimizable));
                break;
            }
            case 3: 
            case 4: {
                methodBuilder.push(this.keyColumnOnLeft(optimizable));
            }
        }
    }

    @Override
    public int getOperator() {
        return this.relOpType;
    }

    @Override
    public double selectivity(Optimizable optimizable) throws StandardException {
        double d2 = this.booleanSelectivity(optimizable);
        if (d2 >= 0.0) {
            return d2;
        }
        switch (this.relOpType) {
            case 1: {
                return 0.1;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                if (this.getBetweenSelectivity()) {
                    return 0.5;
                }
            }
            case 3: {
                return 0.33;
            }
        }
        return 0.0;
    }

    @Override
    public RelationalOperator getTransitiveSearchClause(ColumnReference columnReference) throws StandardException {
        return new BinaryRelationalOperatorNode(this.kind, (ValueNode)columnReference, this.rightOperand, false, this.getContextManager());
    }

    @Override
    public boolean equalsComparisonWithConstantExpression(Optimizable optimizable) {
        if (this.relOpType != 1) {
            return false;
        }
        boolean bl2 = false;
        Object var3_3 = null;
        int n2 = this.columnOnOneSide(optimizable);
        if (n2 == -1) {
            bl2 = this.rightOperand.isConstantExpression();
        } else if (n2 == 1) {
            bl2 = this.leftOperand.isConstantExpression();
        }
        return bl2;
    }

    @Override
    boolean isRelationalOperator() {
        return !this.isInListProbeNode();
    }

    @Override
    boolean isBinaryEqualsOperatorNode() {
        return !this.isInListProbeNode() && this.relOpType == 1;
    }

    @Override
    boolean isInListProbeNode() {
        return this.inListProbeSource != null;
    }

    @Override
    boolean optimizableEqualityNode(Optimizable optimizable, int n2, boolean bl2) throws StandardException {
        if (this.relOpType != 1) {
            return false;
        }
        if (this.isInListProbeNode()) {
            return false;
        }
        ColumnReference columnReference = this.getColumnOperand(optimizable, n2);
        if (columnReference == null) {
            return false;
        }
        if (this.selfComparison(columnReference)) {
            return false;
        }
        return !this.implicitVarcharComparison();
    }

    private boolean implicitVarcharComparison() throws StandardException {
        TypeId typeId = this.leftOperand.getTypeId();
        TypeId typeId2 = this.rightOperand.getTypeId();
        if (typeId.isStringTypeId() && !typeId2.isStringTypeId()) {
            return true;
        }
        return typeId2.isStringTypeId() && !typeId.isStringTypeId();
    }

    @Override
    ValueNode genSQLJavaSQLTree() throws StandardException {
        if (this.relOpType == 1) {
            return this;
        }
        return super.genSQLJavaSQLTree();
    }

    ValueNode getScopedOperand(int n2, JBitSet jBitSet, ResultSetNode resultSetNode, int[] nArray) throws StandardException {
        ResultColumn resultColumn;
        Object object;
        ColumnReference columnReference = n2 == -1 ? (ColumnReference)this.leftOperand : (ColumnReference)this.rightOperand;
        JBitSet jBitSet2 = new JBitSet(jBitSet.size());
        BaseTableNumbersVisitor baseTableNumbersVisitor = new BaseTableNumbersVisitor(jBitSet2);
        columnReference.accept(baseTableNumbersVisitor);
        if (!jBitSet.contains(jBitSet2)) {
            return (ColumnReference)columnReference.getClone();
        }
        if (nArray[0] == -1) {
            object = new int[]{-1};
            ResultSetNode resultSetNode2 = columnReference.getSourceResultSet((int[])object);
            resultColumn = resultSetNode.getResultColumns().getResultColumn(object[0], resultSetNode2, nArray);
        } else {
            resultColumn = resultSetNode.getResultColumns().getResultColumn(nArray[0]);
        }
        if (resultColumn.getExpression() instanceof ColumnReference) {
            object = (ColumnReference)((ColumnReference)resultColumn.getExpression()).getClone();
            ((ColumnReference)object).markAsScoped();
            return object;
        }
        return resultColumn.getExpression();
    }

    private boolean valNodeReferencesOptTable(ValueNode valueNode, Optimizable optimizable, boolean bl2, boolean bl3) {
        this.initBaseTableVisitor(optimizable.getReferencedTableMap().size(), bl3);
        boolean bl4 = false;
        try {
            if (bl3) {
                this.buildTableNumList(optimizable, bl2);
            }
            this.btnVis.setTableMap(this.valNodeBaseTables);
            valueNode.accept(this.btnVis);
            this.valNodeBaseTables.and(this.optBaseTables);
            bl4 = this.valNodeBaseTables.getFirstSetBit() != -1;
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return bl4;
    }

    private void initBaseTableVisitor(int n2, boolean bl2) {
        if (this.valNodeBaseTables == null) {
            this.valNodeBaseTables = new JBitSet(n2);
        } else {
            this.valNodeBaseTables.clearAll();
        }
        if (bl2) {
            if (this.optBaseTables == null) {
                this.optBaseTables = new JBitSet(n2);
            } else {
                this.optBaseTables.clearAll();
            }
        }
        if (this.btnVis == null) {
            this.btnVis = new BaseTableNumbersVisitor(this.valNodeBaseTables);
        }
    }

    private void buildTableNumList(Optimizable optimizable, boolean bl2) throws StandardException {
        if (optimizable.getTableNumber() >= 0) {
            this.optBaseTables.set(optimizable.getTableNumber());
        }
        if (bl2) {
            return;
        }
        this.optBaseTables.or(optimizable.getReferencedTableMap());
        this.btnVis.setTableMap(this.optBaseTables);
        optimizable.accept(this.btnVis);
    }

    @Override
    boolean isSameNodeKind(ValueNode valueNode) {
        return super.isSameNodeKind(valueNode) && ((BinaryRelationalOperatorNode)valueNode).kind == this.kind;
    }
}

